;INITIALIZE.ASM

;***************************************************
;INITIALISING

RESET:		LDI A,LOW(RAMEND)		;FIX STACK POINTER
 		OUT SPL,A
		LDI A,HIGH(RAMEND)
		OUT SPH,A

	
;***************************************************
;SETTING THE IN/OUT PORTS

;PORTD=WAIT,COM,PWM2,PWM1,RD,WR,TX,RX

		LDI A,0B01110010		;SETTING PORT D
		OUT DDRD,A
		LDI A,0B111111
		OUT PORTD,A

;PORTC=DATA IN/OUT

		LDI A,0				;SETTING PORT C
		OUT DDRC,A
		OUT PORTC,A

;PORTB=ADDRESS SELECTOR

		OUT DDRB,A			;SETTING PORT B
		OUT PORTB,A		
		
;PORTA=5 BIT OUTPUT, 1 BIT LED, 2 BITS ANALOG INPUTS
		OUT PORTA,A
		LDI A,0B00000100		;SETTING PORT A
		OUT DDRA,A


;MAKE 1 SECOND DELAY TO NOTICE THE RESET
		LDI A,$FF
		LDI B,$FF
		LDI C,STARTUP_DELAY
		
;RESET SIGNAL (OFF)
		CBI PORTA,2
RESET_DELAY:	DEC A
		BRNE RESET_DELAY
		DEC B
		BRNE RESET_DELAY
		DEC C
		BRNE RESET_DELAY
		SBI PORTA,2			;POWER ON
		
;***************************************************
;RESERVED REGISTERS
		CLR CLR_REG			;
		CLR SET_REG
		COM SET_REG			;
		CLR UART_REG3			;UART BUFFER ON/OFF
		CLR UART_TEMP			;UART REGISTER
		LDI XH,3
		CLR XL				;UART BUFFER WRITE POINTER
		CLR UB_RD			;UART BUFFER READ POINTER
		CLR UB_LENGTH			;UART BUFFER LENGTH REGISTER


;****************************************************************
;SETTING THE UART
		CLR A
		OUT UCSRA,A			;NORMAL UART SPEED
		LDI A,0B11000
		OUT UCSRB,A			;TX & RX ENABLE
		LDI A,0B10000110		;8 BIT
		OUT UCSRC,A
		
		CLR A
		OUT UBRRH,A
		LDI A,5				;UBR=(FCK/(16*BAUD))-1
		OUT UBRRL,A
		IN A,UDR
		IN A,UDR			;CLEAR UDR
		SBI UCSRA,TXC			;CLEAR TXC

;****************************************************************
;SETTING FOR THE TWO PWM CHANNELS                                                                         

		LDI A,0B10101101
		OUT TCCR1A,A
		LDI A,0B1001
		OUT TCCR1B,A

;***************************************************
;ADC CONVERTER SETTING

		;LDI A,0B0010000Y
		;Y=CHANNEL SELECTOR
		LDI A,0B100000
		OUT ADMUX,A		;SELECT CHANNEL 0

		LDI A,0B10000000	;ENABLE CONVERTER
		OUT ADCSRA,A		;SAMPLING FREQ=FREQ/2

;****************************************************************
;LAST BITS OF INITIALIZATION

		LDI YL,$60		;CLEAR ALL SRAM
		LDI YH,0
		LDI B,$FF
		LDI C,$3
		CLR A
CLEAR_RAM:	ST Y+,A
		DEC B
		BRNE CLEAR_RAM
		DEC C
		BRNE CLEAR_RAM
						
		LDI A,0B11000000	;ENABLE EXTERNAL INTERRUPTS
		OUT GIMSK,A

		LDI A,0			;LOW LEVEL EXTERNAL INTERRUPT
		OUT MCUCR,A

		LDI ZH,HIGH(VERSION_DATA*2)
		STS VERSION_HI,ZH
		LDI ZL,LOW(VERSION_DATA*2)
		STS VERSION_LO,ZL
		
		SEI
		RJMP MAIN
		
