NOLIST:ORG &C000:LIMIT &FFFF

;MAXAM LISTING
;AUFBAU EINES ROM-PROGRAMMS

WRITE"TEST.ROM

DB 1                        ;1=KENNUNG FUER HINTERGRUND-ROM
DB 1                        ;MARK NUMBER
DB 0                        ;VERSION NUMBER
DB 1                        ;MODIFICATION LEVEL, DIE DREI WERTE ERGEBEN..
                            ;..HIER VERSION 1.01

DW NAMTAB                   ;ZWEI-BYTE-ZEIGER AUF DIE NAMENS-TABELLE
JP INITROUTINE              ;WIRD BEIM EINSCHALTEN DES RECHNERS ANGESPRUNGEN
JP ROUTINE1                 ;WIRD BEI EINGABE VOM |HALLO ANGESPRUNGEN
JP ROUTINE2                 ;WIRD BEI EINGABE VON |KATALOG ANGESPRUNGEN
                            ;HIER BEI BEDARF JP'S ZU WEITEREN ROUTINEN EINFUEGEN

NAMTAB                      ;HIER BEGINT DIE NAMENS-TABELLE.
                            ;JEDER NAME MAX. 15 BUCHSTABEN
DB "TEST RO","M"+&80        ;DER NAME DER INIT ROUTINE
DB "HALL","O"+&80           ;NAME VON ROUTINE1
DB "KATALO","G"+&80         ;NAME VON ROUTINE2
                            ;HIER BEI BEDARF WEITERE ROUTINEN-NAMEN EINFUEGEN
DB 0                        ;NULL-BYTE IST KENNZEICHEN FUER ENDE DER..
                            ;..NAMENSTABELLE

INITROUTINE                 ;DIE INITIALISIERUNGSROUTINE. WIRD BEIM EIN-
                            ;SCHALTEN ODER RESET ANGESPRUNGEN. IN DIESEM
                            ;FALL IST EINE PROMT-MITTEILUNG UND EIN..
                            ;..CHECKSUMER EINGEBAUT. DENKBAR IST AUCH EINE
                            ;..FARB-ODER MODUSAENDERUNG, TASTATURBELEGUNG USW.

                            ;IN; HL. HL ZEIGT AUF UNTERGRENZE DES ARBEITS-..
                            ;..RAM-BEREICHS DES VORHERIGEN ROMS
LD DE,20                    ;20 BYTES (BEISPIEL) WERDEN..
OR A:SBC HL,DE              ;..VOM RAM ALS ARBEITRAM RESERVIERT
                            ;HL WIRD ALS RAM-UNTERGRENZE AN DIE..
                            ;..NAECHSTE ROM-INIT-ROUTINE WEITERGEGEBEN. DIESE..
                            ;..RESERVIERT SICH EVTL AUCH ETWAS USW. 
PUSH HL                     ;HL RETTEN

LD HL,PROMT_MESSAGE         ;ZEIGER AUF PROMT-TEXT
CALL MESSPRI                ;TEXT AUSGEBEN
CALL CHECKER                ;CHECKSUMER AUFRUFEN
POP HL                      ;HL HOLEN
RET                         ;FERTIG
                            ;OUT; CY,HL

PROMT_MESSAGE
DB " TEST ROM AKTIV",13,10,10,0


ROUTINE1                        ;DIESE ROUTINE WIRD BEI |HALLO ANGESPRUNGEN
                                ;IN; IY. DAS BETRIEBSSYSTEM LEADT NACH AUFRUF..
                                ;..VON !HALLO IY MIT DER UNTERGRENZE DES..
                                ;..ARBEITS-RAM-BEREICHS DIESES ROMS. DIE..
                                ;..UNTERGRENZE KANN DER PROGRAMMIERER IN DER..
                                ;..INITROUTINE NACH UNTEN VERLEGEN
LD HL,BEISPIEL_MESSAGE          ;ZEIGER AUF TEXT SETZEN..
CALL MESSPRI                    ;..UND AUSGEBEN
RET                             ;FERTIG

BEISPIEL_MESSAGE
DB "TJA, ANSTATT DIESE MESSAGE "
DB "AUSZUGEBEN, KOENNTEN DIVERSE "
DB "DINGE GESCHEHEN...",13,10,0

ROUTINE2                       ;DIESE ROUTINE WIRD BEI |KATALOG ANGESPRUNGEN
                               ;IN; IY. DAS BETRIEBSSYSTEM LEADT NACH AUFRUF..
                               ;..VON !KATALOG IY MIT DER UNTERGRENZE DES..
                               ;..ARBEITS-RAM-BEREICHS DIESES ROMS. DIE..
                               ;..UNTERGRENZE KANN DER PROGRAMMIERER IN DER..
                               ;..INITROUTINE NACH UNTEN VERLEGEN
LD DE,&4000                    ;2 KB KATALOG-BUFFER BEI &4000
CALL &BC9B                     ;CAS KATALOG AUFRUFEN 
RET                            ;FERTIG


CHECKER                        ;DER CHECKSUMER. ER BILDET EINE PRUEFSUMME..
                               ;..UEBER DAS ROM UND VERGLEICHT DIESEN WERT..
                               ;..MIT DEM WERT, DER AM ENDE DES ROMS..
                               ;..(BEI &FFFF) EINGETRAGEN IST. DIESER WERT..
                               ;..WIRD VOM SOFTBRENNER AUTOMATISCH ERZEUGT..
                               ;..WENN EIN CHECKSUMER IM ROM EINGEBAUT IST.
                               ;WEGEN DES CHECKSUMERS MUSS MAN BEI DER..
                               ;..ROM-ENTWICKLUNG &FFFF FREILASSEN !
LD HL,&C000                    ;HL AUF START DES ROMS
XOR A                          ;AKKU AUF NULL
LOOP                           ;SCHLEIFE WIRD BIS ZUM ENDE DES ROMS..
ADD A,(HL):INC L               ;..DURCHLAUFEN UND DER AKKU WIRD PERMANENT..
ADD A,(HL):INC L               ;..UM DEN WERT DER NAECHSTEN SPEICHERSTELLE
ADD A,(HL):INC L               ;..ERHOEHT.
ADD A,(HL):INC L
ADD A,(HL):INC L
ADD A,(HL):INC L
ADD A,(HL):INC L
ADD A,(HL):INC L
JR NZ,LOOP
INC H
JR NZ,LOOP
DEC HL                         ;HL AUF ENDE DES ROMS (&FFFF) 
SUB (HL)
CP (HL)                        ;DER AKKU WIRD MIT DEM WERT VERGLICHEN, DER..
                               ;..AM ENDE DES ROMS EINGETRAGEN WAR.
JR Z,GLEICH                    ;WAREN AKKU UND WERT GLEICH, WIRD 'GLEICH'
                               ;ANGESPRUNGEN.
UNGLEICH                       ;WENN AKKU UND WERT NICHT GLEICH WAREN,..
                               ;..WIRD DIE ERROR-MELDUNG AUSGEGEBEN
LD HL,ERROR_MESSAGE            ;HL AUF DIE FEHLERMELDUNG..
CALL MESSPRI                   ;..UND AUSGEBEN.
OR A                           ;CARRY-FLAG WIRD GELOESCHT, DADURCH WIRD..
                               ;..EIN FEHLER SIGNALISIERT.
RET                            ;FERTIG.

GLEICH                         ;ALS OK-ZEICHEN WIRD DAS CARRY-FLAG GESETZT
SCF                       
RET                            ;FERTIG

ERROR_MESSAGE                  ;DIESE MELDUNG WIRD AUSGEGEBEN, WENN DER..
DB 11,"* CHECKSUM "            ;..ROM-INHALT IRGENDWIE VERAENDERT..
DB "ERROR *",7,13,10,10,0      ;..WURDE. WENN DIESE MELDUNG EINMAL..
                               ;..AUFTRETEN SOLLTE, DANN EPROM NEU BRENNEN..
                               ;..BZW .EPROMPROGRAMM IN DER ROM-RAM-BOX NEU..
                               ;..INSTALLIEREN !

MESSPRI ;HL=ZEIGER             ;GIBT TEXTE AUS
LD A,(HL):OR A:RET Z              
INC HL:CALL &BB5A:JR MESSPRI


LIST:END