;MAXAM LISTING
;
;This listing demonstrates how to create own ROM-programmes
;In this version you will find a checksum routine which indicates
;corrupted ROM-data !

ORG &C000:NOLIST:LIMIT &FFFF

WRITE"TEST.ROM

DB 1                        ;background-ROM

DB 1                        ;mark number
DB 0                        ;version number
DB 1                        ;modification level
                            ;-> version 1.01

DW NAMTAB                   ;pointer to the name-table
JP INITROUTINE              ;it is auto-called after switching on computer
JP ROUTINE1                 ;it is called after typing !HELLO
JP ROUTINE2                 ;it is called after typing !CATALOGUE
                            ;maybe fill up with more jump's



NAMTAB                      ;name-table of RSX-commands
                            ;each name max. 15 chars.
                            ;set 7th bit of last char !
DB "TEST RO","M"+&80        ;RSX-command of INITROUTINE
DB "HELL","O"+&80           ;RSX-command of ROUTINE1
DB "CATALOGU","E"+&80       ;RSX-command of ROUTINE2
                            ;maybe fill up with more names
DB 0                        ;0 indicates the end of name-table


INITROUTINE                 ;The initroutine will be called automatically..
                            ;..after switching on/reseting the computer.
                            ;
                            ;This routine has got a checksum-routine and..
                            ;..a promtmessage is implemented.
                            ;you may implement more gadgets... !
PUSH HL                     ;save HL
LD HL,PROMT_MESSAGE         ;pointer to message
CALL MESSPRI                ;print message
CALL CHECKER                ;call checksum-routine
POP HL                      ;get HL
RET                         ;ready
                            ;out -> carryflag
PROMT_MESSAGE
DB " TEST ROM AKTIV"
DB 13,10,10
DB 0


ROUTINE1                    ;this routine is called after typing !HELLO
LD HL,EXAMPLE_MESSAGE       ;pointer to message
CALL MESSPRI                ;print message
RET                         ;ready

EXAMPLE_MESSAGE
DB "Hi ! Instead of printing this silly message, we could do much more !"
DB 13,10
DB 0

ROUTINE2                 ;This routine is called after typing !CATALOGUE
LD DE,&4000              ;2 kb buffer
CALL &BC9B               ;CAS CATALOGUE
RET                      ;ready


CHECKER                  ;The checksum-routine creates a checksum of the ROM..
                         ;..and compares it with the LAST byte of the ROM..
                         ;..at &FFFF.
                         ;This byte represents the checksum of the ROM. You..
                         ;..can generate this checksum with the SOFTBRENNER..
                         ;..very easy !
                         ;If you want to implement such a checksum-routine..
                         ;..in your selfmade-ROM, you have to left the last..
                         ;..byte free !

LD HL,&C000              ;HL=begining of the ROM
XOR A                    ;checksum-reset
LOOP                     ;loop until..
ADD A,(HL):INC L         ;\
ADD A,(HL):INC L         ; \
ADD A,(HL):INC L         ;  \
ADD A,(HL):INC L         ;   \
ADD A,(HL):INC L         ;    \
ADD A,(HL):INC L         ;     \
ADD A,(HL):INC L         ;      \
ADD A,(HL):INC L         ;       \
JR NZ,LOOP               ;        \
INC H                    ;         \
JR NZ,LOOP               ;..all &4000 bytes of the ROM are added

DEC HL                   ;HL=&FFFF 
SUB (HL)                 ;A=A-(&FFFF)
CP (HL)                  ;A=(&FFFF) ?
                         
JR Z,EQUAL               ;if OK jump to EQUAL

NOTEQUAL                 ;corrupted data !
LD HL,ERROR_MESSAGE      ;pointer of message
CALL MESSPRI             ;print message
OR A                     ;reset carryflag -> it's the error-signal
RET                      ;ready

EQUAL                    ;everything OK
SCF                      ;set carryflag
RET                      ;ready

ERROR_MESSAGE
DB 11,"* CHECKSUM "
DB "ERROR *"
DB 7,13,10,10
DB 0

MESSPRI ;HL=pointer       ;it's printing strings
LD A,(HL):OR A:RET Z              
INC HL:CALL &BB5A
JR MESSPRI


LIST:END