;INSTALL.ASM

;On  the  disc  is  a   documented   assembler  listing  (MAXAM)  which 
;demonstrates how you  can  transfer  ROMs  into  the  ROM-RAM-BOX. The 
;difference to the older listing is  that  now  the ROM to be installed 
;(at &4000 in the memory) will not be deleted anymore.
;----------------------------------------------------------------------

;DEMO LISTING
;INSTALLATION OF A ROM IN THE ROM-RAM-BOX
;THE ROM HAS BEEN LOADED TO &4000 ! 
;THE DATA AT &4000 STAYS INTACT AFTER THE INSTALLATION.

ORG &8000:NOLIST

INSTALL           ;INPUT C -> 'ROM-RAM SLOT' 0-15
CALL &B90F        ;SELECT DESIRED ROM ('ROM-RAM SLOT')
PUSH BC           ;SAVE OLD ROMSTATUS


LD HL,INST_MESSA  ;PRINT..
CALL MESSPRI      ;..TEXT

CALL KEYREAD      ;WAIT UNTIL KEYPRESSED
LD HL,&4000       ;TRANSFER ROM FROM &4000;
LD DE,&C000       ;..TO &C000
LD BC,&4000       ;..IN THE
LDIR              ;..ROM-RAM-BOX
LD C,240          ;SELECT DUMMY ROM >15 TO PROTECT THE CURRENT ROM FROM BEING..
CALL &B90F        ;..DELETED BY A TEXT OUTPUT ON SCREEN
LD HL,READY_MESSA ;PRINT.. 
CALL MESSPRI      ;..TEXT
CALL KEYREAD      ;WAIT UNTIL KEYPRESSED
POP BC            ;GET OLD ROMSTATUS..
CALL &B918        ;..AND SELECT OLD ROM
RET               ;READY

KEYREAD
KL1:CALL &BB09:CP 13:JR NZ,KL1 ;WAIT UNTIL 'ENTER' PRESSED
KL2:CALL &BB09:CP 13:JR Z,KL2  ;WAIT UNTIL 'ENTER' NOT PRESSED ANYMORE
RET


MESSPRI                        ;HL=ADR TEXT
LD A,(HL):OR A:RET Z
INC HL:CALL &BB5A:JR MESSPRI


INST_MESSA
DB "INSTALL:",13,10,10
DB "* RAM ON !",13,10
DB "* PLACE ON !",13,10
DB "* WRITE-MODE ON !",13,10,10
DB "<RETURN>",13,10,0

READY_MESSA
DB 4,2                         ;MODE 2
DB "READY.",13,10,10
DB "* WRITE-MODE OFF !",13,10,10
DB "<RETURN>",13,10,0

LIST:END