'                                X86IOPIX.BAS
'                       * PALETTE PROGRAMMING EXAMPLE *
'                      * FROM CPCALIVE X86 ENVIRONMENT *
|input,"ex\X86IOPix.com":call 0
10 defint p:dim pal(256*3)
20 |PALASK,@pal(0):'load palette (keep 16 first pens)
30 gosub 1000:|PALSET,@pal(0):mode 1
50 PRINT"display a line with |OPIX and read"
60 PRINT"colors index (GRAPHICS PEN) with |IPIX"
70 pix%=0:for x=0 to 200:|OPIX,x,0,x:|IPIX,x,0,@pix%:?hex$(pix%,2)":";:next
80 end
1000 '*PALETTE PROGRAMMING EXAMPLE*
1010 InkRef=128:'<-Change InkRef value for various result
1020 for i=16 to 31:pal(i*3+0)=(i-8)*8:pal(i*3+1)=(i-8)*8:pal(i*3+2)=(i-8)*8:next
1030 for i=32 to 63:pal(i*3+0)=InkRef:pal(i*3+1)=(i-32)*8:pal(i*3+2)=(i-32)*8:next
1040 for i=64 to 95:pal(i*3+0)=(i-64)*8:pal(i*3+1)=InkRef:pal(i*3+2)=(i-64)*8:next
1050 for i=96 to 127:pal(i*3+0)=(i-96)*8:pal(i*3+1)=(i-96)*8:pal(i*3+2)=InkRef:next
1060 for i=128 to 159:pal(i*3+0)=InkRef:pal(i*3+1)=InkRef:pal(i*3+2)=(i-128)*8:next
1070 for i=160 to 191:pal(i*3+0)=InkRef:pal(i*3+1)=(i-160)*8:pal(i*3+2)=InkRef:next
1080 for i=192 to 223:pal(i*3+0)=(i-192)*8:pal(i*3+1)=InkRef:pal(i*3+2)=InkRef:next
1090 for i=224 to 255:pal(i*3+0)=InkRef:pal(i*3+1)=int(InkRef/2):pal(i*3+2)=(i-224)*8:next
1100 return
run
|STOP
;                               X86IOPIX.ASM
.MODEL TINY
.STACK 040h
.CODE
.386
;****************************************************************************
;**                   EXEMPLE DE MODULE X86 POUR CpcALive                  **
;**                   AVEC INTGRATION DE COMMANDES RSX                    **
;****************************************************************************
; Assemblage: A86 X86IOPix.asm     -> cre le fichier X86IOPix.com
; Chargement dans l'mulateur, 3 solutions:
; 1-  partir de la ligne de commande Dos: ! X86IOPix.com
; 2-  partir d'un fichier de commande CpcAlive: X86IOPix.com
; 3-  partir de l'interprteur basic du Cpc: |input,"X86IOPix.com":call 0
; commandes  partir de l'interprteur basic du Cpc:
; |OPIX,X,Y,pen   - OUTPUT PIXEL
; |IPIX,X,Y,@pen% - INPUT PIXEL
; |PALSET,@PAL(0) - SET PALETTE DEPUIS VARIABLE DIMENSIONNE
; |PALASK,@PAL(0) - CHARGER PALETTE DANS VARIABLE DIMENSIONNE
; |PALGREY        - CONVERTIR PALETTE EN NUANCES DE GRIS
; - initialiser la variable @pen% par pen%=0 pour |IPIX
; - X et Y sont relatifs au coin en haut  gauche de l'cran.
;****************************************************************************

START:          push cs
                pop ds
                mov dx,offset Mes
                mov ah,9
                int 021H
                mov ax,04C00h
                int 021h

Mes             db "Ce fichier est un module CpcAlive.",13,10
                db "This file is a CpcAlive module.",13,10
                db "http://cpcalive.com.",13,10,"$"

;UTILIS PAR LE SYSTEME CpcAlive
org 0200h
                db 'X86CPC'             ; 0200h marque
                dw 1                    ; 0206h version
                dw offset X86Vec        ; 0208h adresse table vecteurs d'entre
                dw 0                    ; 020Ah rserv
                dw 0                    ; 020Ch rserv
                dw 0                    ; 020Eh rserv
                dw offset MnemoTb       ; 0210h offset mnmoniques
                db -1                   ; 0212h (*)reoit le numro de module X86
                db -1                   ; 0213h numro module complment ou numro bloc banque Cpc
                db -1                   ; 0214h (*)reoit le numro de la rom Z80 associe
                db -1                   ; 0215h indicateur chargement banques Cpc ou module complment
                dw 0                    ; 0216h (*)1ere adresse Cpc ou module complment accessible
                                        ;       (0=aucune adresse accessible)
                db 0                    ; 0218h rserv
                dw 0                    ; 0219h (*)reoit le handle ems associ au module
                dw 0                    ; 021Bh (*)reoit le numro logique premire page du module
                db 0                    ; 021Dh (*)reoit le nombre de pages alloues au module
                dw 0                    ; 021Eh adresse appele  l'arrt de l'mulateur (0=pas d'appel)
                dw 0                    ; 0220h adresse appele  la mise en veille de l'mulateur (0=pas d'appel)
                dw 0                    ; 0222h adresse appele au retour de veille de l'mulateur (0=pas d'appel)
                dw 0                    ; 0224h adresse appele au chargement du module (0=pas d'appel)
                dw 0                    ; 0226h rserv
                db 0                    ; 0228h (*)nombre de pages connectes
                                        ;       ou nombre de pages  connecter
                                        ;       ou nombre de pages  allouer (si<>0 au chargement du module)
                db 0100h-029h dup (0)   ; 0229h rserv

;(*) = valeurs gnres par le systme

;*****************************************************************************

MnemoTb         db "PIXIN","I" or 080h          ; |PIXINI
                db "OPI","X" or 080h            ; |OPIX
                db "IPI","X" or 080h            ; |IPIX
                db "PALSE","T" or 080h          ; |PALSET
                db "PALAS","K" or 080h          ; |PALASK
                db "PALGRE","Y" or 080h         ; |PALGREY
                db 0

X86Vec          dw offset PixIni        ; 00 ** |PIXINI - INIT **
                dw offset OPix          ; 01 ** |OPIX,X,Y,PEN - SORTIE PIXEL A TRAVERS INT 010H **
                dw offset IPix          ; 02 ** |IPIX,X,Y,@PEN% - LECTURE PIXEL A TRAVERS INT 010H **
                dw offset PalSet        ; 03 ** |PALSET,@PAL(0) - SET PALETTE DEPUIS VARIABLE DIMENSIONNE **
                dw offset PalAsk        ; 04 ** |PALASK,@PAL(0) - CHARGER PALETTE DANS VARIABLE DIMENSIONNE **
                dw offset PalGrey       ; 05 ** |PALGREY - CONVERTIR PALETTE EN NUANCES DE GRIS **

                ;... 128 vecteurs maximum

; Valeurs de AH ou AX pour interruption 018H
; ** Lecture banque 0 Cpc (blocs 0,1,2,3) **
ReadAL=0        ; (AH) lire l'octet point par SI et le mettre dans AL
ReadAH=0200h    ; (AX) lire l'octet point par SI et le mettre dans AH
ReadBL=0201h    ; (AX) lire l'octet point par SI et le mettre dans BL
ReadBH=0202h    ; (AX) lire l'octet point par SI et le mettre dans BH
ReadCL=0203h    ; (AX) lire l'octet point par SI et le mettre dans CL
ReadCH=0204h    ; (AX) lire l'octet point par SI et le mettre dans CH
ReadDL=0205h    ; (AX) lire l'octet point par SI et le mettre dans DL
ReadDH=0206h    ; (AX) lire l'octet point par SI et le mettre dans DH
ReadAX=0207h    ; (AX) lire le mot point par SI et le mettre dans AX
ReadBX=0208h    ; (AX) lire le mot point par SI et le mettre dans BX
ReadCX=0209h    ; (AX) lire le mot point par SI et le mettre dans CX
ReadDX=020Ah    ; (AX) lire le mot point par SI et le mettre dans DX
ReadSI=020Bh    ; (AX) lire le mot point par SI et le mettre dans SI
ReadDI=020Ch    ; (AX) lire le mot point par SI et le mettre dans DI
ReadBP=020Dh    ; (AX) lire le mot point par SI et le mettre dans BP
WriteAL=1       ; (AH) crire la valeur de AL dans l'octet point par DI
WriteBL=0301h   ; (AX) crire la valeur de BL dans l'octet point par DI
WriteBH=0302h   ; (AX) crire la valeur de BH dans l'octet point par DI
WriteCL=0303h   ; (AX) crire la valeur de CL dans l'octet point par DI
WriteCH=0304h   ; (AX) crire la valeur de CH dans l'octet point par DI
WriteDL=0305h   ; (AX) crire la valeur de DL dans l'octet point par DI
WriteDH=0306h   ; (AX) crire la valeur de DH dans l'octet point par DI
WriteBX=0308h   ; (AX) crire la valeur de BX dans le mot point par DI
WriteCX=0309h   ; (AX) crire la valeur de CX dans le mot point par DI
WriteDX=030Ah   ; (AX) crire la valeur de DX dans le mot point par DI
WriteBP=030Dh   ; (AX) crire la valeur de BP dans le mot point par DI

PixIni:
                pusha
                mov dx,offset IniMes
                mov ah,9
                int 021H
                popa
                stc                     ; carry="ok"
                RETF                    ; RETOUR VECTEUR (FAR)

IniMes          db " X86IOPix - 2010",13,10
                db "$"


; ** SORTIE PIXEL A TRAVERS INT 010H - |OPIX,X,Y,PEN **
; < conditions d'entre RamCpc:[SI+0] = numro de pinceau (pen)
;                       RamCpc:[SI+2] = y
;                       RamCpc:[SI+4] = x
OPix:
                mov ah,ReadAL           ; charger valeur RamCpc:[SI+0] dans AL
                int 018h                ; couleur demande dans AL
                push ax                 ; sauve numro de pinceau (pen)
                add si,2                ; pointe coordonne Y dans RamCpc
                mov ax,ReadDX           ; charger valeur dans DX
                int 018h                ; coordonne Y dans DX
                add si,2                ; pointe coordonne X dans RamCpc
                mov ax,ReadCX           ; charger valeur dans CX
                int 018h                ; coordonne X dans CX
                pop ax                  ; rcupre numro de pinceau (pen)
                mov ah,0Ch              ; //BIOS//FONCTION 0CH = ECRIRE UN POINT GRAPHIQUE
                INT 010h                ; APPEL INTERRUPTION BIOS 010H
                RETF                    ; RETOUR VECTEUR (FAR)

; ** LECTURE PIXEL A TRAVERS INT 010H - |IPIX,X,Y,@PEN% **
; < conditions d'entre RamCpc:[SI+2] = y
;                       RamCpc:[SI+4] = x
; > condition de sortie RamCpc:[SI+0] = numro de pinceau (pen)
IPix:                
                push bx
                push di
                push si                 ; sauve pointeur adresse variable PEN
                add si,2                ; pointe coordonne Y dans RamCpc
                mov ax,ReadDX           ; charger valeur dans DX
                int 018h                ; coordonne Y dans DX
                add si,2                ; pointe coordonne X dans RamCpc
                mov ax,ReadCX           ; charger valeur dans CX
                int 018h                ; coordonne X dans CX
                mov ah,0Dh              ; //BIOS//FONCTION 0DH = LIRE UN POINT GRAPHIQUE
                INT 010h                ; APPEL INTERRUPTION BIOS 010H
                pop si                  ; rcupre pointeur adresse variable PEN
                push ax                 ; sauve numro de pinceau (pen)
                mov ax,ReadDI           ; charger adresse variable PEN dans DI
                int 018h                ; adresse variable PEN dans DI
                pop bx                  ; rcupre numro de pinceau (pen)
                xor bh,bh               ; raz poid fort numro de pinceau (pen)
                mov ax,WriteBX          ; poser BX dans RamCpc:[DI+0]
                int 018h                ; poser numro de pinceau (pen)
                pop di
                pop bx
                RETF                    ; RETOUR VECTEUR (FAR)

; ** |PALASK,@PAL(0) - CHARGER PALETTE DANS VARIABLE DIMENSIONNE **
PalAsk:
                pusha
                push es
                mov ax,ReadSI           ; charge l'adresse du 1er lment du tableau dans SI
                int 018h

                push si
                sub si,2
                mov ax,ReadCX           ; charger "nombre d'lements du tableau + 1" dans CX
                int 018h
                dec cx
                and ch,3                ; nombre d'lements du tableau 3*256 maxi
                pop di                  ; pointe 1er lment du tableau

                push cx
                mov ax,cx               ; nombre d'lements du tableau
                mov cx,3                ; diviseur
                xor dx,dx               ; ?
                div cx                  ; /3=nombre de couleurs  charger dans tampon
                mov cx,ax               ; rsultat dans cx

                push cs
                pop es                  ; segment tampon couleurs palette
                mov dx,offset Palette   ; offset tampon couleurs palette
                mov bx,0                ; premier index
                mov ax,01017h           ; //BIOS//FONCTION: LIRE CONTENU PLUSIEURS REGISTRES DE COULEUR DAC
                INT 010H                ; APPEL INTERRUPTION BIOS 010H
                pop cx                  ; recupre nombre d'lements du tableau

                mov si,offset Palette   ; offset tampon couleurs palette
PalAskCont:     mov al,cs:[si]          ; charge index couleur
                shl al,2                ; 64>255tons
                mov ah,WriteAL          ; crire la valeur de AL dans l'octet point par DI
                int 018h
                add di,2                ; 2 octets par lment pour le tableau destination
                inc si                  ; 1 octet par lment pour le tampon source
                loop PalAskCont         ; continuer si encore des lments
                pop es
                popa
                RETF                    ; RETOUR VECTEUR (FAR)

Palette         db 256*3 dup (0)        ; tampon couleurs palette (RVB)

; ** |PALSET,@PAL(0) - SET PALETTE DEPUIS VARIABLE DIMENSIONNE **
; remarque: le tableau doit avoir t dfini par l'instruction basic DEFINT
PalSet:
                pusha
                push es
                mov ax,ReadSI           ; charge l'adresse du 1er lment du tableau dans SI
                int 018h

                push si
                sub si,2
                mov ax,ReadCX           ; charger "nombre d'lements du tableau + 1" dans CX
                int 018h
                dec cx
                and ch,3                ; nombre d'lements du tableau 3*256 maxi
                pop si

                push cx
                mov di,offset Palette   ; offset tampon couleurs palette
PalSetCont:     mov ah,ReadAL           ; charger valeur RamCpc:[SI+0] dans AL
                int 018h                ; couleur demande dans AL
                shr al,2                ; 255>64tons
                mov cs:[di],al          ; pose numro de couleur dans tampon "Palette"
                add si,2                ; 2 octets par lment pour le tableau source
                inc di                  ; 1 octet par lment pour le tampon destination
                loop PalSetCont         ; continuer si encore des lments
                pop ax                  ; nombre d'lements du tableau
                mov cx,3                ; diviseur
                xor dx,dx               ; ?
                div cx                  ; /3=nombre de couleurs  redfinir
                mov cx,ax               ; rsultat dans cx
                push cs
                pop es                  ; segment tampon couleurs palette
                mov dx,offset Palette   ; offset tampon couleurs palette
                mov bx,0                ; premier index
                mov ax,01012h           ; //BIOS//FONCTION: CHARGER PLUSIEURS REGISTRES DE COULEUR DAC
                INT 010H                ; APPEL INTERRUPTION BIOS 010H
                pop es
                popa
                RETF                    ; RETOUR VECTEUR (FAR)


; ** |PALGREY - CONVERTIR PALETTE EN NUANCES DE GRIS **
PalGrey:
                pusha
                mov bx,0                ; premier index
                mov cx,256              ; nombre de couleurs  traiter
                mov ax,0101Bh           ; //BIOS//FONCTION: Convertir plusieurs registres de
                                        ;                   couleur DAC en nuances de gris
                INT 010H                ; APPEL INTERRUPTION BIOS 010H
                popa
                RETF                    ; RETOUR VECTEUR (FAR)

; ** EXEMPLE CHARGEMENT VARIABLE BASIC **
; < conditions d'entre RamCpc:[SI] pointe pointeur variable alphanumrique
;                                ou pointe variable numrique
; > condition de sortie AL=variable numrique ou 1er caractre variable alphanumrique
VariAsk:
                push si
                mov ax,ReadSI           ; charger valeur RamCpc:[SI] dans SI
                int 018h
                dec si                  ; pointe type variable
                mov ah,ReadAL           ; charger valeur RamCpc:[SI] dans AL
                int 018h
                cmp al,0B0h             ; constante alphanumrique ? ex:"A"
                jz short ConstAlpha     ; oui sauter
                cmp al,2                ; variable alphanumrique ? ex:a$
                jnz short Varinum       ; non sauter
ConstAlpha:     add si,2                ; pointe pointeur caractre
                mov ax,ReadSI           ; charger valeur RamCpc:[SI] dans SI
                int 018h                ; pointe caractre
                mov ah,ReadAL           ; charger valeur RamCpc:[SI] dans AL
                int 018h
                pop si
                ret                     ; RETOUR SOUS PROGRAMME (NEAR)

;ex:&30,a
VariNum:        pop si
                mov ah,ReadAL           ; charger valeur RamCpc:[SI] dans AL
                int 018h
                ret                     ; RETOUR SOUS PROGRAMME (NEAR)


end start
