'Z80IOPIX.BAS
memory &A5FF

|CMD
;*********************
;* CpcAlive commands *
;*********************

;***************************************************************
;* RSX INPUT/OUTPUT PIXEL CPC THROUGH BIOS INTERRUPTION 010H   *
;***************************************************************
;* The following listing generate functions |OPIX,X,Y,PEN and  *
;* |IPIX,X,Y,@pen which respectively write and read a graphic  *
;* point to the screen.                                        *
;* Commands: |OPIX,X,Y,pen              = OUTPUT PIXEL         *
;*           |IPIX,X,Y,adress pen       = INPUT PIXEL          *
;* (X and Y are relating to the top left corner of the screen) *
;***************************************************************
EX\Z80IOPIX.ASM

;*********************
;*    Cpc Commands   *
;*********************
text

10 call &A600:pix%=0:'RSX INITIALISATIONS
20 mode 1:PRINT:PRINT"display a pixel (PEN 3)"
40 PRINT "to the coordinates 0,0 with |OPIX"
50 PRINT "and read it with |IPIX"
run
|OPIX,0,0,3:|IPIX,0,0,@pix%:print pix%
|STOP


; . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .


LISTING RSX

0001   0000             ;                                 Z80IOPix.asm
0002   0000             ;       ** RSX INPUT/OUTPUT PIXEL CPC THROUGH BIOS INTERRUPTION 010H **
0003   0000             
0004   0000             ; ** Opcodes CpcAlive **
0005   0000             #define LD_AH_A         .db 040h\ .db 052h              ; load the value of the Z80 register A
0006   0000                                                                     ; in the X86 register AH
0007   0000             #define LD_A_AH         .db 040h\ .db 05Bh              ; load the value of the X86 register AH
0008   0000                                                                     ; in the Z80 register A
0009   0000             #define INT(xx)         .db 040h\ .db 048h\ .db xx      ; call Dos interruption number xx
0010   0000             
0011   A600             .org 0A600h
0012   A600             
0013   A600 01 09 A6                            ld bc,RsxTb
0014   A603 21 11 A6                            ld hl,Buf
0015   A606 C3 D1 BC                            jp 0BCD1h               ; RSX INITIALISATIONS
0016   A609             
0017   A609 15 A6       RsxTb                   .dw MnemoTb
0018   A60B C3 1E A6                            jp OPix                 ; ** |OPIX - OUTPUT PIXEL THROUGH INT 010H **
0019   A60E C3 35 A6                            jp IPix                 ; ** |IPIX - INTPUT PIXEL THROUGH INT 010H **
0020   A611             
0021   A611 00 00 00 00 Buf                     .db 0,0,0,0             ; 4 bytes reserved for kernal
0022   A615             
0023   A615 4F 50 49    MnemoTb                 .db "OPI"               ; |OPIX
0024   A618 D8                                  .db 058h | 080h
0025   A619 49 50 49                            .db "IPI"               ; |IPIX
0026   A61C D8                                  .db 058h | 080h
0027   A61D 00                                  .db 0
0028   A61E             
0029   A61E             
0030   A61E             ; ** OUTPUT PIXEL THROUGH INT 010H **
0031   A61E             ; <(IX+0) and (DE) = pen number
0032   A61E             ;  (IX+2) = y
0033   A61E             ;  (IX+4) = x
0034   A61E             
0035   A61E DD 56 03    OPix:                   ld d,(IX+3)             ; coordinate y
0036   A621 DD 5E 02                            ld e,(IX+2)
0037   A624 DD 46 05                            ld b,(IX+5)             ; coordinate x
0038   A627 DD 4E 04                            ld c,(IX+4)
0039   A62A 3E 0C                               ld a,0Ch                ; FUNCTION 0CH = WRITE A GRAPHIC POINT
0040   A62C 40                                  LD_AH_A                 ; load the value of the Z80 register A
0040   A62D 52          
0041   A62E                                                             ; in the X86 register AH
0042   A62E DD 7E 00                            ld a,(IX+0)             ; color requested
0043   A631 40                                  INT(010h)               ; CALL INTERRUPTION BIOS 010H
0043   A632 48          
0043   A633 10          
0044   A634 C9                                  ret
0045   A635             
0046   A635             
0047   A635             ; ** INPUT PIXEL THROUGH INT 010H **
0048   A635             ; <IX+0 and DE = pointer pen number
0049   A635             ;  (IX+2) = y
0050   A635             ;  (IX+4) = x
0051   A635             ; >(IX+0) and (DE) = pen number
0052   A635             
0053   A635 D5          IPix:                   push de
0054   A636 DD 56 03                            ld d,(IX+3)             ; coordinate y
0055   A639 DD 5E 02                            ld e,(IX+2)
0056   A63C DD 46 05                            ld b,(IX+5)             ; coordinate X
0057   A63F DD 4E 04                            ld c,(IX+4)
0058   A642 3E 0D                               ld a,0Dh                ; FUNCTION 0DH = READ A GRAPHIC POINT
0059   A644 40                                  LD_AH_A                 ; load the value of the Z80 register A
0059   A645 52          
0060   A646                                                             ; in the X86 register AH
0061   A646 40                                  INT(010h)               ; CALL INTERRUPTION BIOS 010H
0061   A647 48          
0061   A648 10          
0062   A649 D1                                  pop de
0063   A64A 12                                  ld (de),a               ; pixel color
0064   A64B 13                                  inc de
0065   A64C AF                                  xor a
0066   A64D 12                                  ld (de),a
0067   A64E C9                                  ret
0068   A64F             
0069   A64F             .end
tasm: Number of errors = 0
