set lng eng
set mem 128
set drivedir_A disc
set drivedir_B disc
set OK 0
set monoscreen 0
set customer 7
set model 2
set installdir ""
set workdir ""
set printercmd ""

proc cmd_OK {} {
  global env installdir workdir printercmd
  global lng mem monoscreen customer model
  global rom1 rom2 rom3 rom4 rom5 rom6 rom7
  global drivedir_A drivedir_B
  global pcr plf pff
  set fid [open $env(HOME)/.cpc4xrc w]
  puts $fid $installdir
  puts $fid $workdir
  puts $fid 1
  puts $fid $mem
  puts $fid $rom1
  puts $fid $rom2
  puts $fid $rom3
  puts $fid $rom4
  puts $fid $rom5
  puts $fid $rom6
  puts $fid $rom7
  puts $fid $drivedir_A
  puts $fid $drivedir_B
  puts $fid $monoscreen
  puts $fid $customer
  puts $fid $lng
  puts $fid $model
  puts $fid $printercmd
  puts $fid $pcr
  puts $fid $plf
  puts $fid $pff
  close $fid
  destroy .
}

proc cmd_Cancel {} {
  destroy .
}


wm title . "Einstellungen"
set fid [open $env(HOME)/.cpc4xrc r]
  gets $fid installdir
  gets $fid workdir
  gets $fid OK
  gets $fid mem
  gets $fid rom1
  gets $fid rom2
  gets $fid rom3
  gets $fid rom4
  gets $fid rom5
  gets $fid rom6
  gets $fid rom7
  gets $fid drivedir_A
  gets $fid drivedir_B
  gets $fid monoscreen
  gets $fid customer
  gets $fid lng
  gets $fid model
  gets $fid printercmd
  gets $fid pcr
  gets $fid plf
  gets $fid pff
close $fid


frame .f1
frame .f1.left -borderwidth 10
frame .f1.right -borderwidth 10

frame .f1.left.language -borderwidth 10
label .f1.left.language.lbl -text "Sprache" -justify left -anchor w
radiobutton .f1.left.language.ger -variable lng -text "Deutsch" -value ger -padx 10
radiobutton .f1.left.language.eng -variable lng -text "English" -value eng -padx 10
radiobutton .f1.left.language.fra -variable lng -text "Franais" -value fra -padx 10
pack .f1.left.language.lbl -side top -anchor w
pack .f1.left.language.ger .f1.left.language.eng .f1.left.language.fra -side left -anchor w
pack .f1.left.language -side top -anchor w

frame .f1.left.model -borderwidth 10
label .f1.left.model.lbl -text "Modell" -justify left -anchor w
radiobutton .f1.left.model.cpc464 -variable model -text "CPC 464" -value 0 -padx 10
radiobutton .f1.left.model.cpc664 -variable model -text "CPC 664" -value 1 -padx 10
radiobutton .f1.left.model.cpc6128 -variable model -text "CPC 6128" -value 2 -padx 10
pack .f1.left.model.lbl -side top -anchor w
pack .f1.left.model.cpc464 .f1.left.model.cpc664 .f1.left.model.cpc6128 -side left -anchor w
pack .f1.left.model -side top -anchor w

frame .f1.left.memory -borderwidth 10
label .f1.left.memory.lbl -text "Speicher" -justify left -anchor w
radiobutton .f1.left.memory.m64  -variable mem -text "64k" -value 64 -padx 10
radiobutton .f1.left.memory.m128 -variable mem -text "128k" -value 128 -padx 10
radiobutton .f1.left.memory.m576 -variable mem -text "576k" -value 576 -padx 10
pack .f1.left.memory.lbl -side top -anchor w
pack .f1.left.memory.m64 .f1.left.memory.m128 .f1.left.memory.m576 -side left -anchor w
pack .f1.left.memory -side top -anchor w

frame .f1.left.roms -borderwidth 10
label .f1.left.roms.lbl -text "Obere ROM's" -justify left -anchor w
pack  .f1.left.roms.lbl -side top -anchor w
for {set i 1} {$i <= 7} {incr i} {
  frame .f1.left.roms.f$i
  label .f1.left.roms.f$i.r -text $i -anchor w -width 3
  entry .f1.left.roms.f$i.e -textvariable rom$i -relief sunken
  pack .f1.left.roms.f$i.r .f1.left.roms.f$i.e -side left
  pack .f1.left.roms.f$i -side top -anchor w
}
pack .f1.left.roms -side top -anchor w

frame .f1.right.drive -borderwidth 10
label .f1.right.drive.lbl -text "Standard-Verzeichnisse fr Disketten-Images" -justify left
pack  .f1.right.drive.lbl -side top -anchor w

frame .f1.right.drive.a
label .f1.right.drive.a.lbl -text "Laufwerk A:" -anchor w -width 12
entry .f1.right.drive.a.entry -textvariable drivedir_A -relief sunken
pack  .f1.right.drive.a.lbl .f1.right.drive.a.entry -side left

frame .f1.right.drive.b
label .f1.right.drive.b.lbl -text "Laufwerk B:" -anchor w -width 12
entry .f1.right.drive.b.entry -textvariable drivedir_B -relief sunken
pack  .f1.right.drive.b.lbl .f1.right.drive.b.entry -side left

pack .f1.right.drive.a .f1.right.drive.b -side top -anchor w
pack .f1.right.drive -side top -anchor w

frame .f1.right.monitor -borderwidth 10
label .f1.right.monitor.lbl -text "Monitor" -anchor w
radiobutton .f1.right.monitor.color -variable monoscreen -value 0 -text "Farbe" -anchor w -padx 10
radiobutton .f1.right.monitor.green -variable monoscreen -value 32 -text "Grn" -anchor w -padx 10
pack .f1.right.monitor.lbl -side top -anchor w
pack .f1.right.monitor.color .f1.right.monitor.green -side left
pack .f1.right.monitor -side top -anchor w

frame .f1.right.customer -borderwidth 10
label .f1.right.customer.lbl -text "Hersteller" -anchor w
frame .f1.right.customer.1
frame .f1.right.customer.2
frame .f1.right.customer.3
radiobutton .f1.right.customer.1.ams -variable customer -value 14 -anchor w -width 10 -text "Amstrad"
radiobutton .f1.right.customer.1.sch -variable customer -value 10 -anchor w -width 10 -text "Schneider"
radiobutton .f1.right.customer.1.isp -variable customer -value 0  -anchor w -width 10 -text "Isp"
radiobutton .f1.right.customer.2.tri -variable customer -value 2  -anchor w -width 10 -text "Triumph"
radiobutton .f1.right.customer.2.sai -variable customer -value 4  -anchor w -width 10 -text "Saisho"
radiobutton .f1.right.customer.2.sol -variable customer -value 6  -anchor w -width 10 -text "Solavox"
radiobutton .f1.right.customer.3.awa -variable customer -value 8  -anchor w -width 10 -text "Awa"
radiobutton .f1.right.customer.3.ori -variable customer -value 12 -anchor w -width 10 -text "Orion"
pack .f1.right.customer.lbl -side top -anchor w
pack .f1.right.customer.1.ams .f1.right.customer.1.sch .f1.right.customer.1.isp -side left
pack .f1.right.customer.2.tri .f1.right.customer.2.sai .f1.right.customer.2.sol -side left
pack .f1.right.customer.3.awa .f1.right.customer.3.ori -side left
pack .f1.right.customer.1 .f1.right.customer.2 .f1.right.customer.3 -side top -anchor w
pack .f1.right.customer -side top -anchor w

frame .f1.right.printer -borderwidth 10
label .f1.right.printer.lbl -text "Kommandozeile fr Druckerausgaben" -anchor w
entry .f1.right.printer.cmd -textvariable printercmd -relief sunken
pack .f1.right.printer.lbl .f1.right.printer.cmd -side top -anchor w
label .f1.right.printer.lbl2 -text "Diese Zeichen nicht mit drucken" -anchor w
checkbutton .f1.right.printer.cr -variable pcr -text "CR" -padx 10
checkbutton .f1.right.printer.lf -variable plf -text "LF" -padx 10
checkbutton .f1.right.printer.ff -variable pff -text "FF" -padx 10
pack .f1.right.printer.lbl2 -side top -anchor w
pack .f1.right.printer.cr .f1.right.printer.lf .f1.right.printer.ff -side left
pack .f1.right.printer -side top -anchor w

pack .f1.left .f1.right -side left -anchor n
pack .f1 -side top

frame .f -borderwidth 10
button .f.ok -command cmd_OK -text "bernehmen und Emulation zurcksetzen"
button .f.cancel -command cmd_Cancel -text "Abbruch" -width 8
pack .f.ok .f.cancel -side right
pack .f -side top

