/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.tape;

import JCPC.core.device.tape.CDT2WAVBaseOutput;

public class CDT2WAVWAVOutput
extends CDT2WAVBaseOutput {
    private WAVHeader wavHeader;

    public CDT2WAVWAVOutput(int freq) {
        super(freq);
    }

    public void dispose() {
        super.dispose();
        this.wavHeader = null;
    }

    protected void init() {
        this.wavHeader = new WAVHeader();
        this.wavHeader.ChunkID = 1179011410;
        this.wavHeader.ChunkSize = 0;
        this.wavHeader.Format = 1163280727;
        this.wavHeader.fmtChunkID = 544501094;
        this.wavHeader.fmtChunkSize = 16;
        this.wavHeader.AudioFormat = 1;
        this.wavHeader.SampleRate = (int)this.getFrequency();
        this.wavHeader.Subchunk2ID = 1635017060;
        this.wavHeader.Subchunk2Size = 0;
        this.wavHeader.NumChannels = 1;
        this.wavHeader.BitsPerSample = (short)8;
        this.wavHeader.ByteRate = (int)this.getFrequency();
        this.wavHeader.BlockAlign = 1;
    }

    protected void write(int numsamples) {
        this.wavHeader.Subchunk2Size = this.outputTell() + numsamples - 44;
        this.wavHeader.ChunkSize = 36 + this.wavHeader.Subchunk2Size;
        byte sample = this.isLowAmp() ? (byte)38 : -38;
        this.outputByte(sample, numsamples);
    }

    protected void stop() {
        this.wavHeader.write();
    }

    private class WAVHeader {
        public int ChunkID;
        public int ChunkSize;
        public int Format;
        public int fmtChunkID;
        public int fmtChunkSize;
        public short AudioFormat;
        public short NumChannels;
        public int SampleRate;
        public int ByteRate;
        public short BlockAlign;
        public short BitsPerSample;
        public int Subchunk2ID;
        public int Subchunk2Size;

        private WAVHeader() {
        }

        private void writeInt(int data) {
            CDT2WAVWAVOutput.this.outputByte((byte)(data & 0xFF));
            CDT2WAVWAVOutput.this.outputByte((byte)(data >> 8 & 0xFF));
            CDT2WAVWAVOutput.this.outputByte((byte)(data >> 16 & 0xFF));
            CDT2WAVWAVOutput.this.outputByte((byte)(data >> 24 & 0xFF));
        }

        private void writeShort(short data) {
            CDT2WAVWAVOutput.this.outputByte((byte)(data & 0xFF));
            CDT2WAVWAVOutput.this.outputByte((byte)(data >> 8 & 0xFF));
        }

        public void write() {
            int oldPos = CDT2WAVWAVOutput.this.outputTell();
            CDT2WAVWAVOutput.this.outputSeek(0);
            this.writeInt(this.ChunkID);
            this.writeInt(this.ChunkSize);
            this.writeInt(this.Format);
            this.writeInt(this.fmtChunkID);
            this.writeInt(this.fmtChunkSize);
            this.writeShort(this.AudioFormat);
            this.writeShort(this.NumChannels);
            this.writeInt(this.SampleRate);
            this.writeInt(this.ByteRate);
            this.writeShort(this.BlockAlign);
            this.writeShort(this.BitsPerSample);
            this.writeInt(this.Subchunk2ID);
            this.writeInt(this.Subchunk2Size);
            CDT2WAVWAVOutput.this.outputSeek(oldPos);
        }
    }
}

