/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.device.floppy.UPD765A;
import JCPC.system.cpc.CPCDiscImageSector;

public class CPCDiscImageTrack {
    private final int track;
    private int side;
    private final int length;
    private CPCDiscImageSector[] sectors;

    public CPCDiscImageTrack(int track, int side, int length, int numberOfSectors) {
        this.track = track;
        this.side = side;
        this.length = length;
        this.sectors = new CPCDiscImageSector[numberOfSectors];
    }

    public void removeAllSectorsFromTrack() {
        this.sectors = new CPCDiscImageSector[0];
    }

    public void addSectorToTrack(int sectorTrack, int sectorSide, int sectorId, int sectorSize, int fillerByte) {
        CPCDiscImageSector[] newsectors = new CPCDiscImageSector[this.sectors.length + 1];
        for (int i = 0; i < this.sectors.length; ++i) {
            CPCDiscImageSector sect = this.sectors[i];
            newsectors[i] = new CPCDiscImageSector(sect.getTrack(), sect.getSide(), sect.getId(), sect.getSize(), sect.getData(), sect.getST1(), sect.getST2());
        }
        this.sectors = newsectors;
        int bytes = UPD765A.getSectorSize(sectorSize);
        byte[] sectData = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            sectData[i] = (byte)fillerByte;
        }
        this.setSector(new CPCDiscImageSector(sectorTrack, sectorSide, sectorId, sectorSize, sectData, 0, 0), newsectors.length - 1);
    }

    public void setSector(CPCDiscImageSector sector, int index) {
        this.sectors[index] = sector;
    }

    public CPCDiscImageSector getSector(int index) {
        return this.sectors[index];
    }

    public int getSectorCount() {
        return this.sectors.length;
    }

    public int[] getSectorIDs(int index) {
        int[] result = new int[]{this.sectors[index].getTrack(), this.sectors[index].getSide(), this.sectors[index].getId(), this.sectors[index].getSize()};
        return result;
    }

    public int getTrack() {
        return this.track;
    }

    public int getSide() {
        return this.side;
    }

    public int getLength() {
        return this.length;
    }

    public void setSectorData(int sectorTrack, int sectorSide, int sectorId, int sectorSize, byte[] data) {
        for (int i = 0; i < this.sectors.length; ++i) {
            CPCDiscImageSector sect = this.sectors[i];
            if (sect.getTrack() != sectorTrack || sect.getSide() != sectorSide || sect.getId() != sectorId || sect.getSize() != sectorSize) continue;
            sect.setData(data);
            break;
        }
    }

    public byte[] getSectorData(int sectorTrack, int sectorSide, int sectorId, int sectorSize) {
        for (int i = 0; i < this.sectors.length; ++i) {
            CPCDiscImageSector sect = this.sectors[i];
            if (sect.getTrack() == sectorTrack && sect.getId() == sectorId && sect.getSize() == sectorSize) {
                return sect.getData();
            }
            if (sect.getTrack() != sectorTrack || sect.getId() != sectorId || sect.getSize() == 0) continue;
            try {
                return sect.getData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public int getST1(int sectorTrack, int sectorSide, int sectorId, int sectorSize) {
        for (int i = 0; i < this.sectors.length; ++i) {
            CPCDiscImageSector sect = this.sectors[i];
            if (sect.getTrack() != sectorTrack || sect.getId() != sectorId || sect.getSize() != sectorSize) continue;
            return sect.getST1();
        }
        return 0;
    }

    public int getST2(int sectorTrack, int sectorSide, int sectorId, int sectorSize) {
        for (int i = 0; i < this.sectors.length; ++i) {
            CPCDiscImageSector sect = this.sectors[i];
            if (sect.getTrack() != sectorTrack || sect.getId() != sectorId || sect.getSize() != sectorSize) continue;
            return sect.getST2();
        }
        return 0;
    }

    public void setST1(int sectorTrack, int sectorSide, int sectorId, int sectorSize, int st1) {
        for (int i = 0; i < this.sectors.length; ++i) {
            CPCDiscImageSector sect = this.sectors[i];
            if (sect.getTrack() != sectorTrack || sect.getId() != sectorId || sect.getSize() != sectorSize) continue;
            sect.setST1(st1);
        }
    }

    public void setST2(int sectorTrack, int sectorSide, int sectorId, int sectorSize, int st2) {
        for (int i = 0; i < this.sectors.length; ++i) {
            CPCDiscImageSector sect = this.sectors[i];
            if (sect.getTrack() != sectorTrack || sect.getId() != sectorId || sect.getSize() != sectorSize) continue;
            sect.setST2(st2);
        }
    }

    public void setSide(int side) {
        this.side = side;
        for (int i = 0; i < this.sectors.length; ++i) {
            this.sectors[i].setSide(side);
        }
    }
}

