/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.Util;
import JCPC.core.device.crtc.Basic6845;
import JCPC.core.device.crtc.CRTCListener;
import JCPC.core.device.crtc.Slider;
import JCPC.core.renderer.MonitorRenderer;
import JCPC.system.cpc.CPC;
import JCPC.system.cpc.CPCMemory;
import JCPC.system.cpc.GraphicsDecoder;
import JCPC.system.cpc.Z80;
import JCPC.ui.Display;
import java.awt.Dimension;

public final class GateArray
extends MonitorRenderer
implements CRTCListener {
    protected int borderHeight;
    protected static final GraphicsDecoder decoder = new GraphicsDecoder();
    protected final int HOFFSET = 686080;
    protected final int HOFFSEND = 3831808;
    protected Dimension HALF_DISPLAY_SIZE = new Dimension(384, 272);
    protected Dimension FULL_DISPLAY_SIZE = new Dimension(768, 272);
    static int returnmode = 0;
    static int rambank = 0;
    static int smode = 1;
    public static CPC cpc;
    public static Z80 z80;
    public Basic6845 crtc;
    public int InterruptLineCount;
    protected int InterruptSyncCount = 0;
    protected int hSyncCount;
    protected int vSyncCount = 0;
    protected int screenMode = -1;
    public int newMode = 0;
    protected boolean[] isBorder;
    protected boolean[] rendered;
    protected boolean inHSync = false;
    protected boolean outHSync = false;
    public static int[] inks;
    protected byte[] fullMap;
    protected byte[] halfMap;
    protected int offset = 0;
    protected int scanStart = 0;
    protected boolean scanStarted;
    protected Renderer borderRenderer;
    protected Renderer syncRenderer;
    protected Renderer defRenderer;
    protected Renderer startRenderer;
    protected Renderer endRenderer;
    protected Renderer renderer;
    protected int endPix;
    protected int selInk = 0;
    protected boolean render = true;
    protected boolean rendering = true;
    public static byte[] screenmemory;
    protected int Luminance = 255;
    protected static final int[] maTranslate;
    protected static int[] CPCInks;
    protected static int[] CPCInksb;
    protected static int[] GAInks;
    protected int[] palette = new int[]{13, 13, 19, 25, 1, 7, 10, 16, 7, 25, 24, 26, 6, 8, 15, 17, 1, 19, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
    protected static int[] Inks;
    public static int[] LUM;
    public static int[] inkTranslateColor;
    protected static final int[] original;
    protected static final byte[][] fullMaps;
    protected static final byte[][] halfMaps;
    boolean GateArray_RasterInterruptRequest = false;
    boolean test = true;
    boolean testbars;
    public static int SoftScrollRegister;
    int oldscroll;
    boolean plusdone = true;
    int spritecheck;
    int oldline;
    int pline;
    int pd;
    Slider slider;
    int[] ff = new int[]{243, 237, 86, 49, 255, 191, 1, 131, 247, 237, 73, 1, 0, 244, 237, 73};
    boolean fireandforget = false;
    int skipsprites;
    int vscroll;
    public static int verticalScroll;
    int[] lines = new int[]{0, 112, 224, 336, 448, 560, 672, 784};
    int borderpixel = 0;
    int maxline;
    int ticker;
    boolean tt;
    protected int horizontalScroll;
    int p;
    int spriteoffset;
    int spos;
    CPCMemory spritemem;
    public int[] xm = new int[16];
    public int[] ym = new int[16];
    int[] xpos = new int[16];
    int[] ypos = new int[16];
    int ymin;
    int ymax;
    int xmin;
    int xmax;
    int sproffset;
    int pix;
    int crtcX;
    int crtcY;
    int[] result = new int[4];
    int split;
    int aline;
    boolean srendered;
    int pixelcheck;
    boolean[] spriteput = new boolean[16];
    public boolean[] spritechanged = new boolean[16];
    Thread draw;
    boolean spritesput = false;
    int bink = 16;
    int rasterline;
    int stepper;
    int oldra;
    int tsync;
    boolean DEBUG_BORDER = false;
    boolean skipper = false;
    int line;
    int pixelpos;
    int spritepixel;
    int spriteline;
    int startoff;
    int renderoffset = 0;
    int r3;
    int count = 0;
    boolean is = true;
    boolean hasscroll;
    int scrolline;
    int ispos;
    int[] vscrolls = new int[]{0, 16, 32, 48, 64, 80, 96, 112};
    boolean skip;

    public int getBorder() {
        return inks[16];
    }

    public static void resetCPCColours() {
        System.arraycopy(original, 0, inkTranslateColor, 0, original.length);
    }

    public static void setPlusPalette(int ink, int r, int g, int b) {
        GateArray.setPlusPalette(ink, GateArray.putRGB(LUM[r], LUM[g], LUM[b]));
    }

    public static void setPlusPalette(int ink, int value) {
        GateArray.inkTranslateColor[ink] = value;
        GateArray.resetInkss();
    }

    public static void setPalette(int ink, int value) {
        GateArray.inkTranslateColor[GateArray.Inks[ink]] = value;
    }

    public int getVPOS() {
        return this.crtc.getVVPOS();
    }

    public int getHPOS() {
        return this.crtc.getHPOS();
    }

    public GateArray(CPC cpc) {
        super("Amstrad Gate Array");
        this.setCycleFrequency(1000000L);
        GateArray.cpc = cpc;
        z80 = cpc.z80;
        this.crtc = cpc.crtc;
        this.reset();
        this.setHalfSize();
    }

    public void setHalfSize() {
        if (this.defRenderer == null) {
            this.defRenderer = new FullRenderer();
            this.startRenderer = new FullStartRenderer();
            this.endRenderer = new FullEndRenderer();
            this.borderRenderer = new BorderRenderer(16, 16);
            this.syncRenderer = new BorderRenderer(32, 16);
            this.renderer = this.borderRenderer;
        }
    }

    public void reset() {
        this.oldline = -1;
        this.spritecheck = -1;
        System.out.println("GateArray reset!");
        this.crtc.reset();
        this.horizontalScroll = 0;
        verticalScroll = 0;
        this.InterruptLineCount = 0;
        this.setScreenMode(1);
        for (int i = 0; i < 33; ++i) {
            GateArray.inks[i] = -16777216;
        }
        GateArray.inks[16] = -8355712;
        Display.vscroll = "" + verticalScroll + " - " + this.horizontalScroll;
        SoftScrollRegister = 0;
        this.horizontalScroll = 0;
        verticalScroll = 0;
        if (this.crtc != null) {
            this.crtc.setVerticalScroll(verticalScroll);
            this.crtc.init();
        }
        GateArray.resetCPCColours();
    }

    public void memoryReset() {
        this.oldline = -1;
        this.spritecheck = -1;
        this.InterruptLineCount = 0;
        SoftScrollRegister = 0;
        this.horizontalScroll = 0;
        verticalScroll = 0;
        this.crtc.setVerticalScroll(verticalScroll);
        this.crtc.init();
        GateArray.resetCPCColours();
        Display.vscroll = "" + verticalScroll + " - " + this.horizontalScroll;
    }

    public void setSelectedInk(int value) {
        this.selInk = (value & 0x1F) < 16 ? value & 0xF : 16;
    }

    public int getSelectedInk() {
        return this.selInk;
    }

    public static void setInk(int index, int value) {
        GateArray.CPCInks[index] = GAInks[value & 0x1F];
        GateArray.CPCInksb[index] = value;
        GateArray.inks[index] = inkTranslateColor[value & 0x1F];
    }

    public static void setBorder(int value) {
        GateArray.CPCInks[16] = GAInks[value & 0x1F];
        GateArray.CPCInksb[16] = value;
        GateArray.inks[16] = inkTranslateColor[value & 0x1F];
    }

    public static int getInk(int index) {
        return CPCInks[index];
    }

    public static int getInks(int index) {
        return CPCInksb[index];
    }

    public void writePort(int port, int value) {
        if (GateArray.cpc.memory.plus) {
            return;
        }
        if ((value & 0x80) == 0) {
            if ((value & 0x40) == 0) {
                this.selInk = (value &= 0x1F) < 16 ? value : 16;
            } else {
                GateArray.CPCInks[this.selInk] = GAInks[value & 0x1F];
                GateArray.CPCInksb[this.selInk] = value & 0x1F;
                GateArray.inks[this.selInk] = inkTranslateColor[value & 0x1F];
            }
        } else if ((value & 0x40) == 0) {
            GateArray.cpc.asic.romconfig = value;
            GateArray.cpc.asic.setModeAndROMEnable();
        } else {
            GateArray.cpc.memory.setRAMBank(value);
            rambank = value;
        }
    }

    public int getRAMBank() {
        return rambank;
    }

    public int getMode() {
        return returnmode;
    }

    public void setScreenMode(int mode) {
        this.screenMode = mode;
        this.fullMap = fullMaps[mode];
        this.halfMap = halfMaps[mode];
    }

    public int getScreenMode() {
        return this.screenMode;
    }

    public static int getSMode() {
        return smode;
    }

    public void GateArray_AcknowledgeInterrupt() {
        this.InterruptLineCount &= 0x1F;
        this.GateArray_RasterInterruptRequest = false;
    }

    public boolean GateArray_GetInterruptRequest() {
        return this.GateArray_RasterInterruptRequest;
    }

    public void GateArray_ClearInterrupt() {
        this.GateArray_RasterInterruptRequest = false;
        z80.Z80_ClearInterruptRequest();
        this.GateArray_ClearInterruptCount();
        cpc.getAsic().ASIC_ClearRasterInterrupt();
    }

    public void GateArray_ClearInterruptCount() {
        this.InterruptLineCount = 0;
    }

    public void cycle() {
        if (this.pixels == null) {
            try {
                this.pixels = this.display.getPixels();
            }
            catch (Exception e) {
                this.pixels = new int[208896];
            }
            return;
        }
        if (this.rendered == null) {
            this.rendered = new boolean[this.pixels.length];
        }
        this.crtc.avoidCollision();
        smode = this.screenMode;
        if ((this.hSyncCount == 3 || this.hSyncCount == 4) && this.crtc.CRTCType != 3) {
            this.modeCheck();
        }
        if (this.scanStarted) {
            this.crtc.checkHDisp();
            if (this.hPos < 3831808) {
                this.renderer.render();
            } else {
                this.checkSprites();
                this.endRenderer.render();
                this.scanStarted = false;
                this.render = false;
            }
        } else if (this.render && this.hPos >= 686080) {
            this.startRenderer.render();
            this.scanStarted = true;
        }
        this.crtc.cycle();
        if (this.inHSync) {
            ++this.hSyncCount;
            if (this.hSyncCount == 2) {
                this.outHSync = true;
                super.hSyncStart();
            }
            if (this.hSyncCount == 7) {
                this.endHSync();
            }
        }
        this.clock();
    }

    public void checkSprites() {
        if (this.spritecheck != this.getY()) {
            this.putSprites(true);
            this.spritecheck = this.getY();
        }
    }

    void checkSlider() {
        if (this.slider == null) {
            this.slider = new Slider();
            this.slider.setVisible(true);
            this.slider.slider.setMaximum(20);
            this.slider.slider.setMinimum(0);
        }
    }

    public void checkCart(byte[] data) {
        System.out.println(Util.dumpBytes(data, 0, 16));
        boolean check = true;
        for (int i = 0; i < this.ff.length; ++i) {
            if ((data[i] & 0xFF) == this.ff[i]) continue;
            check = false;
        }
        this.fireandforget = check;
        System.out.println("Fire and Forget loaded:" + this.fireandforget);
    }

    protected void endHSync() {
        if (this.fireandforget && this.InterruptLineCount < 5 && this.InterruptSyncCount == 0) {
            this.crtc.asicHSync();
        }
        if (this.outHSync) {
            this.modeCheck();
            super.hSyncEnd();
        }
        this.outHSync = false;
    }

    public void modeCheck() {
        if (this.screenMode != this.newMode) {
            this.setScreenMode(this.newMode & 3);
        }
    }

    public int getScroll() {
        return verticalScroll;
    }

    public void ASIC_SetSoftScrollRegister(int value) {
        SoftScrollRegister = value & 0xFF;
        this.horizontalScroll = SoftScrollRegister & 0xF;
        verticalScroll = SoftScrollRegister >> 4 & 7;
        this.crtc.setVerticalScroll(verticalScroll);
        Display.vscroll = "" + verticalScroll + " - " + this.horizontalScroll;
    }

    public void hSyncStart() {
        this.hSyncCount = 0;
        this.inHSync = true;
        this.renderer = this.syncRenderer;
    }

    public void hSync() {
        this.ymax = Basic6845.getR(6) * 8 + this.ymin;
        this.render = this.rendering && this.monitorLine >= -4 && this.monitorLine < 268;
        if (this.render) {
            this.offset = this.scanStart;
            this.scanStart += 768;
            if ((SoftScrollRegister & 0x80) << 1 == 0) {
                this.borderpixel = this.pixels[1];
            }
        }
        if (this.vSyncCount > 0 && --this.vSyncCount == 0) {
            super.vSyncEnd();
        }
        this.scanStarted = false;
    }

    public void putSprites(boolean force) {
        if (this.spritemem == null) {
            this.spritemem = (CPCMemory)cpc.getMemory();
        }
        if (cpc.getAsic().isLocked()) {
            return;
        }
        if (GateArray.cpc.doTurbo) {
            boolean bl = this.tt = !this.tt;
            if (this.tt) {
                return;
            }
        }
        for (int spriteindex = 0; spriteindex < 16; ++spriteindex) {
            this.renderSprites(spriteindex, force);
        }
    }

    void GateArray_Interrupt() {
        if (GateArray.cpc.memory.plus) {
            if (!cpc.getAsic().ASIC_RasterIntEnabled()) {
                cpc.getAsic().ASIC_SetRasterInterrupt();
                z80.Z80_SetInterruptRequest();
            }
            return;
        }
        z80.Z80_SetInterruptRequest();
    }

    public void hSyncEnd() {
        this.debug = cpc.getMode() != 3;
        this.endHSync();
        if (++this.InterruptLineCount == 52) {
            this.InterruptLineCount = 0;
            this.GateArray_Interrupt();
        }
        if (this.InterruptSyncCount > 0 && --this.InterruptSyncCount == 0) {
            if (this.InterruptLineCount >= 32) {
                this.GateArray_Interrupt();
            }
            this.InterruptLineCount = 0;
        }
        this.renderer = this.vSyncCount > 0 ? this.syncRenderer : (this.crtc.isVDisp() && this.crtc.isHDisp() ? this.defRenderer : this.borderRenderer);
    }

    public void hDispEnd() {
        this.renderer = this.vSyncCount > 0 || this.crtc.isHSync() ? this.syncRenderer : this.borderRenderer;
    }

    public void hDispStart() {
        this.renderer = this.vSyncCount > 0 || this.crtc.isHSync() ? this.syncRenderer : (this.crtc.isVDisp() ? this.defRenderer : this.borderRenderer);
    }

    public void setMonitorLine(int value) {
        this.offset += value * 768;
    }

    public int getLine() {
        return this.monitorLine;
    }

    public void vSyncStart() {
        super.vSyncStart();
        this.vSyncCount = 25;
        this.renderer = this.syncRenderer;
        this.InterruptSyncCount = 2;
        if (this.isBorder == null) {
            return;
        }
        this.ymin = Basic6845.getR(4) - Basic6845.getR(7) - 3;
        this.ymin *= 8;
        if ((this.ymin & 0x100) == 256) {
            this.ymin |= 0xFF00;
        }
        if ((this.ymin & 0x8000) != 0) {
            this.ymin = -(0 - this.ymin & 0x3F);
        }
        int d = 0;
        for (int i = 0; i < this.isBorder.length; i += 4) {
            if (this.isBorder[i]) continue;
            d = i / 768;
            break;
        }
        if (this.ymin >= 0 && d > this.ymin) {
            this.ymin = d;
        }
    }

    public void vSyncEnd() {
    }

    public int[] getField() {
        this.result[0] = this.xmin;
        this.result[1] = this.xmax;
        this.result[2] = this.ymin * 2;
        this.result[3] = this.ymax * 2;
        return this.result;
    }

    public int getX(int blockID) {
        return blockID % 768;
    }

    public int getY(int blockID) {
        return blockID / 768 % 272;
    }

    public int getY() {
        return this.aline;
    }

    public void setY(int pos) {
        this.aline = this.getY(pos);
    }

    boolean isScroll() {
        return (SoftScrollRegister & 0x80) << 1 != 0;
    }

    protected void putPixel(int pos, int value) {
        if (pos % 768 == 0) {
            this.setY(pos);
        }
        if (this.crtc.getLine() != this.oldra) {
            this.pixelpos = pos;
            this.putSprites(false);
            this.oldra = this.crtc.getLine();
        }
        if (!this.rendered[pos += this.horizontalScroll]) {
            this.pixels[pos] = value;
            if (this.display.DEBUG_SPRITES) {
                this.display.ppixels[pos] = 0;
            }
        }
        if (pos % 768 < this.xmin + 16 && this.isScroll()) {
            this.pixels[pos] = inks[this.bink];
            this.rendered[pos] = true;
        }
        if (pos % 768 > this.xmax && this.isScroll()) {
            this.pixels[pos] = inks[this.bink];
            this.rendered[pos] = true;
        }
        if (this.isBorder[pos] && this.DEBUG_BORDER) {
            this.pixels[pos] = 0xFF0000;
        }
    }

    public void renderSprites(int spriteindex, boolean force) {
        if (this.spritemem == null) {
            return;
        }
        this.spritemem.setSpritePalette(spriteindex);
        if (this.xm[spriteindex] == 0 || this.ym[spriteindex] == 0) {
            return;
        }
        this.line = this.getY() - (cpc.getAsic().ASIC_RasterIntEnabled() ? 0 : (force ? 0 : 1));
        if (this.line < 0) {
            return;
        }
        this.xpos[spriteindex] = this.crtc.getReg(9) != 7 && this.pixelpos % 768 != 0 ? this.spritemem.getSpriteX(spriteindex) + (this.pixelpos % 768 & 0xFFFFFFF8) : this.spritemem.getSpriteX(spriteindex) + this.xmin;
        this.ypos[spriteindex] = this.crtc.getReg(9) != 7 ? this.spritemem.getSpriteY(spriteindex) + this.line : this.spritemem.getSpriteY(spriteindex) + this.ymin;
        this.spritemem.setSpriteData(spriteindex);
        if (this.line < this.ypos[spriteindex] || this.line > this.ypos[spriteindex] + 16 * this.ym[spriteindex]) {
            return;
        }
        if (this.xpos[spriteindex] + 16 * this.xm[spriteindex] < 0) {
            return;
        }
        if (this.xm[spriteindex] == 0 || this.ym[spriteindex] == 0) {
            return;
        }
        this.spriteline = this.line - this.ypos[spriteindex];
        this.startoff = this.spriteline / this.ym[spriteindex] * 16;
        this.spriteoffset = 768 * this.ypos[spriteindex];
        this.spriteoffset += this.xpos[spriteindex];
        this.spriteoffset += this.spriteline * 768;
        try {
            for (int x = 0; x < 16; ++x) {
                this.spritepixel = this.spritemem.sprdata[spriteindex][this.startoff + x];
                if (this.spritepixel == -1234567890) continue;
                for (int xx = 0; xx < this.xm[spriteindex]; ++xx) {
                    this.renderoffset = this.spriteoffset + x * this.xm[spriteindex] + xx;
                    this.pixelcheck = this.xpos[spriteindex] + (x * this.xm[spriteindex] + xx);
                    if (this.pixelcheck >= 768 || this.pixelcheck <= -1 || this.renderoffset <= -1 || this.renderoffset >= this.pixels.length || this.isBorder[this.renderoffset] || this.rendered[this.renderoffset]) continue;
                    this.pixels[this.renderoffset] = this.spritepixel;
                    if (this.display.DEBUG_SPRITES) {
                        this.display.ppixels[this.renderoffset] = -16777216 + this.spritepixel;
                    }
                    this.rendered[this.renderoffset] = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void vSync(boolean interlace) {
        for (int i = 0; i < this.rendered.length; ++i) {
            this.rendered[i] = false;
        }
        int off = 0;
        int line = 0;
        for (int i = 0; i < this.pixels.length; ++i) {
            if (++off == 768) {
                off = 0;
                ++line;
            }
            if (!this.isBorder[i]) break;
        }
        off = 0;
        line = 0;
        this.xmin = (50 - Basic6845.getR(2)) * 16;
        this.r3 = Basic6845.getR(3) & 0xF;
        if (this.r3 < 6) {
            this.xmin += this.r3 * 8;
        }
        this.r3 = Basic6845.getR(0) - 63;
        this.xmin += this.r3 * 16;
        this.xmax = this.xmin + Basic6845.getR(1) * 16;
        this.offset = 0;
        this.scanStart = 0;
        cpc.vSync();
        this.maxline = 0;
    }

    public void vSync() {
        for (int i = 0; i < this.rendered.length; ++i) {
            this.rendered[i] = false;
        }
        this.scanStart = 0;
        try {
            cpc.vSync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void vDispStart() {
    }

    public void setMemory(byte[] value) {
        screenmemory = value;
    }

    public void setRendering(boolean value) {
        this.rendering = value;
        if (!this.rendering) {
            this.scanStarted = false;
            this.render = false;
        }
    }

    public Dimension getDisplaySize(boolean large) {
        return large ? this.FULL_DISPLAY_SIZE : this.HALF_DISPLAY_SIZE;
    }

    public void cursor() {
    }

    public static void resetInks() {
        for (int i = 0; i < 17; ++i) {
            GateArray.setInk(i, GateArray.getInks(i));
        }
    }

    public static void resetInkss() {
        for (int i = 0; i < 17; ++i) {
            GateArray.setInk(i, i);
        }
    }

    public void init() {
        this.crtc.init();
    }

    public int PEEK(int address) {
        return cpc.PEEK(address);
    }

    public void POKE(int address, int value) {
        cpc.POKE(address, value);
    }

    public static int putRGB(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public boolean getOut() {
        return this.endPix != 0;
    }

    public int getLineNumber() {
        return this.crtc.getLineNumber();
    }

    public int getLineNum() {
        return this.getY();
    }

    static {
        inks = new int[33];
        maTranslate = new int[65536];
        CPCInks = new int[33];
        CPCInksb = new int[33];
        GAInks = new int[]{13, 27, 19, 25, 1, 7, 10, 16, 28, 29, 24, 26, 6, 8, 15, 17, 30, 31, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
        Inks = new int[]{20, 4, 21, 28, 24, 29, 12, 5, 13, 22, 6, 23, 30, 0, 31, 14, 7, 15, 18, 2, 19, 26, 25, 27, 10, 3, 11};
        LUM = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
        inkTranslateColor = new int[]{0x636363, 0x636363, 65379, 0xFFFF63, 99, 16711779, 25443, 0xFF6363, 16711779, 0xFFFF63, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16737024, 0xFF63FF, 99, 65379, 65280, 65535, 0, 255, 25344, 25599, 0x630063, 0x63FF63, 6553344, 0x63FFFF, 0x630000, 6488319, 0x636300, 0x6363FF};
        original = new int[]{0x636363, 0x636363, 65379, 0xFFFF63, 99, 16711779, 25443, 0xFF6363, 16711779, 0xFFFF63, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16737024, 0xFF63FF, 99, 65379, 65280, 65535, 0, 255, 25344, 25599, 0x630063, 0x63FF63, 6553344, 0x63FFFF, 0x630000, 6488319, 0x636300, 0x6363FF};
        fullMaps = new byte[4][];
        halfMaps = new byte[4][];
        for (int mode = 0; mode < 4; ++mode) {
            byte[] full = new byte[0x100000];
            byte[] half = new byte[524288];
            GateArray.fullMaps[mode] = full;
            GateArray.halfMaps[mode] = half;
            for (int i = 0; i < 524288; i += 4) {
                int b1 = i >> 3 & 0xFF;
                int b2 = i >> 11 & 0xFF;
                decoder.decodeFull(full, i * 2, mode, b1);
                decoder.decodeFull(full, (i += 4) * 2, mode, b2);
            }
        }
        for (int i = 0; i < maTranslate.length; ++i) {
            int j = i << 1;
            GateArray.maTranslate[i] = j & 0x7FE | (j & 0x6000) << 1;
        }
    }

    protected class FullEndRenderer
    extends Renderer {
        protected FullEndRenderer() {
        }

        public void render() {
            try {
                if (GateArray.this.renderer == GateArray.this.borderRenderer) {
                    int pix = inks[16];
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        if (GateArray.this.offset + GateArray.this.horizontalScroll >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, pix);
                    }
                } else if (GateArray.this.renderer == GateArray.this.defRenderer) {
                    int addr = maTranslate[GateArray.this.crtc.getMA()] + (GateArray.this.crtc.getRA() << 11);
                    int val = ((screenmemory[addr] & 0xFF) << 4) + ((screenmemory[addr + 1] & 0xFF) << 12);
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = false;
                        if (GateArray.this.offset + GateArray.this.horizontalScroll >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, inks[GateArray.this.fullMap[val++]]);
                    }
                } else {
                    int pix = inks[32];
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = false;
                        if (GateArray.this.offset + GateArray.this.horizontalScroll >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, pix);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class FullStartRenderer
    extends Renderer {
        protected FullStartRenderer() {
        }

        public void render() {
            try {
                GateArray.this.endPix = 16 - (GateArray.this.hPos - 686080 >> 12 & 0xF);
                if (GateArray.this.renderer == GateArray.this.borderRenderer) {
                    int pix = inks[16];
                    for (int i = GateArray.this.endPix; i < 16; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        if (GateArray.this.offset + GateArray.this.horizontalScroll >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, pix);
                    }
                } else if (GateArray.this.renderer == GateArray.this.defRenderer) {
                    int addr = maTranslate[GateArray.this.crtc.getMA()] + (GateArray.this.crtc.getRA() << 11);
                    int val = ((screenmemory[addr] & 0xFF) << 4) + ((screenmemory[addr + 1] & 0xFF) << 12) + GateArray.this.endPix;
                    for (int i = GateArray.this.endPix; i < 16; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = false;
                        if (GateArray.this.offset + GateArray.this.horizontalScroll >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, inks[GateArray.this.fullMap[val++]]);
                    }
                } else {
                    int pix = inks[32];
                    for (int i = GateArray.this.endPix; i < 16; ++i) {
                        GateArray.this.isBorder[GateArray.this.offset] = false;
                        if (GateArray.this.offset + GateArray.this.horizontalScroll >= GateArray.this.pixels.length) continue;
                        GateArray.this.putPixel(GateArray.this.offset++, pix);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class FullRenderer
    extends Renderer {
        protected FullRenderer() {
        }

        public void render() {
            int addr = maTranslate[GateArray.this.crtc.getMA()] + (GateArray.this.crtc.getRA() << 11);
            int val = ((screenmemory[addr] & 0xFF) << 4) + ((screenmemory[addr + 1] & 0xFF) << 12);
            for (int i = 0; i < 16; ++i) {
                GateArray.this.isBorder[GateArray.this.offset] = false;
                if (GateArray.this.offset + GateArray.this.horizontalScroll >= GateArray.this.pixels.length) continue;
                GateArray.this.putPixel(GateArray.this.offset++, inks[GateArray.this.fullMap[val++]]);
            }
        }
    }

    protected class BorderRenderer
    extends Renderer {
        protected int ink;
        protected int width;

        public BorderRenderer(int ink, int width) {
            this.ink = ink;
            this.width = width;
        }

        public void render() {
            if (GateArray.this.pixels == null) {
                return;
            }
            if (GateArray.this.isBorder == null || GateArray.this.isBorder.length < 1) {
                GateArray.this.isBorder = new boolean[GateArray.this.pixels.length];
            }
            int pix = inks[this.ink];
            try {
                for (int i = 0; i < this.width; ++i) {
                    if (GateArray.this.offset + GateArray.this.horizontalScroll < GateArray.this.pixels.length) {
                        GateArray.this.putPixel(GateArray.this.offset, pix);
                    }
                    GateArray.this.isBorder[GateArray.this.offset] = true;
                    ++GateArray.this.offset;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract class Renderer {
        protected Renderer() {
        }

        public void render() {
        }
    }
}

