/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc.plus;

import JCPC.core.Util;
import JCPC.core.device.Device;
import JCPC.system.cpc.GateArray;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class CPRLoader {
    protected byte[][] cprdata;
    public boolean DEBUG = false;
    protected boolean[] loaded = new boolean[32];
    protected String CPRHeader = "RIFF";
    protected String CPRIdentifier = "AMS!";
    protected int CPRBegin = 16;
    protected int CPRSize;
    byte[] cpr = new byte[524288];

    public static void main(String[] args) {
        CPRLoader load = new CPRLoader();
        load.DEBUG = true;
        load.OpenCPR2();
    }

    public void OpenCPR() {
        String filename = null;
        try {
            FileDialog filedia = new FileDialog(new Frame(), "Open CPR cartridge", 0);
            filedia.setFile("*.CPR; *.BIN");
            filedia.setVisible(true);
            filename = filedia.getFile();
            if (filename != null) {
                filename = filedia.getDirectory() + filedia.getFile();
            }
        }
        catch (Exception e) {
            System.err.println("Load failed...");
            return;
        }
        if (filename == null) {
            filename = "CPC_PLUS.CPR";
            return;
        }
        this.openCPR(filename);
    }

    public void OpenCPR2() {
        String filename = null;
        try {
            FileDialog filedia = new FileDialog(new Frame(), "Open CPR cartridge", 0);
            filedia.setFile("*.CPR; *.BIN");
            filedia.setVisible(true);
            filename = filedia.getFile();
            if (filename != null) {
                filename = filedia.getDirectory() + filedia.getFile();
                this.openCPR2(filename);
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.err.println("Load failed...");
            return;
        }
        if (filename == null) {
            filename = "CPC_PLUS.CPR";
            return;
        }
    }

    public void openCPR(String filename) {
        File t = new File(filename);
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(t));
            byte[] data = new byte[bin.available()];
            bin.read(data);
            bin.close();
            this.readCPR(data, filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openCPR2(String filename) {
        File t = new File(filename);
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(t));
            byte[] data = new byte[bin.available()];
            bin.read(data);
            bin.close();
            this.CPR2BIN(data, filename);
            this.OpenCPR2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openCPR(URL u) {
        try {
            int offset;
            URLConnection uc = u.openConnection();
            String contentType = uc.getContentType();
            int contentLength = uc.getContentLength();
            if (contentType.startsWith("text/") || contentLength == -1) {
                throw new IOException("This is not a binary file.");
            }
            InputStream raw = uc.getInputStream();
            BufferedInputStream in = new BufferedInputStream(raw);
            byte[] data = new byte[contentLength];
            int bytesRead = 0;
            for (offset = 0; offset < contentLength && (bytesRead = ((InputStream)in).read(data, offset, data.length - offset)) != -1; offset += bytesRead) {
            }
            ((InputStream)in).close();
            if (offset != contentLength) {
                throw new IOException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
            }
            this.readCPR(data, null);
        }
        catch (Exception e) {
            System.err.println("File not loadable / not found:" + u.getFile());
        }
    }

    public byte[] getCPR() {
        GateArray.cpc.getGateArray().checkCart(this.cpr);
        return this.cpr;
    }

    public byte[] getData(int index) {
        try {
            return this.cprdata[index];
        }
        catch (Exception e) {
            return null;
        }
    }

    public void readCPR(byte[] data, String filename) {
        boolean store = false;
        if (this.cprdata == null) {
            this.cprdata = new byte[32][];
        }
        if (this.CPRHeader.equals(new String(data, 0, this.CPRHeader.length()).toUpperCase())) {
            if (this.CPRIdentifier.equals(new String(data, 8, this.CPRIdentifier.length()).toUpperCase())) {
                int i;
                int i2;
                for (i2 = 0; i2 < 32; ++i2) {
                    this.loaded[i2] = false;
                }
                this.CPRSize = Device.getDWord(data, 4);
                for (i2 = 0; i2 < 32; ++i2) {
                    this.cprdata[i2] = null;
                }
                int pos = 12;
                while (pos < data.length) {
                    try {
                        byte check1 = data[pos++];
                        byte check2 = data[pos++];
                        byte index1 = data[pos++];
                        byte index2 = data[pos++];
                        int length = Device.getDWord(data, pos);
                        pos += 4;
                        if (check1 == 99 && check2 == 98) {
                            int index = 0;
                            String a = "" + (char)index1 + "" + (char)index2;
                            try {
                                index = Integer.parseInt(a);
                            }
                            catch (Exception e) {
                                System.err.println("An error occured!");
                                return;
                            }
                            if (!this.loaded[index &= 0x1F]) {
                                this.cprdata[index] = new byte[16384];
                                System.arraycopy(data, pos, this.cprdata[index], 0, length);
                                this.loaded[index] = true;
                                System.out.println("Storing to position: " + index);
                            } else {
                                byte[] check = new byte[16384];
                                System.arraycopy(data, pos, check, 0, length);
                                for (int i3 = 0; i3 < length; ++i3) {
                                    if (check[i3] == this.cprdata[index][i3]) continue;
                                    System.err.println("Difference encountered! " + Util.hex((short)i3));
                                    System.err.println(Util.dumpBytes(this.cprdata[index], i3, 16));
                                    System.err.println(Util.dumpBytes(check, i3, 16));
                                    this.cprdata[index] = new byte[16384];
                                    System.arraycopy(data, pos, this.cprdata[index], 0, length);
                                    break;
                                }
                            }
                        }
                        pos += length;
                    }
                    catch (Exception e) {
                        System.out.println("Error in Cartride file!!!");
                    }
                }
                int s = 0;
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    s += this.cprdata[i].length;
                }
                this.cpr = new byte[s];
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    System.arraycopy(this.cprdata[i], 0, this.cpr, i * 16384, this.cprdata[i].length);
                }
                if (filename != null && store) {
                    String newname = filename + ".bin";
                    File out = new File(newname);
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                        for (int i4 = 0; i4 < 32; ++i4) {
                            if (this.cprdata[i4] == null) continue;
                            bos.write(this.cprdata[i4]);
                        }
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            int pos = 0;
            try {
                for (int i = 0; i < data.length; i += 16384) {
                    this.cprdata[pos] = new byte[16384];
                    System.arraycopy(data, i, this.cprdata[pos], 0, 16384);
                    System.out.println(pos);
                    ++pos;
                }
                this.cpr = new byte[data.length];
                System.arraycopy(data, 0, this.cpr, 0, this.cpr.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GateArray.cpc.reset();
        GateArray.cpc.getAsic().reset();
    }

    public void CPR2BIN(byte[] data, String filename) {
        boolean store = true;
        if (this.cprdata == null) {
            this.cprdata = new byte[32][];
        }
        if (this.CPRHeader.equals(new String(data, 0, this.CPRHeader.length()).toUpperCase())) {
            if (this.CPRIdentifier.equals(new String(data, 8, this.CPRIdentifier.length()).toUpperCase())) {
                int i;
                int length;
                int i2;
                for (i2 = 0; i2 < 32; ++i2) {
                    this.loaded[i2] = false;
                }
                this.CPRSize = Device.getDWord(data, 4);
                for (i2 = 0; i2 < 32; ++i2) {
                    this.cprdata[i2] = null;
                }
                block8: for (int pos = 12; pos < this.CPRSize; pos += length) {
                    byte check1 = data[pos++];
                    byte check2 = data[pos++];
                    byte index1 = data[pos++];
                    byte index2 = data[pos++];
                    length = Device.getDWord(data, pos);
                    pos += 4;
                    if (check1 != 99 || check2 != 98) continue;
                    int index = 0;
                    String a = "" + (char)index1 + "" + (char)index2;
                    try {
                        index = Integer.parseInt(a);
                    }
                    catch (Exception e) {
                        System.err.println("An error occured!");
                        return;
                    }
                    if (!this.loaded[index &= 0x1F]) {
                        this.cprdata[index] = new byte[16384];
                        System.arraycopy(data, pos, this.cprdata[index], 0, length);
                        this.loaded[index] = true;
                        System.out.println("Storing to position: " + index);
                        continue;
                    }
                    byte[] check = new byte[16384];
                    System.arraycopy(data, pos, check, 0, length);
                    for (int i3 = 0; i3 < length; ++i3) {
                        if (check[i3] == this.cprdata[index][i3]) continue;
                        System.err.println("Difference encountered! " + Util.hex((short)i3));
                        System.err.println(Util.dumpBytes(this.cprdata[index], i3, 16));
                        System.err.println(Util.dumpBytes(check, i3, 16));
                        this.cprdata[index] = new byte[16384];
                        System.arraycopy(data, pos, this.cprdata[index], 0, length);
                        continue block8;
                    }
                }
                int s = 0;
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    s += this.cprdata[i].length;
                }
                this.cpr = new byte[s];
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    System.arraycopy(this.cprdata[i], 0, this.cpr, i * 16384, this.cprdata[i].length);
                }
                if (filename != null && store) {
                    String newname = filename.replace(".cpr", "") + ".bin";
                    File out = new File(newname);
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                        int limit = 0;
                        for (int i4 = 0; i4 < 32; ++i4) {
                            if (this.cprdata[i4] == null || limit >= 128) continue;
                            limit += 16;
                            bos.write(this.cprdata[i4]);
                        }
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            int pos = 0;
            try {
                for (int i = 0; i < data.length; i += 16384) {
                    this.cprdata[pos] = new byte[16384];
                    System.arraycopy(data, i, this.cprdata[pos], 0, 16384);
                    System.out.println(pos);
                    ++pos;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readCPR2(byte[] data, String filename) {
        boolean store = false;
        if (this.cprdata == null) {
            this.cprdata = new byte[32][];
        }
        if (this.CPRHeader.equals(new String(data, 0, this.CPRHeader.length()).toUpperCase())) {
            if (this.CPRIdentifier.equals(new String(data, 8, this.CPRIdentifier.length()).toUpperCase())) {
                int i;
                int length;
                int i2;
                for (i2 = 0; i2 < 32; ++i2) {
                    this.loaded[i2] = false;
                }
                this.CPRSize = Device.getDWord(data, 4);
                for (i2 = 0; i2 < 32; ++i2) {
                    this.cprdata[i2] = null;
                }
                block8: for (int pos = 12; pos < this.CPRSize; pos += length) {
                    byte check1 = data[pos++];
                    byte check2 = data[pos++];
                    byte index1 = data[pos++];
                    byte index2 = data[pos++];
                    length = Device.getDWord(data, pos);
                    pos += 4;
                    if (check1 != 99 || check2 != 98) continue;
                    int index = 0;
                    String a = "" + (char)index1 + "" + (char)index2;
                    try {
                        index = Integer.parseInt(a);
                    }
                    catch (Exception e) {
                        System.err.println("An error occured!");
                        return;
                    }
                    if (!this.loaded[index &= 0x1F]) {
                        this.cprdata[index] = new byte[16384];
                        System.arraycopy(data, pos, this.cprdata[index], 0, length);
                        this.loaded[index] = true;
                        System.out.println("Storing to position: " + index);
                        continue;
                    }
                    byte[] check = new byte[16384];
                    System.arraycopy(data, pos, check, 0, length);
                    for (int i3 = 0; i3 < length; ++i3) {
                        if (check[i3] == this.cprdata[index][i3]) continue;
                        System.err.println("Difference encountered! " + Util.hex((short)i3));
                        System.err.println(Util.dumpBytes(this.cprdata[index], i3, 16));
                        System.err.println(Util.dumpBytes(check, i3, 16));
                        this.cprdata[index] = new byte[16384];
                        System.arraycopy(data, pos, this.cprdata[index], 0, length);
                        continue block8;
                    }
                }
                int s = 0;
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    s += this.cprdata[i].length;
                }
                this.cpr = new byte[s];
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    System.arraycopy(this.cprdata[i], 0, this.cpr, i * 16384, this.cprdata[i].length);
                }
                if (filename != null && store) {
                    String newname = filename + ".bin";
                    File out = new File(newname);
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                        for (int i4 = 0; i4 < 32; ++i4) {
                            if (this.cprdata[i4] == null) continue;
                            bos.write(this.cprdata[i4]);
                        }
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            int pos = 0;
            try {
                for (int i = 0; i < data.length; i += 16384) {
                    this.cprdata[pos] = new byte[16384];
                    System.arraycopy(data, i, this.cprdata[pos], 0, 16384);
                    System.out.println(pos);
                    ++pos;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

