/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc.plus;

import JCPC.core.Util;
import JCPC.core.device.Device;
import JCPC.system.cpc.CPC;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class JukeBox
extends Device {
    boolean DEBUG = false;
    int choosenSlot;
    CPC cpc;
    int clock = 0;
    int games = 12;
    int[] times = new int[]{9, 17, 33, 67};
    int wait = 2;
    boolean timed = false;
    int gamepos;
    boolean gamemode = false;
    int internclock = 0;
    boolean oldmode;
    ActionListener time = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (!JukeBox.this.timed) {
                return;
            }
            if (JukeBox.this.gamemode != JukeBox.this.oldmode) {
                JukeBox.this.internclock = 0;
                JukeBox.this.oldmode = JukeBox.this.gamemode;
            }
            if (JukeBox.this.DEBUG) {
                System.out.println(JukeBox.this.gamemode + " - " + JukeBox.this.internclock++);
            }
            if (!JukeBox.this.gamemode) {
                JukeBox.this.clock = 0;
            }
            if (JukeBox.this.cpc.cprslot == 0) {
                JukeBox.this.gamemode = false;
            }
            if (JukeBox.this.gamemode) {
                ++JukeBox.this.clock;
                if (JukeBox.this.clock >= JukeBox.this.times[JukeBox.this.wait]) {
                    JukeBox.this.clock = 0;
                    JukeBox.this.gamemode = false;
                    JukeBox.this.cpc.cprslot = 0;
                    JukeBox.this.cpc.remapCPR(!JukeBox.this.gamemode);
                }
            }
        }
    };
    Timer timer = new Timer(1000, this.time);

    public JukeBox(CPC cpc) {
        super("Amstrad CSD Cartridge Demonstrator");
        this.cpc = cpc;
    }

    public void reset() {
        this.gamemode = false;
    }

    public void writePort(int port, int value) {
        if (this.DEBUG) {
            System.out.println("Someone is writing to my port: " + Util.hex((short)port) + " - " + Util.hex((byte)value));
        }
        if (port == 64481 && value > 127 && value < 208) {
            this.choosenSlot = value % 12;
            if (this.choosenSlot == 0) {
                this.choosenSlot = 12;
            }
            this.cpc.cprslot = this.choosenSlot;
            if (this.DEBUG) {
                System.out.println("loading " + this.choosenSlot);
            }
            this.gamemode = true;
            this.cpc.remapCPR(!this.gamemode);
        }
    }

    public void stopTimer() {
        this.timed = false;
        this.cpc.reset();
        this.clock = 0;
        this.timer.stop();
    }

    public void setTimer(int value) {
        this.timed = value != 0;
        this.clock = 0;
        this.timer.stop();
        if (this.timed) {
            this.timer.start();
        }
        this.wait = value - 1;
        System.out.println("Timer set to " + value);
    }

    public void startTimer() {
        this.timed = true;
        this.cpc.reset();
        this.clock = 0;
        this.timer.start();
    }

    public void resetJukeBox() {
        this.choosenSlot = 0;
        this.gamemode = false;
    }

    public static int random(int n) {
        double decimal = Math.random();
        int value = (int)Math.round(decimal * (double)n);
        return value;
    }

    public int readPort(int port) {
        if (this.DEBUG) {
            System.out.println("Someone is reading my port " + Util.hex((short)port));
        }
        if (port == 64482) {
            return this.choosenSlot << 4 & 0xFF;
        }
        return 1;
    }
}

