/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.ui.Timer;
import JCPC.ui.TimerListener;
import JCPC.ui.UserEvent;

public class Counter {
    Timer timer;
    protected long duration;
    protected long total;
    protected long count;
    protected long last;
    protected TimerListener listener;
    protected Object data;

    public Counter(TimerListener listener, long duration, Object data) {
        this.listener = listener;
        this.duration = duration;
        this.data = data;
        this.last = System.currentTimeMillis();
        this.total = 0L;
        if (this.timer == null) {
            this.timer = new Timer();
        }
        Timer.addCounter(this);
    }

    public void setDuration(long value) {
        this.duration = value;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setData(Object value) {
        this.data = value;
    }

    public Object getData() {
        return this.data;
    }

    public long getTime() {
        return this.total;
    }

    public void stop() {
        Timer.removeCounter(this);
    }

    protected void tick(Timer timer, long time) {
        long diff = time - this.last;
        this.last = time;
        this.count += diff;
        this.total += diff;
        if (this.count >= this.duration && this.duration > 0L) {
            timer.post(new UserEvent(timer, 4000, this));
            while (this.count >= this.duration && this.duration > 0L) {
                this.count -= this.duration;
            }
        }
    }
}

