/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.core.Util;
import JCPC.core.device.Computer;
import JCPC.core.device.memory.Memory;
import JCPC.ui.EButton;
import JCPC.ui.EDisassembler;
import JCPC.ui.EMemory;
import JCPC.ui.ERegisters;
import JCPC.util.diss.Disassembler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class Debugger
extends JFrame
implements MouseListener,
ActionListener {
    public static final Color navy = new Color(0, 0, 127);
    protected Computer computer;
    protected long startCycles = 0L;
    protected JFileChooser fileDlg;
    protected JButton bRun;
    protected EButton bStep;
    protected EButton bStepOver;
    protected JButton bStop;
    protected EDisassembler eDisassembler;
    protected EMemory eMemory;
    protected ERegisters eRegisters;
    protected JPanel jPanel1;
    protected JPanel jPanel2;
    protected JPanel jPanel3;
    protected JScrollPane jScrollPane1;
    protected JSplitPane jSplitPane1;
    protected JLabel lCycleCount;
    protected JLabel lCycles;
    protected JMenuItem mGoto;
    protected JMenuItem mSave;
    protected JPopupMenu popupMenu;

    public Debugger() {
        this.initComponents();
        this.eDisassembler.setFont(new Font("Monospaced", 0, 11));
        this.eMemory.setFont(new Font("Monospaced", 0, 11));
        this.bRun.addActionListener(this);
        this.bStop.addActionListener(this);
        this.bStep.addActionListener(this);
        this.bStepOver.addActionListener(this);
        this.mSave.addActionListener(this);
        this.mGoto.addActionListener(this);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(this.getFontMetrics(this.eMemory.getFont()).getHeight());
    }

    public void setComputer(Computer value) {
        if (this.computer != null) {
            this.computer.removeActionListener(this);
        }
        this.computer = value;
        this.eDisassembler.setComputer(this.computer);
        this.eMemory.setComputer(this.computer);
        if (this.computer != null) {
            this.computer.addActionListener(this);
            this.eRegisters.setDevice(this.computer.getProcessor());
            this.updateDisplay();
        } else {
            this.eRegisters.setDevice(null);
        }
    }

    protected void updateDisplay() {
        this.eDisassembler.setPC(this.computer.getProcessor().getProgramCounter());
        this.lCycleCount.setText(Long.toString(this.computer.getProcessor().getCycles() - this.startCycles));
        this.eRegisters.setValues();
        this.repaint();
    }

    protected long getGotoAddress() {
        String address = JOptionPane.showInputDialog("Address: ", (Object)"#");
        if (address == null) {
            return -1L;
        }
        if ((address = address.trim()).length() == 0) {
            return -1L;
        }
        switch (address.charAt(0)) {
            case '#': 
            case '$': 
            case '&': {
                return Long.parseLong(address.substring(1), 16);
            }
        }
        return Long.parseLong(address);
    }

    public void actionPerformed(ActionEvent e) {
        this.computer.clearRunToAddress();
        if (e.getSource() == this.bRun) {
            this.computer.start();
        } else if (e.getSource() == this.bStop) {
            this.computer.stop();
        } else if (e.getSource() == this.bStep) {
            this.computer.step();
        } else if (e.getSource() == this.bStepOver) {
            this.computer.stepOver();
        } else if (e.getSource() == this.computer) {
            this.updateDisplay();
        } else if (e.getSource() == this.mGoto) {
            long address = this.getGotoAddress();
            if (address != -1L) {
                if (this.popupMenu.getInvoker() == this.eDisassembler) {
                    this.eDisassembler.setAddress((int)address);
                } else {
                    this.eMemory.setAddress((int)address);
                }
            }
        } else if (e.getSource() == this.mSave) {
            if (this.popupMenu.getInvoker() == this.eDisassembler) {
                this.saveDisassembly();
            } else {
                this.saveMemory();
            }
        }
        this.computer.setFrameSkip(0);
        this.computer.updateDisplay(false);
    }

    protected File showSaveDialog(String title) {
        if (this.fileDlg == null) {
            this.fileDlg = new JFileChooser();
        }
        this.fileDlg.setDialogTitle(title);
        return this.fileDlg.showSaveDialog(this.bRun) == 0 ? this.fileDlg.getSelectedFile() : null;
    }

    public void saveMemory() {
        this.saveMemory(this.eMemory.selStart, this.eMemory.selEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMemory(int start, int end) {
        File file = this.showSaveDialog("Save Memory");
        if (file != null) {
            try {
                FileOutputStream io = new FileOutputStream(file);
                try {
                    Memory mem = this.computer.getMemory();
                    for (int addr = start; addr <= end; ++addr) {
                        io.write(mem.readByte(addr));
                    }
                }
                finally {
                    io.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveDisassembly() {
        this.saveDisassembly(this.eDisassembler.selStart, this.eDisassembler.selEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDisassembly(int start, int end) {
        File file = this.showSaveDialog("Save Disassembly");
        if (file != null) {
            int[] addr = new int[]{start};
            try {
                FileOutputStream io = new FileOutputStream(file);
                try {
                    Disassembler diss = this.computer.getDisassembler();
                    Memory mem = this.computer.getMemory();
                    while (addr[0] <= end) {
                        String s = Util.hex((short)addr[0]) + ": ";
                        io.write((s + diss.disassemble(mem, addr) + "\r\n").getBytes());
                    }
                }
                finally {
                    io.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.mGoto = new JMenuItem();
        this.mSave = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.bRun = new JButton();
        this.bStop = new JButton();
        this.bStep = new EButton();
        this.bStepOver = new EButton();
        this.jPanel3 = new JPanel();
        this.lCycles = new JLabel();
        this.lCycleCount = new JLabel();
        this.eRegisters = new ERegisters();
        this.jSplitPane1 = new JSplitPane();
        this.eDisassembler = new EDisassembler();
        this.jScrollPane1 = new JScrollPane();
        this.eMemory = new EMemory();
        this.mGoto.setText("Goto...");
        this.popupMenu.add(this.mGoto);
        this.mSave.setText("Save...");
        this.popupMenu.add(this.mSave);
        this.setTitle("JavaGX4000 Debugger");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0));
        this.bRun.setText("Run");
        this.jPanel2.add(this.bRun);
        this.bStop.setText("Stop");
        this.jPanel2.add(this.bStop);
        this.bStep.setText("Step");
        this.jPanel2.add(this.bStep);
        this.bStepOver.setText("Step Over");
        this.jPanel2.add(this.bStepOver);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.lCycles.setForeground(new Color(0, 0, 127));
        this.lCycles.setText("Cycles:");
        this.jPanel3.add(this.lCycles);
        this.lCycleCount.setText("0");
        this.lCycleCount.addMouseListener(this);
        this.jPanel3.add(this.lCycleCount);
        this.jPanel1.add((Component)this.jPanel3, "East");
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.eRegisters.setFocusable(false);
        this.eRegisters.setLayout(null);
        this.getContentPane().add((Component)this.eRegisters, "After");
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setContinuousLayout(true);
        this.eDisassembler.setComponentPopupMenu(this.popupMenu);
        this.eDisassembler.addMouseListener(this);
        this.jSplitPane1.setTopComponent(this.eDisassembler);
        this.eMemory.setComponentPopupMenu(this.popupMenu);
        this.jScrollPane1.setViewportView(this.eMemory);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getSource() == this.lCycleCount) {
            this.lCycleCountMouseClicked(evt);
        } else if (evt.getSource() == this.eDisassembler) {
            this.eDisassemblerMouseClicked(evt);
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    private void eDisassemblerMouseClicked(MouseEvent e) {
        int addr;
        if (e.getClickCount() == 2 && (addr = this.eDisassembler.getAddress(e.getY())) != -1) {
            this.computer.setRunToAddress(addr);
            this.computer.start();
        }
    }

    private void lCycleCountMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.startCycles = this.computer.getProcessor().getCycles();
            this.lCycleCount.setText("0");
        }
    }
}

