/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.core.device.crtc.Basic6845;
import JCPC.system.cpc.CPC;
import JCPC.system.cpc.GateArray;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Display
extends JPanel {
    public static boolean showdisks = false;
    public static boolean drawmonitor = false;
    boolean DEBUG_FPS = false;
    boolean DEBUG_SCREEN = false;
    public boolean DEBUG_SPRITES = false;
    public static String vscroll = "0";
    long mLastFPSTime;
    int mNextFPS;
    public int mCurrFPS;
    public static boolean scanlines = true;
    public static final Color LED_ON = new Color(32, 255, 32);
    public static final Color LED_OFF = new Color(32, 96, 32, 192);
    public static final Color LED_BORDER = new Color(96, 64, 64, 160);
    public static final Color fLED_ON = new Color(255, 96, 32);
    public static final Color fLED_OFF = new Color(96, 32, 32, 192);
    public static final Color fLED_BORDER = new Color(96, 64, 64, 160);
    public static final Color SCAN = new Color(20, 20, 20, 144);
    public static final Color SCANL = new Color(20, 20, 20, 48);
    public int storesna;
    public int restoresna;
    public int crtc;
    final URL disc = this.getClass().getResource("3disc.gif");
    final Image Disc = this.getToolkit().getImage(this.disc);
    final URL iel = this.getClass().getResource("logo.png");
    final Image logo = this.getToolkit().getImage(this.iel);
    final URL imf = this.getClass().getResource("glossywindow.png");
    final Image masks = this.getToolkit().getImage(this.imf);
    final URL mimf = this.getClass().getResource("monitor.png");
    final URL dist = this.getClass().getResource("MonitorPieceBezel.png");
    final Image Dist = this.getToolkit().getImage(this.dist);
    final URL car = this.getClass().getResource("minis_cart.gif");
    final Image Cart = this.getToolkit().getImage(this.car);
    public boolean large;
    public static boolean ledOn;
    protected int divider = 1;
    public static final int CENTER = 0;
    public static final Dimension SCALE_1;
    public static final Dimension SCALE_2;
    public static final Dimension SCALE_1x2;
    protected String snapl = "Snapshot loaded... Press F5 to reload";
    protected String snaps = "Snapshot stored... Press F5 to load";
    protected String crtctype = "CRTC type ";
    protected String crtctype2 = "... Press F8 to change";
    protected BufferedImage image;
    protected WritableRaster raster;
    protected WritableRaster praster;
    protected WritableRaster leftraster;
    protected WritableRaster rightraster;
    protected int[] pixels;
    protected int imageWidth;
    protected int imageHeight;
    protected int scaleWidth;
    protected int scaleHeight;
    protected Rectangle imageRect = new Rectangle();
    protected Rectangle sourceRect = null;
    protected int imagePos = 0;
    protected boolean sameSize;
    protected boolean painted = true;
    BufferedImage moniter;
    double div = 1.25;
    int off;
    int splitrgb;
    int[] rgb = new int[]{0, 0, 0};
    public boolean turbo;
    BufferedImage output;
    int width;
    public BufferedImage leftside;
    public BufferedImage rightside;
    public int[] leftpixels;
    public int[] rightpixels;
    public JPanel left;
    public JPanel right;
    public boolean drawborder = false;
    protected boolean borderinit = false;
    int fpstimer = 0;
    int errorhit = 0;
    int errortimer = 0;
    int lx;
    int ly;
    int logotimer = 0;
    int logopos = 0;
    public boolean penonscreen;
    int a = 0;
    int b = 0;
    int c = 0;
    JFrame spriteframe;
    BufferedImage sprites;
    JLabel spritelabel;
    JFrame spriteframe2;
    BufferedImage sprites2;
    JLabel spritelabel2;
    BufferedImage trans;
    Graphics g2;
    BufferedImage sprites3;
    public static String[] carts;
    public int[] ppixels = new int[208896];
    public boolean fullscreen = false;
    final URL cursorl = this.getClass().getResource("Pen-icon.png");
    final Image lightPen = this.getToolkit().getImage(this.cursorl);
    public static int showtime;
    int menupos = -300;
    public boolean menumode;
    public boolean shootme = false;
    int impos = 0;
    int lpos = 550;
    int lw = 0;
    String info = "";
    int[] spx = new int[16];
    int[] spy = new int[16];
    int[] spw = new int[16];
    int[] sph = new int[16];
    boolean oldfull;
    int timer;
    private boolean started = false;

    public void doTouchFPS() {
        long time = System.currentTimeMillis();
        ++this.mNextFPS;
        if (time - this.mLastFPSTime >= 1000L) {
            this.mCurrFPS = this.mNextFPS;
            this.mNextFPS = 0;
            this.mLastFPSTime = time;
        }
    }

    public Display() {
        try {
            BufferedImage moni = ImageIO.read(this.mimf);
            this.moniter = new BufferedImage(moni.getWidth(), moni.getHeight(), 2);
            this.moniter.createGraphics().drawImage((Image)moni, 0, 0, null);
            for (int x = 0; x < this.moniter.getWidth(); ++x) {
                for (int y = 0; y < this.moniter.getHeight(); ++y) {
                    Color grab = new Color(this.moniter.getRGB(x, y));
                    if (grab.getBlue() != 0 || grab.getGreen() != 0 || grab.getRed() != 0) continue;
                    this.moniter.setRGB(x, y, 0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enableEvents(4L);
        this.setFocusTraversalKeysEnabled(false);
        this.setRequestFocusEnabled(true);
    }

    public int[] getPixel(int x, int y) {
        return this.raster.getPixel(x, y, this.pixels);
    }

    public int putRGB(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    protected void getRGB(int value, int[] rgb) {
        rgb[0] = value >> 16 & 0xFF;
        rgb[1] = value >> 8 & 0xFF;
        rgb[2] = value & 0xFF;
    }

    protected void CRTFilter() {
        this.splitrgb = 0;
        this.off = 0;
        while (this.off < this.pixels.length) {
            ++this.splitrgb;
            if (this.splitrgb > 4) {
                this.splitrgb = 0;
            }
            this.getRGB(this.pixels[this.off], this.rgb);
            switch (this.splitrgb) {
                case 0: {
                    this.pixels[this.off] = this.putRGB(this.rgb[0], (int)((double)this.rgb[1] / this.div), (int)((double)this.rgb[2] / this.div));
                    break;
                }
                case 1: {
                    this.pixels[this.off] = this.putRGB((int)((double)this.rgb[0] / this.div), this.rgb[1], (int)((double)this.rgb[2] / this.div));
                    break;
                }
                case 2: {
                    this.pixels[this.off] = this.putRGB((int)((double)this.rgb[0] / this.div), (int)((double)this.rgb[1] / this.div), this.rgb[2]);
                    break;
                }
            }
            ++this.off;
        }
        if (this.leftside != null && this.fullscreen) {
            this.splitrgb = 0;
            this.off = 0;
            while (this.off < this.leftpixels.length) {
                this.leftpixels[this.off] = 0;
                ++this.off;
            }
            this.off = 0;
            while (this.off < this.rightpixels.length) {
                this.rightpixels[this.off] = 0;
                ++this.off;
            }
        }
    }

    public void setImageSize(Dimension size, Dimension scale) {
        this.imageWidth = size.width;
        this.imageHeight = size.height;
        this.image = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        this.image.setAccelerationPriority(1.0f);
        this.raster = this.image.getRaster();
        this.pixels = new int[208896];
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = -16777216;
        }
        if (scale == null) {
            scale = SCALE_1;
        }
        this.scaleWidth = this.imageWidth * scale.width;
        this.scaleHeight = this.imageHeight * scale.height;
        this.checkSize();
        Graphics g = this.getGraphics();
        if (g != null) {
            size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            this.paint(g);
            g.dispose();
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.checkSize();
    }

    protected void checkSize() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int clientWidth = size.width - insets.left - insets.right;
        int clientHeight = size.height - insets.top - insets.bottom;
        this.imageRect = new Rectangle(insets.left + (clientWidth - this.scaleWidth) / 2, insets.top + (clientHeight - this.scaleHeight) / 2, this.scaleWidth, this.scaleHeight);
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void updateLightpen(int x, int y) {
        this.lx = x;
        this.ly = y;
    }

    public void updateImage(boolean wait) {
        this.checkSize();
        this.doTouchFPS();
        if (this.mCurrFPS < 20 && !GateArray.cpc.doTurbo && !this.large) {
            ++this.fpstimer;
            if (this.fpstimer > 30) {
                this.fpstimer = 0;
                ++this.errorhit;
                if (this.errorhit < 10) {
                    GateArray.cpc.reSync();
                    System.out.println("Slow Performance: " + this.mCurrFPS + "fps - Adjusting");
                }
            }
        } else {
            ++this.errortimer;
            if (this.errortimer > 150) {
                this.errorhit = 0;
            }
            this.fpstimer = 0;
        }
        int off = 0;
        int lastPix = 0;
        if (this.fullscreen && this.leftside != null && this.drawborder) {
            if (!this.borderinit) {
                this.leftraster = this.leftside.getRaster();
                this.rightraster = this.rightside.getRaster();
                this.borderinit = true;
            }
            int pipos = 0;
            int prpos = 0;
            int pval = GateArray.cpc.getGateArray().getBorder();
            for (int i = 0; i < 272; ++i) {
                int k;
                for (k = 0; k < this.leftside.getWidth(); ++k) {
                    this.leftpixels[pipos++] = pval;
                }
                for (k = 0; k < this.rightside.getWidth(); ++k) {
                    this.rightpixels[prpos++] = pval;
                }
            }
        }
        if (scanlines) {
            this.CRTFilter();
            for (int y = 0; y < this.imageHeight - 1; ++y) {
                off = y * this.imageWidth;
                for (int x = 0; x < this.imageWidth; ++x) {
                    ++off;
                    try {
                        lastPix = this.pixels[off] = (lastPix & 0xFEFEFE) + (this.pixels[off] & 0xFEFEFE) >> 1;
                        continue;
                    }
                    catch (Exception pval) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.fullscreen && this.leftside != null && this.drawborder) {
            Graphics l = this.left.getGraphics();
            Graphics r = this.right.getGraphics();
            this.leftraster.setDataElements(0, 0, this.leftside.getWidth(), this.leftside.getHeight(), this.leftpixels);
            this.rightraster.setDataElements(0, 0, this.rightside.getWidth(), this.rightside.getHeight(), this.rightpixels);
            Graphics2D l2 = (Graphics2D)l;
            l2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            l = l2;
            Graphics2D r2 = (Graphics2D)r;
            r2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            r = r2;
            l.drawImage(this.leftside, 0, 0, this.left.getWidth(), this.left.getHeight(), null);
            r.drawImage(this.rightside, 0, 0, this.right.getWidth(), this.right.getHeight(), null);
        }
        if (this.imageRect.width != 0 && this.imageRect.height != 0 && this.isShowing()) {
            this.raster.setDataElements(0, 0, this.imageWidth, this.imageHeight, this.pixels);
            if (this.logopos < 300) {
                ++this.logotimer;
                if (this.logotimer > 100) {
                    this.logopos += 2;
                }
            }
            this.repaint(0, 0, this.getWidth(), this.getHeight());
        }
        if (wait) {
            this.waitPainted();
        }
    }

    public void waitPainted() {
        while (!this.painted) {
            Thread.yield();
        }
    }

    public void showSprites() {
        int[] result = GateArray.cpc.getGateArray().getField();
        if (this.spriteframe == null) {
            this.sprites = new BufferedImage(640, 400, 1);
            this.spriteframe = new JFrame("Sprites");
            this.spritelabel = new JLabel();
            this.spritelabel.setIcon(new ImageIcon(this.sprites));
            this.spriteframe.setResizable(false);
            this.spriteframe.setLayout(new BorderLayout());
            this.spriteframe.add((Component)this.spritelabel, "Center");
            this.spriteframe.pack();
            this.spriteframe.setVisible(true);
        }
        Graphics g = this.sprites.getGraphics();
        g.setColor(new Color(20, 60, 128));
        g.fillRect(0, 0, 768, 544);
        g.setFont(new Font("", 1, this.large ? 11 : 8));
        String f = "";
        try {
            int i;
            int xpos = 0;
            for (i = 7; i >= 0; --i) {
                if (GateArray.cpc.getGateArray().ym[i] == 0 || GateArray.cpc.getGateArray().xm[i] == 0) continue;
                GateArray.cpc.memory.putSpriteImg(i);
                g.setColor(Color.white);
                g.drawRect(4 + xpos, 19, 16 * GateArray.cpc.getGateArray().xm[i] + 1, 1 + 32 * GateArray.cpc.getGateArray().ym[i]);
                g.drawImage(GateArray.cpc.memory.spriteImg[i], 5 + xpos, 20, this);
                f = GateArray.cpc.memory.getSpriteX(i) + "," + GateArray.cpc.memory.getSpriteY(i);
                g.drawString(f, 4 + xpos, 30 + 32 * GateArray.cpc.getGateArray().ym[i]);
                xpos += 8 + 18 * GateArray.cpc.getGateArray().xm[i];
            }
            xpos = 0;
            for (i = 15; i > 7; --i) {
                if (GateArray.cpc.getGateArray().ym[i] == 0 || GateArray.cpc.getGateArray().xm[i] == 0) continue;
                GateArray.cpc.memory.putSpriteImg(i);
                g.setColor(Color.white);
                f = GateArray.cpc.memory.getSpriteX(i) + "," + GateArray.cpc.memory.getSpriteY(i);
                g.drawString(f, 4 + xpos, 210 + 32 * GateArray.cpc.getGateArray().ym[i]);
                xpos += 8 + 18 * GateArray.cpc.getGateArray().xm[i];
            }
            this.spritelabel.setIcon(new ImageIcon(this.sprites));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawSprites();
    }

    public void drawSprites() {
        int[] result = GateArray.cpc.getGateArray().getField();
        if (this.spriteframe2 == null) {
            this.sprites2 = new BufferedImage(768, 544, 1);
            this.sprites3 = new BufferedImage(768, 272, 2);
            this.praster = this.sprites3.getRaster();
            this.trans = new BufferedImage(16, 16, 1);
            Graphics2D d = this.trans.createGraphics();
            d.setColor(Color.white);
            d.fillRect(0, 0, 8, 8);
            d.fillRect(8, 8, 8, 8);
            d.setColor(Color.lightGray);
            d.fillRect(8, 0, 8, 8);
            d.fillRect(0, 8, 8, 8);
            this.spriteframe2 = new JFrame("Sprites");
            this.spritelabel2 = new JLabel();
            this.spritelabel2.setIcon(new ImageIcon(this.sprites2));
            this.spriteframe2.setResizable(false);
            this.spriteframe2.setLayout(new BorderLayout());
            this.spriteframe2.add((Component)this.spritelabel2, "Center");
            this.spriteframe2.pack();
            this.spriteframe2.setVisible(true);
            this.g2 = this.sprites2.getGraphics();
        }
        for (int x = 0; x < 800; x += 16) {
            for (int y = 0; y < 600; y += 16) {
                this.g2.drawImage(this.trans, x, y, this);
            }
        }
        Color b = new Color(this.pixels[0]);
        this.g2.setColor(new Color(b.getRed(), b.getGreen(), b.getBlue(), 128));
        this.g2.fillRect(result[0], result[2], GateArray.cpc.getGateArray().crtc.getRegisterValue(1) * 16, GateArray.cpc.getGateArray().crtc.getRegisterValue(6) * 16);
        try {
            this.praster.setDataElements(0, 0, this.imageWidth, this.imageHeight, this.ppixels);
            this.sprites2.getGraphics().drawImage(this.sprites3, 0, 0, 768, 544, this);
            this.spritelabel2.getGraphics().drawImage(this.sprites2, 0, 0, 768, 544, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFullscreen(boolean full) {
        this.fullscreen = full;
    }

    protected void paintImage(Graphics g) {
        Graphics2D g2;
        if (scanlines || !this.large || this.fullscreen) {
            g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g = g2;
        }
        g.setFont(new Font("", 1, this.large ? 16 : 10));
        if (scanlines && !this.fullscreen) {
            this.image.createGraphics().drawImage(this.Dist, 0, 0, 768, 272, this);
        }
        if (this.fullscreen) {
            g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g = g2;
            g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
            if (this.penonscreen) {
                g.drawImage(this.lightPen, this.lx + 8, this.ly + 8, 256, 256, null);
            }
            if (this.turbo) {
                g.setColor(LED_ON);
                g.fillRect(4 * this.divider, 3 * this.divider, 7 * this.divider, 3 * this.divider);
                g.setColor(LED_BORDER);
                g.drawString("x" + CPC.turbospeed, 4 * this.divider, 15 * this.divider);
                g.drawRect(3 * this.divider, 2 * this.divider, 8 * this.divider, 4 * this.divider);
                g.setColor(LED_ON);
                g.drawString("x" + CPC.turbospeed, 3 * this.divider, 14 * this.divider);
            }
            if (showdisks && showtime > 1) {
                g.drawImage(this.Disc, 24 * this.divider, 3 * this.divider, this.divider != 1 ? 26 : 13, this.divider != 1 ? 32 : 16, null);
                g.drawImage(this.Disc, 40 * this.divider, 3 * this.divider, this.divider != 1 ? 26 : 13, this.divider != 1 ? 32 : 16, null);
                --showtime;
            }
            return;
        }
        if (drawmonitor) {
            g.drawImage(this.image, this.large ? 60 : 30, this.large ? 80 : 40, this.large ? 768 : 384, this.large ? 544 : 272, null);
        } else {
            g.drawImage(this.image, 0, 0, this.large ? 768 : 384, this.large ? 544 : 272, null);
        }
        if (this.DEBUG_SCREEN) {
            int[] result = GateArray.cpc.getGateArray().getField();
            g.setColor(new Color(255, 255, 255, 96));
            g.fillRect(0, 0, this.large ? 768 : 384, this.large ? result[2] : result[2] / 2);
            g.fillRect(0, 0, this.large ? result[0] : result[0] / 2, this.large ? 544 : 272);
            g.fillRect(0, this.large ? result[3] : result[3] / 2, this.large ? 768 : 384, this.large ? 544 : 272);
            g.fillRect(this.large ? result[1] : result[1] / 2, 0, this.large ? result[1] : result[1] / 2, this.large ? 544 : 272);
        }
        if (this.DEBUG_SPRITES) {
            this.showSprites();
        }
        if (scanlines && drawmonitor) {
            g.setColor(this.large ? SCAN : SCANL);
            for (int i = 0; i < this.imageRect.height; i += 2) {
                g.drawLine(this.large ? 60 : 30, (this.large ? 80 : 40) + i, this.large ? 828 : 414, (this.large ? 80 : 40) + i);
            }
            g.drawImage(this.Dist, this.large ? 60 : 30, this.large ? 80 : 40, this.large ? 768 : 384, this.large ? 544 : 272, this);
        }
        if (scanlines && !drawmonitor) {
            g.setColor(this.large ? SCAN : SCANL);
            for (int i = 0; i < this.imageRect.height; i += 2) {
                g.drawLine(0, i, this.large ? 768 : 384, i);
            }
            g.drawImage(this.Dist, 0, 0, this.large ? 768 : 384, this.large ? 544 : 272, this);
        }
        if (this.storesna > 0) {
            g.setColor(LED_ON);
            this.restoresna = 0;
            this.crtc = 0;
            g.drawString(this.snaps, this.large ? 40 : 20, this.large ? 20 : 10);
            --this.storesna;
        }
        if (this.restoresna > 0) {
            this.crtc = 0;
            this.storesna = 0;
            g.setColor(Color.GREEN);
            g.drawString(this.snapl, this.large ? 40 : 20, this.large ? 20 : 10);
            --this.restoresna;
        }
        if (this.crtc > 0) {
            this.storesna = 0;
            this.restoresna = 0;
            g.setColor(Color.yellow);
            g.drawString(this.crtctype + Basic6845.CRTC + this.crtctype2, this.large ? 40 : 20, this.large ? 20 : 10);
            --this.crtc;
        }
        if (GateArray.cpc.saveallowed && GateArray.cpc.storing() != 0) {
            g.setColor(Color.red);
            g.drawRect(0, 0, this.large ? 767 : 383, this.large ? 543 : 271);
            g.drawRect(1, 1, this.large ? 765 : 381, this.large ? 541 : 269);
        }
        if (this.shootme) {
            File fil = new File("shots");
            if (!fil.exists()) {
                fil.mkdir();
            }
            try {
                ImageIO.write((RenderedImage)this.image, "PNG", new File("shots/" + this.impos++ + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.menumode || this.menupos > -300) {
            int pos;
            if (this.large) {
                int i;
                this.menumode = false;
                this.menupos = -300;
                pos = 100 + this.menupos;
                for (i = 0; i < carts.length - 11; ++i) {
                    g.setColor(new Color(0, 0, 128, 96));
                    g.fillRect(190, pos, 230, 32);
                    g.drawImage(this.Cart, 200, pos, this);
                    g.setColor(Color.white);
                    g.drawString(carts[i], 238, pos + 20);
                    g.drawString(carts[i], 239, pos + 20);
                    pos += 32;
                }
                pos = 100 + this.menupos;
                for (i = carts.length - 11; i < carts.length; ++i) {
                    g.setColor(new Color(0, 0, 128, 96));
                    g.fillRect(490, pos, 230, 32);
                    g.drawImage(this.Cart, 500, pos, this);
                    g.setColor(Color.white);
                    g.drawString(carts[i], 538, pos + 20);
                    g.drawString(carts[i], 539, pos + 20);
                    pos += 32;
                }
            } else {
                int i;
                pos = 50 + this.menupos;
                int d = 20;
                for (i = 0; i < carts.length - 11; ++i) {
                    g.setColor(new Color(255 - d, 255 - d, 55, 255));
                    g.drawRect(95, pos, 135, 16);
                    g.setColor(new Color(d, d / 2, 200, 128));
                    g.fillRect(95, pos, 136, 16);
                    g.drawImage(this.Cart, 100, pos, 16, 16, this);
                    g.setColor(Color.white);
                    g.drawString(carts[i], 119, pos + 10);
                    g.drawString(carts[i], 120, pos + 10);
                    pos += 16;
                    d += 12;
                }
                pos = 50 + this.menupos;
                d = 20;
                for (i = carts.length - 11; i < carts.length; ++i) {
                    g.setColor(new Color(255 - d, 255 - d, 55, 255));
                    g.drawRect(245, pos, 135, 16);
                    g.setColor(new Color(d, d / 2, 200, 128));
                    g.fillRect(245, pos, 136, 16);
                    g.drawImage(this.Cart, 250, pos, 16, 16, this);
                    g.setColor(Color.white);
                    g.drawString(carts[i], 269, pos + 10);
                    g.drawString(carts[i], 268, pos + 10);
                    pos += 16;
                    d += 12;
                }
            }
            if (this.menumode) {
                if (this.menupos < 0) {
                    this.menupos += 4;
                }
            } else {
                this.menupos -= 4;
            }
        }
        if (this.penonscreen) {
            g.drawImage(this.lightPen, this.lx + (this.large ? 8 : 4), this.ly + (this.large ? 8 : 4), this.large ? 128 : 64, this.large ? 128 : 64, null);
        }
        if (drawmonitor) {
            g.drawImage(this.moniter, 0, 0, this.large ? 880 : 440, this.large ? 730 : 365, this);
        }
        if (this.DEBUG_FPS) {
            g.setColor(Color.red);
            g.drawString("FPS: " + this.mCurrFPS, 4, this.getHeight() - (this.large ? 5 : 10));
        }
        if (this.DEBUG_SPRITES) {
            for (int i = 0; i < 16; ++i) {
                if (GateArray.cpc.getGateArray().xm[i] == 0 || GateArray.cpc.getGateArray().ym[i] == 0) continue;
                g.setColor(Color.white);
                g.drawRect(this.spx[i], this.spy[i], this.spw[i], this.sph[i]);
                g.setColor(Color.white);
                g.drawString("" + (i + 1), this.spx[i] + 2, this.spy[i] + 16);
            }
        }
        if (!this.large) {
            if (ledOn) {
                g.setColor(fLED_ON);
            } else {
                g.setColor(fLED_OFF);
            }
            g.fillRect(40, 340, 8, 4);
            g.setColor(fLED_BORDER);
            g.drawRect(39, 339, 9, 5);
        } else if (ledOn) {
            g.drawImage(this.Disc, 360 * this.divider, 3 * this.divider, this);
        }
        if (this.turbo) {
            g.setColor(LED_ON);
            g.fillRect(4 * this.divider, 3 * this.divider, 7 * this.divider, 3 * this.divider);
            g.setColor(LED_BORDER);
            g.drawString("x" + CPC.turbospeed, 4 * this.divider, 15 * this.divider);
            g.drawRect(3 * this.divider, 2 * this.divider, 8 * this.divider, 4 * this.divider);
            g.setColor(LED_ON);
            g.drawString("x" + CPC.turbospeed, 3 * this.divider, 14 * this.divider);
        }
        if (showdisks && showtime > 1) {
            g.drawImage(this.Disc, 24 * this.divider, 3 * this.divider, this.divider != 1 ? 26 : 13, this.divider != 1 ? 32 : 16, null);
            g.drawImage(this.Disc, 40 * this.divider, 3 * this.divider, this.divider != 1 ? 26 : 13, this.divider != 1 ? 32 : 16, null);
            --showtime;
        }
    }

    public void repaint() {
    }

    public void setspri(int index, int x, int y, int w, int h) {
        this.spx[index] = x;
        this.spy[index] = y * 2;
        this.spw[index] = w;
        this.sph[index] = h * 2;
    }

    public void paintComponent(Graphics g) {
        this.painted = false;
        if (this.image != null) {
            this.started = true;
            this.paintImage(g);
        }
        this.painted = true;
    }

    public Dimension getPreferredSize() {
        if (drawmonitor) {
            if (this.large) {
                return new Dimension(880, 730);
            }
            return new Dimension(440, 365);
        }
        if (this.large) {
            return new Dimension(768, 544);
        }
        return new Dimension(384, 272);
    }

    public Dimension getSize() {
        if (drawmonitor) {
            if (this.large) {
                return new Dimension(880, 730);
            }
            return new Dimension(440, 365);
        }
        if (this.large) {
            return new Dimension(768, 544);
        }
        return new Dimension(384, 272);
    }

    static {
        SCALE_1 = new Dimension(1, 1);
        SCALE_2 = new Dimension(2, 2);
        SCALE_1x2 = new Dimension(1, 2);
        carts = new String[]{"Barbarian II", "Batman", "Burnin' Rubber", "Copter 271", "Crazy Cars II", "Dick Tracy", "Epyx World Of Sports", "Fire And Forget II", "Klax", "Mystical", "Navy Seals", "No Exit", "Operation Thunderbolt", "Pang", "Panza Kickboxing", "Plotting", "Pro Tennis Tour", "Robocop II", "Skeet Shoot", "Super Pinball Magic", "Switchblade", "Tennis Cup II", "The Enforcer", "Tintin On The Moon", "Wildstreets", "CPC Plus System"};
        showtime = 0;
    }
}

