/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.ui.Counter;
import JCPC.ui.TimerListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class EButton
extends JButton
implements TimerListener {
    protected int autoRepeatDelay = 1000;
    protected int autoRepeatTime = 50;
    protected Counter counter = null;
    protected boolean over = false;

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.over = true;
            if (this.autoRepeatDelay >= 0) {
                this.fireActionPerformed();
                this.startTimer();
            }
        } else if (e.getID() == 502) {
            this.stopTimer();
            this.over = false;
        } else if (e.getID() == 504) {
            this.over = true;
        } else if (e.getID() == 505) {
            this.over = false;
        }
        super.processMouseEvent(e);
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(new ActionEvent(this, 0, null));
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.autoRepeatDelay < 0 || this.over) {
            super.fireActionPerformed(e);
        }
    }

    protected void startTimer() {
        if (this.counter == null) {
            this.counter = new Counter(this, this.autoRepeatDelay, null);
        }
    }

    protected void stopTimer() {
        if (this.counter != null) {
            this.counter.stop();
            this.counter = null;
        }
    }

    public void setAutoRepeatDelay(int value) {
        this.autoRepeatDelay = value;
    }

    public int getAutoRepeatDelay() {
        return this.autoRepeatDelay;
    }

    public void setAutoRepeatTime(int value) {
        this.autoRepeatTime = value;
    }

    public int getAutoRepeatTime() {
        return this.autoRepeatTime;
    }

    public void timerTick(Counter counter) {
        counter.setDuration(this.autoRepeatTime);
        if (this.over && this.counter != null) {
            this.fireActionPerformed();
        }
    }
}

