/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.core.Util;
import JCPC.core.device.Computer;
import JCPC.core.device.crtc.Basic6845;
import JCPC.system.cpc.CPC;
import JCPC.system.cpc.GateArray;
import JCPC.system.cpc.Samples;
import JCPC.ui.Controller;
import JCPC.ui.Debugger;
import JCPC.ui.Display;
import JCPC.ui.KeyTranslator;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GX4000
extends Applet
implements ItemListener,
KeyListener,
FocusListener,
Runnable,
MouseListener,
MouseMotionListener {
    protected Debugger debug = null;
    boolean menupossible = false;
    boolean penonscreen = false;
    protected static boolean developer = false;
    protected boolean URL = false;
    String CRTC = "3";
    boolean alt = false;
    int multiload = 0;
    String cartridge = "none";
    String load = "none";
    String loadb = "none";
    String sna = "none";
    protected Computer computer = null;
    Locale loc;
    String localkeys = "";
    public static boolean isStandalone = false;
    public Display plusdisplay = new Display();
    protected boolean started = false;
    protected boolean large = false;
    JInternalFrame emu;
    String disk1 = "";
    String disk2 = "";
    protected int loadit = 0;
    ActionListener update = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            GX4000.this.update();
        }
    };
    Timer fireUpdate = new Timer(50, this.update);
    int fram = 0;
    int ktick;
    boolean pressed;
    int keypresser = 0;
    boolean kpress;
    boolean ispress;
    private KeyTranslator translator = new KeyTranslator();
    JFrame fullframe;
    BufferedImage testim = new BufferedImage(768, 544, 1);
    Controller controller;
    boolean lightpen = false;
    final URL cursorim = this.getClass().getResource("lightgun.png");
    final Image lightGun = this.getToolkit().getImage(this.cursorim);
    final URL cursorim2 = this.getClass().getResource("lightpen.png");
    final Image lightPen = this.getToolkit().getImage(this.cursorim2);
    Cursor gun = Toolkit.getDefaultToolkit().createCustomCursor(this.lightGun, new Point(1, 1), "gunCursor");
    Cursor pen = Toolkit.getDefaultToolkit().createCustomCursor(this.lightPen, new Point(1, 1), "penCursor");
    int basex = 200;
    int basexmax = 230;
    boolean keepmonitor;
    static JFrame frame;

    public void showDebugger() {
        try {
            System.out.println("showDebugger");
            if (this.debug == null) {
                this.debug = (Debugger)Util.secureConstructor(Debugger.class, new Class[0], new Object[0]);
                this.debug.setBounds(0, 0, 640, 450);
                this.debug.setComputer(this.computer);
            }
            System.out.println("Showing Debugger");
            this.debug.setVisible(true);
            this.debug.toFront();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.controller.trojan) {
            this.setLightgun(this.controller.trojan.isSelected());
        }
        if (e.getSource() == this.controller.cart) {
            GateArray.cpc.loadCart(this.controller.cart.getSelectedIndex());
        }
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (y < 50) {
            if (Display.showdisks) {
                Display.showtime = 50;
            }
        }
        this.plusdisplay.updateLightpen(x, y);
        if (this.lightpen) {
            if (this.plusdisplay.fullscreen) {
                double xx = 768.0 / (double)this.plusdisplay.getWidth();
                double yy = 544.0 / (double)this.plusdisplay.getHeight();
                x = (int)((double)x * xx);
                y = (int)((double)y * yy);
            }
            GateArray.cpc.getCRTC().setLightpen(x, y, this.plusdisplay.large, this.plusdisplay.fullscreen, this.penonscreen);
        }
        if (this.large) {
            if (e.getX() > 720 && e.getX() < 780 && e.getY() > 706 && e.getY() < 726) {
                this.plusdisplay.setCursor(new Cursor(12));
                this.menupossible = true;
            } else if (this.plusdisplay.menumode && e.getX() > this.basex && e.getX() < this.basexmax && e.getY() > 100 && e.getY() < 580) {
                this.plusdisplay.setCursor(new Cursor(12));
            } else if (this.plusdisplay.menumode && e.getX() > this.basex + 300 && e.getX() < this.basexmax + 300 && e.getY() > 100 && e.getY() < 450) {
                this.plusdisplay.setCursor(new Cursor(12));
            } else {
                this.menupossible = false;
                if (!this.lightpen) {
                    this.plusdisplay.setCursor(new Cursor(0));
                } else {
                    this.plusdisplay.setCursor(this.penonscreen ? this.pen : this.gun);
                }
            }
        } else if (e.getX() > 360 && e.getX() < 390 && e.getY() > 353 && e.getY() < 363) {
            this.plusdisplay.setCursor(new Cursor(12));
            this.menupossible = true;
        } else if (this.plusdisplay.menumode && e.getX() > 100 && e.getX() < 220 && e.getY() > 50 && e.getY() < 290) {
            this.plusdisplay.setCursor(new Cursor(12));
        } else if (this.plusdisplay.menumode && e.getX() > 250 && e.getX() < 370 && e.getY() > 50 && e.getY() < 225) {
            this.plusdisplay.setCursor(new Cursor(12));
        } else {
            this.menupossible = false;
            if (!this.lightpen) {
                this.plusdisplay.setCursor(new Cursor(0));
            } else {
                this.plusdisplay.setCursor(this.penonscreen ? this.pen : this.gun);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.plusdisplay.updateLightpen(x, y);
        if (this.lightpen) {
            if (this.plusdisplay.fullscreen) {
                double xx = 768.0 / (double)this.plusdisplay.getWidth();
                double yy = 544.0 / (double)this.plusdisplay.getHeight();
                x = (int)((double)x * xx);
                y = (int)((double)y * yy);
            }
            GateArray.cpc.getCRTC().setLightpen(x, y, this.plusdisplay.large, this.plusdisplay.fullscreen, true);
        }
    }

    public String getParameter(String key, String def) {
        try {
            return isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
        }
        catch (Exception e) {
            return def;
        }
    }

    public GX4000() {
        this.enableEvents(8L);
    }

    public void init() {
        this.localkeys = this.getLocale().toString().toUpperCase();
        this.plusdisplay.requestFocus();
    }

    public void init(String locale) {
        this.localkeys = locale;
        this.plusdisplay.requestFocus();
    }

    public void stopMotor() {
        this.computer.stop();
    }

    public void startMotor() {
        this.computer.start();
    }

    public JInternalFrame getEmu(GX4000 emul) {
        this.emu = new JInternalFrame("JavaGX4000 - Amstrad CPC+ Emulator - Desktop");
        this.emu.setLayout(new BorderLayout());
        this.emu.add((Component)this, "Center");
        this.emu.pack();
        this.emu.setResizable(false);
        this.emu.setIconifiable(true);
        this.emu.setClosable(true);
        this.emu.setDefaultCloseOperation(1);
        return this.emu;
    }

    public void init(Locale loc) {
        this.localkeys = loc.toString().toUpperCase();
        this.plusdisplay.requestFocus();
    }

    public void startEngine() {
        try {
            this.controller = new Controller();
            this.fram = 0;
            this.disk2 = "";
            this.setLayout(new BorderLayout());
            CPC.cartindex = Integer.parseInt(this.getParameter("GAME", "25"));
            if (CPC.cartindex > 25 || CPC.cartindex < 0) {
                CPC.cartindex = 2;
            }
            this.large = Util.getBoolean(this.getParameter("LARGE", "true"));
            Display.scanlines = Util.getBoolean(this.getParameter("FILTER", "false"));
            this.keepmonitor = Display.drawmonitor = Util.getBoolean(this.getParameter("GUI", "false"));
            this.controller.trojan.addItemListener(this);
            this.controller.cart.setModel(new DefaultComboBoxModel<String>(Display.carts));
            this.controller.cart.setSelectedIndex(CPC.cartindex);
            this.controller.cart.addItemListener(this);
            String url = this.getParameter("URL", "false");
            url = url.toUpperCase();
            if (url.equals("TRUE")) {
                this.URL = true;
            }
            String csd = this.getParameter("CSD", "false");
            csd = csd.toUpperCase();
            CPC.CSD = false;
            if (csd.equals("TRUE")) {
                CPC.CSD = true;
            }
            String type = this.getParameter("AUTOTYPE", null);
            String boot = this.getParameter("BOOT", null);
            this.CRTC = "3";
            this.CRTC = this.getParameter("CRTC", this.CRTC);
            if (this.CRTC.startsWith("1")) {
                this.CRTC = "1";
            }
            if (this.CRTC.startsWith("3")) {
                this.CRTC = "3";
            }
            if (this.CRTC.startsWith("0")) {
                this.CRTC = "0";
            }
            Basic6845.CRTC = Integer.parseInt(this.CRTC);
            this.cartridge = this.getParameter("CPR", "internal");
            if (CPC.CSD) {
                this.cartridge = "none";
            }
            if (this.cartridge.equals("internal")) {
                this.cartridge = "none";
                CPC.internal = true;
            }
            this.sna = this.load = this.getParameter("SNA", "none");
            this.load = this.getParameter("DISK", this.load);
            if (this.load.startsWith("$")) {
                this.load = "none";
            }
            this.loadb = this.getParameter("DISKB", this.loadb);
            if (this.loadb.startsWith("$")) {
                this.loadb = "none";
            }
            this.disk2 = this.getParameter("DISK2", "");
            if (this.disk2.startsWith("$")) {
                this.disk2 = "";
            }
            Display.showdisks = false;
            if (this.disk2.length() > 1) {
                this.disk1 = this.load;
                Display.showdisks = true;
                Display.showtime = 150;
            }
            this.plusdisplay.large = this.large;
            this.setComputer("CPCPLUS", true);
            if (this.large) {
                this.plusdisplay.setSize(768, 542);
                this.plusdisplay.divider = 2;
            } else {
                this.plusdisplay.setSize(384, 272);
            }
            this.add((Component)this.plusdisplay, "Center");
            this.plusdisplay.setDoubleBuffered(true);
            this.plusdisplay.setBackground(Color.black);
            this.plusdisplay.addKeyListener(this);
            this.plusdisplay.addMouseListener(this);
            this.plusdisplay.addMouseMotionListener(this);
            this.plusdisplay.addFocusListener(this);
            this.started = true;
            if (type != null) {
                this.computer.prepareAutotype(type);
            }
            if (boot != null) {
                if (boot.contains("/")) {
                    boot = boot.replace("/", "\"");
                    this.computer.prepareAutotype(boot);
                } else if (boot.equals("tape")) {
                    this.computer.prepareAutotype("|TAPE:RUN\"!\"");
                } else if (boot.startsWith("|")) {
                    this.computer.prepareAutotype(boot);
                } else {
                    this.computer.prepareAutotype("RUN\"" + boot + "\"");
                }
            }
            this.setLightgun(Util.getBoolean(this.getParameter("LIGHTGUN", "false")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.cartridge.equals("none")) {
            this.loadFile(2, this.cartridge, true);
        }
        if (!this.load.equals("none") && this.sna.equals("none")) {
            this.loadFile(2, this.load, true);
        }
        if (this.load.equals("none") && !this.sna.equals("none")) {
            this.loadit = 1;
        }
        if (!this.load.equals("none") && !this.sna.equals("none")) {
            this.multiload = 1;
        }
        if (!this.loadb.equals("none")) {
            this.computer.setCurrentDrive(1);
            this.loadFile(2, this.loadb, true);
        }
        this.computer.setCurrentDrive(0);
        if (frame != null) {
            frame.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation((d.width - GX4000.frame.getSize().width) / 2, (d.height - GX4000.frame.getSize().height) / 2);
        }
        this.fireUpdate.start();
        this.plusdisplay.requestFocus();
        this.plusdisplay.DEBUG_SPRITES = Util.getBoolean(this.getParameter("SPRITES", this.plusdisplay.DEBUG_SPRITES ? "true" : "false"));
        this.plusdisplay.DEBUG_SCREEN = Util.getBoolean(this.getParameter("SCREEN", this.plusdisplay.DEBUG_SCREEN ? "true" : "false"));
    }

    public void start() {
        this.startEngine();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void waitStart() {
        try {
            while (!this.started) {
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
    }

    public void stop() {
        GateArray.cpc.reset();
        GateArray.cpc.getPSG().resetRegisters();
        this.computer.stop();
    }

    public void update() {
        if (this.emu != null && !this.emu.isVisible()) {
            this.stopMotor();
        }
        if (this.keypresser != 0) {
            if (this.kpress) {
                this.computer.keyReleased(100);
                this.ispress = true;
            } else {
                this.computer.keyPressed(100);
                this.ispress = false;
            }
            this.kpress = !this.kpress;
        } else {
            this.kpress = false;
            if (this.ispress) {
                this.computer.keyReleased(100);
            }
            this.ispress = false;
        }
        if (this.fram < 1) {
            ++this.fram;
            this.computer.reset();
            this.computer.reSync();
            if (frame != null) {
                frame.pack();
            }
        }
        if (this.loadit > 0) {
            ++this.loadit;
            if (this.loadit > 5) {
                this.loadit = 0;
                this.loadFile(1, this.sna, true);
            }
        }
        if (this.multiload >= 1) {
            ++this.multiload;
            if (this.multiload == 6) {
                this.loadFile(1, this.sna, true);
            }
            if (this.multiload == 8) {
                this.loadFile(1, this.load, true);
                this.multiload = 0;
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setupController() {
        this.controller.setVisible(true);
    }

    public void repaint() {
    }

    public void loadPlus() {
        GateArray.cpc.loadSystem();
    }

    public void toggleFullscreen() {
        this.alt = false;
        if (this.fullframe == null) {
            this.fullframe = new JFrame();
            this.fullframe.setUndecorated(true);
            this.fullframe.setLayout(new BorderLayout());
            GraphicsConfiguration conf = this.getGraphicsConfiguration();
            int monitors = conf.getDevice().getConfigurations().length;
            int device = 0;
            int h = conf.getDevice().getConfigurations()[device].getBounds().height;
            int w = conf.getDevice().getConfigurations()[device].getBounds().width;
            Dimension d = new Dimension(w, h);
            this.fullframe.setPreferredSize(d);
            this.fullframe.setSize(d);
            Image testit = this.testim.getScaledInstance(d.width, -1, 2);
            this.plusdisplay.left = new JPanel();
            this.plusdisplay.right = new JPanel();
            this.plusdisplay.left.setBackground(Color.black);
            this.plusdisplay.right.setBackground(Color.black);
            Dimension dd = new Dimension(0, d.height - testit.getHeight(null) >> 1);
            this.plusdisplay.left.setPreferredSize(dd);
            this.plusdisplay.right.setPreferredSize(dd);
            if (testit.getHeight(null) > this.getHeight()) {
                testit = this.testim.getScaledInstance(-1, d.height, 2);
                dd = new Dimension(d.width - testit.getWidth(null) >> 1, Toolkit.getDefaultToolkit().getScreenSize().height);
                this.plusdisplay.left.setPreferredSize(dd);
                this.plusdisplay.right.setPreferredSize(dd);
                this.plusdisplay.leftside = new BufferedImage(20, 272, 1);
                this.plusdisplay.rightside = new BufferedImage(20, 272, 1);
                this.plusdisplay.leftpixels = new int[5440];
                this.plusdisplay.rightpixels = new int[5440];
                this.fullframe.add((Component)this.plusdisplay.left, "West");
                this.fullframe.add((Component)this.plusdisplay.right, "East");
                this.plusdisplay.drawborder = true;
            } else {
                this.plusdisplay.drawborder = false;
                this.fullframe.add((Component)this.plusdisplay.left, "North");
                this.fullframe.add((Component)this.plusdisplay.right, "South");
            }
        }
        boolean bl = this.plusdisplay.fullscreen = !this.plusdisplay.fullscreen;
        if (this.plusdisplay.fullscreen) {
            if (frame != null) {
                frame.setVisible(false);
            }
            this.setVisible(false);
            this.remove(this.plusdisplay);
            this.fullframe.add((Component)this.plusdisplay, "Center");
            this.fullframe.setVisible(true);
        } else {
            this.fullframe.remove(this.plusdisplay);
            this.add((Component)this.plusdisplay, "Center");
            this.fullframe.setVisible(false);
            this.setVisible(true);
            if (frame != null) {
                frame.setVisible(true);
                frame.pack();
            }
        }
        this.plusdisplay.requestFocus();
    }

    public void toggleFilter() {
        Display.scanlines = !Display.scanlines;
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 123 && this.alt) {
            this.showDebugger();
            return;
        }
        if (e.getKeyCode() == 145) {
            this.setLightgun(!this.lightpen);
            this.controller.trojan.setSelected(this.lightpen);
        }
        if (e.getKeyCode() == 18) {
            this.alt = true;
        }
        if (this.alt && e.getKeyCode() == 10 && !this.plusdisplay.menumode) {
            this.toggleFullscreen();
        }
        if (e.getKeyCode() == 121) {
            e.consume();
            return;
        }
        block8: for (int i = 0; i < 6; ++i) {
            if (e.getKeyCode() != this.controller.keyevents[i]) continue;
            switch (i) {
                case 0: {
                    e.setKeyCode(101);
                    continue block8;
                }
                case 1: {
                    e.setKeyCode(96);
                    continue block8;
                }
                case 2: {
                    e.setKeyCode(104);
                    continue block8;
                }
                case 3: {
                    e.setKeyCode(98);
                    continue block8;
                }
                case 4: {
                    e.setKeyCode(100);
                    continue block8;
                }
                case 5: {
                    e.setKeyCode(102);
                }
            }
        }
        if (e.getKeyCode() == 100) {
            int n = this.ktick = this.ktick == 0 ? 1 : 0;
        }
        if ((e = this.translator.translate(e, this.localkeys)).getKeyCode() == 123) {
            this.resetComputer();
        }
        this.computer.processKeyEvent(e);
        e.consume();
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.alt = false;
        }
        if (e.getKeyCode() == 105) {
            int n = this.keypresser = this.keypresser == 1 ? 0 : 1;
        }
        if (e.getKeyCode() == 121) {
            this.controller.setVisible(true);
            e.consume();
            return;
        }
        block8: for (int i = 0; i < 6; ++i) {
            if (e.getKeyCode() != this.controller.keyevents[i]) continue;
            switch (i) {
                case 0: {
                    e.setKeyCode(101);
                    continue block8;
                }
                case 1: {
                    e.setKeyCode(96);
                    continue block8;
                }
                case 2: {
                    e.setKeyCode(104);
                    continue block8;
                }
                case 3: {
                    e.setKeyCode(98);
                    continue block8;
                }
                case 4: {
                    e.setKeyCode(100);
                    continue block8;
                }
                case 5: {
                    e.setKeyCode(102);
                }
            }
        }
        if (e.getKeyCode() == 114) {
            boolean bl = GateArray.cpc.saveallowed = !GateArray.cpc.saveallowed;
        }
        if (e.getKeyCode() == 112) {
            JOptionPane.showMessageDialog(new JFrame(), "JavaGX4000 by Markus Hohmann\r\nContact: webmaster@cpc-live.com\r\n\r\nF1 - This info\r\nF2 - Load medium*\r\nF3 - Enable/disable DSK storing (Off by default)\r\nF6 - Load cartridge image (CPR)\r\nF7 - Toggle Scanlines (When large)\r\nF8 - Toggle CRTC type (0/1)\r\nF9 - Toggle Turbo\r\nF10 - Setup controller and lightgun / Select internal CPR\r\nF11 - Autotype console\r\nF12 - Reset CPC\r\n\r\nAlt+F12 - Debugger\r\nAlt+Enter - Toggle fullscreen\r\nPrint Screen - Poke interface\r\nScroll Lock - Toggle lightgun\r\nPause - Amstrad Cartridge Software Demonstrator (CSD) emulation panel\r\n\r\nJoystick is mapped to:\r\n<Insert>/<NP 5> - Fire 0\r\n<Page up>/<NP 0> - Fire 1\r\n<Home>/<NP 8> - Up\r\n<Page down>/<NP 6> - Right\r\n<End>/<NP 2> - Down\r\n<Delete>/<NP 4> - Left\r\n\r\n*Supported media:\r\nDSK, SNA, CDT, CSW, BIN, CPR\r\n");
            return;
        }
        if (e.getKeyCode() == 118) {
            boolean bl = Display.scanlines = !Display.scanlines;
        }
        if ((e = this.translator.translate(e, this.localkeys)).getKeyCode() == 113) {
            this.load();
        }
        this.computer.processKeyEvent(e);
        e.consume();
    }

    protected void load() {
        if (developer) {
            FileDialog filedia = new FileDialog((Frame)frame, "Load file", 0);
            filedia.setFile("*.dsk;*.bin;*.cdt;*.cpr;*.sna;*.csw");
            filedia.setVisible(true);
            String filename = filedia.getFile();
            if (filename != null) {
                filename = filedia.getDirectory() + filedia.getFile();
                this.loadFile(1, filename, false);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.lightpen) {
            return;
        }
        this.plusdisplay.requestFocus();
        if (e.getClickCount() == 2 && frame != null && !this.plusdisplay.fullscreen) {
            Thread b = new Thread(){

                public void run() {
                    GX4000.this.setFullSize(!GX4000.this.large);
                    System.out.println("Changing display to " + (GX4000.this.large ? "large size" : "small size"));
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GX4000.this.plusdisplay.setPreferredSize(GX4000.this.plusdisplay.getPreferredSize());
                    GX4000.this.plusdisplay.setSize(GX4000.this.plusdisplay.getPreferredSize());
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    frame.pack();
                    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                    frame.setLocation((d.width - GX4000.frame.getSize().width) / 2, (d.height - GX4000.frame.getSize().height) / 2);
                }
            };
            b.start();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.lightpen && !this.plusdisplay.menumode) {
            if (e.getButton() != 1) {
                this.plusdisplay.penonscreen = this.penonscreen = !this.penonscreen;
                this.plusdisplay.setCursor(this.penonscreen ? this.pen : this.gun);
                return;
            }
            int x = e.getX();
            int y = e.getY();
            if (this.plusdisplay.fullscreen) {
                double xx = 768.0 / (double)this.plusdisplay.getWidth();
                double yy = 544.0 / (double)this.plusdisplay.getHeight();
                x = (int)((double)x * xx);
                y = (int)((double)y * yy);
            }
            GateArray.cpc.getCRTC().setLightpen(x, y, this.plusdisplay.large, this.plusdisplay.fullscreen, true);
            this.computer.keyPressed(this.penonscreen ? 10 : 155);
        }
    }

    public void setLightgun(boolean enable) {
        GateArray.cpc.getCRTC().lightgun = this.lightpen = enable;
        if (this.lightpen) {
            this.plusdisplay.setCursor(this.penonscreen ? this.pen : this.gun);
        } else {
            this.plusdisplay.setCursor(new Cursor(0));
        }
    }

    public void mouseReleased(MouseEvent e) {
        block25: {
            int index;
            block30: {
                block29: {
                    int y;
                    int x;
                    block26: {
                        block28: {
                            block27: {
                                block19: {
                                    block24: {
                                        block23: {
                                            block20: {
                                                block22: {
                                                    block21: {
                                                        x = e.getX();
                                                        y = e.getY();
                                                        if (y < 50) {
                                                            Display.showtime = 50;
                                                        }
                                                        if (Display.showtime > 0) {
                                                            int d = this.plusdisplay.divider;
                                                            d = d == 2 ? 1 : 2;
                                                            if (x > 46 / d && x < 76 / d && y > 6 / d && y < 38 / d) {
                                                                System.out.println("Loading disk 1");
                                                                this.loadFile(2, this.disk1, true);
                                                                Samples.INSERT.play();
                                                            }
                                                            if (x > 80 / d && x < 106 / d && y > 6 / d && y < 38 / d) {
                                                                System.out.println("Loading disk 2");
                                                                this.loadFile(2, this.disk2, true);
                                                                Samples.INSERT.play();
                                                            }
                                                        }
                                                        if (this.menupossible) {
                                                            boolean bl = this.plusdisplay.menumode = !this.plusdisplay.menumode;
                                                        }
                                                        if (!this.plusdisplay.menumode && this.lightpen) {
                                                            this.computer.keyReleased(this.penonscreen ? 10 : 155);
                                                            GateArray.cpc.getCRTC().releaseGun();
                                                            return;
                                                        }
                                                        if (!this.plusdisplay.menumode || !this.plusdisplay.large) break block19;
                                                        if (x <= this.basex || x >= this.basexmax || (y -= 100) >= 480 || y <= 0) break block20;
                                                        index = y / 32;
                                                        if (index < 0) break block21;
                                                        if (index <= Display.carts.length - 1) break block22;
                                                    }
                                                    return;
                                                }
                                                this.controller.cart.setSelectedIndex(index);
                                                this.plusdisplay.menumode = false;
                                            }
                                            if (x <= this.basex + 300 || x >= this.basexmax + 300 || y >= 320 || y <= 0) break block19;
                                            index = 15 + y / 32;
                                            if (index < 0) break block23;
                                            if (index <= Display.carts.length - 1) break block24;
                                        }
                                        return;
                                    }
                                    this.controller.cart.setSelectedIndex(index);
                                    this.plusdisplay.menumode = false;
                                }
                                if (!this.plusdisplay.menumode || this.plusdisplay.large) break block25;
                                if (x <= 100 || x >= 220 || (y -= 50) >= 240 || y <= 0) break block26;
                                index = y / 16;
                                if (index < 0) break block27;
                                if (index <= Display.carts.length - 1) break block28;
                            }
                            return;
                        }
                        this.controller.cart.setSelectedIndex(index);
                        this.plusdisplay.menumode = false;
                    }
                    if (x <= 250 || x >= 370 || y >= 210 || y <= 0) break block25;
                    index = 15 + y / 16;
                    if (index < 0) break block29;
                    if (index <= Display.carts.length - 1) break block30;
                }
                return;
            }
            this.controller.cart.setSelectedIndex(index);
            this.plusdisplay.menumode = false;
        }
        if (this.plusdisplay.mCurrFPS < 45) {
            this.computer.reSync();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void loadFile(String name) {
        this.loadFile(0, name, true);
    }

    public void loadFile(int type, String name, boolean usePath) {
        if (this.URL) {
            usePath = false;
        }
        try {
            this.computer.stop();
            this.computer.loadFile(type, (usePath ? this.computer.getFilePath() : "") + name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.computer.start();
        this.plusdisplay.requestFocus();
    }

    public void resetComputer() {
        GateArray.cpc.cprslot = 0;
        this.computer.reset();
    }

    public void loadGame(int slot) {
        GateArray.cpc.loadCart(slot);
    }

    public void setComputer(String name) {
        try {
            this.setComputer(name, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void setComputer(String name, boolean start) throws Exception {
        if (this.computer == null || !name.equalsIgnoreCase(this.computer.getName())) {
            Computer newComputer;
            this.computer = newComputer = Computer.createComputer(this, name);
            this.setFullSize(this.large);
            this.computer.initialise();
            if (start) {
                this.computer.start();
            }
        }
    }

    public void setFullSize(boolean value) {
        this.large = value;
        Display.drawmonitor = value ? false : this.keepmonitor;
        this.computer.stop();
        this.plusdisplay.divider = this.large ? 2 : 1;
        this.plusdisplay.large = this.large;
        this.computer.setLarge(this.large);
        this.plusdisplay.setImageSize(this.computer.getDisplaySize(this.large), this.computer.getDisplayScale(this.large));
        this.computer.setDisplay(this.plusdisplay);
        this.computer.start();
    }

    public void focusLost(FocusEvent e) {
        this.computer.displayLostFocus();
        if (this.plusdisplay.mCurrFPS < 45) {
            this.computer.reSync();
        }
    }

    public void focusGained(FocusEvent e) {
        if (this.plusdisplay.mCurrFPS < 45) {
            this.computer.reSync();
        }
    }

    public static void main(String[] args) {
        developer = true;
        GX4000 applet = new GX4000();
        isStandalone = true;
        frame = new JFrame(){

            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    System.exit(0);
                }
            }

            public synchronized void setTitle(String title) {
                super.setTitle(title);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("JavaGX4000");
        frame.getContentPane().add((Component)applet, "Center");
        applet.init();
        applet.start();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - GX4000.frame.getSize().width) / 2, (d.height - GX4000.frame.getSize().height) / 2);
        frame.setVisible(true);
        frame.setResizable(false);
        frame.pack();
    }
}

