/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.internalfilesystem;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import jemu.core.device.Device;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;

public class ImageExporter {
    String systempath;
    byte[] data = new byte[16384];
    byte[] scrchk = new byte[16384];
    long checksum;
    long oldchecksum;
    String filename = "";
    public int[] SCR_CODE = new int[]{58, 208, 215, 205, 28, 189, 33, 209, 215, 70, 72, 205, 56, 188, 175, 33, 209, 215, 70, 72, 245, 229, 205, 50, 188, 225, 241, 35, 60, 254, 16, 32, 241, 195, 24, 187};
    protected String internalname = "           ";
    protected int namepos = 1;
    protected int filetypepos = 18;
    protected int datalengthpos = 19;
    protected int datalocationpos = 21;
    protected int firstblockpos = 23;
    protected int filelengthpos = 24;
    protected int execaddresspos = 26;
    protected int lengthpos = 64;
    protected int checksumpos = 67;
    byte[] HEADER;

    public void Start() {
        try {
            this.systempath = Settings.get("filesystem_path", new File("").getCanonicalPath() + "/");
            this.data = this.makeHeader(2, 49152, 16384, 51152, "SCREEN", this.data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] makeHeader(int type, int start, int length, int exec, String intname, byte[] data) {
        this.HEADER = new byte[128];
        intname = intname.replace(".", "");
        while (intname.length() > 11) {
            intname = intname.substring(0, intname.length() - 1);
        }
        intname = intname.toUpperCase();
        try {
            System.arraycopy("           ".getBytes("UTF-8"), 0, this.HEADER, this.namepos, 11);
            System.arraycopy(intname.getBytes("UTF-8"), 0, this.HEADER, this.namepos, intname.length());
        }
        catch (Exception e) {
            System.err.println("Something went wrong with " + intname);
        }
        this.HEADER[this.filetypepos] = (byte)type;
        Device.putWord(this.HEADER, this.datalengthpos, length);
        Device.putWord(this.HEADER, this.datalocationpos, start);
        this.HEADER[this.firstblockpos] = -1;
        Device.putWord(this.HEADER, this.filelengthpos, length);
        Device.putWord(this.HEADER, this.execaddresspos, exec);
        ImageExporter.put24Bit(this.HEADER, this.lengthpos, length);
        ImageExporter.put24Bit(this.HEADER, this.checksumpos, CPC.ChecksumAMSDOS(this.HEADER));
        return this.addHeader(data);
    }

    public static void put24Bit(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 2] = (byte)(data >> 16 & 0xFF);
    }

    public byte[] addHeader(byte[] SOURCEFILE) {
        byte[] RESULT = new byte[SOURCEFILE.length + 128];
        System.arraycopy(this.HEADER, 0, RESULT, 0, 128);
        System.arraycopy(SOURCEFILE, 0, RESULT, 128, SOURCEFILE.length);
        SOURCEFILE = new byte[RESULT.length];
        System.arraycopy(RESULT, 0, SOURCEFILE, 0, SOURCEFILE.length);
        return RESULT;
    }

    public void record() {
        int i;
        if (this.systempath == null) {
            this.Start();
        }
        System.arraycopy(GateArray.screenmemory, 49152, this.scrchk, 0, 16384);
        for (i = 0; i < this.scrchk.length; ++i) {
            this.checksum += (long)this.scrchk[i];
        }
        if (this.checksum != this.oldchecksum) {
            System.arraycopy(GateArray.screenmemory, 49152, this.data, 128, 16384);
            for (i = 0; i < 16; ++i) {
                this.data[6097 + i + 128] = (byte)GateArray.getInk(i);
            }
            for (i = 0; i < 36; ++i) {
                this.data[2000 + i + 128] = (byte)this.SCR_CODE[i];
            }
            this.data[6224] = (byte)GateArray.getSMode();
            int adr = 2128;
            this.data[adr + 33] = -55;
            this.data[adr + 34] = 0;
            this.data[adr + 35] = 0;
            int d = 1;
            File out = new File(this.systempath + d + ".SCR");
            while (out.exists()) {
                out = new File(this.systempath + ++d + ".SCR");
            }
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                bos.write(this.data);
                bos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.oldchecksum = this.checksum;
    }
}

