/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.internalfilesystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import jemu.core.Util;
import jemu.core.device.Device;
import jemu.core.device.sound.DigiDevice;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Switches;

public class InternalFileSystem
extends DigiDevice {
    protected File checkfile;
    protected String systempath = "";
    protected String filename = "";
    protected int outport = 255;
    protected String content = "";
    protected final String up = "\u000b";
    String feed = null;
    String loadcommand = "";
    int loadaddress = 0;
    byte[] HEADER;
    protected String internalname = "           ";
    protected int namepos = 1;
    protected int filetypepos = 18;
    protected int datalengthpos = 19;
    protected int datalocationpos = 21;
    protected int firstblockpos = 23;
    protected int filelengthpos = 24;
    protected int execaddresspos = 26;
    protected int lengthpos = 64;
    protected int checksumpos = 67;
    byte[] address1 = new byte[2];
    byte[] address2 = new byte[2];
    byte[] address3 = new byte[2];
    boolean enabled = false;
    int commandport;
    int nextcommand = 0;
    int oldval = 0;
    int feedpos = 0;
    int pc = 0;
    int pause = 0;

    public InternalFileSystem() {
        super("Internal Filesystem");
        try {
            this.systempath = Settings.get("filesystem_path", new File("").getCanonicalPath() + "/");
            this.systempath = this.systempath.replace("\\", "/");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void writetype(String tocpc) {
        GateArray.cpc.BasicAutoType(tocpc, true);
    }

    protected void write(String tocpc) {
        this.feedpos = 0;
        this.feed = tocpc;
    }

    protected void dir(String name) {
        File a;
        if (name.length() < 1 && !(a = new File(name = "C:/")).exists()) {
            name = "/Users/";
        }
        long dirs = 0L;
        long files = 0L;
        long sizes = 0L;
        this.checkfile = new File(name);
        String[] check = this.checkfile.list();
        int l = GateArray.getSMode();
        if (l == 2) {
            l = 3;
        }
        String line = "--------------------";
        if (l == 1) {
            line = line + "--------------------";
        }
        if (l == 3) {
            line = line + "------------------------------------------------------------";
        }
        String tocpc = "Directory for \"" + name + "\"\r\n" + line;
        boolean lf = false;
        int lft = 1;
        if (check != null) {
            for (int i = 0; i < check.length; ++i) {
                int size = 0;
                tocpc = tocpc + " ";
                if (new File(name + check[i]).isDirectory()) {
                    ++dirs;
                } else {
                    ++files;
                    size = (int)new File(name + check[i]).length();
                    sizes += (long)size;
                }
                String d = check[i].toUpperCase();
                while (d.length() < 12) {
                    d = d + " ";
                }
                if (d.contains(".")) {
                    d = d.replace(".", "ZZZZ1111eeee4444");
                    String[] ir = d.split("ZZZZ1111eeee4444");
                    while (ir[0].length() < 8) {
                        ir[0] = ir[0] + " ";
                    }
                    d = ir[0] + "." + ir[1];
                }
                while (d.length() > 12) {
                    d = d.substring(0, d.length() - 1);
                }
                while (d.length() < 12) {
                    d = d + " ";
                }
                tocpc = tocpc + d;
                if (size != 0) {
                    String s = "";
                    if (size < 1024) {
                        s = size + "B";
                    } else {
                        s = size / 1000 + "K";
                        if (size / 1000 > 1024) {
                            s = size / 1000 / 1000 + "M";
                        }
                    }
                    while (s.length() < 5) {
                        s = " " + s;
                    }
                    tocpc = tocpc + ":" + s;
                } else {
                    tocpc = tocpc + ":[DIR]";
                }
                if (l == 0) {
                    lf = true;
                }
                tocpc = lf ? tocpc + "\r\n" : tocpc + " ";
                lf = false;
                if (++lft <= l) continue;
                lf = true;
                lft = 0;
            }
        }
        tocpc = tocpc + "\r\n" + line + dirs + " dirs, " + files + " files, " + sizes + " bytes\r\n";
        this.write(tocpc);
    }

    protected void setPath(String command) {
        String old = this.systempath;
        if (!(command = command.replace("\\", "/")).endsWith("/")) {
            command = command + "/";
        }
        if (command.contains(":") || command.startsWith("/")) {
            this.systempath = command;
        } else if (command.contains("..")) {
            if (this.systempath.endsWith("/")) {
                this.systempath = this.systempath.substring(0, this.systempath.length() - 1);
                if (this.systempath.contains("/")) {
                    while (!this.systempath.endsWith("/")) {
                        this.systempath = this.systempath.substring(0, this.systempath.length() - 1);
                    }
                    this.systempath = this.systempath.substring(0, this.systempath.length() - 1);
                }
            } else if (this.systempath.contains("/")) {
                while (!this.systempath.endsWith("/")) {
                    this.systempath = this.systempath.substring(0, this.systempath.length() - 1);
                }
                this.systempath = this.systempath.substring(0, this.systempath.length() - 1);
            }
            this.systempath = this.systempath + "/";
        } else {
            this.systempath = this.systempath + command;
        }
        this.systempath = this.systempath.replace("\\", "/");
        File a = new File(this.systempath);
        if (!a.exists()) {
            String tocpc = "*ERROR* Path " + this.systempath + " not found.";
            this.write(tocpc);
            this.systempath = old;
            return;
        }
        String tocpc = "Path changed to " + this.systempath + ".";
        this.write(tocpc);
        Settings.set("filesystem_path", this.systempath);
        System.out.println("Path seth to " + this.systempath);
    }

    protected void mkdir(String command) {
        File a = new File(this.systempath + command);
        if (!a.exists()) {
            a.mkdir();
            String tocpc = "DIR " + command + " created.";
            this.write(tocpc);
        } else {
            String tocpc = "*ERROR* DIR " + command + " already exists.";
            this.write(tocpc);
        }
    }

    protected void del(String command) {
        File a = new File(this.systempath + command);
        if (a.exists()) {
            a.delete();
            int dd = 0;
            while (a.exists() && ++dd <= 100000) {
            }
            if (a.exists()) {
                String tocpc = "*ERROR* Cannot delete " + command + ".";
                this.write(tocpc);
            } else {
                String tocpc = command + " erased.";
                this.write(tocpc);
            }
        } else {
            String tocpc = "*ERROR* File " + command + " not found.";
            this.write(tocpc);
        }
    }

    protected void load(String command) {
        this.loadaddress = Device.getWord(this.address1, 0);
        this.clear();
        if (command.toLowerCase().endsWith(".dsk")) {
            try {
                int d = GateArray.cpc.getCurrentDrive();
                GateArray.cpc.setCurrentDrive(this.loadaddress);
                GateArray.cpc.loadFile(0, this.systempath + command);
                Settings.set("file.drive" + Integer.toString(this.loadaddress), this.systempath + command);
                Settings.setBoolean("loaddrive" + Integer.toString(this.loadaddress), true);
                GateArray.cpc.setCurrentDrive(d);
            }
            catch (Exception d) {
                // empty catch block
            }
            return;
        }
        File a = new File(this.systempath + command);
        if (!a.exists() || a.isDirectory()) {
            if (a.isDirectory()) {
                String tocpc = "\r\n'*ERROR* " + command + " is a folder.\r\n";
                this.writetype(tocpc);
                return;
            }
            a = new File(this.systempath + command + ".BAS");
            if (!(a.exists() && !a.isDirectory() || (a = new File(this.systempath + command + ".BIN")).exists() && !a.isDirectory() || (a = new File(this.systempath + command + ".SNA")).exists())) {
                String tocpc = "\r\n'*ERROR* File " + command + " not found.\r\n";
                this.writetype(tocpc);
                return;
            }
        }
        int siz = (int)a.length();
        byte[] data = new byte[siz];
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
            bin.read(data);
            bin.close();
            GateArray.cpc.loadFile(data, this.loadaddress);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void save(String command) {
        if (command.startsWith("&")) {
            command = command.replace("&", "");
            try {
                this.loadaddress = Util.hexValue(command);
            }
            catch (Exception exception) {}
        } else {
            File a = new File(this.systempath + command);
            int siz = (int)a.length();
            byte[] data = new byte[siz];
            try {
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
                bin.read(data);
                bin.close();
                GateArray.cpc.loadFile(data, this.loadaddress);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public byte[] makeHeader(int type, int start, int length, int exec, String intname, byte[] data) {
        this.HEADER = new byte[128];
        intname = intname.replace(".", "");
        while (intname.length() > 11) {
            intname = intname.substring(0, intname.length() - 1);
        }
        intname = intname.toUpperCase();
        try {
            System.arraycopy("           ".getBytes("UTF-8"), 0, this.HEADER, this.namepos, 11);
            System.arraycopy(intname.getBytes("UTF-8"), 0, this.HEADER, this.namepos, intname.length());
        }
        catch (Exception e) {
            System.err.println("Something went wrong with " + intname);
        }
        this.HEADER[this.filetypepos] = (byte)type;
        Device.putWord(this.HEADER, this.datalengthpos, length);
        Device.putWord(this.HEADER, this.datalocationpos, start);
        this.HEADER[this.firstblockpos] = -1;
        Device.putWord(this.HEADER, this.filelengthpos, length);
        Device.putWord(this.HEADER, this.execaddresspos, exec);
        InternalFileSystem.put24Bit(this.HEADER, this.lengthpos, length);
        InternalFileSystem.put24Bit(this.HEADER, this.checksumpos, CPC.ChecksumAMSDOS(this.HEADER));
        return this.addHeader(data);
    }

    public static void put24Bit(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 2] = (byte)(data >> 16 & 0xFF);
    }

    public byte[] addHeader(byte[] SOURCEFILE) {
        byte[] RESULT = new byte[SOURCEFILE.length + 128];
        System.arraycopy(this.HEADER, 0, RESULT, 0, 128);
        System.arraycopy(SOURCEFILE, 0, RESULT, 128, SOURCEFILE.length);
        SOURCEFILE = new byte[RESULT.length];
        System.arraycopy(RESULT, 0, SOURCEFILE, 0, SOURCEFILE.length);
        return RESULT;
    }

    protected void savebin(String command) {
        if (!(command = command.toUpperCase()).contains(".")) {
            command = command + ".BIN";
        } else if (command.endsWith(".")) {
            command = command.substring(0, command.length() - 1);
        }
        File a = new File(this.systempath + command);
        if (a.exists()) {
            String old = command;
            if (!(command = command.replace(".BIN", ".BAK")).endsWith(".BAK")) {
                command = command + ".BAK";
            }
            File b = new File(this.systempath + command);
            a.renameTo(b);
            command = old;
            a = new File(this.systempath + old);
        }
        int siz = Device.getWord(this.address2, 0);
        int start = Device.getWord(this.address1, 0);
        int begin = Device.getWord(this.address3, 0);
        this.clear();
        int pos = start;
        byte[] data = new byte[siz];
        int d = 0;
        for (int i = pos; i < pos + siz; ++i) {
            int n = d++;
            data[n] = (byte)CPC.memory.readWriteByte(i);
        }
        data = this.makeHeader(2, start, siz, begin, command, data);
        try {
            BufferedOutputStream bin = new BufferedOutputStream(new FileOutputStream(a));
            bin.write(data);
            bin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void savebas(String command) {
        if ((command = command.toUpperCase()).endsWith(".SNA")) {
            int sizemem = 512;
            if (CPC.memory.getRAMType() == 0) {
                sizemem = 64;
            }
            if (CPC.memory.getRAMType() == 1) {
                sizemem = 128;
            }
            if (CPC.memory.getRAMType() == 15) {
                sizemem = 256;
            }
            byte[] data = GateArray.cpc.getSNA(sizemem);
            File d = new File(this.systempath + command);
            try {
                BufferedOutputStream bin = new BufferedOutputStream(new FileOutputStream(d));
                bin.write(data);
                bin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (command.endsWith(".DSK")) {
            byte[] data = GateArray.cpc.getDSKImage(0);
            File d = new File(this.systempath + command);
            try {
                BufferedOutputStream bin = new BufferedOutputStream(new FileOutputStream(d));
                bin.write(data);
                bin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (!command.contains(".")) {
            command = command + ".BAS";
        } else if (command.endsWith(".")) {
            command = command.substring(0, command.length() - 1);
        }
        String oldc = command;
        System.out.println("Storing " + this.systempath + command);
        File a = new File(this.systempath + command);
        if (a.exists()) {
            if (!(command = command.replace(".BAS", ".BAK")).endsWith(".BAK")) {
                command = command + ".BAK";
            }
            File b = new File(this.systempath + command);
            a.renameTo(b);
        }
        command = oldc;
        a = new File(this.systempath + command);
        int siz = GateArray.cpc.getBasSize1_1();
        if (Switches.ROM.equals("CPC464")) {
            siz = GateArray.cpc.getBasSize1_0();
        }
        int pos = 368;
        byte[] data = new byte[siz + 2];
        int d = 0;
        for (int i = pos; i < pos + siz; ++i) {
            int n = d++;
            data[n] = (byte)CPC.memory.readWriteByte(i);
        }
        data = this.makeHeader(0, 368, siz, 0, command, data);
        try {
            BufferedOutputStream bin = new BufferedOutputStream(new FileOutputStream(a));
            bin.write(data);
            bin.close();
        }
        catch (Exception e) {
            this.write("*Error* save failed.");
        }
    }

    protected void hextype(String command) {
        this.feed = null;
        int l = GateArray.getSMode();
        if (l != 2) {
            this.write("Please set MODE to 2 and retry.");
            return;
        }
        File a = new File(this.systempath + command);
        int siz = (int)a.length();
        byte[] data = new byte[siz];
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
            bin.read(data);
            bin.close();
            String d = Util.dumpBytes(data, 0, data.length, true, true, true);
            this.write(d);
        }
        catch (Exception e) {
            this.write("*Error* file " + command + " not found.");
        }
    }

    protected void type(String command) {
        this.feed = null;
        File a = new File(this.systempath + command);
        int siz = (int)a.length();
        byte[] data = new byte[siz];
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
            bin.read(data);
            bin.close();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < data.length; ++i) {
                int p = data[i] & 0xFF;
                if (p <= 30 && p != 13 && p != 10) continue;
                b.append("" + (char)(data[i] & 0xFF));
            }
            this.write(b.toString());
        }
        catch (Exception e) {
            this.write("*Error* file " + command + " not found.");
        }
    }

    protected void clear() {
        this.address1[0] = 0;
        this.address1[1] = 0;
        this.address2[0] = 0;
        this.address2[1] = 0;
        this.address3[0] = 0;
        this.address3[1] = 0;
    }

    protected void executeCommand(int port, String command) {
        System.out.println("Running command #" + port);
        switch (port) {
            case 0: {
                this.setPath(command);
                break;
            }
            case 1: {
                this.dir(this.systempath);
                break;
            }
            case 2: {
                this.load(command);
                break;
            }
            case 3: {
                this.save(command);
                break;
            }
            case 4: {
                this.savebas(command);
                break;
            }
            case 5: {
                this.mkdir(command);
                break;
            }
            case 6: {
                this.del(command);
                break;
            }
            case 7: {
                this.clear();
                this.load(command);
                break;
            }
            case 8: {
                this.savebin(command);
                break;
            }
            case 9: {
                this.type(command);
                break;
            }
            case 10: {
                this.hextype(command);
            }
        }
    }

    public void writePort(int port, int value) {
        if (port < 65520) {
            return;
        }
        if (value == 2 && this.feed != null) {
            this.feed = null;
            this.write("\r\n*Stopped*\r\n");
        }
        if (this.feed != null) {
            if (value == 255 && this.pc != GateArray.cpc.z80.getPC()) {
                if (this.feedpos == this.feed.length()) {
                    this.feed = null;
                    this.outport = 0;
                } else {
                    this.outport = this.feed.charAt(this.feedpos);
                    ++this.feedpos;
                }
            }
            return;
        }
        if (port != 65520) {
            if (this.oldval == value) {
                return;
            }
            this.oldval = value;
        }
        System.out.println(Util.hex((short)port) + " - " + value);
        this.outport = 0;
        if (this.nextcommand != 0) {
            switch (this.nextcommand) {
                case 1: {
                    this.address1[1] = (byte)value;
                    break;
                }
                case 2: {
                    this.address1[0] = (byte)value;
                    break;
                }
                case 3: {
                    this.address2[1] = (byte)value;
                    break;
                }
                case 4: {
                    this.address2[0] = (byte)value;
                    break;
                }
                case 5: {
                    this.address3[1] = (byte)value;
                    break;
                }
                case 6: {
                    this.address3[0] = (byte)value;
                }
            }
            this.nextcommand = 0;
            this.outport = 255;
            return;
        }
        if (value < 13 && port != 65520) {
            this.commandport = value;
            System.out.println("Commandport is: " + value);
        } else if (value == 255 && port != 65520) {
            this.executeCommand(this.commandport, this.content);
            this.content = "";
        } else if (value == 20 && port != 65520) {
            this.nextcommand = 1;
        } else if (value == 21 && port != 65520) {
            this.nextcommand = 2;
        } else if (value == 30 && port != 65520) {
            this.nextcommand = 3;
        } else if (value == 31 && port != 65520) {
            this.nextcommand = 4;
        } else if (value == 40 && port != 65520) {
            this.nextcommand = 5;
        } else if (value == 41 && port != 65520) {
            this.nextcommand = 6;
            System.out.println("next is 6");
        } else {
            this.content = this.content + (char)value;
        }
        this.outport = 255;
    }

    public int readPort(int port) {
        return this.outport;
    }
}

