/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.printer;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jemu.core.device.printer.DMP2000;
import jemu.core.device.printer.PrinterDevice;
import jemu.core.device.printer.TextPrinter;
import jemu.ui.Switches;

public class Printer
extends PrinterDevice {
    TextPrinter textprinter;
    DMP2000 dmp;
    public Thread printer;
    boolean isRunning = false;
    boolean init = true;
    final JFrame frame = new JFrame("Amstrad DMP 2000");
    public boolean matrixprinter = false;

    public Printer() {
        super("Amstrad DMP 2000");
    }

    public void init() {
        if (this.dmp == null) {
            this.dmp = new DMP2000();
            this.frame.setLayout(new BorderLayout());
            this.frame.add((Component)this.dmp, "Center");
            this.frame.setDefaultCloseOperation(1);
            this.frame.pack();
            this.frame.setAlwaysOnTop(false);
        }
        this.dmp.print(10);
        this.dmp.ypos -= this.dmp.ydpi;
        this.dmp.yprint -= this.dmp.ydpi;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Printer.this.dmp.clearPage();
                    Printer.this.dmp.PaperFeed(false);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isRunning = true;
    }

    public void writePort(int port, int value) {
        if (this.matrixprinter) {
            if (Switches.Printer && !this.isRunning) {
                this.frame.setVisible(true);
                this.init();
            } else if (this.isRunning && Switches.Printer && !this.frame.isVisible() && value > 32 && value < 120) {
                System.err.println(value);
                this.frame.setVisible(true);
            }
        }
        if ((value & 0x80) != 0 && Switches.Printer) {
            value &= 0x7F;
            if (this.matrixprinter) {
                this.dmp.print(value);
            } else {
                if (this.textprinter == null) {
                    this.textprinter = new TextPrinter();
                }
                this.textprinter.print(value);
            }
        }
    }
}

