/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.realtimeclock;

import JCPC.core.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.Timer;
import jemu.core.device.realtimeclock.ClockDevice;

public class SFIIClock
extends ClockDevice {
    boolean DEBUG = false;
    int realsecond;
    int hours;
    int mins;
    int secs;
    int weekdays;
    int days;
    int months;
    int years;
    int mills;
    int mhour;
    int mmin;
    int msec;
    int mweek;
    int mday;
    int mmonth;
    int myear;
    int mmill;
    boolean running = false;
    ActionListener update = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            SFIIClock.this.cal = Calendar.getInstance();
            if (SFIIClock.this.realsecond != SFIIClock.this.cal.get(13)) {
                SFIIClock.this.realsecond = SFIIClock.this.cal.get(13);
                ++SFIIClock.this.secs;
                if (SFIIClock.this.secs > 59) {
                    SFIIClock.this.secs = 0;
                    ++SFIIClock.this.mins;
                    if (SFIIClock.this.mins > 59) {
                        SFIIClock.this.mins = 0;
                        ++SFIIClock.this.hours;
                        if (SFIIClock.this.hours > 23) {
                            SFIIClock.this.hours = 0;
                            ++SFIIClock.this.days;
                            SFIIClock.this.handleCalendar();
                        }
                    }
                }
                SFIIClock.this.updateClock();
            }
        }
    };
    Timer fireUpdate = new Timer(250, this.update);
    int[] dayOfMonth = new int[]{-1, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    Calendar cal;
    int selReg;
    boolean bcd = false;
    int oldbcd;
    protected int[] reg = new int[255];

    public SFIIClock() {
        super("Symbiface II Realtime Clock");
        this.fireUpdate.start();
    }

    public void setRunning(boolean run) {
        this.running = run;
        this.reset();
    }

    public void handleCalendar() {
        int p = this.dayOfMonth[this.months];
        if (this.months == 2) {
            this.cal = Calendar.getInstance();
            int n = p = this.istSchaltjahr(this.cal.get(1)) ? 29 : 28;
        }
        if (this.days > p) {
            this.days = 1;
            ++this.months;
            if (this.months > 12) {
                this.months = 1;
                ++this.years;
                if (this.years > 99) {
                    this.years = 0;
                    ++this.mills;
                }
            }
        }
    }

    public boolean istSchaltjahr(int jahr) {
        return jahr % 4 == 0 && (jahr % 100 != 0 || jahr % 400 == 0);
    }

    public void updateClock() {
        if (!this.bcd) {
            try {
                String a = this.secs + "";
                this.reg[0] = Util.hexValue(a);
                a = this.mins + "";
                this.reg[2] = Util.hexValue(a);
                a = this.hours + "";
                this.reg[4] = Util.hexValue(a);
                a = this.weekdays + "";
                this.reg[6] = Util.hexValue(a);
                a = this.days + "";
                this.reg[7] = Util.hexValue(a);
                a = this.months + "";
                this.reg[8] = Util.hexValue(a);
                a = "" + this.years;
                this.reg[9] = Util.hexValue(a);
                a = "" + this.mills;
                this.reg[50] = Util.hexValue(a);
            }
            catch (Exception exception) {}
        } else {
            this.reg[0] = this.secs;
            this.reg[2] = this.mins;
            this.reg[4] = this.hours;
            this.reg[6] = this.weekdays;
            this.reg[7] = this.days;
            this.reg[8] = this.months;
            this.reg[9] = this.years;
            this.reg[50] = this.mills;
        }
    }

    public void reset() {
        this.cal = Calendar.getInstance();
        System.out.println("Clock reset");
        if (!this.running) {
            String a;
            for (int i = 0; i < this.reg.length; ++i) {
                this.reg[i] = 255;
            }
            this.reg[10] = 32;
            this.reg[11] = 7;
            this.reg[12] = 0;
            this.reg[13] = 128;
            this.secs = this.cal.get(13);
            this.mins = this.cal.get(12);
            this.hours = this.cal.get(11);
            this.weekdays = this.cal.get(7);
            this.days = this.cal.get(5);
            this.months = this.cal.get(2) + 1;
            String b = a = this.cal.get(1) + "";
            a = a.substring(2);
            b = b.substring(0, b.length() - 2);
            this.years = Integer.parseInt(a);
            this.mills = Integer.parseInt(b);
        }
        this.bcd = (this.reg[11] & 4) != 0;
        System.out.println("BCD is " + this.bcd);
        this.running = true;
        this.updateClock();
    }

    public void writePort(int port, int value) {
        this.bcd = (this.reg[11] & 4) != 0;
        switch (port) {
            case 64788: {
                int b;
                if (this.selReg != 50 && this.DEBUG) {
                    System.err.println("selReg = " + this.selReg + " value = " + Util.hex((byte)value));
                }
                if (this.selReg == 11) {
                    // empty if block
                }
                this.reg[this.selReg] = value & 0xFF;
                if (!(this.selReg >= 10 && this.selReg != 50 || this.bcd)) {
                    String a = Util.hex((byte)this.reg[this.selReg]);
                    b = Integer.parseInt(a);
                } else {
                    b = this.reg[this.selReg];
                }
                switch (this.selReg) {
                    case 0: {
                        this.secs = b;
                        break;
                    }
                    case 2: {
                        this.mins = b;
                        break;
                    }
                    case 4: {
                        this.hours = b;
                        break;
                    }
                    case 6: {
                        this.weekdays = b;
                        break;
                    }
                    case 7: {
                        this.days = b;
                        break;
                    }
                    case 8: {
                        this.months = b;
                        break;
                    }
                    case 9: {
                        this.years = b;
                        break;
                    }
                    case 50: {
                        this.mills = b;
                    }
                }
                this.selReg = 0;
                break;
            }
            case 64789: {
                this.selReg = value & 0x3F;
            }
        }
    }

    public int readPort(int port) {
        this.bcd = (this.reg[11] & 4) != 0;
        switch (port) {
            case 64784: {
                return 0;
            }
            case 64788: {
                return this.reg[this.selReg];
            }
        }
        return 255;
    }
}

