/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jemu.core.device.sound.AY_3_8910;
import jemu.core.device.sound.AudioFilter;
import jemu.core.device.sound.SoundUtil;
import jemu.core.device.sound.SunAudio;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.ui.Desktop;
import jemu.ui.Switches;

public class JavaSound
extends SunAudio {
    protected AudioFilter filter;
    public static int SAMPLE_RATE = 44100;
    protected static AudioFormat MONO_FORMAT;
    protected static AudioFormat STEREO_FORMAT;
    protected SourceDataLine line;
    public static byte[] data;
    protected int offset = 0;
    protected int channels;
    protected long startCount;
    protected int rate;

    public JavaSound(int samples, boolean stereo) {
        super(samples, stereo);
    }

    public int getSampleRate() {
        return SAMPLE_RATE;
    }

    public void init() {
        this.rate = Integer.parseInt(Settings.get("samplerate", "1"));
        SAMPLE_RATE = this.frequencies[this.rate];
        if (this.filter == null) {
            this.filter = new AudioFilter();
        }
        this.filter.setSampleRate(this.rate);
        System.out.println("Samplerate is " + SAMPLE_RATE + "hz");
        MONO_FORMAT = new AudioFormat(SAMPLE_RATE, 1, 1, false, false);
        STEREO_FORMAT = new AudioFormat(SAMPLE_RATE, 8, 2, false, true);
        this.format = 2;
        this.channels = this.stereo ? 2 : 1;
        data = new byte[this.samples * this.channels];
        AudioFormat fmt = this.stereo ? STEREO_FORMAT : MONO_FORMAT;
        try {
            if (this.line != null) {
                this.line.flush();
                this.line.close();
            }
            this.line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, fmt));
            this.line.open();
            System.out.println("Line for PSG AY started!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("JavaSound: " + this.samples + " x " + this.channels);
        System.out.println("Line Buffer: " + this.line.getBufferSize() + " for " + this.line.getClass());
        JavaSound.clear();
        this.resync();
    }

    public void resync() {
        int len;
        if (this.line == null) {
            this.reset();
        }
        if (CPC.disableresync && Switches.turbo == 1) {
            return;
        }
        this.line.flush();
        this.startCount = this.line.getLongFramePosition();
        for (int samp = SAMPLE_RATE / 10 * this.channels; samp > 0; samp -= len) {
            len = Math.min(data.length, samp);
            this.line.write(data, 0, len);
        }
        if (Switches.turbo > 1) {
            --Switches.turbo;
        } else {
            System.out.println("resync: start=" + this.startCount);
        }
    }

    public long getCount() {
        return this.line.getLongFramePosition() - this.startCount - 100L;
    }

    public long getDeviation() {
        return SAMPLE_RATE / 10;
    }

    public void play() {
        this.resync();
        this.line.start();
    }

    public void stop() {
        this.line.stop();
    }

    public void dispose() {
        this.line.close();
    }

    public void writeMono(int value) {
        switch (this.format) {
            case 0: {
                JavaSound.data[this.offset] = SoundUtil.ulawToUPCM8((byte)value);
                break;
            }
            case 2: {
                JavaSound.data[this.offset] = (byte)value;
            }
        }
        if (++this.offset == data.length) {
            this.line.write(data, 0, data.length);
            this.offset = 0;
        }
        ++this.updates;
    }

    public static void clear() {
        if (data == null) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            JavaSound.data[i] = -128;
        }
    }

    public void writeStereo(int a, int b) {
        if (AY_3_8910.digiblast) {
            a ^= 0x80;
            b ^= 0x80;
        }
        AudioFilter.highpass = AY_3_8910.Speaker;
        if (AudioFilter.highpass) {
            a = this.filter.HighpassFilterLeft(a);
            b = this.filter.HighpassFilterRight(b);
        } else if (AudioFilter.lowpass) {
            a = this.filter.LowpassFilterLeft(a);
            b = this.filter.LowpassFilterRight(b);
        }
        if (!AY_3_8910.digiblast) {
            a ^= 0x80;
            b ^= 0x80;
        }
        if (!CPC.relay && AY_3_8910.digiblast && AY_3_8910.Speaker) {
            a ^= 0x80;
            b ^= 0x80;
        }
        try {
            switch (this.format) {
                case 0: {
                    a = SoundUtil.ulawToUPCM8((byte)a);
                    b = SoundUtil.ulawToUPCM8((byte)b);
                    break;
                }
                case 1: {
                    a = SoundUtil.ulawToPCM8((byte)a);
                    b = SoundUtil.ulawToPCM8((byte)b);
                }
            }
            JavaSound.data[this.offset] = (byte)a;
            JavaSound.data[this.offset + 1] = (byte)b;
            if ((this.offset += 2) == data.length) {
                if (Desktop.cap != null) {
                    if (CPC.showAudioCapture && !Desktop.cap.isVisible()) {
                        Desktop.cap.showCapture();
                    }
                    if (!CPC.showAudioCapture && Desktop.cap.isVisible() && data != null) {
                        Desktop.cap.PaintBuffer(data);
                    }
                    if (CPC.showAudioCapture && Desktop.cap.isVisible()) {
                        Desktop.cap.setVisible(true);
                        CPC.showAudioCapture = false;
                    }
                }
                if (Desktop.cap != null && Desktop.cap.doCapture) {
                    Desktop.cap.Capture(data, data.length);
                }
                this.offset = 0;
                this.line.write(data, 0, data.length);
            }
            ++this.updates;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.offset = 0;
        }
    }
}

