/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.tape;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import jemu.core.device.tape.TapeInfo;
import jemu.core.device.tape.TapeWheels;
import jemu.core.samples.Samples;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Desktop;
import jemu.ui.Switches;

public class TapeDeck
extends JFrame
implements ActionListener,
MouseListener {
    public int resettime = 0;
    public static JPanel tapepanel;
    public String filename;
    public static JProgressBar position;
    protected String Counter;
    final URL cursorim = this.getClass().getResource("image/icon_finger.gif");
    final Image cursor = this.getToolkit().getImage(this.cursorim);
    Cursor finger;
    int pos;
    int stepper = 1;
    int updater = 6;
    int stoptimer;
    public int updatewheels;
    protected JPanel drivepanel;
    protected JPanel wheelpanel;
    protected JPanel infopanel;
    public static boolean newtape;
    public static boolean blanktape;
    protected int lastnumber;
    public int WAVBYTE = 0;
    private int update = 0;
    public static JMenuBar tapeblocks;
    public static JMenu drive;
    public static JMenu blocks;
    public static JScrollPane blockpane;
    public static JList blocklist;
    public static JMenu info;
    public JMenuItem play;
    public JMenuItem showinfo;
    public JMenuItem record;
    public JMenuItem rewind;
    public JMenuItem forward;
    public JMenuItem stop;
    public JMenuItem pause;
    public JMenuItem eject;
    public static JMenuItem savetape;
    public static JMenuItem tapeload;
    public int block = 0;
    TapeInfo tapeinfo = new TapeInfo();
    TapeWheels wheels = new TapeWheels();
    final URL tapeupe = this.getClass().getResource("image/upper_tape_e.png");
    final ImageIcon tapupe = new ImageIcon(this.tapeupe);
    final URL tapeup = this.getClass().getResource("image/upper_tape.png");
    final ImageIcon tapup = new ImageIcon(this.tapeup);
    final URL tapeupl = this.getClass().getResource("image/upper_ltape.png");
    final ImageIcon tapupl = new ImageIcon(this.tapeupl);
    final URL tapeupr = this.getClass().getResource("image/upper_rtape.png");
    final ImageIcon tapupr = new ImageIcon(this.tapeupr);
    final URL tapelefte = this.getClass().getResource("image/left_tape_e.png");
    final ImageIcon taplefte = new ImageIcon(this.tapelefte);
    final URL tapeleft = this.getClass().getResource("image/left_tape.png");
    final ImageIcon tapleft = new ImageIcon(this.tapeleft);
    final URL[] twheel = new URL[5];
    final ImageIcon[] wheel = new ImageIcon[5];
    final URL taperighte = this.getClass().getResource("image/right_tape_e.png");
    final ImageIcon taprighte = new ImageIcon(this.taperighte);
    final URL taperight = this.getClass().getResource("image/right_tape.png");
    final ImageIcon tapright = new ImageIcon(this.taperight);
    final URL tapelowe = this.getClass().getResource("image/lower_tape_e.png");
    final ImageIcon taplowe = new ImageIcon(this.tapelowe);
    final URL tapelow = this.getClass().getResource("image/lower_tape.png");
    final ImageIcon taplow = new ImageIcon(this.tapelow);
    final URL recb = this.getClass().getResource("image/but_rec.png");
    final ImageIcon recbu = new ImageIcon(this.recb);
    final URL rewb = this.getClass().getResource("image/but_rew.png");
    final ImageIcon rewbu = new ImageIcon(this.rewb);
    final URL ffb = this.getClass().getResource("image/but_ff.png");
    final ImageIcon ffbu = new ImageIcon(this.ffb);
    final URL playb = this.getClass().getResource("image/but_play.png");
    final ImageIcon playbu = new ImageIcon(this.playb);
    final URL stopb = this.getClass().getResource("image/but_stop.png");
    final ImageIcon stopbu = new ImageIcon(this.stopb);
    final URL pauseb = this.getClass().getResource("image/but_pause.png");
    final ImageIcon pausebu = new ImageIcon(this.pauseb);
    final URL recbp = this.getClass().getResource("image/but_rec_p.png");
    final ImageIcon recbup = new ImageIcon(this.recbp);
    final URL rewbp = this.getClass().getResource("image/but_rew_p.png");
    final ImageIcon rewbup = new ImageIcon(this.rewbp);
    final URL ffbp = this.getClass().getResource("image/but_ff_p.png");
    final ImageIcon ffbup = new ImageIcon(this.ffbp);
    final URL playbp = this.getClass().getResource("image/but_play_p.png");
    final ImageIcon playbup = new ImageIcon(this.playbp);
    final URL stopbp = this.getClass().getResource("image/but_stop_p.png");
    final ImageIcon stopbup = new ImageIcon(this.stopbp);
    final URL pausebp = this.getClass().getResource("image/but_pause_p.png");
    final ImageIcon pausebup = new ImageIcon(this.pausebp);
    final JLabel tup = new JLabel(this.tapup);
    final JLabel tupl = new JLabel(this.tapupl);
    final JLabel tupr = new JLabel(this.tapupr);
    final JLabel tleft = new JLabel(this.tapleft);
    JLabel wleft;
    JLabel wright;
    final JLabel tright = new JLabel(this.tapright);
    final JLabel tlow = new JLabel(this.taplow);
    public static Color CPCGRAY;
    public boolean buttonpressed;
    public static boolean isMem;
    public boolean paused;
    public boolean played;
    public boolean recorded = false;
    protected boolean playing = false;
    public JButton btnREC = new JButton(this.recbu);
    public JButton btnREW = new JButton(this.rewbu);
    public JButton btnPLAY = new JButton(this.playbu);
    public JButton btnFF = new JButton(this.ffbu);
    public JButton btnStart = new JButton("\u25ba");
    public JButton btnStop = new JButton("\u25a0");
    JButton btnSTOP = new JButton(this.stopbu);
    JButton btnPAUSE = new JButton(this.pausebu);
    JButton reset = new JButton(" ");
    JLabel blanker = new JLabel("              ");
    JLabel blanker2 = new JLabel("     ");
    public static int counter;
    public static String before;
    public static JTextField TapeCounter;
    public static JTextField TapeMemory;
    public JToggleButton memory = new JToggleButton("Mem");
    public static int memCount;
    int paintthis = 0;
    boolean hastape = false;
    int skin = 0;
    public boolean started = false;
    ActionListener updateTape = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            TapeDeck.this.checkTape();
            TapeDeck.this.paintWheels();
            TapeDeck.this.started = true;
        }
    };
    public Timer Updater = new Timer(10, this.updateTape);

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.setPos(blocklist.getSelectedIndex());
        blocks.setPopupMenuVisible(false);
        blocks.setSelected(false);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public static void main(String[] args) {
        TapeDeck deck = new TapeDeck();
        deck.setVisible(true);
        deck.Updater.start();
    }

    public void windowClosing(WindowEvent e) {
        CPC.tapedeck = false;
        this.setVisible(false);
    }

    public void windowClosed(WindowEvent e) {
        CPC.tapedeck = false;
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public TapeDeck() {
        position = new JProgressBar();
        position.setIndeterminate(false);
        position.setPreferredSize(new Dimension(247, 12));
        tapepanel = new JPanel();
        tapepanel.setBackground(Color.black);
        this.Counter = "0000";
        this.filename = "No tape inserted...";
        for (int i = 0; i < 4; ++i) {
            this.twheel[i] = this.getClass().getResource("image/wheel" + i + ".png");
            this.wheel[i] = new ImageIcon(this.twheel[i]);
        }
        this.twheel[4] = this.getClass().getResource("image/wheel_e.png");
        this.wheel[4] = new ImageIcon(this.twheel[4]);
        Samples.volume = Samples.Volume.HIGH;
        tapepanel.setLayout(new FlowLayout(1, 6, 4));
        this.btnREW.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TapeDeck.this.pressRew();
            }
        });
        this.btnPLAY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TapeDeck.this.pressPlay();
            }
        });
        this.btnREC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TapeDeck.this.pressRec(false);
            }
        });
        this.btnFF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TapeDeck.this.pressFwd();
            }
        });
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GateArray.cpc.startTapeMotor();
            }
        });
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GateArray.cpc.stopTapeMotor();
            }
        });
        this.btnSTOP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TapeDeck.this.pressStop();
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TapeDeck.this.showText();
                counter = 0;
                before = "000";
                TapeCounter.setText(before + counter);
                CPC.tape_band_pos = 0;
            }
        });
        this.btnPAUSE.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TapeDeck.this.pressPause();
            }
        });
        this.memory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String first = "";
                if (!isMem) {
                    TapeDeck.this.memory.setSelected(true);
                    TapeDeck.this.memory.setBackground(Color.GREEN);
                    TapeMemory.setForeground(Color.WHITE);
                    TapeMemory.setBackground(Color.GRAY);
                    isMem = true;
                    memCount = counter;
                    if (memCount < 10) {
                        first = "000";
                    } else if (memCount < 100) {
                        first = "00";
                    } else if (memCount < 1000) {
                        first = "0";
                    }
                    TapeMemory.setText(first + memCount);
                } else {
                    isMem = false;
                    TapeDeck.this.memory.setSelected(false);
                    TapeDeck.this.memory.setBackground(new Color(192, 192, 192));
                    TapeMemory.setBackground(Color.BLACK);
                    TapeMemory.setForeground(Color.BLACK);
                    TapeMemory.setText("000");
                }
            }
        });
        tapepanel.add(TapeCounter);
        tapepanel.add(this.reset);
        tapepanel.add(this.blanker);
        tapepanel.add(this.btnStart);
        tapepanel.add(this.btnStop);
        tapepanel.add(this.blanker2);
        tapepanel.add(this.memory);
        tapepanel.add(TapeMemory);
        this.wleft = new JLabel(this.wheel[0]);
        this.wright = new JLabel(this.wheel[0]);
        this.drivepanel = new JPanel();
        this.wheelpanel = new JPanel();
        this.infopanel = new JPanel();
        this.drivepanel.setLayout(new BorderLayout());
        this.wheelpanel.setLayout(new FlowLayout(0, 0, 0));
        this.infopanel.setLayout(new BorderLayout());
        this.infopanel.add((Component)this.tup, "North");
        this.infopanel.add((Component)this.tupl, "West");
        this.infopanel.add((Component)this.tapeinfo, "Center");
        this.infopanel.add((Component)this.tupr, "East");
        this.infopanel.setBorder(null);
        this.tleft.setBorder(null);
        this.wleft.setBorder(null);
        this.wheels.setBorder(null);
        this.wheelpanel.setBorder(null);
        this.tright.setBorder(null);
        this.wright.setBorder(null);
        this.tlow.setBorder(null);
        this.tapeinfo.setBorder(null);
        this.tup.setBorder(null);
        this.tupl.setBorder(null);
        this.tupr.setBorder(null);
        this.drivepanel.add((Component)this.infopanel, "North");
        this.drivepanel.add((Component)this.tleft, "West");
        this.wheelpanel.add((Component)this.wleft, "West");
        this.wheelpanel.add((Component)this.wheels, "Center");
        this.wheelpanel.add((Component)this.wright, "East");
        this.drivepanel.add((Component)this.wheelpanel, "Center");
        this.drivepanel.add((Component)this.tright, "East");
        this.drivepanel.add((Component)this.tlow, "South");
        this.drivepanel.setDoubleBuffered(false);
        tapepanel.add(this.drivepanel);
        this.finger = Toolkit.getDefaultToolkit().createCustomCursor(this.cursor, new Point(7, 2), "gunCursor");
        this.reset.setCursor(this.finger);
        this.memory.setCursor(this.finger);
        this.btnREC.setCursor(this.finger);
        this.btnPLAY.setCursor(this.finger);
        this.btnREW.setCursor(this.finger);
        this.btnFF.setCursor(this.finger);
        this.btnSTOP.setCursor(this.finger);
        this.btnPAUSE.setCursor(this.finger);
        this.btnStart.setCursor(this.finger);
        this.btnStop.setCursor(this.finger);
        tapepanel.add(this.btnREC);
        tapepanel.add(this.btnPLAY);
        tapepanel.add(this.btnREW);
        tapepanel.add(this.btnFF);
        tapepanel.add(this.btnSTOP);
        tapepanel.add(this.btnPAUSE);
        tapepanel.add(position);
        drive = new JMenu("Drive");
        blocks = new JMenu("Blocks");
        blockpane = new JScrollPane();
        blocklist = new JList();
        blocklist.setBorder(null);
        blockpane.setBorder(null);
        blockpane.setViewportView(blocklist);
        blockpane.setPreferredSize(new Dimension(150, 400));
        blocklist.addMouseListener(this);
        blocks.add(blockpane);
        info = new JMenu("Info");
        this.showinfo = new JMenuItem("Show info");
        this.showinfo.addActionListener(this);
        this.play = new JMenuItem("Press Play");
        this.play.addActionListener(this);
        this.record = new JMenuItem("Press Rec & Play");
        this.record.addActionListener(this);
        this.rewind = new JMenuItem("Press Rewind");
        this.rewind.addActionListener(this);
        this.forward = new JMenuItem("Press Fast Forward");
        this.forward.addActionListener(this);
        this.stop = new JMenuItem("Press Stop/Eject");
        this.stop.addActionListener(this);
        this.pause = new JMenuItem("Press Pause");
        this.pause.addActionListener(this);
        this.eject = new JMenuItem("Eject Tape");
        this.eject.addActionListener(this);
        savetape = new JMenuItem("Save WAV-tape");
        savetape.addActionListener(this);
        savetape.setEnabled(false);
        tapeload = new JMenuItem("Load tape-file");
        tapeload.addActionListener(this);
        tapeload.setEnabled(true);
        drive.add(tapeload);
        drive.addSeparator();
        drive.add(this.play);
        drive.add(this.record);
        drive.add(this.rewind);
        drive.add(this.forward);
        drive.add(this.stop);
        drive.add(this.pause);
        drive.add(this.eject);
        drive.addSeparator();
        drive.add(savetape);
        drive.addActionListener(this);
        info.add(this.showinfo);
        info.addActionListener(this);
        tapeblocks.add(drive);
        tapeblocks.add(blocks);
        tapeblocks.add(info);
        this.btnREW.setBorder(new BevelBorder(0));
        this.btnREW.setFocusable(false);
        this.btnREW.setBackground(Color.DARK_GRAY);
        this.btnREW.setForeground(Color.WHITE);
        this.memory.setFocusable(false);
        this.memory.setBackground(Color.DARK_GRAY);
        TapeMemory.setBorder(new BevelBorder(1));
        TapeMemory.setFocusable(false);
        TapeMemory.setBackground(Color.BLACK);
        TapeMemory.setForeground(Color.BLACK);
        TapeMemory.setEditable(false);
        this.btnPLAY.setBorder(new BevelBorder(0));
        this.btnREW.setFocusable(false);
        this.btnFF.setBorder(new BevelBorder(0));
        this.btnSTOP.setBorder(new BevelBorder(0));
        this.btnStart.setBorder(new BevelBorder(0));
        this.btnStop.setBorder(new BevelBorder(0));
        this.btnPAUSE.setBorder(new BevelBorder(0));
        TapeCounter.setBorder(new BevelBorder(1));
        this.reset.setBorder(new BevelBorder(0));
        this.btnREC.setBorder(new BevelBorder(0));
        this.btnPLAY.setFocusable(false);
        this.btnFF.setFocusable(false);
        this.btnSTOP.setFocusable(false);
        this.btnPAUSE.setFocusable(false);
        this.btnStart.setFocusable(false);
        this.btnStop.setFocusable(false);
        this.reset.setFocusable(false);
        TapeCounter.setFocusable(false);
        TapeCounter.setEditable(false);
        TapeCounter.setFont(new Font("Monospaced", 0, 12));
        TapeCounter.setDoubleBuffered(false);
        this.btnREC.setBackground(new Color(255, 0, 0));
        this.btnPLAY.setBackground(Color.DARK_GRAY);
        this.btnFF.setBackground(Color.DARK_GRAY);
        this.btnSTOP.setBackground(Color.DARK_GRAY);
        this.btnPAUSE.setBackground(Color.DARK_GRAY);
        this.reset.setBackground(Color.DARK_GRAY);
        this.btnREC.setForeground(Color.WHITE);
        this.btnPLAY.setForeground(Color.WHITE);
        this.btnFF.setForeground(Color.WHITE);
        this.btnSTOP.setForeground(Color.WHITE);
        this.btnPAUSE.setForeground(Color.WHITE);
        TapeCounter.setBackground(Color.DARK_GRAY);
        TapeCounter.setForeground(Color.WHITE);
        this.reset.setForeground(Color.LIGHT_GRAY);
        tapepanel.setForeground(Color.LIGHT_GRAY);
        tapepanel.setBackground(Color.BLACK);
        this.add(tapepanel);
        this.setTitle("TapeDeck");
        this.pack();
        this.setSize(272, 384);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        blocks.setEnabled(false);
    }

    public void setName(String text) {
        this.filename = text;
    }

    public void showText(String text) {
    }

    public void showText() {
    }

    public void paintWheels() {
        if (blocklist.isShowing()) {
            return;
        }
        if (CPC.tapesample != null) {
            if (position.getMaximum() != CPC.tapesample.length) {
                position.setMaximum(CPC.tapesample.length);
            }
            position.setValue(CPC.tape_band_pos);
            if (CPC.rec) {
                position.setIndeterminate(true);
            } else {
                position.setIndeterminate(false);
            }
        }
        if (this.stoptimer != 0) {
            ++this.stoptimer;
            if (this.stoptimer == 10) {
                this.stoptimer = 0;
                this.btnSTOP.setIcon(this.stopbu);
            }
        }
        ++this.paintthis;
        if (this.paintthis > 20) {
            this.paintthis = 0;
            this.doPaint();
        }
        ++this.updatewheels;
        if (this.updatewheels > this.updater) {
            this.setWheels();
            this.updatewheels = 0;
        }
    }

    public void doPaint() {
        try {
            if (!tapeload.isShowing() && !this.showinfo.isShowing()) {
                this.wheels.paintWheels();
                this.tapeinfo.paintInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkTape() {
        boolean bl = this.hastape = CPC.tapesample != null;
        if (!this.hastape && this.skin == 0) {
            this.skin = 1;
            this.tup.setIcon(this.tapupe);
            this.tleft.setIcon(this.taplefte);
            this.tright.setIcon(this.taprighte);
            this.tlow.setIcon(this.taplowe);
            this.tupl.setVisible(false);
            this.tupr.setVisible(false);
            this.tapeinfo.setVisible(false);
            this.setSize(270, 374);
            this.setSize(272, 374);
            this.doPaint();
        }
        if (this.hastape && this.skin == 1) {
            this.skin = 0;
            this.tup.setIcon(this.tapup);
            this.tleft.setIcon(this.tapleft);
            this.tright.setIcon(this.tapright);
            this.tlow.setIcon(this.taplow);
            this.tupl.setVisible(true);
            this.tupr.setVisible(true);
            this.tapeinfo.setVisible(true);
            this.setSize(270, 374);
            this.setSize(272, 374);
            this.doPaint();
        }
    }

    public void setWheels() {
        int pos2;
        if (!this.hastape) {
            this.wleft.setIcon(this.wheel[4]);
            this.wright.setIcon(this.wheel[4]);
            return;
        }
        if (CPC.playing && (CPC.relay || CPC.trueaudio) && !this.paused && (CPC.rec || CPC.play) || CPC.rew || CPC.ffwd) {
            this.pos += this.stepper;
        }
        if (this.pos >= 4 || this.pos <= -4) {
            this.pos = 0;
        }
        switch (this.pos) {
            case -1: {
                pos2 = 3;
                break;
            }
            case -2: {
                pos2 = 2;
                break;
            }
            case -3: {
                pos2 = 1;
                break;
            }
            default: {
                pos2 = this.pos;
            }
        }
        this.wleft.setIcon(this.wheel[pos2]);
        this.wright.setIcon(this.wheel[pos2]);
    }

    public void setPos(int i) {
        try {
            CPC.tape_band_pos = CPC.blocks[i];
            TapeCounter.setText(CPC.getCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == savetape) {
            CPC.savetape = true;
        }
        if (e.getSource() == tapeload) {
            CPC.tapeload = true;
        }
        if (e.getSource() == this.play) {
            this.pressPlay();
        }
        if (e.getSource() == this.record) {
            this.pressRec(false);
        }
        if (e.getSource() == this.rewind) {
            this.pressRew();
        }
        if (e.getSource() == this.forward) {
            this.pressFwd();
        }
        if (e.getSource() == this.stop) {
            this.pressStop();
        }
        if (e.getSource() == this.pause) {
            this.pressPause();
        }
        if (e.getSource() == this.eject) {
            this.pressEject();
        }
        if (e.getSource() == this.showinfo) {
            this.showInfo();
        }
    }

    public void pressPlay() {
        this.showText();
        this.buttonpressed = true;
        if (!CPC.rec) {
            this.stepper = 1;
            this.updater = 6;
            blanktape = false;
            if (Switches.FloppySound && (CPC.ffwd || CPC.rew)) {
                Samples.TAPESTOP.play();
            }
            this.playing = true;
            CPC.rec = false;
            CPC.play = true;
            CPC.rew = false;
            CPC.ffwd = false;
            if (Switches.FloppySound) {
                Samples.TAPEKEY.play();
                Samples.WINDMOTOR.stop();
                Samples.REWINDMOTOR.stop();
                if (CPC.relay) {
                    Samples.TAPEMOTOR.loop();
                }
            }
            this.btnREW.setIcon(this.rewbu);
            this.btnFF.setIcon(this.ffbu);
            this.btnPLAY.setIcon(this.playbup);
            this.btnSTOP.setIcon(this.stopbu);
            this.btnREC.setIcon(this.recbu);
            this.btnREW.setBorder(new BevelBorder(0));
            this.btnPLAY.setBorder(new BevelBorder(1));
            this.btnPLAY.setBackground(Color.BLACK);
            this.btnFF.setBorder(new BevelBorder(0));
            this.btnSTOP.setBorder(new BevelBorder(0));
            this.btnREC.setBorder(new BevelBorder(0));
            this.btnREC.setBackground(new Color(255, 0, 0));
            this.btnREW.setBackground(Color.DARK_GRAY);
            this.btnFF.setBackground(Color.DARK_GRAY);
            this.btnREC.setForeground(Color.WHITE);
            this.btnREW.setForeground(Color.WHITE);
            this.btnPLAY.setForeground(Color.LIGHT_GRAY);
            this.btnFF.setForeground(Color.WHITE);
        }
    }

    public void pressRec(boolean pause) {
        this.tapeinfo.setInfo("My tape - not saved yet!!!", false);
        this.setName("Blank tape inserted...");
        this.buttonpressed = true;
        if (!this.playing) {
            this.stepper = 1;
            this.updater = 6;
            blanktape = true;
            newtape = true;
            this.showText(this.filename);
            CPC.tapeloaded = true;
            TapeCounter.setText("0000");
            CPC.tapesample = null;
            CPC.tape_stereo = false;
            if ((int)Switches.availmem > 110000000) {
                Switches.availmem = 110000000L;
            }
            try {
                CPC.tapesample = new byte[(int)Switches.availmem];
                for (int i = 0; i < CPC.tapesample.length; ++i) {
                    CPC.tapesample[i] = -128;
                }
                System.out.println(Switches.availmem);
            }
            catch (Exception tooLarge) {
                tooLarge.printStackTrace();
                System.exit(0);
            }
            this.buildTapeBlocks();
            if (!pause) {
                CPC.tape_band_pos = 0;
                CPC.recordcount = 0;
            } else {
                CPC.tape_band_pos = 200000;
                CPC.recordcount = 200000;
            }
            if (Switches.khz44) {
                CPC.tape_delay = 22;
            }
            if (Switches.khz11) {
                CPC.tape_delay = 90;
            }
            if (!Switches.khz11 && !Switches.khz44) {
                CPC.tape_delay = 45;
            }
            CPC.rec = true;
            CPC.play = true;
            CPC.rew = false;
            CPC.ffwd = false;
            this.playing = false;
            if (Switches.FloppySound) {
                Samples.TAPEKEY.play();
                Samples.WINDMOTOR.stop();
                Samples.REWINDMOTOR.stop();
                if (CPC.relay) {
                    Samples.TAPEMOTOR.loop();
                }
            }
            this.btnREW.setIcon(this.rewbu);
            this.btnFF.setIcon(this.ffbu);
            this.btnPLAY.setIcon(this.playbup);
            this.btnSTOP.setIcon(this.stopbu);
            this.btnREC.setIcon(this.recbup);
            this.btnREW.setBorder(new BevelBorder(0));
            this.btnPLAY.setBorder(new BevelBorder(1));
            this.btnFF.setBorder(new BevelBorder(0));
            this.btnSTOP.setBorder(new BevelBorder(0));
            this.btnREC.setBorder(new BevelBorder(1));
            this.btnREC.setBackground(Color.BLACK);
            this.btnREW.setBackground(Color.DARK_GRAY);
            this.btnPLAY.setBackground(Color.BLACK);
            this.btnFF.setBackground(Color.DARK_GRAY);
            this.btnREC.setForeground(Color.LIGHT_GRAY);
            this.btnREW.setForeground(Color.WHITE);
            this.btnPLAY.setForeground(Color.LIGHT_GRAY);
            this.btnFF.setForeground(Color.WHITE);
        }
    }

    public void pressRew() {
        this.showText();
        this.buttonpressed = true;
        if (!CPC.rec) {
            this.stepper = -1;
            this.updater = 1;
            blanktape = false;
            if (Switches.FloppySound && CPC.ffwd) {
                Samples.TAPESTOP.play();
            }
            CPC.rec = false;
            CPC.rew = true;
            CPC.ffwd = false;
            this.playing = false;
            this.btnREW.setIcon(this.rewbup);
            this.btnFF.setIcon(this.ffbu);
            this.btnSTOP.setIcon(this.stopbu);
            this.btnREC.setIcon(this.recbu);
            this.btnREC.setForeground(Color.WHITE);
            this.btnREW.setForeground(Color.LIGHT_GRAY);
            this.btnFF.setForeground(Color.WHITE);
            this.btnREW.setBorder(new BevelBorder(1));
            if (!CPC.play) {
                this.btnPLAY.setBorder(new BevelBorder(0));
                this.btnPLAY.setBackground(Color.DARK_GRAY);
            }
            this.btnFF.setBorder(new BevelBorder(0));
            this.btnSTOP.setBorder(new BevelBorder(0));
            this.btnREW.setBackground(Color.BLACK);
            this.btnFF.setBackground(Color.DARK_GRAY);
            if (Switches.FloppySound) {
                Samples.TAPEKEY.play();
                Samples.WINDMOTOR.stop();
                Samples.REWINDMOTOR.loop();
                Samples.TAPEMOTOR.stop();
            }
        }
    }

    public void pressFwd() {
        this.showText();
        this.buttonpressed = true;
        if (!CPC.rec) {
            this.stepper = 1;
            this.updater = 1;
            blanktape = false;
            if (Switches.FloppySound && CPC.rew) {
                Samples.TAPESTOP.play();
            }
            CPC.rec = false;
            CPC.rew = false;
            CPC.ffwd = true;
            this.playing = false;
            if (Switches.FloppySound) {
                Samples.TAPEKEY.play();
                Samples.WINDMOTOR.loop();
                Samples.REWINDMOTOR.stop();
                Samples.TAPEMOTOR.stop();
            }
            this.btnREW.setBorder(new BevelBorder(0));
            if (!CPC.play) {
                this.btnPLAY.setBackground(Color.DARK_GRAY);
                this.btnPLAY.setBorder(new BevelBorder(0));
            }
            this.btnREW.setIcon(this.rewbu);
            this.btnFF.setIcon(this.ffbup);
            this.btnSTOP.setIcon(this.stopbu);
            this.btnREC.setIcon(this.recbu);
            this.btnFF.setBorder(new BevelBorder(1));
            this.btnSTOP.setBorder(new BevelBorder(0));
            this.btnREC.setBorder(new BevelBorder(0));
            this.btnREC.setBackground(new Color(255, 0, 0));
            this.btnREW.setBackground(Color.DARK_GRAY);
            this.btnFF.setBackground(Color.BLACK);
            this.btnREC.setForeground(Color.WHITE);
            this.btnREW.setForeground(Color.WHITE);
            this.btnFF.setForeground(Color.LIGHT_GRAY);
        }
    }

    public void pressStop() {
        if (!CPC.tapeloaded) {
            if (!newtape) {
                CPC.tapeload = true;
                return;
            }
            if (CPC.recordcount < 100) {
                CPC.tapeload = true;
                return;
            }
        }
        CPC.rec = false;
        blanktape = false;
        if (CPC.tapesample == null) {
            this.setName("No tape inserted...");
        }
        this.btnSTOP.setIcon(this.stopbup);
        this.stoptimer = 1;
        this.showText();
        GateArray.cpc.restoreScreen();
        this.rebuildBlocks(CPC.tape_band_pos);
        this.stepper = 1;
        this.updater = 6;
        if (!this.buttonpressed) {
            Object[] options;
            int n;
            if (newtape && CPC.recordcount > 100 && (n = JOptionPane.showOptionDialog(this, "Your WAV is not saved!\nDo you want to save it now?", "Save your tape?", 0, 2, null, options = new Object[]{"Yes", "No"}, options[0])) != 1) {
                CPC.savetape = true;
                return;
            }
            Desktop.checkdrives = true;
            CPC.tapesample = null;
            newtape = false;
            this.setInfo("", true);
            this.setName("No tape inserted...");
            Settings.set("tapelabel", "");
            Settings.set("file.tape", "~none~");
            Settings.setBoolean("loadtape", false);
            this.showText();
            CPC.tapeloaded = false;
            TapeCounter.setText("0000");
            this.Counter = "0000";
            CPC.tape_band_pos = 0;
            CPC.ids = null;
            CPC.blocks = null;
            this.buildTapeBlocks();
            if (Switches.FloppySound) {
                Samples.TAPEEJECT.play();
            }
            this.doPaint();
            this.setWheels();
            this.checkTape();
            this.paintWheels();
            this.skin = 1;
            this.tup.setIcon(this.tapupe);
            this.tleft.setIcon(this.taplefte);
            this.tright.setIcon(this.taprighte);
            this.tlow.setIcon(this.taplowe);
            this.tupl.setVisible(false);
            this.tupr.setVisible(false);
            this.tapeinfo.setVisible(false);
            this.setSize(270, 374);
            this.setSize(272, 374);
            tapepanel.repaint();
        }
        CPC.rec = false;
        CPC.play = false;
        CPC.rew = false;
        CPC.ffwd = false;
        this.buttonpressed = false;
        this.playing = false;
        if (Switches.FloppySound) {
            Samples.TAPESTOP.play();
            Samples.WINDMOTOR.stop();
            Samples.REWINDMOTOR.stop();
            Samples.TAPEMOTOR.stop();
        }
        this.btnREW.setIcon(this.rewbu);
        this.btnFF.setIcon(this.ffbu);
        this.btnPLAY.setIcon(this.playbu);
        this.btnREC.setIcon(this.recbu);
        this.btnREW.setBorder(new BevelBorder(0));
        this.btnPLAY.setBorder(new BevelBorder(0));
        this.btnFF.setBorder(new BevelBorder(0));
        this.btnSTOP.setBorder(new BevelBorder(0));
        this.btnREC.setBorder(new BevelBorder(0));
        this.btnREC.setBackground(new Color(255, 0, 0));
        this.btnREW.setBackground(Color.DARK_GRAY);
        this.btnPLAY.setBackground(Color.DARK_GRAY);
        this.btnFF.setBackground(Color.DARK_GRAY);
        this.btnREC.setForeground(Color.WHITE);
        this.btnREW.setForeground(Color.WHITE);
        this.btnPLAY.setForeground(Color.WHITE);
        this.btnFF.setForeground(Color.WHITE);
    }

    public void pressPause() {
        this.showText();
        if (Switches.FloppySound) {
            Samples.TAPEKEY.play();
        }
        if (this.paused) {
            this.btnPAUSE.setIcon(this.pausebu);
            this.btnPAUSE.setBackground(Color.DARK_GRAY);
            this.paused = false;
            if (CPC.play || CPC.rec) {
                this.stepper = 1;
            }
        } else {
            this.btnPAUSE.setIcon(this.pausebup);
            this.btnPAUSE.setBackground(Color.BLACK);
            this.paused = true;
            this.stepper = 1;
        }
    }

    public void pressEject() {
        Settings.set("tapelabel", "");
        System.out.println("Tape ejected");
        this.pressStop();
        this.pressStop();
        this.buildTapeBlocks();
    }

    public String getCounter(int pos) {
        int ccounter = 0;
        try {
            ccounter = CPC.blocks[pos] / (2045000 / (byte)CPC.tape_delay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String before = "";
        if (ccounter <= 9999) {
            before = "";
        }
        if (ccounter <= 999) {
            before = "0";
        }
        if (ccounter <= 99) {
            before = "00";
        }
        if (ccounter <= 9) {
            before = "000";
        }
        return before + ccounter;
    }

    public void buildTapeBlocks() {
        savetape.setEnabled(false);
        String foundblocks = "";
        try {
            if (CPC.ids != null) {
                blocks.setEnabled(true);
                for (int i = 0; i < CPC.ids.length; ++i) {
                    String ccounter = this.getCounter(i);
                    foundblocks = foundblocks + ccounter + ": " + CPC.ids[i] + "#";
                }
            } else {
                if (CPC.tapesample != null) {
                    String ccounter = this.getCounter(0);
                    foundblocks = foundblocks + ccounter + ": " + CPC.ids[0] + "#";
                }
                blocks.setEnabled(true);
            }
            final String[] bl = foundblocks.split("#");
            blocklist.setModel(new AbstractListModel(){

                public int getSize() {
                    return bl.length;
                }

                public Object getElementAt(int i) {
                    return bl[i];
                }
            });
        }
        catch (Exception e) {
            blocks.setEnabled(false);
        }
        if (CPC.tapesample != null) {
            savetape.setEnabled(true);
        }
    }

    public void rebuildBlocks(int value) {
        if (CPC.ids == null) {
            return;
        }
        for (int i = 1; i < CPC.ids.length; ++i) {
            try {
                if (CPC.blocks[i] <= value) continue;
                blocklist.setSelectedIndex(i - 1);
            }
            catch (Exception e) {}
            break;
        }
    }

    public void setInfo(String s, boolean store) {
        this.tapeinfo.setInfo(s, store);
    }

    public void showInfo() {
        System.out.println("info here");
    }

    public String getCounter() {
        return this.Counter;
    }

    static {
        newtape = false;
        blanktape = false;
        tapeblocks = new JMenuBar();
        CPCGRAY = new Color(55, 55, 55);
        counter = 0;
        before = "000";
        TapeCounter = new JTextField(before + counter);
        TapeMemory = new JTextField("0000");
        memCount = 0;
    }
}

