/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.tape;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.swing.JPanel;
import jemu.settings.Settings;

public class TapeInfo
extends JPanel {
    BufferedImage panel = new BufferedImage(152, 26, 1);
    private final int CANVAS_WIDTH = 152;
    private final int CANVAS_HEIGHT = 26;
    private Color back;
    private Color text;
    public String Info;
    private Font font;
    private int center = 16;
    Graphics page = this.panel.getGraphics();

    public TapeInfo() {
        this.back = new Color(0xE8E8E8);
        this.text = new Color(1381735);
        this.setInfo(Settings.get("tapelabel", ""), false);
        this.setBackground(this.back);
        this.setForeground(this.text);
        this.setSize(152, 26);
        this.setPreferredSize(new Dimension(152, 26));
    }

    public void setInfo(String s, boolean store) {
        this.Info = s;
        while (this.Info.contains("  ")) {
            this.Info = this.Info.replace("  ", " ");
        }
        if (this.Info.length() < 1) {
            return;
        }
        char d = this.Info.charAt(0);
        if (d >= '0' && d <= '9' && this.Info.contains(" ")) {
            while (!this.Info.startsWith(" ")) {
                this.Info = this.Info.substring(1);
            }
            this.Info = this.Info.substring(1);
        }
        if (((d = this.Info.charAt(0)) <= '@' || d == '-') && this.Info.contains(" ")) {
            while (!this.Info.startsWith(" ")) {
                this.Info = this.Info.substring(1);
            }
            this.Info = this.Info.substring(1);
        }
        if ((d = this.Info.charAt(0)) >= '0' && d <= '9' && this.Info.contains(" ")) {
            while (!this.Info.startsWith(" ")) {
                this.Info = this.Info.substring(1);
            }
            this.Info = this.Info.substring(1);
        }
        if (((d = this.Info.charAt(0)) <= '@' || d == '-') && this.Info.contains(" ")) {
            while (!this.Info.startsWith(" ")) {
                this.Info = this.Info.substring(1);
            }
            this.Info = this.Info.substring(1);
        }
        boolean ignore = false;
        String newInfo = "";
        String reInfo = "";
        for (int i = 0; i < this.Info.length(); ++i) {
            newInfo = "" + this.Info.charAt(i);
            ignore = i > 0 && this.Info.charAt(i - 1) == ' ' || i == 0;
            newInfo = !ignore ? newInfo.toLowerCase() : newInfo.toUpperCase();
            reInfo = reInfo + newInfo;
        }
        if (reInfo.contains(" (")) {
            while (reInfo.contains("(")) {
                reInfo = reInfo.substring(0, reInfo.length() - 1);
            }
            reInfo = reInfo.replace(" (", "");
        }
        this.Info = reInfo;
        System.out.println("Setting tapelabel:" + this.Info);
        Settings.set("tapelabel", this.Info);
        InputStream in = this.getClass().getResourceAsStream("image/SF-Heather.ttf");
        try {
            this.font = this.Info.length() < 10 ? Font.createFont(0, in).deriveFont(0, 18.0f) : (this.Info.length() < 15 ? Font.createFont(0, in).deriveFont(0, 16.0f) : (this.Info.length() < 18 ? Font.createFont(0, in).deriveFont(0, 14.0f) : (this.Info.length() < 22 ? Font.createFont(0, in).deriveFont(0, 13.0f) : (this.Info.length() < 25 ? Font.createFont(0, in).deriveFont(0, 12.0f) : (this.Info.length() < 30 ? Font.createFont(0, in).deriveFont(0, 11.0f) : Font.createFont(0, in).deriveFont(0, 9.0f))))));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.font = new Font("Arial", 3, 12);
        }
        this.page.setFont(this.font);
    }

    public void paintInfo() {
        if (this.Info == null || this.Info.length() < 1) {
            return;
        }
        this.page.setFont(this.font);
        Graphics p = this.getGraphics();
        this.page.setColor(this.back);
        this.page.fillRect(0, 0, 152, 26);
        this.page.setColor(this.text);
        this.page.drawString(this.Info, 0, this.center);
        p.drawImage(this.panel, 0, 0, this);
    }
}

