/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import jemu.core.device.Device;
import jemu.core.device.floppy.DiscImage;
import jemu.core.device.floppy.UPD765A;
import jemu.core.samples.Samples;
import jemu.system.cpc.CPCDiscImageSector;
import jemu.system.cpc.CPCDiscImageTrack;
import jemu.ui.Display;
import jemu.ui.Switches;

public class CPCDiscImage
extends DiscImage {
    protected boolean DEBUG = false;
    private static String SAVED_DSK = "";
    private static final String WIN_APE_EYECATCHER = "Win APE 32 1.0";
    private static final String MV_CPC_EYECATCHER = "MV - CPC";
    private static final String EXTENDED_EYECATCHER = "EXTENDED";
    private static final String EXTENDED_DESCRIPTION = "EXTENDED CPC DSK File\r\nDisk-Info\r\n";
    private static final String CREATOR_DATA = "JAVACPC EXTDSK";
    private static final String ENCODING = "UTF-8";
    private static final String TRACK_INFO = "Track-Info\r\n";
    private static final int SIDE_MASK = 1;
    private static final int MAX_TRACK = 79;
    private static final int BUFFER_SIZE = 8192;
    private static final int[] AMSDOS_SECTOR_IDS = new int[]{193, 195, 197, 199, 201, 194, 196, 198, 200};
    private final boolean newImage;
    public int sectSize = 0;
    public int statusregisterA;
    public int statusregisterB;
    private final String discId;
    private final String creator;
    private final int numberOfTracks;
    private final int numberOfSides;
    private final int sizeOfTrack;
    private final boolean extended;
    private final CPCDiscImageTrack[][] tracks;
    private int gapTrack = 0;
    public static int[] GAP = new int[168];
    int oldst1;
    int oldst2;

    public void notifyWriteSector(byte data, int cylinder, int head, int c, int h, int r, int n) {
    }

    public void notifyReadSector(boolean beginOfSector, int cylinder, int head, int c, int h, int r, int n) {
    }

    public static CPCDiscImage create(String name, InputStream is) throws IOException {
        return new CPCDiscImage(name, CPCDiscImage.load(is));
    }

    public int getNoOfTracks() {
        return this.numberOfTracks;
    }

    public CPCDiscImage(String name, int numberOfSides) {
        super(name);
        this.newImage = true;
        this.discId = EXTENDED_DESCRIPTION;
        this.creator = CREATOR_DATA;
        this.numberOfTracks = 80;
        this.numberOfSides = 1;
        this.statusregisterA = 0;
        this.statusregisterB = 0;
        this.sizeOfTrack = Math.max(1, Math.min(2, numberOfSides));
        this.extended = true;
        this.tracks = new CPCDiscImageTrack[this.numberOfTracks][this.numberOfSides];
        int sectorSize = UPD765A.getCommandSize(512);
        for (int track = 0; track < this.numberOfTracks; ++track) {
            for (int side = 0; side < this.numberOfSides; ++side) {
                this.tracks[track][side] = new CPCDiscImageTrack(track, side, 4608, 9);
                for (int sector = 0; sector < 9; ++sector) {
                    byte[] data = new byte[512];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = 0;
                    }
                    this.tracks[track][side].setSector(new CPCDiscImageSector(track, side, AMSDOS_SECTOR_IDS[sector], sectorSize, data, this.statusregisterA, this.statusregisterB), sector);
                }
            }
        }
    }

    public CPCDiscImage(String name, byte[] data) {
        super(name);
        UPD765A.error = false;
        this.gapTrack = 0;
        GAP = new int[168];
        this.newImage = false;
        this.discId = new String(data, 0, 34);
        this.creator = new String(data, 34, 14);
        Switches.numberOfTracks = this.numberOfTracks = data[48] & 0xFF;
        System.out.println("Numberof tracks is:" + this.numberOfTracks);
        this.numberOfSides = data[49] & 0xFF;
        this.sizeOfTrack = Device.getWord(data, 50);
        this.extended = this.discId.toUpperCase().startsWith(EXTENDED_EYECATCHER);
        boolean isCpcDisc = this.extended || this.discId.toUpperCase().startsWith(MV_CPC_EYECATCHER);
        boolean winape = this.creator.equalsIgnoreCase(WIN_APE_EYECATCHER);
        this.tracks = new CPCDiscImageTrack[this.numberOfTracks][this.numberOfSides];
        if (isCpcDisc) {
            byte[] trackSizes = new byte[256];
            if (this.extended) {
                System.arraycopy(data, 52, trackSizes, 0, this.numberOfTracks * this.numberOfSides);
            }
            int offs = 256;
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int trackLength = this.sizeOfTrack;
                    if (this.extended) {
                        trackLength = (trackSizes[track * this.numberOfSides + side] & 0xFF) * 256;
                    }
                    if (trackLength == 0 || offs >= data.length) continue;
                    int sot = offs;
                    int numberOfSectors = data[offs + 21] & 0xFF;
                    CPCDiscImage.GAP[this.gapTrack++] = data[offs + 22] & 0xFF;
                    int sectorInformationPos = offs + 24;
                    this.tracks[track][side] = new CPCDiscImageTrack(track, side, trackLength, numberOfSectors);
                    offs += 256;
                    for (int sect = 0; sect < numberOfSectors; ++sect) {
                        int sz;
                        int sectTrack = data[sectorInformationPos++] & 0xFF;
                        int sectSide = data[sectorInformationPos++] & 0xFF;
                        int sectId = data[sectorInformationPos++] & 0xFF;
                        this.sectSize = data[sectorInformationPos++] & 0xFF;
                        this.statusregisterA = data[sectorInformationPos++] & 0xFF;
                        this.statusregisterB = data[sectorInformationPos++] & 0xFF;
                        int bytes = UPD765A.getSectorSize(this.sectSize);
                        if (this.extended && !winape && (sz = Device.getWord(data, sectorInformationPos)) != 0) {
                            bytes = sz;
                            this.sectSize = UPD765A.getCommandSize(bytes);
                        }
                        sectorInformationPos += 2;
                        byte[] sectData = new byte[bytes];
                        try {
                            System.arraycopy(data, offs, sectData, 0, bytes);
                        }
                        catch (Exception e) {
                            System.err.println("Corrupt DSK image...");
                            Samples.CORRUPT.play();
                            UPD765A.error = true;
                            return;
                        }
                        offs += bytes;
                        this.tracks[track][side].setSector(new CPCDiscImageSector(sectTrack, sectSide, sectId, this.sectSize, sectData, this.statusregisterA, this.statusregisterB), sect);
                    }
                    if (winape) continue;
                    offs = sot + trackLength;
                }
            }
        }
        for (int sect = 0; sect < GAP.length; ++sect) {
            if (GAP[sect] != 0) continue;
            CPCDiscImage.GAP[sect] = 78;
        }
    }

    public CPCDiscImage(String newFileName, CPCDiscImage firstImage, CPCDiscImage secondImage) throws IOException {
        super(newFileName);
        int i;
        this.newImage = true;
        this.discId = firstImage.discId;
        this.creator = firstImage.creator;
        this.numberOfTracks = Math.max(firstImage.numberOfTracks, secondImage.numberOfTracks);
        this.numberOfSides = 2;
        this.sizeOfTrack = firstImage.sizeOfTrack;
        this.extended = firstImage.extended;
        if (!firstImage.extended || !secondImage.extended) {
            throw new IOException("only extended images can be merged!");
        }
        if (firstImage.numberOfSides != 1 || secondImage.numberOfSides != 1) {
            throw new IOException("only single sided extended images can be merged!");
        }
        this.tracks = new CPCDiscImageTrack[this.numberOfTracks][this.numberOfSides];
        for (i = 0; i < firstImage.numberOfTracks; ++i) {
            this.tracks[i][0] = firstImage.tracks[i][0];
        }
        for (i = 0; i < secondImage.numberOfTracks; ++i) {
            CPCDiscImageTrack track = secondImage.tracks[i][0];
            track.setSide(1);
            this.tracks[i][1] = track;
        }
    }

    public byte[] readSector(int track, int side, int c, int h, int r, int n) {
        if (this.DEBUG) {
            System.out.println("TRACK: " + track + " SIDE:" + side + " C:" + c + " H:" + h + " R:" + r + " N:" + n);
        }
        if (track <= 79) {
            try {
                return this.tracks[track][side & 1].getSectorData(c, h, r, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public int[] getSectorID(int track, int side, int index) {
        return this.tracks[track][side & 1].getSectorIDs(index);
    }

    public void removeAllSectorsFromTrack(int track, int side) {
        try {
            this.tracks[track][side & 1].removeAllSectorsFromTrack();
        }
        catch (Exception e) {
            Display.formaterror = 1;
            UPD765A.error = true;
            Samples.CORRUPTED.play();
        }
    }

    public void addSectorToTrack(int track, int side, int c, int h, int r, int n, int fillerByte) {
        try {
            this.tracks[track][side & 1].addSectorToTrack(c, h, r, n, fillerByte);
        }
        catch (Exception e) {
            Display.formaterror = 1;
            UPD765A.error = true;
            Samples.CORRUPTED.play();
        }
    }

    public int getST1ForSector(int track, int side, int c, int h, int r, int n) {
        try {
            this.oldst1 = this.tracks[track][side & 1].getST1(c, h, r, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.oldst1;
    }

    public int getST2ForSector(int track, int side, int c, int h, int r, int n) {
        try {
            this.oldst2 = this.tracks[track][side & 1].getST2(c, h, r, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.oldst2;
    }

    public void setST1ForSector(int track, int side, int c, int h, int r, int n, int st1) {
        try {
            this.tracks[track][side & 1].setST1(c, h, r, n, st1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setST2ForSector(int track, int side, int c, int h, int r, int n, int st2) {
        try {
            this.tracks[track][side & 1].setST2(c, h, r, n, st2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveCheck() {
        this.saveImage();
    }

    public int getSectorCount(int track, int side) {
        int result = 0;
        try {
            result = track > 79 ? 0 : this.tracks[track][side & 1].getSectorCount();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void writeSector(int track, int side, int c, int h, int r, int n, byte[] data) {
    }

    public String getDiscId() {
        return this.discId;
    }

    public String getCreator() {
        return this.creator;
    }

    public int getNumberOfTracks() {
        return this.numberOfTracks;
    }

    public int getNumberOfSides() {
        return this.numberOfSides;
    }

    public int getSizeOfTrack() {
        return this.sizeOfTrack;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public CPCDiscImageTrack[][] getTracks() {
        return this.tracks;
    }

    public void saveImage() {
        File discImage = new File(this.name);
        String saveFileName = discImage.getName();
        SAVED_DSK = Switches.neverOverwrite ? "_saved" : "";
        if (!this.newImage && SAVED_DSK.length() > 0) {
            int dotPos = saveFileName.lastIndexOf(46);
            if (dotPos == -1) {
                if (!saveFileName.endsWith(SAVED_DSK)) {
                    saveFileName = saveFileName + SAVED_DSK;
                    saveFileName = this.checkNewSaveFile(discImage.getParent(), saveFileName, "");
                }
            } else {
                String ext = saveFileName.substring(dotPos);
                if (!saveFileName.endsWith(SAVED_DSK + ext)) {
                    saveFileName = this.checkNewSaveFile(discImage.getParent(), saveFileName.substring(0, dotPos) + SAVED_DSK, ext);
                }
            }
        }
        this.saveImage(new File(discImage.getParent(), saveFileName));
    }

    public synchronized void saveImage(File savedImage) {
        if (!Switches.uncompressed) {
            this.saveDSZImage(savedImage);
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkWrite(savedImage.getAbsolutePath());
            }
            catch (SecurityException sex) {
                return;
            }
        }
        System.out.println("store dsk file to " + savedImage);
        this.name = savedImage.getAbsolutePath();
        if (this.name.toLowerCase().endsWith(".zip")) {
            this.name = this.name + "_" + Switches.choosenname;
        }
        if (!this.name.toLowerCase().endsWith(".dsk")) {
            this.name = this.name + ".dsk";
        }
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.name));
            bos.write(EXTENDED_DESCRIPTION.getBytes(ENCODING));
            bos.write(CREATOR_DATA.getBytes(ENCODING));
            bos.write(this.numberOfTracks);
            bos.write(this.numberOfSides);
            bos.write(0);
            bos.write(0);
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    try {
                        int trackLength = this.tracks[track][side].getLength();
                        bos.write(trackLength / 256 & 0xFF);
                        continue;
                    }
                    catch (Exception trackLength) {
                        // empty catch block
                    }
                }
            }
            int unused = 204 - this.numberOfTracks * this.numberOfSides;
            for (int i = 0; i < unused; ++i) {
                bos.write(0);
            }
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int sector;
                    CPCDiscImageTrack td = this.tracks[track][side];
                    bos.write(TRACK_INFO.getBytes(ENCODING));
                    bos.write(0);
                    bos.write(0);
                    bos.write(0);
                    bos.write(0);
                    bos.write(td.getTrack());
                    bos.write(td.getSide());
                    bos.write(0);
                    bos.write(0);
                    bos.write(td.getSector(0).getSize());
                    int numberOfSectors = td.getSectorCount();
                    bos.write(numberOfSectors);
                    bos.write(78);
                    bos.write(229);
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        CPCDiscImageSector sd = td.getSector(sector);
                        bos.write(sd.getTrack());
                        bos.write(sd.getSide());
                        bos.write(sd.getId());
                        bos.write(sd.getSize());
                        bos.write(sd.getST1());
                        bos.write(sd.getST2());
                        int dataSize = sd.getData().length;
                        bos.write(dataSize & 0xFF);
                        bos.write(dataSize / 256 & 0xFF);
                    }
                    unused = 232 - 8 * numberOfSectors;
                    for (int i = 0; i < unused; ++i) {
                        bos.write(0);
                    }
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        bos.write(td.getSector(sector).getData());
                    }
                }
            }
            bos.close();
        }
        catch (IOException iox) {
            System.out.println("can't write to file " + savedImage + ": " + iox.getMessage());
        }
    }

    public synchronized byte[] getImage() {
        byte[] predata = new byte[0x100000];
        int prepos = 0;
        try {
            byte[] dat = EXTENDED_DESCRIPTION.getBytes(ENCODING);
            System.arraycopy(dat, 0, predata, prepos, dat.length);
            prepos += dat.length;
            dat = CREATOR_DATA.getBytes(ENCODING);
            System.arraycopy(dat, 0, predata, prepos, dat.length);
            prepos += dat.length;
            predata[prepos++] = (byte)this.numberOfTracks;
            predata[prepos++] = (byte)this.numberOfSides;
            predata[prepos++] = 0;
            predata[prepos++] = 0;
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    try {
                        int trackLength = this.tracks[track][side].getLength();
                        predata[prepos++] = (byte)(trackLength / 256 & 0xFF);
                        continue;
                    }
                    catch (Exception trackLength) {
                        // empty catch block
                    }
                }
            }
            int unused = 204 - this.numberOfTracks * this.numberOfSides;
            for (int i = 0; i < unused; ++i) {
                predata[prepos++] = 0;
            }
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int sector;
                    CPCDiscImageTrack td = this.tracks[track][side];
                    dat = TRACK_INFO.getBytes(ENCODING);
                    System.arraycopy(dat, 0, predata, prepos, dat.length);
                    prepos += dat.length;
                    predata[prepos++] = 0;
                    predata[prepos++] = 0;
                    predata[prepos++] = 0;
                    predata[prepos++] = 0;
                    predata[prepos++] = (byte)td.getTrack();
                    predata[prepos++] = (byte)td.getSide();
                    predata[prepos++] = 0;
                    predata[prepos++] = 0;
                    predata[prepos++] = (byte)td.getSector(0).getSize();
                    int numberOfSectors = td.getSectorCount();
                    predata[prepos++] = (byte)numberOfSectors;
                    predata[prepos++] = 78;
                    predata[prepos++] = -27;
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        CPCDiscImageSector sd = td.getSector(sector);
                        predata[prepos++] = (byte)sd.getTrack();
                        predata[prepos++] = (byte)sd.getSide();
                        predata[prepos++] = (byte)sd.getId();
                        predata[prepos++] = (byte)sd.getSize();
                        predata[prepos++] = 0;
                        predata[prepos++] = 0;
                        int dataSize = sd.getData().length;
                        predata[prepos++] = (byte)(dataSize & 0xFF);
                        predata[prepos++] = (byte)(dataSize / 256 & 0xFF);
                    }
                    unused = 232 - 8 * numberOfSectors;
                    for (int i = 0; i < unused; ++i) {
                        predata[prepos++] = 0;
                    }
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        dat = td.getSector(sector).getData();
                        dat = td.getSector(sector).getData();
                        System.arraycopy(dat, 0, predata, prepos, dat.length);
                        prepos += dat.length;
                    }
                }
            }
            byte[] dskdata = new byte[prepos];
            System.arraycopy(predata, 0, dskdata, 0, dskdata.length);
            return dskdata;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void saveDSZImage(File savedImage) {
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkWrite(savedImage.getAbsolutePath());
            }
            catch (SecurityException sex) {
                return;
            }
        }
        System.out.println("store dsk file to " + savedImage);
        this.name = savedImage.getAbsolutePath();
        if (this.name.toLowerCase().endsWith(".zip") || this.name.toLowerCase().endsWith(".dsk")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        if (!this.name.toLowerCase().endsWith(".dsz")) {
            this.name = this.name + ".dsz";
        }
        File gzip_output = new File(this.name);
        try {
            FileOutputStream outp = new FileOutputStream(gzip_output);
            GZIPOutputStream bos = new GZIPOutputStream(new BufferedOutputStream(outp));
            bos.write(EXTENDED_DESCRIPTION.getBytes(ENCODING));
            bos.write(CREATOR_DATA.getBytes(ENCODING));
            bos.write(this.numberOfTracks);
            bos.write(this.numberOfSides);
            bos.write(0);
            bos.write(0);
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int trackLength = this.tracks[track][side].getLength();
                    bos.write(trackLength / 256 & 0xFF);
                }
            }
            int unused = 204 - this.numberOfTracks * this.numberOfSides;
            for (int i = 0; i < unused; ++i) {
                bos.write(0);
            }
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int sector;
                    CPCDiscImageTrack td = this.tracks[track][side];
                    bos.write(TRACK_INFO.getBytes(ENCODING));
                    bos.write(0);
                    bos.write(0);
                    bos.write(0);
                    bos.write(0);
                    bos.write(td.getTrack());
                    bos.write(td.getSide());
                    bos.write(0);
                    bos.write(0);
                    bos.write(td.getSector(0).getSize());
                    int numberOfSectors = td.getSectorCount();
                    bos.write(numberOfSectors);
                    bos.write(78);
                    bos.write(229);
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        CPCDiscImageSector sd = td.getSector(sector);
                        bos.write(sd.getTrack());
                        bos.write(sd.getSide());
                        bos.write(sd.getId());
                        bos.write(sd.getSize());
                        bos.write(sd.getST1());
                        bos.write(sd.getST2());
                        int dataSize = sd.getData().length;
                        bos.write(dataSize & 0xFF);
                        bos.write(dataSize / 256 & 0xFF);
                    }
                    unused = 232 - 8 * numberOfSectors;
                    for (int i = 0; i < unused; ++i) {
                        bos.write(0);
                    }
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        bos.write(td.getSector(sector).getData());
                    }
                }
            }
            bos.close();
        }
        catch (IOException iox) {
            System.out.println("can't write to file " + savedImage + ": " + iox.getMessage());
        }
    }

    private String checkNewSaveFile(String directory, String fileName, String ext) {
        String result = fileName + ext;
        File saveFile = new File(directory, result);
        int index = 1;
        int counter = 10000;
        while (saveFile.exists()) {
            result = fileName + Integer.toString(index++) + ext;
            saveFile = new File(directory, result);
            if (--counter >= 0) continue;
            break;
        }
        return result;
    }

    static byte[] load(InputStream is) throws IOException {
        int readLen;
        if (is == null) {
            return new byte[0];
        }
        int bufferSize = 8192;
        byte[] tmpData = new byte[8192];
        int offs = 0;
        int addOn = 16384;
        while ((readLen = is.read(tmpData, offs, tmpData.length - offs)) != -1) {
            if ((offs += readLen) != tmpData.length) continue;
            byte[] newres = new byte[tmpData.length + addOn];
            if (addOn < 0x100000) {
                addOn *= 2;
            }
            System.arraycopy(tmpData, 0, newres, 0, tmpData.length);
            tmpData = newres;
        }
        is.close();
        byte[] data = new byte[offs];
        System.arraycopy(tmpData, 0, data, 0, offs);
        return data;
    }

    public void SaveDSK() {
        this.saveImage();
    }
}

