/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import JCPC.core.device.Device;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jemu.core.Util;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GameMapper;

public class Mapper
extends JFrame {
    ActionListener update = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Mapper.this.drawMap();
            Mapper.this.repaint();
        }
    };
    Timer fireUpdate = new Timer(150, this.update);
    FileDialog exporter;
    BufferedImage[] screen;
    BufferedImage result;
    int tilewidth;
    int tileheight;
    int bytewidth;
    int byteheight;
    int mapwidth;
    int width;
    int height;
    int ramaddress;
    int tilenum;
    int mode;
    int linear;
    int[] address;
    int[] value;
    StringBuilder textmap;
    JLabel display;
    GameMapper mapper;
    private JTextField addr;
    private JCheckBox bit16;
    private JCheckBox blanktile;
    private JCheckBox half;
    private JTextField hei;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JCheckBox rev;
    private JCheckBox revy;
    private JCheckBox skip;
    private JTextField wid;

    public BufferedImage getMap() {
        return this.result;
    }

    public void exportScreen() {
        try {
            if (this.exporter == null) {
                this.exporter = new FileDialog((Frame)this, "Export map", 1);
            }
            this.exporter.setVisible(true);
            String path = this.exporter.getDirectory();
            String name = this.exporter.getFile();
            if (!name.toLowerCase().endsWith(".png")) {
                name = name + ".png";
            }
            String texname = name;
            texname = texname.substring(0, texname.length() - 4);
            texname = texname + ".txt";
            File a = new File(path + name);
            ImageIO.write((RenderedImage)this.result, "PNG", a);
            a = new File(path + texname);
            byte[] tex = this.getInfo().getBytes("UTF-8");
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(a));
            bos.write(tex);
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInfo(String addr, String width, String height) {
        this.addr.setText(addr);
        this.wid.setText(width);
        this.hei.setText(height);
    }

    public void initMapper(int tiles, int addr, int width, int height, BufferedImage[] input, int mode, boolean linear, boolean bit16, boolean skip) {
        int i;
        this.bit16.setSelected(bit16);
        this.skip.setSelected(skip);
        this.linear = linear ? 1 : 0;
        this.mode = mode;
        this.bytewidth = width;
        this.byteheight = height;
        this.ramaddress = addr;
        this.tilewidth = input[0].getWidth();
        this.tileheight = input[0].getHeight();
        this.tilenum = tiles;
        if (this.tilenum < 1) {
            this.tilenum = 512;
        }
        if (this.tilenum > 512) {
            this.tilenum = 512;
        }
        this.screen = new BufferedImage[this.tilenum];
        int buffer = 0;
        for (i = 0; i < this.screen.length; ++i) {
            try {
                this.screen[i] = new BufferedImage(this.tilewidth, this.tileheight, 1);
                this.screen[i].createGraphics().drawImage((Image)input[i], 0, 0, null);
                continue;
            }
            catch (Exception e) {
                buffer = i - 1;
            }
        }
        if (buffer != 0) {
            this.tilenum = tiles = buffer;
            if (this.tilenum < 1) {
                this.tilenum = 1;
            }
            this.screen = new BufferedImage[this.tilenum];
            for (i = 0; i < this.screen.length; ++i) {
                this.screen[i] = new BufferedImage(this.tilewidth, this.tileheight, 1);
                this.screen[i].createGraphics().drawImage((Image)input[i], 0, 0, null);
            }
        }
        this.drawMap();
    }

    public String getInfo() {
        String a = "";
        a = a + "TileAddress= &" + Util.hex((short)this.ramaddress) + "\r\n";
        a = a + "TilesNumber= " + this.tilenum + "\r\n";
        a = a + "TilesWidth = " + this.bytewidth + "\r\n";
        a = a + "TilesHeight= " + this.byteheight + "\r\n";
        a = a + "MapAddress = &" + this.addr.getText() + "\r\n";
        a = a + "MapWidth   = " + this.wid.getText() + "\r\n";
        a = a + "MapHeight  = " + this.hei.getText() + "\r\n";
        a = a + "ScreenMode = " + this.mode + "\r\n";
        a = a + "ModeLinear = " + this.linear + "\r\n";
        a = a + "16BitMap   = " + (this.bit16.isSelected() ? 1 : 0) + "\r\n";
        a = a + "SkipLines  = " + (this.skip.isSelected() ? 1 : 0);
        return a;
    }

    public void drawMap() {
        try {
            this.mapwidth = this.width = Integer.parseInt(this.wid.getText());
            this.height = Integer.parseInt(this.hei.getText());
            int adr = Util.hexValue(this.addr.getText());
            this.result = !this.half.isSelected() ? new BufferedImage(this.tilewidth * this.width, this.tileheight * this.height, 1) : new BufferedImage(this.tilewidth * this.width / 2, this.tileheight * this.height / 2, 1);
            this.address = new int[this.width * this.height];
            this.value = new int[this.width * this.height];
            this.textmap = new StringBuilder();
            BufferedImage dummy = new BufferedImage(this.screen[0].getWidth(), this.screen[0].getHeight(), 1);
            if (this.rev.isSelected()) {
                int w = 0;
                int h = 0;
                int off = 0;
                int ad = 0;
                for (int x = 0; x < this.width; ++x) {
                    h = 0;
                    for (int y = 0; y < this.height; ++y) {
                        this.address[off] = adr + ad;
                        if (this.bit16.isSelected()) {
                            int[] bug = new int[]{CPC.PEEK(this.address[off]), CPC.PEEK(this.address[off + 1])};
                            this.value[off] = Device.getWord(bug, 0);
                        } else {
                            this.value[off] = CPC.PEEK(this.address[off]);
                        }
                        ad += this.bit16.isSelected() ? 2 : 1;
                        this.textmap.append(Util.hex((byte)this.value[off]));
                        int tilepos = this.value[off++];
                        int tile = tilepos % this.tilenum;
                        if (this.jCheckBox1.isSelected()) {
                            tile = this.tilenum - 1 - tile;
                        }
                        if (this.blanktile.isSelected()) {
                            if (tilepos == 0) {
                                this.result.createGraphics().drawImage(dummy, w, h, this.tilewidth / (this.half.isSelected() ? 2 : 1), this.tileheight / (this.half.isSelected() ? 2 : 1), null);
                            } else {
                                this.result.createGraphics().drawImage(this.screen[tile - 1], w, h, this.tilewidth / (this.half.isSelected() ? 2 : 1), this.tileheight / (this.half.isSelected() ? 2 : 1), null);
                            }
                        } else {
                            this.result.createGraphics().drawImage(this.screen[tile], w, h, this.tilewidth / (this.half.isSelected() ? 2 : 1), this.tileheight / (this.half.isSelected() ? 2 : 1), null);
                        }
                        h += this.tileheight / (this.half.isSelected() ? 2 : 1);
                    }
                    this.textmap.append("\r\n");
                    if ((w += this.tilewidth) < x * this.tilewidth / (this.half.isSelected() ? 2 : 1)) continue;
                    w = 0;
                }
            } else {
                int w = 0;
                int h = 0;
                int off = 0;
                int ad = 0;
                if (this.revy.isSelected()) {
                    h = this.height * this.tileheight - this.tileheight;
                }
                for (int y = 0; y < this.height; ++y) {
                    w = 0;
                    for (int x = 0; x < this.width; ++x) {
                        this.address[off] = adr + ad;
                        int bad = adr + ad + 1;
                        ad += this.bit16.isSelected() ? 2 : 1;
                        this.value[off] = CPC.PEEK(this.address[off]);
                        if (this.bit16.isSelected() && !this.skip.isSelected()) {
                            int[] k = new int[]{CPC.PEEK(this.address[off]), CPC.PEEK(this.address[off] + 1)};
                            this.value[off] = Device.getWord(k, 0);
                        }
                        this.textmap.append(Util.hex((byte)this.value[off]));
                        int tilepos = this.value[off++];
                        int tile = tilepos % this.tilenum;
                        if (this.jCheckBox1.isSelected()) {
                            tile = this.tilenum - 1 - tile;
                        }
                        if (this.blanktile.isSelected()) {
                            if (tilepos == 0) {
                                this.result.createGraphics().drawImage(dummy, w, h, this.tilewidth / (this.half.isSelected() ? 2 : 1), this.tileheight / (this.half.isSelected() ? 2 : 1), null);
                            } else if (tile - 1 >= 0) {
                                this.result.createGraphics().drawImage(this.screen[tile - 1], w, h, this.tilewidth / (this.half.isSelected() ? 2 : 1), this.tileheight / (this.half.isSelected() ? 2 : 1), null);
                            }
                        } else {
                            this.result.createGraphics().drawImage(this.screen[tile], w, h, this.tilewidth / (this.half.isSelected() ? 2 : 1), this.tileheight / (this.half.isSelected() ? 2 : 1), null);
                        }
                        w += this.tilewidth / (this.half.isSelected() ? 2 : 1);
                    }
                    if (this.skip.isSelected()) {
                        ad += this.width * 2;
                    }
                    this.textmap.append("\r\n");
                    if (this.revy.isSelected()) {
                        if ((h -= this.tileheight / (this.half.isSelected() ? 2 : 1)) >= 0 - this.tileheight / (this.half.isSelected() ? 2 : 1)) continue;
                        h = this.height * this.tileheight / (this.half.isSelected() ? 2 : 1);
                        continue;
                    }
                    if ((h += this.tileheight / (this.half.isSelected() ? 2 : 1)) < this.height * this.tileheight / (this.half.isSelected() ? 2 : 1)) continue;
                    h = 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.display == null) {
            this.display = new JLabel();
            this.display.setBackground(Color.red);
        }
        this.display.setPreferredSize(new Dimension(this.tilewidth * this.width / (this.half.isSelected() ? 2 : 1), this.tileheight * this.height / (this.half.isSelected() ? 2 : 1)));
        this.display.setIcon(new ImageIcon(this.result));
        this.jScrollPane1.setViewportView(this.display);
        this.jTextArea1.setText(this.getInfo());
    }

    public Mapper() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jButton10 = new JButton();
        this.jButton6 = new JButton();
        this.addr = new JTextField();
        this.jButton7 = new JButton();
        this.jButton9 = new JButton();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.wid = new JTextField();
        this.jButton2 = new JButton();
        this.jLabel3 = new JLabel();
        this.jButton3 = new JButton();
        this.hei = new JTextField();
        this.jButton4 = new JButton();
        this.rev = new JCheckBox();
        this.revy = new JCheckBox();
        this.jButton5 = new JButton();
        this.jCheckBox2 = new JCheckBox();
        this.jTextArea1 = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jButton8 = new JButton();
        this.half = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.blanktile = new JCheckBox();
        this.bit16 = new JCheckBox();
        this.skip = new JCheckBox();
        this.jButton11 = new JButton();
        this.setTitle("JavaCPC GameMap Ripper");
        this.jScrollPane1.setMaximumSize(new Dimension(640, 480));
        this.jScrollPane1.setMinimumSize(new Dimension(640, 480));
        this.jScrollPane1.setPreferredSize(new Dimension(640, 480));
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setPreferredSize(new Dimension(836, 30));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jLabel1.setText("Address:");
        this.jPanel1.add(this.jLabel1);
        this.jButton10.setText("<<");
        this.jButton10.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton10ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton10);
        this.jButton6.setText("<");
        this.jButton6.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton6ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton6);
        this.addr.setColumns(4);
        this.addr.setHorizontalAlignment(4);
        this.addr.setText("200");
        this.addr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.addrActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.addr);
        this.jButton7.setText(">");
        this.jButton7.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton7ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton7);
        this.jButton9.setText(">>");
        this.jButton9.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton9ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton9);
        this.jLabel2.setText("Width:");
        this.jPanel1.add(this.jLabel2);
        this.jButton1.setText("<");
        this.jButton1.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.wid.setColumns(2);
        this.wid.setHorizontalAlignment(4);
        this.wid.setText("10");
        this.jPanel1.add(this.wid);
        this.jButton2.setText(">");
        this.jButton2.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton2);
        this.jLabel3.setText("Height:");
        this.jPanel1.add(this.jLabel3);
        this.jButton3.setText("<");
        this.jButton3.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton3);
        this.hei.setColumns(2);
        this.hei.setHorizontalAlignment(4);
        this.hei.setText("10");
        this.jPanel1.add(this.hei);
        this.jButton4.setText(">");
        this.jButton4.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton4);
        this.rev.setText("Rev. X");
        this.rev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.revActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rev);
        this.revy.setText("Rev. Y");
        this.revy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.revyActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.revy);
        this.jButton5.setText("Paint map");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton5);
        this.jCheckBox2.setText("AutoPaint");
        this.jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jCheckBox2);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea1.setRows(5);
        this.getContentPane().add((Component)this.jTextArea1, "East");
        this.jPanel2.setLayout(new FlowLayout(0, 5, 2));
        this.jButton8.setText("Export");
        this.jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton8ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton8);
        this.half.setSelected(true);
        this.half.setText("Half size");
        this.half.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.halfActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.half);
        this.jCheckBox1.setText("Reverse");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jCheckBox1);
        this.blanktile.setText("Replace Tile 0 (Blank tile)");
        this.blanktile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.blanktileActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.blanktile);
        this.bit16.setText("16bit Map");
        this.bit16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.bit16ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.bit16);
        this.skip.setText("Skip Lines (Cybernoid)");
        this.skip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.skipActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.skip);
        this.jButton11.setText("Mapper");
        this.jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Mapper.this.jButton11ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton11);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void addrActionPerformed(ActionEvent evt) {
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.drawMap();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        try {
            int adr = Util.hexValue(this.addr.getText());
            adr = adr > 0 ? --adr : 65535;
            this.addr.setText(Util.hex((short)adr));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawMap();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        try {
            int adr = Util.hexValue(this.addr.getText());
            adr = adr < 65535 ? ++adr : 0;
            this.addr.setText(Util.hex((short)adr));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawMap();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int g = Integer.parseInt(this.wid.getText());
        if (g > 1) {
            --g;
        }
        this.wid.setText("" + g);
        this.drawMap();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int g = Integer.parseInt(this.wid.getText());
        if (g < 65536) {
            ++g;
        }
        this.wid.setText("" + g);
        this.drawMap();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        int g = Integer.parseInt(this.hei.getText());
        if (g > 1) {
            --g;
        }
        this.hei.setText("" + g);
        this.drawMap();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        int g = Integer.parseInt(this.hei.getText());
        if (g < 65536) {
            ++g;
        }
        this.hei.setText("" + g);
        this.drawMap();
    }

    private void revActionPerformed(ActionEvent evt) {
        this.drawMap();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.exportScreen();
    }

    private void revyActionPerformed(ActionEvent evt) {
        this.drawMap();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.drawMap();
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        try {
            int adr = Util.hexValue(this.addr.getText());
            adr = adr < 65536 ? (adr += this.mapwidth * (this.bit16.isSelected() ? 2 : 1) * (this.skip.isSelected() ? 2 : 1)) : 0;
            this.addr.setText(Util.hex((short)adr));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawMap();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        try {
            int adr = Util.hexValue(this.addr.getText());
            adr = adr >= this.mapwidth * (this.bit16.isSelected() ? 2 : 1) * (this.skip.isSelected() ? 2 : 1) ? (adr -= this.mapwidth * (this.bit16.isSelected() ? 2 : 1) * (this.skip.isSelected() ? 2 : 1)) : 65536 - this.mapwidth;
            this.addr.setText(Util.hex((short)adr));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawMap();
    }

    private void halfActionPerformed(ActionEvent evt) {
        this.drawMap();
    }

    private void blanktileActionPerformed(ActionEvent evt) {
        this.drawMap();
    }

    private void bit16ActionPerformed(ActionEvent evt) {
        this.drawMap();
    }

    private void skipActionPerformed(ActionEvent evt) {
        this.drawMap();
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox2.isSelected() && !this.fireUpdate.isRunning()) {
            this.fireUpdate.start();
        } else if (!this.jCheckBox2.isSelected() && this.fireUpdate.isRunning()) {
            this.fireUpdate.stop();
        }
    }

    public void keyPress(int code) {
        if (this.mapper != null && this.mapper.isVisible()) {
            this.mapper.keyPress(code);
        }
    }

    public void keyRelease(int code) {
        if (this.mapper != null && this.mapper.isVisible()) {
            this.mapper.keyRelease(code);
        }
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        if (this.mapper == null) {
            this.mapper = new GameMapper(this);
        }
        this.mapper.setVisible(true);
        this.mapper.newMap();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Mapper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Mapper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Mapper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Mapper.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Mapper().setVisible(true);
            }
        });
    }
}

