/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTheme;
import jemu.settings.DSettings;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.ui.CMDInfo;
import jemu.ui.CheckResources;
import jemu.ui.Desktop;
import jemu.ui.JEMU;
import jemu.ui.OSValidator;
import jemu.ui.Splash;
import jemu.ui.SyntheticaLicense;
import jemu.ui.TransparentBackground;

public class Main {
    public static String version = "2";
    public static String subversion = ".9.20";
    public static String year = "2016";
    public static String path = "";
    public static TransparentBackground bg;
    public static JFrame splash;
    public static String wallpaper;
    public static String stretch;
    public static String monitor;
    public static String desk;
    static CheckResources checkresources;
    static Splash info;

    public void parseArgs(String[] args) {
        String command = "";
        String value = "";
        boolean launched = false;
        boolean even = true;
        for (String s : args) {
            command = command + " " + s;
        }
        System.out.println("Args:" + command);
        command = "";
        for (String s : args) {
            if (even) {
                launched = false;
                command = s;
            } else {
                launched = true;
                value = s;
                this.parseArg(command, value);
            }
            even = !even;
        }
        if (!launched) {
            this.parseArg(command, value);
        }
    }

    public static void printHelp() {
        CMDInfo inf = new CMDInfo();
        inf.setVisible(true);
    }

    public void parseArg(String cmd, String val) {
        val = val.replace("&quot;", "\"");
        if (cmd.contains("cpctype")) {
            System.out.println("Choosen CPCtype:" + val);
            CPC.cpctype = val;
        }
        if (cmd.contains("df0")) {
            System.out.println("Choosen DSK for drive A:" + val);
            CPC.drivea = val;
        }
        if (cmd.contains("sna")) {
            System.out.println("Choosen Snapshot file:" + val);
            CPC.snapshot = val;
        }
        if (cmd.contains("df1")) {
            System.out.println("Choosen DSK for drive B:" + val);
            CPC.driveb = val;
        }
        if (cmd.contains("drivea")) {
            System.out.println("Choosen DSK for drive A:" + val);
            CPC.drivea = val;
        }
        if (cmd.contains("driveb")) {
            System.out.println("Choosen DSK for drive B:" + val);
            CPC.driveb = val;
        }
        if (cmd.contains("tape")) {
            System.out.println("Choosen CDT for tapedrive:" + val);
            CPC.tape = val;
        }
        if (cmd.contains("boot")) {
            System.out.println("You want to boot from " + val);
            CPC.bootdrive = val;
        }
        if (cmd.contains("amsdos")) {
            System.out.println("Amsdos will be: " + val);
            if (val.contains("false") || val.contains("0")) {
                val = "no";
            }
            CPC.amsdos = val;
        }
        if (cmd.contains("crtc")) {
            System.out.println("CRTC type will be: " + val);
            CPC.crtctype = val;
        }
        if (cmd.contains("autotype")) {
            System.out.println("JavaCPC will enter this text: " + val);
            CPC.autotypetext = val;
        }
        if (cmd.contains("desktop")) {
            System.out.println("Desktop is used: " + val);
            desk = val;
        }
        if (cmd.contains("wallpaper")) {
            System.out.println("Wallpaper: " + val);
            wallpaper = val;
        }
        if (cmd.contains("stretch")) {
            System.out.println("Stretch wallpaper: " + val);
            stretch = val;
        }
        if (cmd.contains("mem")) {
            System.out.println("Memory will be set to: " + val + "k");
            CPC.usemem = val;
        }
        if (cmd.contains("monitor")) {
            System.out.println("Monitor emulation is: " + val);
            monitor = val;
        }
        if (cmd.contains("polarity")) {
            System.out.println("Tape polarity is: " + val);
            JEMU.tapepolarity = val;
        }
        if (cmd.contains("help")) {
            Main.printHelp();
        }
    }

    protected static void setupReg() {
        try {
            String line;
            String command = "reg.exe QUERY \"HKCU\\Software\\Classes\\.DSK\" /ve";
            Process process = Runtime.getRuntime().exec(command);
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String result = "";
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
            if (result.contains("REG_SZ")) {
                while (!result.startsWith("REG_SZ")) {
                    result = result.substring(1);
                }
                result = result.substring(7);
                while (result.startsWith(" ")) {
                    result = result.substring(1);
                }
            }
            br.close();
            boolean wincpc = false;
            if (result.toLowerCase().contains("wincpc")) {
                wincpc = true;
            }
            process = null;
            String rem = "testpath";
            File checkit = new File(rem);
            String got = "\"\\\"" + checkit.getAbsolutePath().replace(rem, "");
            got = got + "JavaCPC.exe\\\" \\\"%1\\\"\"";
            if (result.length() > 0) {
                command = "reg.exe ADD \"HKLM\\Software\\Classes\\" + result + "\\shell\\Mount DSK in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
                Runtime.getRuntime().exec(command);
            } else {
                command = "reg.exe ADD \"HKLM\\Software\\Classes\\.DSK\" /ve /t REG_SZ /d dskfile /f";
                Runtime.getRuntime().exec(command);
                command = "reg.exe ADD \"HKCU\\Software\\Classes\\.DSK\" /ve /t REG_SZ /d dskfile /f";
                Runtime.getRuntime().exec(command);
                command = "reg.exe ADD \"HKLM\\Software\\Classes\\dskfile\\shell\\Mount DSK in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
                Runtime.getRuntime().exec(command);
            }
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.DSK\" /ve /t REG_SZ /d dskfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKCU\\Software\\Classes\\.DSK\" /ve /t REG_SZ /d dskfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.ASM\" /ve /t REG_SZ /d asmfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.ASM\" /v PerceivedType /t REG_SZ /d text /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKCU\\Software\\Classes\\.ASM\" /ve /t REG_SZ /d asmfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.CDT\" /ve /t REG_SZ /d cdtfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.SNA\" /ve /t REG_SZ /d snafile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.ANI\" /ve /t REG_SZ /d anifile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.ANZ\" /ve /t REG_SZ /d anifile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\cdtfile\\shell\\Mount CDT in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\asmfile\\shell\\Edit with JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKCU\\Software\\Classes\\cdtfile\\shell\\Mount CDT in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKCU\\Software\\Classes\\asmfile\\shell\\Edit with JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\snafile\\shell\\Load SNA in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\anifile\\shell\\Play in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\WinCPC.DSK\\shell\\Mount DSK in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\WinCPC.CDT\\shell\\Mount CDT in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\WinCPC.SNA\\shell\\Load SNA in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\dsk.Document\\shell\\Mount DSK in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void verifyJavaCPC() {
        checkresources.checkResources();
    }

    public static void checkUpdate(boolean autocheck) {
        String inputLine = null;
        String result = "";
        String ver = version + subversion;
        try {
            URL oracle = new URL("http://cpc-live.com/javacpc_update/javacpc_version.txt");
            URLConnection yc = oracle.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                result = result + inputLine;
            }
            in.close();
            System.out.println(result);
            System.out.println(ver);
        }
        catch (Exception e) {
            return;
        }
        if (!ver.equals(result) && !result.contains("al")) {
            splash.setVisible(false);
            int n = JOptionPane.showConfirmDialog(new JFrame(), "Your JavaCPC version is " + ver + ".\r\n" + "Do you want to download and install\r\nJavaCPC version " + result + "?", "JavaCPC update version " + result + " is available...", 0);
            if (n == 0) {
                try {
                    checkresources.checkResources();
                    String command = "java -jar update.jar";
                    Runtime.getRuntime().exec(command);
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
        } else if (result.contains("al") && !autocheck) {
            String up = result.contains("al") ? "\r\nBe careful! It's Alpha!" : "";
            System.out.println(up);
            splash.setVisible(false);
            int n = JOptionPane.showConfirmDialog(new JFrame(), "Your JavaCPC version is " + ver + ".\r\n" + "Do you want to download and install\r\nJavaCPC version " + result + "?" + up, "JavaCPC update version " + result + " is available...", 0);
            if (n == 0) {
                try {
                    checkresources.checkResources();
                    String command = "java -jar update.jar";
                    Runtime.getRuntime().exec(command);
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
        } else if (!autocheck) {
            JOptionPane.showMessageDialog(null, "Your copy of JavaCPC is up to date.");
        }
    }

    public static void main(String[] args) {
        Object[] optionss;
        int nf;
        System.setProperty("http.agent", "BDDBrowser/" + version + subversion);
        path = System.getProperty("user.dir");
        checkresources.checkFileResources();
        Settings.set("version", version + subversion);
        Main javacpc = new Main();
        String[] orgargs = args;
        boolean ret = false;
        if (args != null && args.length > 0 && args[0].startsWith("-")) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].contains("-help")) continue;
                ret = true;
                break;
            }
            orgargs = new String[]{""};
            javacpc.parseArgs(args);
        }
        if (ret) {
            return;
        }
        args = orgargs;
        if (OSValidator.isWindows() && OSValidator.needNewJava() && (nf = JOptionPane.showOptionDialog(new JFrame(), "Your Java is outdated.\nPlease visit www.java.com\nand install the latest update.", "Problem", 1, 2, null, optionss = new Object[]{"Ignore", "Quit JavaCPC"}, optionss[1])) == 1) {
            JEMU.openWebPage("http://www.java.com");
            System.exit(0);
        }
        String desktop = DSettings.get("use_desktop", "not_set");
        if (desk != null && ((desktop = desk.toLowerCase()).contains("true") || desktop.contains("1"))) {
            desktop = "yes";
        }
        if (desktop.equals("not_set")) {
            Object[] options = new Object[]{"Desktop", "Normal", "Cancel"};
            int n = JOptionPane.showOptionDialog(new JFrame(), "Would you like to run JavaCPC Desktop?", "Please choose", 1, 3, null, options, options[0]);
            if (n == 2) {
                System.exit(0);
            }
            if (n == 0) {
                Main.initsplash(60);
                DSettings.set("use_desktop", "yes");
                javacpc.launchDesktop(args);
            } else {
                Main.initsplash(40);
                DSettings.set("use_desktop", "no");
                javacpc.launchClassic(args);
            }
        } else if (desktop.equals("yes")) {
            Main.initsplash(60);
            int look = Integer.parseInt(DSettings.get("look", "4"));
            if (look == 30) {
                try {
                    new SyntheticaLicense().register();
                    UIManager.setLookAndFeel("de.javasoft.plaf.synthetica.SyntheticaBlackEyeLookAndFeel");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            javacpc.launchDesktop(args);
        } else {
            Main.initsplash(40);
            javacpc.launchClassic(args);
        }
        Desktop.aboutline.setText("\u00a92004-" + year + " by Markus Hohmann");
    }

    protected static void initsplash(int speed) {
        try {
            info = new Splash(speed);
            splash.add(info);
            splash.setUndecorated(true);
            splash.pack();
            bg = new TransparentBackground(splash);
            splash.setAlwaysOnTop(true);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            splash.setLocation((d.width - Main.splash.getSize().width) / 2, (d.height - Main.splash.getSize().height) / 2);
            splash.getContentPane().add(bg);
            splash.setVisible(true);
        }
        catch (Exception e) {
            Main.verifyJavaCPC();
        }
    }

    protected void launchDesktop(String[] args) {
        Desktop.isDesktop = true;
        Desktop.addToEmu = args;
        Desktop.main(args);
    }

    static void setClassicStyle() {
        try {
            File a = new File("./Update.jar");
            if (a.exists()) {
                NimRODTheme nt = new NimRODTheme();
                Color flow1 = new Color(5526720);
                Color flow2 = new Color(13158634);
                Color selected = new Color(6184650);
                Color white = new Color(4802644);
                Color black = new Color(0xFFFFFF);
                Color sec1 = new Color(1646119);
                Color sec2 = new Color(2304049);
                Color sec3 = new Color(2961979);
                nt.setPrimary1(flow1);
                nt.setPrimary3(flow2);
                nt.setPrimary2(selected);
                nt.setSecondary1(sec1);
                nt.setSecondary2(sec2);
                nt.setSecondary3(sec3);
                nt.setBlack(black);
                nt.setWhite(white);
                nt.setMenuOpacity(195);
                nt.setFrameOpacity(120);
                NimRODLookAndFeel NimRODLF = new NimRODLookAndFeel();
                NimRODLookAndFeel.setCurrentTheme((MetalTheme)nt);
                UIManager.setLookAndFeel((LookAndFeel)NimRODLF);
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void launchClassic(String[] args) {
        Desktop.isDesktop = false;
        JEMU.main(args);
    }

    static {
        splash = new JFrame();
        wallpaper = null;
        stretch = null;
        monitor = null;
        desk = null;
        checkresources = new CheckResources();
    }
}

