/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;

public final class Mandel3
extends Applet
implements MouseListener,
MouseMotionListener,
KeyListener {
    public boolean toCPC = false;
    private int maxCount = 192;
    private boolean smooth = false;
    public boolean antialias = false;
    private boolean drag = false;
    private boolean toDrag = false;
    private boolean rect = true;
    private boolean oldRect = true;
    private Color[][] colors;
    private int pal = 0;
    private double viewX = 0.0;
    private double viewY = 0.0;
    private double zoom = 1.0;
    private int mouseX;
    private int mouseY;
    private int dragX;
    private int dragY;
    private int oldX;
    private int oldY;
    private static final int[][][] colpal = new int[][][]{new int[][]{{0, 10, 20}, {50, 100, 240}, {20, 3, 26}, {230, 60, 20}, {25, 10, 9}, {230, 170, 0}, {20, 40, 10}, {0, 100, 0}, {5, 10, 10}, {210, 70, 30}, {90, 0, 50}, {180, 90, 120}, {0, 20, 40}, {30, 70, 200}}, new int[][]{{70, 0, 20}, {100, 0, 100}, {255, 0, 0}, {255, 200, 0}}, new int[][]{{40, 70, 10}, {40, 170, 10}, {100, 255, 70}, {255, 255, 255}}, new int[][]{{0, 0, 0}, {0, 0, 255}, {0, 255, 255}, {255, 255, 255}, {0, 128, 255}}, new int[][]{{0, 0, 0}, {255, 255, 255}, {128, 128, 128}}};
    String mode1 = "10 MODE 1\n20 INK 0,0:INK 1,1:INK 2,2:INK 3,11\n40 GOTO 40\nrun\n";
    String color = "10 MODE 0:FOR t=0 TO 15:READ a:INK t,a:NEXT:DATA 0,1,2,11,23,21,18,9,12,24,25,16,15,6,3,4\n20 GOTO 20\nRUN\n";
    String flip = "10 MODE 0\n20 INK 0,0\n30 INK 1,1,0\n40 INK 2,1\n50 INK 3,1,2\n60 INK 4,2\n70 INK 5,2,11\n80 INK 6,11\n90 INK 7,11,14\n100 INK 8,14\n110 INK 9,14,20\n120 INK 10,20\n130 INK 11,20,23\n140 INK 12,23\n150 INK 13,23,26\n160 INK 14,26\n170 INK 15,26\n180 SPEED INK 1,1\n190 GOTO 190\nrun\n";

    public void init() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.colors = new Color[colpal.length][];
        for (int p = 0; p < colpal.length; ++p) {
            this.colors[p] = new Color[colpal[p].length * 12];
            for (int i = 0; i < colpal[p].length; ++i) {
                int[] c1 = colpal[p][i];
                int[] c2 = colpal[p][(i + 1) % colpal[p].length];
                for (int j = 0; j < 12; ++j) {
                    this.colors[p][i * 12 + j] = new Color((c1[0] * (11 - j) + c2[0] * j) / 11, (c1[1] * (11 - j) + c2[1] * j) / 11, (c1[2] * (11 - j) + c2[2] * j) / 11);
                }
            }
        }
        this.pal = (this.pal + 1) % this.colors.length;
        this.pal = (this.pal + 1) % this.colors.length;
        this.pal = (this.pal + 1) % this.colors.length;
    }

    public void type() {
        boolean flipp = Settings.getBoolean("de-interlace", false);
        if (!flipp) {
            GateArray.cpc.BasicAutoType(this.color);
        } else {
            GateArray.cpc.BasicAutoType(this.flip);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        if (this.drag) {
            double r;
            int h;
            int w;
            int y;
            int x;
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            if (this.oldRect) {
                x = Math.min(this.mouseX, this.oldX);
                y = Math.min(this.mouseY, this.oldY);
                w = Math.max(this.mouseX, this.oldX) - x;
                h = Math.max(this.mouseY, this.oldY) - y;
                r = Math.max((double)w / (double)size.width, (double)h / (double)size.height);
                g.drawRect(x, y, (int)((double)size.width * r), (int)((double)size.height * r));
            } else {
                g.drawLine(this.mouseX, this.mouseY, this.oldX, this.oldY);
            }
            if (this.rect) {
                x = Math.min(this.mouseX, this.dragX);
                y = Math.min(this.mouseY, this.dragY);
                w = Math.max(this.mouseX, this.dragX) - x;
                h = Math.max(this.mouseY, this.dragY) - y;
                r = Math.max((double)w / (double)size.width, (double)h / (double)size.height);
                g.drawRect(x, y, (int)((double)size.width * r), (int)((double)size.height * r));
            } else {
                g.drawLine(this.mouseX, this.mouseY, this.dragX, this.dragY);
            }
            this.oldX = this.dragX;
            this.oldY = this.dragY;
            this.oldRect = this.rect;
            this.drag = false;
            return;
        }
        for (int y = 0; y < size.height; ++y) {
            for (int x = 0; x < size.width; ++x) {
                double r = this.zoom / (double)Math.min(size.width, size.height);
                double dx = 2.5 * ((double)x * r + this.viewX) - 2.0;
                double dy = 1.25 - 2.5 * ((double)y * r + this.viewY);
                Color color = this.color(dx, dy);
                if (this.antialias) {
                    Color c1 = this.color(dx, dy + 0.5 * r);
                    Color c2 = this.color(dx + 0.5 * r, dy);
                    Color c3 = this.color(dx + 0.5 * r, dy + 0.5 * r);
                    int red = (color.getRed() + c1.getRed() + c2.getRed() + c3.getRed()) / 4;
                    int green = (color.getGreen() + c1.getGreen() + c2.getGreen() + c3.getGreen()) / 4;
                    int blue = (color.getBlue() + c1.getBlue() + c2.getBlue() + c3.getBlue()) / 4;
                    color = new Color(red, green, blue);
                }
                g.setColor(color);
                g.drawLine(x, y, x, y);
                int mode = GateArray.getSMode();
                int cpcX = x;
                if (mode == 0) {
                    cpcX /= 2;
                }
                if (mode == 2) {
                    cpcX *= 2;
                }
                int pen = color.getRed() + color.getGreen() + color.getBlue();
                pen /= 51;
                if (mode == 1) {
                    pen = (int)((double)pen / 3.75);
                }
                if (mode == 2) {
                    pen = (int)((double)pen / 7.5);
                }
                if (!this.toCPC) continue;
                CPC.PLOT(cpcX, y, pen, mode, false);
                if (mode != 2) continue;
                CPC.PLOT(cpcX + 1, y, pen, mode, false);
            }
        }
    }

    private Color color(double x, double y) {
        int count = this.mandel(0.0, 0.0, x, y);
        int palSize = this.colors[this.pal].length;
        Color color = this.colors[this.pal][count / 256 % palSize];
        if (this.smooth) {
            Color color2 = this.colors[this.pal][(count / 256 + palSize - 1) % palSize];
            int k1 = count % 256;
            int k2 = 255 - k1;
            int red = (k1 * color.getRed() + k2 * color2.getRed()) / 255;
            int green = (k1 * color.getGreen() + k2 * color2.getGreen()) / 255;
            int blue = (k1 * color.getBlue() + k2 * color2.getBlue()) / 255;
            color = new Color(red, green, blue);
        }
        return color;
    }

    private int mandel(double zRe, double zIm, double pRe, double pIm) {
        int count;
        double zRe2 = zRe * zRe;
        double zIm2 = zIm * zIm;
        double zM2 = 0.0;
        for (count = 0; zRe2 + zIm2 < 4.0 && count < this.maxCount; ++count) {
            zM2 = zRe2 + zIm2;
            zIm = 2.0 * zRe * zIm + pIm;
            zRe = zRe2 - zIm2 + pRe;
            zRe2 = zRe * zRe;
            zIm2 = zIm * zIm;
        }
        if (count == 0 || count == this.maxCount) {
            return 0;
        }
        return 256 * count + (int)(255.0 * Math.log(4.0 / (zM2 += 1.0E-9)) / Math.log((zRe2 + zIm2) / zM2));
    }

    public void mousePressed(MouseEvent e) {
        this.dragX = this.oldX = e.getX();
        this.mouseX = this.oldX;
        this.dragY = this.oldY = e.getY();
        this.mouseY = this.oldY;
        this.toDrag = true;
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if ((e.getModifiers() & 0x10) != 0) {
            if ((e.getModifiers() & 1) != 0) {
                int width = this.getSize().width;
                int height = this.getSize().height;
                this.viewX += this.zoom * (double)(this.mouseX - x) / (double)Math.min(width, height);
                this.viewY += this.zoom * (double)(this.mouseY - y) / (double)Math.min(width, height);
                this.repaint();
            } else if (x != this.mouseX && y != this.mouseY) {
                int width = this.getSize().width;
                int height = this.getSize().height;
                int mx = Math.min(x, this.mouseX);
                int my = Math.min(y, this.mouseY);
                this.viewX += this.zoom * (double)mx / (double)Math.min(width, height);
                this.viewY += this.zoom * (double)my / (double)Math.min(width, height);
                int w = Math.max(x, this.mouseX) - mx;
                int h = Math.max(y, this.mouseY) - my;
                double r = Math.max((double)w / (double)width, (double)h / (double)height);
                this.zoom *= r;
                this.drag = false;
                this.repaint();
            }
        } else if ((e.getModifiers() & 4) != 0) {
            this.addIter();
        }
        this.toDrag = false;
    }

    public void zoomOut() {
        this.viewX -= 0.5 * this.zoom;
        this.viewY -= 0.5 * this.zoom;
        this.zoom *= 2.0;
        this.repaint();
    }

    public void zoomIn() {
        this.viewX += 0.25 * this.zoom;
        this.viewY += 0.25 * this.zoom;
        this.zoom /= 2.0;
        this.repaint();
    }

    public void addIter() {
        this.maxCount += this.maxCount / 4;
        this.repaint();
    }

    public void subIter() {
        this.maxCount -= this.maxCount / 4;
        if (this.maxCount <= 4) {
            this.maxCount = 4;
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            this.dragX = e.getX();
            this.dragY = e.getY();
            this.drag = true;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void reset() {
        this.maxCount = 192;
        this.viewY = 0.0;
        this.viewX = 0.0;
        this.zoom = 1.0;
        this.repaint();
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.reset();
        } else if (e.getKeyCode() == 79) {
            this.zoomOut();
        } else if (e.getKeyCode() == 80) {
            this.pal = (this.pal + 1) % this.colors.length;
            this.repaint();
        } else if (e.getKeyCode() == 83) {
            this.smooth = !this.smooth;
            this.repaint();
        } else if (e.getKeyCode() == 65) {
            this.antialias = !this.antialias;
            this.repaint();
        } else if (e.getKeyCode() == 16 && this.rect) {
            this.oldRect = true;
            this.rect = false;
            if (this.toDrag) {
                this.drag = true;
                this.repaint();
            }
        }
    }

    public void toCPC() {
        this.toCPC = !this.toCPC;
        this.repaint();
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16 && !this.rect) {
            this.oldRect = false;
            this.rect = true;
            if (this.toDrag) {
                this.drag = true;
                this.repaint();
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public static void main(String[] args) {
        Frame applet = new Frame("Mandelbrot");
        Mandel3 mandel = new Mandel3();
        applet.add(mandel);
        applet.setSize(320, 200);
        applet.setVisible(true);
        mandel.init();
    }
}

