/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import jemu.core.device.sound.AY_3_8910;
import jemu.settings.Settings;
import jemu.ui.Switches;

public class VolumeDiagram
extends JPanel
implements MouseMotionListener {
    private JLabel level;
    final Color spot = new Color(255, 0, 0, 128);
    protected Color choosenspot = new Color(255, 0, 0);
    protected Color choosentext = new Color(255, 0, 0);
    protected Color last = new Color(160, 160, 255, 160);
    BufferedImage bout;
    BufferedImage glossy;
    protected diagram dia;
    int choosen = 0;
    int puls = 0;
    int pulsdirection = 15;
    int spotR = 0;
    int spotpulsR = 2;
    int spotG = 0;
    int spotpulsG = 4;
    int spotB = 0;
    int spotpulsB = 6;
    double[] volumes;
    double[] lastvolumes;
    boolean lastchoosen;
    int xalt;
    int v;
    int yalt;
    public boolean lock = true;
    public boolean change = false;
    ActionListener update = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (VolumeDiagram.this.level.isShowing()) {
                VolumeDiagram.this.pulseColor();
                VolumeDiagram.this.pulseTextColor();
                VolumeDiagram.this.level.repaint();
            }
        }
    };
    Timer fireUpdate = new Timer(16, this.update);

    public VolumeDiagram() {
        this.level = new JLabel(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(VolumeDiagram.this.dia.getDisplay(), 0, 0, this);
            }
        };
        this.setMaximumSize(new Dimension(313, 100));
        this.setMinimumSize(new Dimension(313, 100));
        this.setPreferredSize(new Dimension(313, 100));
        this.setLayout(new BorderLayout());
        this.add((Component)this.level, "Center");
        this.dia = new diagram();
        this.level.addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        this.choosen = (int)((double)x / 19.65);
        if (this.choosen > 15) {
            this.choosen = 15;
        }
        if (this.choosen < 0) {
            this.choosen = 0;
        }
    }

    public void mouseDragged(MouseEvent e) {
        int y;
        double yy;
        int x = e.getX();
        this.choosen = (int)((double)x / 19.65);
        if (this.choosen > 15) {
            this.choosen = 15;
        }
        if (this.choosen < 0) {
            this.choosen = 0;
        }
        if ((yy = (double)(y = e.getY()) / 6.667) < 0.0) {
            yy = 0.0;
        }
        if (yy > 15.0) {
            yy = 15.0;
        }
        if (this.lock) {
            if (this.choosen == 15) {
                yy = 0.0;
            }
            if (this.choosen == 0) {
                yy = 15.0;
            }
        }
        if (Switches.linear && this.choosen < 16 && this.choosen >= 0) {
            AY_3_8910.LOG_VOLUME_L[this.choosen] = 15.0 - yy;
            Settings.set("ay_volume_" + Integer.toString(this.choosen), Double.toString(AY_3_8910.LOG_VOLUME_L[this.choosen]));
        }
    }

    protected void putVolumes(double[] input) {
        if (this.volumes == null) {
            this.volumes = new double[16];
        }
        if (this.lastvolumes == null) {
            this.lastvolumes = new double[16];
            System.arraycopy(input, 0, this.lastvolumes, 0, this.volumes.length);
        }
        if (this.change) {
            this.lastchoosen = true;
            this.change = false;
            try {
                System.arraycopy(this.volumes, 0, this.lastvolumes, 0, this.volumes.length);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.arraycopy(input, 0, this.lastvolumes, 0, this.volumes.length);
            }
        }
        System.arraycopy(input, 0, this.volumes, 0, this.volumes.length);
    }

    public void pulseColor() {
        this.choosenspot = new Color(this.puls, 255, 255 - this.puls);
        this.puls += this.pulsdirection;
        if (this.puls > 255) {
            this.puls = 255;
            this.pulsdirection = -2;
        }
        if (this.puls < 1) {
            this.puls = 1;
            this.pulsdirection = 2;
        }
    }

    public void pulseTextColor() {
        this.choosentext = new Color(this.spotR, this.spotG, this.spotB);
        this.spotR += this.spotpulsR;
        this.spotG += this.spotpulsG;
        this.spotB += this.spotpulsB;
        if (this.spotR > 255) {
            this.spotR = 255;
            this.spotpulsR = -2;
        }
        if (this.spotR < 1) {
            this.spotR = 1;
            this.spotpulsR = 2;
        }
        if (this.spotG > 255) {
            this.spotG = 255;
            this.spotpulsG = -4;
        }
        if (this.spotG < 1) {
            this.spotG = 1;
            this.spotpulsG = 4;
        }
        if (this.spotB > 255) {
            this.spotB = 255;
            this.spotpulsB = -6;
        }
        if (this.spotB < 1) {
            this.spotB = 1;
            this.spotpulsB = 6;
        }
    }

    public void put() {
        URL front = this.getClass().getResource("icon/glossywindow.png");
        this.bout = new BufferedImage(313, 100, 4);
        try {
            this.glossy = ImageIO.read(front);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 16; ++i) {
            AY_3_8910.LOG_VOLUME_L[i] = Double.parseDouble(Settings.get("ay_volume_" + Integer.toString(i), "" + i));
        }
        this.fireUpdate.start();
    }

    public class diagram {
        protected BufferedImage getDisplay() {
            int x;
            int i;
            String is;
            if (VolumeDiagram.this.bout == null) {
                return new BufferedImage(1, 1, 1);
            }
            if (Switches.VSoftOutput) {
                VolumeDiagram.this.putVolumes(AY_3_8910.LOG_VOLUME_B);
                is = "AY_Emul: VSoft";
            } else if (Switches.CPCE95) {
                VolumeDiagram.this.putVolumes(AY_3_8910.LOG_VOLUME);
                is = "JavaCPC: CPCe95";
            } else if (Switches.HACKER) {
                VolumeDiagram.this.putVolumes(AY_3_8910.LOG_VOLUME_D);
                is = "AY_Emul: Hacker Kay II";
            } else if (Switches.LION) {
                VolumeDiagram.this.putVolumes(AY_3_8910.LOG_VOLUME_C);
                is = "AY_Emul: Lion17";
            } else if (Switches.linear) {
                VolumeDiagram.this.putVolumes(AY_3_8910.LOG_VOLUME_L);
                is = "JavaCPC: User defined";
            } else {
                VolumeDiagram.this.putVolumes(AY_3_8910.LOG_VOLUME_A);
                is = "AY_Emul: Hacker Kay";
            }
            Graphics g = VolumeDiagram.this.bout.getGraphics();
            g.setColor(Color.black);
            g.fillRect(0, 0, 313, 100);
            g.setColor(Color.blue);
            for (i = 0; i < 16; ++i) {
                x = 6 + i * 20;
                g.drawLine(x, 0, x, 100);
            }
            for (i = 0; i < 16; ++i) {
                int y = (194 - (int)((double)i * 12.5)) / 2;
                g.drawLine(6, y, 307, y);
            }
            if (VolumeDiagram.this.lastchoosen) {
                g.setColor(VolumeDiagram.this.last);
                VolumeDiagram.this.xalt = 3;
                VolumeDiagram.this.v = (int)(VolumeDiagram.this.lastvolumes[0] * 12.5);
                VolumeDiagram.this.yalt = (194 - VolumeDiagram.this.v) / 2;
                for (i = 0; i < 16; ++i) {
                    VolumeDiagram.this.v = (int)(VolumeDiagram.this.lastvolumes[i] * 12.5);
                    g.drawLine(6 + i * 20, (194 - VolumeDiagram.this.v) / 2, VolumeDiagram.this.xalt, VolumeDiagram.this.yalt);
                    VolumeDiagram.this.xalt = 6 + i * 20;
                    VolumeDiagram.this.yalt = (194 - VolumeDiagram.this.v) / 2;
                }
            }
            VolumeDiagram.this.xalt = 3;
            VolumeDiagram.this.v = (int)(VolumeDiagram.this.volumes[0] * 12.5);
            VolumeDiagram.this.yalt = (194 - VolumeDiagram.this.v) / 2;
            for (i = 0; i < 16; ++i) {
                g.setColor(Color.white);
                if (i == VolumeDiagram.this.choosen || i == VolumeDiagram.this.choosen + 1) {
                    g.setColor(VolumeDiagram.this.choosentext);
                }
                VolumeDiagram.this.v = (int)(VolumeDiagram.this.volumes[i] * 12.5);
                g.drawLine(6 + i * 20, (194 - VolumeDiagram.this.v) / 2, VolumeDiagram.this.xalt, VolumeDiagram.this.yalt);
                VolumeDiagram.this.xalt = 6 + i * 20;
                VolumeDiagram.this.yalt = (194 - VolumeDiagram.this.v) / 2;
            }
            g.setColor(VolumeDiagram.this.choosentext);
            if (Switches.linear) {
                g.setColor(Color.green);
            }
            g.drawString(is, 6, 12);
            g.setColor(VolumeDiagram.this.choosenspot);
            for (i = 0; i < 16; ++i) {
                if (VolumeDiagram.this.choosen == i) {
                    g.setColor(VolumeDiagram.this.choosenspot);
                    String inf = "";
                    if (VolumeDiagram.this.choosen < 10) {
                        inf = "0";
                    }
                    inf = inf + VolumeDiagram.this.choosen + " - " + VolumeDiagram.this.volumes[i];
                    g.drawString(inf, 6, 24);
                    g.setColor(VolumeDiagram.this.choosenspot);
                } else {
                    g.setColor(VolumeDiagram.this.spot);
                }
                VolumeDiagram.this.v = (int)(VolumeDiagram.this.volumes[i] * 12.5);
                x = 6 + i * 20;
                int y = (194 - VolumeDiagram.this.v) / 2;
                g.fillOval(x - 4, y - 4, 8, 8);
            }
            g.drawImage(VolumeDiagram.this.glossy, 0, 0, 313, 100, null);
            return VolumeDiagram.this.bout;
        }
    }
}

