/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.lhadecompressor.LhaDecoderInputStream;
import net.sourceforge.lhadecompressor.LhaEntry;
import net.sourceforge.lhadecompressor.LhaEntryReader;
import net.sourceforge.lhadecompressor.LhaException;

public class LhaFile {
    private RandomAccessFile raf;
    private String encoding;
    private String name;
    private List entryList;
    private Hashtable entryMap;
    private int size;
    private long pos;

    public LhaFile(File file) throws LhaException, IOException {
        this(file.getPath(), "MS932");
    }

    public LhaFile(String name) throws LhaException, IOException {
        this(name, "MS932");
    }

    public LhaFile(File file, String encoding) throws LhaException, IOException {
        this(file.getPath(), encoding);
    }

    public LhaFile(String name, String encoding) throws LhaException, IOException {
        this.raf = new RandomAccessFile(name, "r");
        this.encoding = encoding;
        this.name = name;
        this.entryList = new ArrayList();
        this.entryMap = new Hashtable();
        this.makeEntryMap();
    }

    public LhaEntry getEntry(String name) {
        return (LhaEntry)this.entryMap.get(name);
    }

    public LhaEntry getEntry(int index) {
        return (LhaEntry)this.entryList.get(index);
    }

    public InputStream getInputStream(LhaEntry entry) throws IOException {
        return new LhaDecoderInputStream(new LhaFileInputStream(this, entry), entry);
    }

    public String getName() {
        return this.name;
    }

    public Iterator entryIterator() {
        return this.entryList.iterator();
    }

    private int read(long pos, byte[] b, int off, int len) throws IOException {
        int n;
        if (pos != this.pos) {
            this.raf.seek(pos);
        }
        if ((n = this.raf.read(b, off, len)) > 0) {
            this.pos = pos + (long)n;
        }
        return n;
    }

    private int read(long pos) throws IOException {
        int n;
        if (pos != this.pos) {
            this.raf.seek(pos);
        }
        if ((n = this.raf.read()) > 0) {
            this.pos = pos + 1L;
        }
        return n;
    }

    public int size() {
        return this.size;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
    }

    private void makeEntryMap() throws LhaException, IOException {
        LhaEntry e;
        LhaEntryReader hr = new LhaEntryReader(this.encoding){

            protected int _read(byte[] b) throws IOException {
                return LhaFile.this.raf.read(b);
            }
        };
        this.size = 0;
        while ((e = hr.readHeader()) != null) {
            e.setOffset(this.raf.getFilePointer());
            this.entryList.add(e);
            this.entryMap.put(e.getFile().getPath(), e);
            ++this.size;
            int skipSize = (int)e.getCompressedSize();
            if (this.raf.skipBytes(skipSize) == skipSize) continue;
            break;
        }
    }

    private static class LhaFileInputStream
    extends InputStream {
        private LhaFile file;
        private long pos;
        private long count;

        public LhaFileInputStream(LhaFile file, LhaEntry entry) {
            if (file == null || entry == null) {
                throw new NullPointerException();
            }
            this.file = file;
            this.pos = entry.getOffset();
            this.count = entry.getCompressedSize();
        }

        public int read(byte[] b, int off, int len) throws IOException, LhaException {
            if (this.count == 0L) {
                return -1;
            }
            if ((long)len > this.count) {
                len = Integer.MAX_VALUE < this.count ? Integer.MAX_VALUE : (int)this.count;
            }
            if ((len = this.file.read(this.pos, b, off, len)) == -1) {
                throw new LhaException("premature EOF");
            }
            this.pos += (long)len;
            this.count -= (long)len;
            return len;
        }

        public int read() throws IOException, LhaException {
            if (this.count == 0L) {
                return -1;
            }
            int n = this.file.read(this.pos);
            if (n == -1) {
                throw new LhaException("premature EOF");
            }
            ++this.pos;
            --this.count;
            return n;
        }
    }
}

