/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.lhadecompressor.LhaException;
import net.sourceforge.lhadecompressor.SlidingDicDecoder;

public class LzsDecoder
extends SlidingDicDecoder {
    private static final int MAGIC = 18;
    private int matchPosition;

    public LzsDecoder(InputStream in, long originalSize) {
        super(in, originalSize, 11, 254);
    }

    protected int decodeCode() throws IOException {
        int b = this.getBits(1);
        if (b != 0) {
            return this.getBits(8);
        }
        this.matchPosition = this.getBits(11);
        return this.getBits(4) + 256;
    }

    protected int decodePosition() throws IOException {
        return this.bufferPointerEnd - this.matchPosition - 18 & this.dictionaryMask;
    }

    protected void initRead() throws LhaException, IOException {
        this.fillBitBuffer(16);
    }
}

