/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.lhadecompressor.LhaDecoder;
import net.sourceforge.lhadecompressor.LhaException;

public class NocompressDecoder
implements LhaDecoder {
    private InputStream in;
    private long originalSize;

    public NocompressDecoder(InputStream in, long originalSize) {
        this.in = in;
        this.originalSize = originalSize;
    }

    public int read(byte[] b, int off, int len) throws LhaException, IOException {
        if (len <= 0) {
            return 0;
        }
        if (this.originalSize <= 0L) {
            return -1;
        }
        int sl = len;
        while (this.originalSize > 0L && len > 0) {
            b[off++] = (byte)this.in.read();
            --this.originalSize;
            --len;
        }
        return sl - len;
    }

    public void close() {
        this.in = null;
    }
}

