/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.lhadecompressor.LhaDecoder;
import net.sourceforge.lhadecompressor.LhaException;

public abstract class SlidingDicDecoder
implements LhaDecoder {
    protected static final int OFFSET = 253;
    protected static final int UNSINGED_CHAR_MAX = 255;
    protected static final int CHAR_BIT = 8;
    protected static final int THRESHOLD = 3;
    protected static final int MAX_MATCH = 256;
    protected InputStream in;
    protected long originalSize;
    protected long decodeCount;
    protected int positionAdjust;
    protected int dictionarySize;
    protected int dictionaryMask;
    protected byte[] dictionaryBuffer;
    protected int bufferPointerBegin;
    protected int bufferPointerEnd;
    protected int bitBuffer;
    protected int subBitBuffer;
    protected int bitCount;
    protected boolean needInitialRead;

    public SlidingDicDecoder(InputStream in, long originalSize, int dictionaryBit, int positionAdjust) {
        this.in = in;
        this.originalSize = originalSize;
        this.decodeCount = 0L;
        this.positionAdjust = positionAdjust;
        this.dictionarySize = 1 << dictionaryBit;
        this.dictionaryMask = this.dictionarySize - 1;
        this.dictionaryBuffer = new byte[this.dictionarySize];
        this.bufferPointerBegin = 0;
        this.bufferPointerEnd = 0;
        this.bitBuffer = 0;
        this.subBitBuffer = 0;
        this.bitCount = 0;
        this.needInitialRead = true;
    }

    public void close() {
    }

    public int read(byte[] b, int off, int len) throws LhaException, IOException {
        if (this.needInitialRead) {
            this.initRead();
            this.needInitialRead = false;
        }
        int sl = len;
        int rs = this.bufferPointerEnd - this.bufferPointerBegin;
        if (rs < 0) {
            int bl = this.dictionarySize - this.bufferPointerBegin;
            if (bl >= len) {
                System.arraycopy(this.dictionaryBuffer, this.bufferPointerBegin, b, off, len);
                this.bufferPointerBegin += len;
                if (this.bufferPointerBegin == this.dictionarySize) {
                    this.bufferPointerBegin = 0;
                }
                return sl;
            }
            System.arraycopy(this.dictionaryBuffer, this.bufferPointerBegin, b, off, bl);
            off += bl;
            this.bufferPointerBegin = 0;
            if (this.bufferPointerEnd >= (len -= bl)) {
                System.arraycopy(this.dictionaryBuffer, 0, b, off, len);
                this.bufferPointerBegin = len;
                return sl;
            }
            if (this.bufferPointerEnd != 0) {
                System.arraycopy(this.dictionaryBuffer, 0, b, off, this.bufferPointerEnd);
                off += this.bufferPointerEnd;
                len -= this.bufferPointerEnd;
                this.bufferPointerBegin = this.bufferPointerEnd;
            }
        } else {
            if (rs >= len) {
                System.arraycopy(this.dictionaryBuffer, this.bufferPointerBegin, b, off, len);
                this.bufferPointerBegin += len;
                return sl;
            }
            if (rs != 0) {
                System.arraycopy(this.dictionaryBuffer, this.bufferPointerBegin, b, off, rs);
                off += rs;
                len -= rs;
                this.bufferPointerBegin = this.bufferPointerEnd;
            }
        }
        if (this.originalSize <= this.decodeCount) {
            int l = sl - len;
            return l > 0 ? l : -1;
        }
        while (this.decodeCount < this.originalSize && len > 0) {
            int c = this.decodeCode();
            if (c <= 255) {
                ++this.decodeCount;
                --len;
                ++this.bufferPointerBegin;
                int n = off++;
                byte by = (byte)c;
                b[n] = by;
                this.dictionaryBuffer[this.bufferPointerEnd++] = by;
                if (this.bufferPointerEnd != this.dictionarySize) continue;
                this.bufferPointerEnd = 0;
                this.bufferPointerBegin = 0;
                continue;
            }
            int matchLength = c - this.positionAdjust;
            int matchOffset = this.decodePosition();
            int matchPosition = this.bufferPointerEnd - matchOffset - 1 & this.dictionaryMask;
            this.decodeCount += (long)matchLength;
            for (int k = 0; k < matchLength; ++k) {
                byte t = (byte)(this.dictionaryBuffer[matchPosition + k & this.dictionaryMask] & 0xFF);
                this.dictionaryBuffer[this.bufferPointerEnd++] = t;
                if (len > 0) {
                    --len;
                    ++this.bufferPointerBegin;
                    if (this.bufferPointerBegin == this.dictionarySize) {
                        this.bufferPointerBegin = 0;
                    }
                    b[off++] = t;
                }
                if (this.bufferPointerEnd != this.dictionarySize) continue;
                this.bufferPointerEnd = 0;
            }
        }
        return sl - len;
    }

    protected final void fillBitBuffer(int n) throws IOException {
        while (n > this.bitCount) {
            n -= this.bitCount;
            this.bitBuffer = (this.bitBuffer << this.bitCount) + (this.subBitBuffer >>> 8 - this.bitCount);
            int c = this.in.read();
            this.subBitBuffer = c > 0 ? c : 0;
            this.bitCount = 8;
        }
        this.bitCount -= n;
        this.bitBuffer = (this.bitBuffer << n) + (this.subBitBuffer >>> 8 - n) & 0xFFFF;
        this.subBitBuffer = this.subBitBuffer << n & 0xFF;
    }

    protected final int getBits(int n) throws IOException {
        int x = this.bitBuffer >>> 16 - n;
        this.fillBitBuffer(n);
        return x;
    }

    protected abstract int decodeCode() throws IOException;

    protected abstract int decodePosition() throws IOException;

    protected abstract void initRead() throws LhaException, IOException;
}

