/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.util.ArrayList;
import org.monte.media.Codec;
import org.monte.media.Format;

public abstract class AbstractCodec
implements Codec {
    protected Format[] inputFormats;
    protected Format[] outputFormats;
    protected Format inputFormat;
    protected Format outputFormat;
    protected String name = "unnamed codec";

    public AbstractCodec(Format[] supportedInputFormats, Format[] supportedOutputFormats) {
        this.inputFormats = supportedInputFormats;
        this.outputFormats = supportedOutputFormats;
    }

    public AbstractCodec(Format[] supportedInputOutputFormats) {
        this.inputFormats = supportedInputOutputFormats;
        this.outputFormats = supportedInputOutputFormats;
    }

    public Format[] getInputFormats() {
        return (Format[])this.inputFormats.clone();
    }

    public Format[] getOutputFormats(Format input) {
        ArrayList<Format> of = new ArrayList<Format>(this.outputFormats.length);
        for (Format f : this.outputFormats) {
            of.add(input == null ? f : f.append(input));
        }
        return of.toArray(new Format[of.size()]);
    }

    public Format setInputFormat(Format f) {
        if (f != null) {
            for (Format sf : this.getInputFormats()) {
                if (!sf.matches(f)) continue;
                this.inputFormat = sf.append(f);
                return this.inputFormat;
            }
        }
        this.inputFormat = null;
        return null;
    }

    public Format setOutputFormat(Format f) {
        for (Format sf : this.getOutputFormats(f)) {
            if (!sf.matches(f)) continue;
            this.outputFormat = f;
            return sf;
        }
        this.outputFormat = null;
        return null;
    }

    public Format getInputFormat() {
        return this.inputFormat;
    }

    public Format getOutputFormat() {
        return this.outputFormat;
    }

    public String getName() {
        return this.name;
    }

    public void reset() {
    }

    public String toString() {
        String className = this.getClass().getName();
        int p = className.lastIndexOf(46);
        return className.substring(p + 1) + "{" + "inputFormat=" + this.inputFormat + ", outputFormat=" + this.outputFormat + '}';
    }
}

