/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.monte.media.FormatKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Format {
    private HashMap<FormatKey, Object> properties;

    public Format(Map<FormatKey, Object> properties) {
        for (Map.Entry<FormatKey, Object> e : properties.entrySet()) {
            if (e.getKey().isAssignable(e.getValue())) continue;
            throw new ClassCastException(e.getValue() + " must be of type " + e.getKey().getValueClass());
        }
        this.properties = new HashMap<FormatKey, Object>(properties);
    }

    public Format(Object ... p) {
        this.properties = new HashMap();
        for (int i = 0; i < p.length; i += 2) {
            FormatKey key = (FormatKey)p[i];
            if (!key.isAssignable(p[i + 1])) {
                throw new ClassCastException(key + ": " + p[i + 1] + " must be of type " + key.getValueClass());
            }
            this.properties.put(key, p[i + 1]);
        }
    }

    public <T> T get(FormatKey<T> key) {
        return (T)this.properties.get(key);
    }

    public <T> T get(FormatKey<T> key, T defaultValue) {
        return (T)(this.properties.containsKey(key) ? this.properties.get(key) : defaultValue);
    }

    public boolean containsKey(FormatKey key) {
        return this.properties.containsKey(key);
    }

    public Map<FormatKey, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<FormatKey> getKeys() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public boolean matches(Format that) {
        for (Map.Entry<FormatKey, Object> e : this.properties.entrySet()) {
            Object b;
            Object a;
            if (!that.properties.containsKey(e.getKey()) || ((a = e.getValue()) == (b = that.properties.get(e.getKey())) || a != null) && a.equals(b)) continue;
            return false;
        }
        return true;
    }

    public Format append(Format that) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>(this.properties);
        for (Map.Entry<FormatKey, Object> e : that.properties.entrySet()) {
            if (m.containsKey(e.getKey())) continue;
            m.put(e.getKey(), e.getValue());
        }
        return new Format(m);
    }

    public Format intersectKeys(FormatKey ... keys) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>();
        for (FormatKey k : keys) {
            if (!this.properties.containsKey(k)) continue;
            m.put(k, this.properties.get(k));
        }
        return new Format(m);
    }

    public Format removeKeys(FormatKey ... keys) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>(this.properties);
        for (FormatKey k : keys) {
            m.remove(k);
        }
        return new Format(m);
    }

    public Format containsKeys(FormatKey ... keys) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>(this.properties);
        for (FormatKey k : keys) {
            m.remove(k);
        }
        return new Format(m);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Format{");
        boolean isFirst = true;
        for (Map.Entry<FormatKey, Object> e : this.properties.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            buf.append(e.getKey().toString());
            buf.append(':');
            buf.append(e.getValue().toString());
        }
        buf.append('}');
        return buf.toString();
    }
}

