/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.ilbm;

import java.util.Arrays;
import org.monte.media.ilbm.ColorCycle;

public class DRNGColorCycle
extends ColorCycle {
    private int min;
    private int max;
    private boolean isEHB;
    private Cell[] ic;
    private Cell[] cells;
    private boolean isReverse;

    public DRNGColorCycle(int rate, int timeScale, int min, int max, boolean isActive, boolean isEHB, Cell[] cells) {
        super(rate, timeScale, isActive);
        this.min = min;
        this.max = max;
        this.isEHB = isEHB;
        this.cells = cells;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    private void interpolateCells(int[] rgbs) {
        this.ic = new Cell[this.max - this.min + 1];
        Arrays.sort(this.cells);
        for (int i = 0; i < this.cells.length; ++i) {
            this.ic[this.cells[i].cell - this.min] = this.cells[i];
            this.cells[i].readValue(rgbs, false);
        }
        int left = this.cells.length - 1;
        int right = 0;
        for (int i = 0; i < this.ic.length; ++i) {
            if (this.cells[right].cell == i) {
                left = right;
                right = right == this.cells.length - 1 ? 0 : right + 1;
                continue;
            }
            int levels = this.cells[left].cell < this.cells[right].cell ? this.cells[right].cell - this.cells[left].cell : this.max - this.cells[left].cell + this.cells[right].cell + 1;
            int blend = this.cells[right].cell > i + this.min ? this.cells[right].cell - (i + this.min) : this.max - (i + this.min) + this.cells[right].cell + 1;
            int lrgb = this.cells[left].value;
            int rrgb = this.cells[right].value;
            this.ic[i] = new DColorCell(i, ((lrgb & 0xFF0000) * blend + (rrgb & 0xFF0000) * (levels - blend)) / levels & 0xFF0000 | ((lrgb & 0xFF00) * blend + (rrgb & 0xFF00) * (levels - blend)) / levels & 0xFF00 | ((lrgb & 0xFF) * blend + (rrgb & 0xFF) * (levels - blend)) / levels);
        }
    }

    public void doCycle(int[] rgbs, long time) {
        block18: {
            int i;
            int tmp;
            int j;
            int i2;
            int shift;
            block19: {
                int i3;
                int tmp2;
                int j2;
                int i4;
                if (!this.isActive) break block18;
                if (this.ic == null) {
                    this.interpolateCells(rgbs);
                }
                shift = (int)(time * (long)this.rate / (long)this.timeScale / 1000L % (long)this.ic.length);
                if (!this.isReverse) break block19;
                for (i4 = 0; i4 < this.ic.length; ++i4) {
                    this.ic[i4].readValue(rgbs, false);
                }
                for (j2 = 0; j2 < shift; ++j2) {
                    tmp2 = this.ic[0].value;
                    for (i3 = 1; i3 < this.ic.length; ++i3) {
                        this.ic[i3 - 1].value = this.ic[i3].value;
                    }
                    this.ic[this.ic.length - 1].value = tmp2;
                }
                for (i4 = 0; i4 < this.ic.length; ++i4) {
                    this.ic[i4].writeValue(rgbs, false);
                }
                if (!this.isEHB) break block18;
                for (i4 = 0; i4 < this.ic.length; ++i4) {
                    this.ic[i4].readValue(rgbs, true);
                }
                for (j2 = 0; j2 < shift; ++j2) {
                    tmp2 = this.ic[0].value;
                    for (i3 = 1; i3 < this.ic.length; ++i3) {
                        this.ic[i3 - 1].value = this.ic[i3].value;
                    }
                    this.ic[this.ic.length - 1].value = tmp2;
                }
                for (i4 = 0; i4 < this.ic.length; ++i4) {
                    this.ic[i4].writeValue(rgbs, true);
                }
                break block18;
            }
            for (i2 = 0; i2 < this.ic.length; ++i2) {
                this.ic[i2].readValue(rgbs, false);
            }
            for (j = 0; j < shift; ++j) {
                tmp = this.ic[this.ic.length - 1].value;
                for (i = this.ic.length - 1; i > 0; --i) {
                    this.ic[i].value = this.ic[i - 1].value;
                }
                this.ic[0].value = tmp;
            }
            for (i2 = 0; i2 < this.ic.length; ++i2) {
                this.ic[i2].writeValue(rgbs, false);
            }
            if (this.isEHB) {
                for (i2 = 0; i2 < this.ic.length; ++i2) {
                    this.ic[i2].readValue(rgbs, true);
                }
                for (j = 0; j < shift; ++j) {
                    tmp = this.ic[this.ic.length - 1].value;
                    for (i = this.ic.length - 1; i > 0; --i) {
                        this.ic[i].value = this.ic[i - 1].value;
                    }
                    this.ic[0].value = tmp;
                }
                for (i2 = 0; i2 < this.ic.length; ++i2) {
                    this.ic[i2].writeValue(rgbs, true);
                }
            }
        }
    }

    public static class DIndexCell
    extends Cell {
        private int index;

        public DIndexCell(int cell, int index) {
            super(cell);
            this.index = index;
        }

        public void readValue(int[] rgbs, boolean isHalfbright) {
            this.value = isHalfbright ? rgbs[this.index + 32] : rgbs[this.index];
        }

        public void writeValue(int[] rgbs, boolean isHalfbright) {
            rgbs[isHalfbright ? this.index + 32 : this.index] = this.value;
        }
    }

    public static class DColorCell
    extends Cell {
        private int rgb;

        public DColorCell(int cell, int rgb) {
            super(cell);
            this.rgb = rgb;
        }

        public void readValue(int[] rgbs, boolean isHalfbright) {
            this.value = isHalfbright ? this.rgb & 0xF0F0F : this.rgb;
        }

        public void writeValue(int[] rgbs, boolean isHalfbright) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Cell
    implements Comparable<Cell> {
        protected int cell;
        protected int value;

        public Cell(int cell) {
            this.cell = cell;
        }

        public abstract void readValue(int[] var1, boolean var2);

        public abstract void writeValue(int[] var1, boolean var2);

        @Override
        public int compareTo(Cell that) {
            return this.cell - that.cell;
        }

        public boolean equals(Object o) {
            if (o instanceof Cell) {
                Cell that = (Cell)o;
                return that.cell == this.cell;
            }
            return false;
        }

        public int hashCode() {
            return this.cell;
        }
    }
}

