/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.ilbm;

import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.iff.IFFParser;
import org.monte.media.ilbm.ILBMImageReader;

public class ILBMImageReaderSpi
extends ImageReaderSpi {
    protected static final int FORM_ID = IFFParser.stringToID("FORM");
    protected static final int CAT_ID = IFFParser.stringToID("CAT ");
    protected static final int LIST_ID = IFFParser.stringToID("LIST");
    protected static final int ILBM_ID = IFFParser.stringToID("ILBM");
    protected static final int ANIM_ID = IFFParser.stringToID("ANIM");

    public ILBMImageReaderSpi() {
        super("Werner Randelshofer", "1.0", new String[]{"ILBM"}, new String[]{"ilbm", "lbm", ""}, new String[]{"image/ilbm"}, "org.monte.media.ilbm.ILBMImageReader", new Class[]{ImageInputStream.class}, null, false, null, null, null, null, false, null, null, null, null);
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (source instanceof ImageInputStream) {
            ImageInputStream in = (ImageInputStream)source;
            in.mark();
            int fileID = in.readInt();
            if (fileID != FORM_ID && fileID != CAT_ID && fileID != LIST_ID) {
                in.reset();
                return false;
            }
            int contentSize = in.readInt();
            int contentID = in.readInt();
            if (contentID != ILBM_ID && contentID != ANIM_ID) {
                in.reset();
                return false;
            }
            in.reset();
            return true;
        }
        return false;
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new ILBMImageReader(this);
    }

    public String getDescription(Locale locale) {
        return "ILBM Interleaved Bitmap";
    }
}

