/*
 * Decompiled with CFR 0.152.
 */
package org.monte.screenrecorder;

import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.swing.SwingUtilities;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Codec;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.MovieWriter;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;
import org.monte.media.avi.AVIWriter;
import org.monte.media.beans.AbstractStateModel;
import org.monte.media.color.Colors;
import org.monte.media.converter.CodecChain;
import org.monte.media.converter.ScaleImageCodec;
import org.monte.media.image.Images;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.QuickTimeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenRecorder
extends AbstractStateModel {
    private State state = State.DONE;
    public static final String ENCODING_BLACK_CURSOR = "black";
    public static final String ENCODING_WHITE_CURSOR = "white";
    private Format fileFormat;
    private Format mouseFormat;
    private Format screenFormat;
    private Format audioFormat;
    private Rectangle captureArea;
    private MovieWriter w;
    private long recordingStartTime;
    private volatile long recordingStopTime;
    private long fileStartTime;
    private ArrayBlockingQueue<Buffer> mouseCaptures;
    private ScheduledThreadPoolExecutor screenCaptureTimer;
    private ScheduledThreadPoolExecutor mouseCaptureTimer;
    private ScheduledThreadPoolExecutor audioCaptureTimer;
    private volatile Thread writerThread;
    private BufferedImage cursorImg;
    private Point cursorOffset = new Point(-8, -5);
    private final Object sync = new Object();
    private ArrayBlockingQueue<Buffer> writerQueue;
    private Codec frameEncoder;
    private Rational outputTime;
    private Rational ffrDuration;
    private ArrayList<File> recordedFiles;
    protected int videoTrack = 0;
    protected int audioTrack = 1;
    private GraphicsDevice captureDevice;
    private AudioGrabber audioGrabber;
    private ScreenGrabber screenGrabber;
    private MouseGrabber mouseGrabber;
    private ScheduledFuture audioFuture;
    private ScheduledFuture screenFuture;
    private ScheduledFuture mouseFuture;
    long counter = 0L;

    public ScreenRecorder(GraphicsConfiguration cfg) throws IOException, AWTException {
        this(cfg, null, new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, VideoFormatKeys.MimeTypeKey, "video/quicktime"}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "rle ", VideoFormatKeys.CompressorNameKey, "Animation", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.FrameRateKey, new Rational(15L, 1L)}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, ENCODING_BLACK_CURSOR, VideoFormatKeys.FrameRateKey, new Rational(30L, 1L)}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, VideoFormatKeys.EncodingKey, "twos", VideoFormatKeys.FrameRateKey, new Rational(48000L, 1L), AudioFormatKeys.SampleSizeInBitsKey, 16, AudioFormatKeys.ChannelsKey, 2, AudioFormatKeys.SampleRateKey, new Rational(48000L, 1L), AudioFormatKeys.SignedKey, true, AudioFormatKeys.ByteOrderKey, ByteOrder.BIG_ENDIAN}));
    }

    public ScreenRecorder(GraphicsConfiguration cfg, Format fileFormat, Format screenFormat, Format mouseFormat, Format audioFormat) throws IOException, AWTException {
        this(cfg, null, fileFormat, screenFormat, mouseFormat, audioFormat);
    }

    public ScreenRecorder(GraphicsConfiguration cfg, Rectangle captureArea, Format fileFormat, Format screenFormat, Format mouseFormat, Format audioFormat) throws IOException, AWTException {
        this.fileFormat = fileFormat;
        this.screenFormat = screenFormat;
        this.mouseFormat = mouseFormat;
        if (this.mouseFormat == null) {
            this.mouseFormat = new Format(VideoFormatKeys.FrameRateKey, new Rational(0L, 0L), VideoFormatKeys.EncodingKey, ENCODING_BLACK_CURSOR);
        }
        this.audioFormat = audioFormat;
        this.recordedFiles = new ArrayList();
        this.captureDevice = cfg.getDevice();
        Rectangle rectangle = this.captureArea = captureArea == null ? cfg.getBounds() : captureArea;
        if (mouseFormat != null && ((Rational)mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue() > 0) {
            this.mouseCaptures = new ArrayBlockingQueue(((Rational)mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue() * 2);
            this.cursorImg = ((String)this.mouseFormat.get(VideoFormatKeys.EncodingKey)).equals(ENCODING_BLACK_CURSOR) ? Images.toBufferedImage(Images.createImage(ScreenRecorder.class, "/org/monte/media/gui/images/Cursor.black.png")) : Images.toBufferedImage(Images.createImage(ScreenRecorder.class, "/org/monte/media/gui/images/Cursor.white.png"));
        }
    }

    protected void createMovieWriter() throws IOException {
        Codec encoder;
        File f = this.createMovieFile(this.fileFormat);
        this.recordedFiles.add(f);
        this.w = Registry.getInstance().getWriter(this.fileFormat, f);
        Rational videoRate = Rational.max((Rational)this.screenFormat.get(VideoFormatKeys.FrameRateKey), (Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey));
        this.ffrDuration = videoRate.inverse();
        Format videoInputFormat = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.WidthKey, this.captureArea.width, VideoFormatKeys.HeightKey, this.captureArea.height, VideoFormatKeys.FrameRateKey, videoRate}).append(this.screenFormat);
        Format videoOutputFormat = new Format(VideoFormatKeys.FrameRateKey, videoRate, VideoFormatKeys.MimeTypeKey, this.fileFormat.get(VideoFormatKeys.MimeTypeKey)).append(this.screenFormat).append(new Format(VideoFormatKeys.WidthKey, this.captureArea.width, VideoFormatKeys.HeightKey, this.captureArea.height));
        this.videoTrack = this.w.addTrack(videoOutputFormat);
        if (this.audioFormat != null) {
            this.audioTrack = this.w.addTrack(this.audioFormat);
        }
        if ((encoder = Registry.getInstance().getEncoder(this.w.getFormat(this.videoTrack))) == null) {
            throw new IOException("No encoder for format " + this.w.getFormat(this.videoTrack));
        }
        this.frameEncoder = encoder;
        this.frameEncoder.setInputFormat(videoInputFormat);
        this.frameEncoder.setOutputFormat(videoOutputFormat);
        if (this.frameEncoder.getOutputFormat() == null) {
            throw new IOException("Unable to encode video frames in this output format:" + videoOutputFormat);
        }
        if (!videoInputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey).matches(videoOutputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey))) {
            ScaleImageCodec sic = new ScaleImageCodec();
            sic.setInputFormat(videoInputFormat);
            sic.setOutputFormat(videoOutputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey).append(videoInputFormat));
            this.frameEncoder = new CodecChain(sic, this.frameEncoder);
        }
        if (this.screenFormat.get(VideoFormatKeys.DepthKey) == 8) {
            if (this.w instanceof AVIWriter) {
                AVIWriter aviw = (AVIWriter)this.w;
                aviw.setPalette(this.videoTrack, Colors.createMacColors());
            } else if (this.w instanceof QuickTimeWriter) {
                QuickTimeWriter qtw = (QuickTimeWriter)this.w;
                qtw.setVideoColorTable(this.videoTrack, Colors.createMacColors());
            }
        }
        this.fileStartTime = System.currentTimeMillis();
    }

    public List<File> getCreatedMovieFiles() {
        return Collections.unmodifiableList(this.recordedFiles);
    }

    protected File createMovieFile(Format fileFormat) throws IOException {
        File folder = System.getProperty("os.name").toLowerCase().startsWith("windows") ? new File(System.getProperty("user.home") + File.separator + "Videos") : new File(System.getProperty("user.home") + File.separator + "Movies");
        if (!folder.exists()) {
            folder.mkdirs();
        } else if (!folder.isDirectory()) {
            throw new IOException("\"" + folder + "\" is not a directory.");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH.mm.ss");
        File f = new File(folder, "ScreenRecording " + dateFormat.format(new Date()) + "." + Registry.getInstance().getExtension(fileFormat));
        return f;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State newValue) {
        this.state = newValue;
        this.fireStateChanged();
    }

    public void start() throws IOException {
        this.stop();
        this.createMovieWriter();
        this.recordedFiles.clear();
        this.recordingStartTime = System.currentTimeMillis();
        this.recordingStopTime = Long.MAX_VALUE;
        this.outputTime = new Rational(0L, 0L);
        this.startWriter();
        try {
            this.startScreenCapture();
        }
        catch (AWTException e) {
            IOException ioe = new IOException("Start screen capture failed");
            ioe.initCause(e);
            this.stop();
            throw ioe;
        }
        catch (IOException ioe) {
            this.stop();
            throw ioe;
        }
        if (this.mouseFormat != null && ((Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue() > 0) {
            this.startMouseCapture();
        }
        if (this.audioFormat != null) {
            try {
                this.startAudioCapture();
            }
            catch (LineUnavailableException e) {
                IOException ioe = new IOException("Start audio capture failed");
                ioe.initCause(e);
                this.stop();
                throw ioe;
            }
        }
        this.setState(State.RECORDING);
    }

    private void startScreenCapture() throws AWTException, IOException {
        this.screenCaptureTimer = new ScheduledThreadPoolExecutor(1);
        int delay = Math.max(1, (int)(1000.0 / ((Rational)this.screenFormat.get(VideoFormatKeys.FrameRateKey)).doubleValue()));
        this.screenGrabber = new ScreenGrabber(this, this.recordingStartTime);
        this.screenFuture = this.screenCaptureTimer.scheduleAtFixedRate(this.screenGrabber, delay, delay, TimeUnit.MILLISECONDS);
        this.screenGrabber.setFuture(this.screenFuture);
    }

    private void startMouseCapture() {
        this.mouseCaptureTimer = new ScheduledThreadPoolExecutor(1);
        int delay = Math.max(1, (int)(1000.0 / ((Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey)).doubleValue()));
        this.mouseGrabber = new MouseGrabber(this, this.recordingStartTime, this.mouseCaptureTimer);
        this.mouseFuture = this.mouseCaptureTimer.scheduleAtFixedRate(this.mouseGrabber, delay, delay, TimeUnit.MILLISECONDS);
        this.mouseGrabber.setFuture(this.mouseFuture);
    }

    private void startAudioCapture() throws LineUnavailableException {
        this.audioCaptureTimer = new ScheduledThreadPoolExecutor(1);
        int delay = 500;
        this.audioGrabber = new AudioGrabber(this.audioFormat, this.audioTrack, this.recordingStartTime, this.writerQueue);
        this.audioFuture = this.audioCaptureTimer.scheduleWithFixedDelay(this.audioGrabber, 0L, 10L, TimeUnit.MILLISECONDS);
        this.audioGrabber.setFuture(this.audioFuture);
    }

    private void startWriter() {
        this.writerQueue = new ArrayBlockingQueue(Math.max(((Rational)this.screenFormat.get(VideoFormatKeys.FrameRateKey)).intValue(), ((Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue()) + 1);
        this.writerThread = new Thread(){

            public void run() {
                try {
                    while (ScreenRecorder.this.writerThread == this || !ScreenRecorder.this.writerQueue.isEmpty()) {
                        try {
                            Buffer buf = (Buffer)ScreenRecorder.this.writerQueue.take();
                            ScreenRecorder.this.doWrite(buf);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    ScreenRecorder.this.recordingFailed();
                }
            }
        };
        this.writerThread.start();
    }

    private void recordingFailed() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ScreenRecorder.this.stop();
                    ScreenRecorder.this.setState(State.FAILED);
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        });
    }

    public void stop() throws IOException {
        if (this.state == State.RECORDING) {
            block23: {
                this.recordingStopTime = System.currentTimeMillis();
                if (this.mouseCaptureTimer != null) {
                    this.mouseGrabber.setStopTime(this.recordingStopTime);
                }
                if (this.screenCaptureTimer != null) {
                    this.screenGrabber.setStopTime(this.recordingStopTime);
                }
                if (this.audioCaptureTimer != null) {
                    this.audioGrabber.setStopTime(this.recordingStopTime);
                }
                try {
                    if (this.mouseCaptureTimer != null) {
                        try {
                            this.mouseFuture.get();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        this.mouseCaptureTimer.shutdown();
                        this.mouseCaptureTimer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                        this.mouseCaptureTimer = null;
                        this.mouseGrabber.close();
                        this.mouseGrabber = null;
                    }
                    if (this.screenCaptureTimer != null) {
                        try {
                            this.screenFuture.get();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        this.screenCaptureTimer.shutdown();
                        this.screenCaptureTimer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                        this.screenCaptureTimer = null;
                        this.screenGrabber.close();
                        this.screenGrabber = null;
                    }
                    if (this.audioCaptureTimer == null) break block23;
                    try {
                        this.audioFuture.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    this.audioCaptureTimer.shutdown();
                    this.audioCaptureTimer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                    this.audioCaptureTimer = null;
                    this.audioGrabber.close();
                    this.audioGrabber = null;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Thread pendingWriterThread = this.writerThread;
            this.writerThread = null;
            try {
                if (pendingWriterThread != null) {
                    pendingWriterThread.interrupt();
                    pendingWriterThread.join();
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.w.close();
            this.w = null;
            this.setState(State.DONE);
        }
    }

    protected void write(Buffer buf) throws IOException, InterruptedException {
        MovieWriter writer = this.w;
        if (writer == null) {
            return;
        }
        if (buf.track == this.videoTrack) {
            if (!writer.getFormat(this.videoTrack).get(VideoFormatKeys.FixedFrameRateKey, false).booleanValue()) {
                Buffer wbuf = new Buffer();
                this.frameEncoder.process(buf, wbuf);
                this.writerQueue.put(wbuf);
            } else {
                Rational inputTime = buf.timeStamp.add(buf.sampleDuration);
                boolean isFirst = true;
                while (this.outputTime.compareTo(inputTime) < 0) {
                    buf.timeStamp = this.outputTime;
                    buf.sampleDuration = this.ffrDuration;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buf.setFlag(BufferFlag.SAME_DATA);
                    }
                    Buffer wbuf = new Buffer();
                    if (this.frameEncoder.process(buf, wbuf) != 0) {
                        throw new IOException("Codec failed or could not process frame in a single step.");
                    }
                    this.writerQueue.put(wbuf);
                    this.outputTime = this.outputTime.add(this.ffrDuration);
                }
            }
        } else {
            Buffer wbuf = new Buffer();
            wbuf.setMetaTo(buf);
            wbuf.data = ((byte[])buf.data).clone();
            wbuf.length = buf.length;
            wbuf.offset = buf.offset;
            this.writerQueue.put(wbuf);
        }
    }

    private void doWrite(Buffer buf) throws IOException {
        MovieWriter mw = this.w;
        mw.write(buf.track, buf);
        long now = System.currentTimeMillis();
        if (mw.isDataLimitReached() || now - this.fileStartTime > 3600000L) {
            final MovieWriter closingWriter = mw;
            new Thread(){

                public void run() {
                    try {
                        closingWriter.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }.start();
            this.createMovieWriter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AudioGrabber
    implements Runnable {
        private final TargetDataLine line;
        private final BlockingQueue<Buffer> queue;
        private final Format audioFormat;
        private final int audioTrack;
        private final long startTime;
        private volatile long stopTime = Long.MAX_VALUE;
        private long totalSampleCount;
        private ScheduledFuture future;
        private long sequenceNumber;

        public AudioGrabber(Format audioFormat, int audioTrack, long startTime, BlockingQueue<Buffer> queue) throws LineUnavailableException {
            this.audioFormat = audioFormat;
            this.audioTrack = audioTrack;
            this.queue = queue;
            this.startTime = startTime;
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, AudioFormatKeys.toAudioFormat(audioFormat));
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.open();
            this.line.start();
        }

        public void setFuture(ScheduledFuture future) {
            this.future = future;
        }

        public void close() {
            this.line.close();
        }

        public synchronized void setStopTime(long newValue) {
            this.stopTime = newValue;
        }

        public synchronized long getStopTime() {
            return this.stopTime;
        }

        @Override
        public void run() {
            Buffer buf = new Buffer();
            AudioFormat lineFormat = this.line.getFormat();
            buf.format = AudioFormatKeys.fromAudioFormat(lineFormat);
            int bufferSize = lineFormat.getFrameSize() * (int)lineFormat.getSampleRate();
            if (((int)lineFormat.getSampleRate() & 1) == 0) {
                bufferSize /= 2;
            }
            byte[] bdat = new byte[bufferSize];
            buf.data = bdat;
            Rational sampleRate = Rational.valueOf(lineFormat.getSampleRate());
            Rational frameRate = Rational.valueOf(lineFormat.getFrameRate());
            int count = this.line.read(bdat, 0, bdat.length);
            if (count > 0) {
                buf.sampleCount = count / (lineFormat.getSampleSizeInBits() / 8 * lineFormat.getChannels());
                buf.sampleDuration = sampleRate.inverse();
                buf.offset = 0;
                buf.sequenceNumber = this.sequenceNumber++;
                buf.length = count;
                buf.track = this.audioTrack;
                buf.timeStamp = new Rational(this.totalSampleCount, 1L).divide(frameRate);
                Rational stopTS = new Rational(this.getStopTime() - this.startTime, 1000L);
                if (buf.timeStamp.add(buf.sampleDuration.multiply(buf.sampleCount)).compareTo(stopTS) > 0) {
                    buf.sampleCount = Math.max(0, (int)Math.ceil(stopTS.subtract(buf.timeStamp).divide(buf.sampleDuration).floatValue()));
                    buf.length = buf.sampleCount * (lineFormat.getSampleSizeInBits() / 8 * lineFormat.getChannels());
                    this.future.cancel(false);
                }
                if (buf.sampleCount > 0) {
                    try {
                        this.queue.put(buf);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.totalSampleCount += (long)buf.sampleCount;
            }
        }
    }

    private static class MouseGrabber
    implements Runnable {
        private Point prevCapturedMouseLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        private ScheduledThreadPoolExecutor timer;
        private ScreenRecorder recorder;
        private GraphicsDevice captureDevice;
        private Rectangle captureArea;
        private BlockingQueue<Buffer> mouseCaptures;
        private volatile long stopTime = Long.MAX_VALUE;
        private long startTime;
        private Format format;
        private ScheduledFuture future;

        public MouseGrabber(ScreenRecorder recorder, long startTime, ScheduledThreadPoolExecutor timer) {
            this.timer = timer;
            this.format = recorder.mouseFormat;
            this.captureDevice = recorder.captureDevice;
            this.captureArea = recorder.captureArea;
            this.mouseCaptures = recorder.mouseCaptures;
            this.startTime = startTime;
        }

        public void setFuture(ScheduledFuture future) {
            this.future = future;
        }

        public void run() {
            try {
                this.grabMouse();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.timer.shutdown();
                this.recorder.recordingFailed();
            }
        }

        public synchronized void setStopTime(long newValue) {
            this.stopTime = newValue;
        }

        public synchronized long getStopTime() {
            return this.stopTime;
        }

        private void grabMouse() throws InterruptedException {
            long now = System.currentTimeMillis();
            if (now > this.getStopTime()) {
                this.future.cancel(false);
                return;
            }
            PointerInfo info = MouseInfo.getPointerInfo();
            Point p = info.getLocation();
            if (!info.getDevice().equals(this.captureDevice) || !this.captureArea.contains(p)) {
                p.setLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            if (!p.equals(this.prevCapturedMouseLocation)) {
                Buffer buf = new Buffer();
                buf.format = this.format;
                buf.timeStamp = new Rational(now, 1000L);
                buf.data = p;
                this.mouseCaptures.put(buf);
                this.prevCapturedMouseLocation.setLocation(p);
            }
        }

        public void close() {
        }
    }

    private static class ScreenGrabber
    implements Runnable {
        private Point prevDrawnMouseLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        private BufferedImage screenCapture;
        private ScreenRecorder recorder;
        private ScheduledThreadPoolExecutor screenTimer;
        private Robot robot;
        private Rectangle captureArea;
        private BufferedImage videoImg;
        private Graphics2D videoGraphics;
        private final Format mouseFormat;
        private ArrayBlockingQueue<Buffer> mouseCaptures;
        private Rational prevScreenCaptureTime;
        private final Object sync;
        private BufferedImage cursorImg;
        private Point cursorOffset;
        private int videoTrack;
        private long startTime;
        private volatile long stopTime = Long.MAX_VALUE;
        private ScheduledFuture future;
        private long sequenceNumber;

        public void setFuture(ScheduledFuture future) {
            this.future = future;
        }

        public synchronized void setStopTime(long newValue) {
            this.stopTime = newValue;
        }

        public synchronized long getStopTime() {
            return this.stopTime;
        }

        public ScreenGrabber(ScreenRecorder recorder, long startTime) throws AWTException, IOException {
            this.recorder = recorder;
            this.captureArea = recorder.captureArea;
            this.robot = new Robot(recorder.captureDevice);
            this.mouseFormat = recorder.mouseFormat;
            this.mouseCaptures = recorder.mouseCaptures;
            this.sync = recorder.sync;
            this.cursorImg = recorder.cursorImg;
            this.cursorOffset = recorder.cursorOffset;
            this.videoTrack = recorder.videoTrack;
            this.prevScreenCaptureTime = new Rational(startTime, 1000L);
            this.startTime = startTime;
            Format screenFormat = recorder.screenFormat;
            if (screenFormat.get(VideoFormatKeys.DepthKey, 24) == 24) {
                this.videoImg = new BufferedImage(this.captureArea.width, this.captureArea.height, 1);
            } else if (screenFormat.get(VideoFormatKeys.DepthKey) == 16) {
                this.videoImg = new BufferedImage(this.captureArea.width, this.captureArea.height, 9);
            } else if (screenFormat.get(VideoFormatKeys.DepthKey) == 8) {
                this.videoImg = new BufferedImage(this.captureArea.width, this.captureArea.height, 13, Colors.createMacColors());
            } else {
                throw new IOException("Unsupported color depth " + screenFormat.get(VideoFormatKeys.DepthKey));
            }
            this.videoGraphics = this.videoImg.createGraphics();
            this.videoGraphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            this.videoGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            this.videoGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }

        public void run() {
            try {
                this.grabScreen();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.screenTimer.shutdown();
                this.recorder.recordingFailed();
            }
        }

        private void grabScreen() throws IOException, InterruptedException {
            BufferedImage previousScreenCapture = this.screenCapture;
            long timeBeforeCapture = System.currentTimeMillis();
            try {
                this.screenCapture = this.robot.createScreenCapture(this.captureArea);
            }
            catch (IllegalMonitorStateException e) {
                return;
            }
            long timeAfterCapture = System.currentTimeMillis();
            if (previousScreenCapture == null) {
                previousScreenCapture = this.screenCapture;
            }
            this.videoGraphics.drawImage((Image)previousScreenCapture, 0, 0, null);
            Buffer buf = new Buffer();
            buf.format = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "image"});
            boolean hasMouseCapture = false;
            if (this.mouseFormat != null && ((Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue() > 0) {
                while (!this.mouseCaptures.isEmpty() && this.mouseCaptures.peek().timeStamp.compareTo(new Rational(timeAfterCapture, 1000L)) < 0) {
                    Buffer mouseCapture = this.mouseCaptures.poll();
                    if (mouseCapture.timeStamp.compareTo(this.prevScreenCaptureTime) <= 0) continue;
                    if (mouseCapture.timeStamp.compareTo(new Rational(timeBeforeCapture, 1000L)) < 0) {
                        previousScreenCapture = this.screenCapture;
                        this.videoGraphics.drawImage((Image)previousScreenCapture, 0, 0, null);
                    }
                    Point mcp = (Point)mouseCapture.data;
                    this.prevDrawnMouseLocation.setLocation(mcp.x - this.captureArea.x, mcp.y - this.captureArea.y);
                    Point p = this.prevDrawnMouseLocation;
                    long localStopTime = this.getStopTime();
                    if (mouseCapture.timeStamp.compareTo(new Rational(localStopTime, 1000L)) > 0) break;
                    hasMouseCapture = true;
                    this.videoGraphics.drawImage((Image)this.cursorImg, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, null);
                    buf.clearFlags();
                    buf.data = this.videoImg;
                    buf.sampleDuration = mouseCapture.timeStamp.subtract(this.prevScreenCaptureTime);
                    buf.timeStamp = this.prevScreenCaptureTime.subtract(new Rational(this.startTime, 1000L));
                    buf.track = this.videoTrack;
                    ++this.sequenceNumber;
                    buf.sequenceNumber = buf.sequenceNumber;
                    buf.header = p.x == Integer.MAX_VALUE ? null : p;
                    this.recorder.write(buf);
                    this.prevScreenCaptureTime = mouseCapture.timeStamp;
                    this.videoGraphics.drawImage(previousScreenCapture, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, null);
                }
                if (!hasMouseCapture && this.prevScreenCaptureTime.compareTo(new Rational(this.getStopTime(), 1000L)) < 0) {
                    Point p = this.prevDrawnMouseLocation;
                    if (p != null) {
                        this.videoGraphics.drawImage((Image)this.cursorImg, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, null);
                    }
                    buf.data = this.videoImg;
                    buf.sampleDuration = new Rational(timeAfterCapture, 1000L).subtract(this.prevScreenCaptureTime);
                    buf.timeStamp = this.prevScreenCaptureTime.subtract(new Rational(this.startTime, 1000L));
                    buf.track = this.videoTrack;
                    buf.sequenceNumber = this.sequenceNumber++;
                    buf.header = p.x == Integer.MAX_VALUE ? null : p;
                    this.recorder.write(buf);
                    this.prevScreenCaptureTime = new Rational(timeAfterCapture, 1000L);
                    if (p != null) {
                        this.videoGraphics.drawImage(previousScreenCapture, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, null);
                    }
                }
            } else if (this.prevScreenCaptureTime.compareTo(new Rational(this.getStopTime(), 1000L)) < 0) {
                buf.data = this.videoImg;
                buf.sampleDuration = new Rational(timeAfterCapture, 1000L).subtract(this.prevScreenCaptureTime);
                buf.timeStamp = this.prevScreenCaptureTime.subtract(new Rational(this.startTime, 1000L));
                buf.track = this.videoTrack;
                buf.sequenceNumber = this.sequenceNumber++;
                buf.header = null;
                this.recorder.write(buf);
                this.prevScreenCaptureTime = new Rational(timeAfterCapture, 1000L);
            }
            if (timeBeforeCapture > this.getStopTime()) {
                this.future.cancel(false);
            }
        }

        public void close() {
            this.videoGraphics.dispose();
            this.videoImg.flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        DONE,
        FAILED,
        RECORDING;

    }
}

