/*
 * Decompiled with CFR 0.152.
 */
package tiled.core;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.Properties;
import tiled.core.LayerLockedException;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.Tile;

public class TileLayer
extends MapLayer {
    protected Tile[][] map;
    protected HashMap tileInstanceProperties = new HashMap();

    public Properties getTileInstancePropertiesAt(int x, int y) {
        if (!this.bounds.contains(x, y)) {
            return null;
        }
        Point key = new Point(x, y);
        return (Properties)this.tileInstanceProperties.get(key);
    }

    public void setTileInstancePropertiesAt(int x, int y, Properties tip) {
        if (this.bounds.contains(x, y)) {
            Point key = new Point(x, y);
            this.tileInstanceProperties.put(key, tip);
        }
    }

    public TileLayer() {
    }

    public TileLayer(int w, int h) {
        super(w, h);
    }

    public TileLayer(Rectangle r) {
        super(r);
    }

    TileLayer(Map m) {
        super(m);
    }

    public TileLayer(Map m, int w, int h) {
        super(w, h);
        this.setMap(m);
    }

    public void rotate(int angle) {
        Tile[][] trans;
        int xtrans = 0;
        int ytrans = 0;
        if (!this.canEdit()) {
            return;
        }
        switch (angle) {
            case 90: {
                trans = new Tile[this.bounds.width][this.bounds.height];
                xtrans = this.bounds.height - 1;
                break;
            }
            case 180: {
                trans = new Tile[this.bounds.height][this.bounds.width];
                xtrans = this.bounds.width - 1;
                ytrans = this.bounds.height - 1;
                break;
            }
            case 270: {
                trans = new Tile[this.bounds.width][this.bounds.height];
                ytrans = this.bounds.width - 1;
                break;
            }
            default: {
                System.out.println("Unsupported rotation (" + angle + ")");
                return;
            }
        }
        double ra = Math.toRadians(angle);
        int cos_angle = (int)Math.round(Math.cos(ra));
        int sin_angle = (int)Math.round(Math.sin(ra));
        for (int y = 0; y < this.bounds.height; ++y) {
            for (int x = 0; x < this.bounds.width; ++x) {
                int xrot = x * cos_angle - y * sin_angle;
                int yrot = x * sin_angle + y * cos_angle;
                trans[yrot + ytrans][xrot + xtrans] = this.getTileAt(x + this.bounds.x, y + this.bounds.y);
            }
        }
        this.bounds.width = trans[0].length;
        this.bounds.height = trans.length;
        this.map = trans;
    }

    public void mirror(int dir) {
        if (!this.canEdit()) {
            return;
        }
        Tile[][] mirror = new Tile[this.bounds.height][this.bounds.width];
        for (int y = 0; y < this.bounds.height; ++y) {
            for (int x = 0; x < this.bounds.width; ++x) {
                mirror[y][x] = dir == 2 ? this.map[this.bounds.height - 1 - y][x] : this.map[y][this.bounds.width - 1 - x];
            }
        }
        this.map = mirror;
    }

    public boolean isUsed(Tile t) {
        for (int y = 0; y < this.bounds.height; ++y) {
            for (int x = 0; x < this.bounds.width; ++x) {
                if (this.map[y][x] != t) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        for (int p = 0; p < 2; ++p) {
            for (int y = 0; y < this.bounds.height; ++y) {
                for (int x = p; x < this.bounds.width; x += 2) {
                    if (this.map[y][x] == null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.map = new Tile[bounds.height][bounds.width];
        if (this.tileInstanceProperties != null) {
            this.tileInstanceProperties.clear();
        }
    }

    public MapLayer createDiff(MapLayer ml) {
        if (ml == null) {
            return null;
        }
        if (ml instanceof TileLayer) {
            Rectangle r = null;
            for (int y = this.bounds.y; y < this.bounds.height + this.bounds.y; ++y) {
                for (int x = this.bounds.x; x < this.bounds.width + this.bounds.x; ++x) {
                    if (((TileLayer)ml).getTileAt(x, y) == this.getTileAt(x, y)) continue;
                    if (r != null) {
                        r.add(x, y);
                        continue;
                    }
                    r = new Rectangle(new Point(x, y));
                }
            }
            if (r != null) {
                TileLayer diff = new TileLayer(new Rectangle(r.x, r.y, r.width + 1, r.height + 1));
                ((MapLayer)diff).copyFrom(ml);
                return diff;
            }
            return new TileLayer();
        }
        return null;
    }

    public void removeTile(Tile tile) throws LayerLockedException {
        if (this.getLocked()) {
            throw new LayerLockedException("Attempted to remove tile when this layer is locked.");
        }
        for (int y = 0; y < this.bounds.height; ++y) {
            for (int x = 0; x < this.bounds.width; ++x) {
                if (this.map[y][x] != tile) continue;
                this.setTileAt(x + this.bounds.x, y + this.bounds.y, null);
            }
        }
    }

    public void setTileAt(int tx, int ty, Tile ti) {
        if (this.bounds.contains(tx, ty) && this.canEdit()) {
            this.map[ty - this.bounds.y][tx - this.bounds.x] = ti;
        }
    }

    public Tile getTileAt(int tx, int ty) {
        return this.bounds.contains(tx, ty) ? this.map[ty - this.bounds.y][tx - this.bounds.x] : null;
    }

    public Point locationOf(Tile t) {
        for (int y = this.bounds.y; y < this.bounds.height + this.bounds.y; ++y) {
            for (int x = this.bounds.x; x < this.bounds.width + this.bounds.x; ++x) {
                if (this.getTileAt(x, y) != t) continue;
                return new Point(x, y);
            }
        }
        return null;
    }

    public void replaceTile(Tile find, Tile replace) {
        if (!this.canEdit()) {
            return;
        }
        for (int y = this.bounds.y; y < this.bounds.y + this.bounds.height; ++y) {
            for (int x = this.bounds.x; x < this.bounds.x + this.bounds.width; ++x) {
                if (this.getTileAt(x, y) != find) continue;
                this.setTileAt(x, y, replace);
            }
        }
    }

    public void mergeOnto(MapLayer other) {
        if (!other.canEdit()) {
            return;
        }
        for (int y = this.bounds.y; y < this.bounds.y + this.bounds.height; ++y) {
            for (int x = this.bounds.x; x < this.bounds.x + this.bounds.width; ++x) {
                Tile tile = this.getTileAt(x, y);
                if (tile == null) continue;
                ((TileLayer)other).setTileAt(x, y, tile);
            }
        }
    }

    public void maskedMergeOnto(MapLayer other, Area mask) {
        if (!this.canEdit()) {
            return;
        }
        Rectangle boundBox = mask.getBounds();
        for (int y = boundBox.y; y < boundBox.y + boundBox.height; ++y) {
            for (int x = boundBox.x; x < boundBox.x + boundBox.width; ++x) {
                Tile tile = ((TileLayer)other).getTileAt(x, y);
                if (!mask.contains(x, y) || tile == null) continue;
                this.setTileAt(x, y, tile);
            }
        }
    }

    public void copyFrom(MapLayer other) {
        if (!this.canEdit()) {
            return;
        }
        for (int y = this.bounds.y; y < this.bounds.y + this.bounds.height; ++y) {
            for (int x = this.bounds.x; x < this.bounds.x + this.bounds.width; ++x) {
                this.setTileAt(x, y, ((TileLayer)other).getTileAt(x, y));
            }
        }
    }

    public void maskedCopyFrom(MapLayer other, Area mask) {
        if (!this.canEdit()) {
            return;
        }
        Rectangle boundBox = mask.getBounds();
        for (int y = boundBox.y; y < boundBox.y + boundBox.height; ++y) {
            for (int x = boundBox.x; x < boundBox.x + boundBox.width; ++x) {
                if (!mask.contains(x, y)) continue;
                this.setTileAt(x, y, ((TileLayer)other).getTileAt(x, y));
            }
        }
    }

    public void copyTo(MapLayer other) {
        if (!other.canEdit()) {
            return;
        }
        for (int y = this.bounds.y; y < this.bounds.y + this.bounds.height; ++y) {
            for (int x = this.bounds.x; x < this.bounds.x + this.bounds.width; ++x) {
                ((TileLayer)other).setTileAt(x, y, this.getTileAt(x, y));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TileLayer clone = (TileLayer)super.clone();
        clone.map = new Tile[this.map.length][];
        clone.tileInstanceProperties = new HashMap();
        for (int i = 0; i < this.map.length; ++i) {
            clone.map[i] = new Tile[this.map[i].length];
            System.arraycopy(this.map[i], 0, clone.map[i], 0, this.map[i].length);
            for (int j = 0; j < this.map[i].length; ++j) {
                Properties p = this.getTileInstancePropertiesAt(i, j);
                if (p == null) continue;
                Integer key = i + j * this.bounds.width;
                clone.tileInstanceProperties.put(key, p.clone());
            }
        }
        return clone;
    }

    public void resize(int width, int height, int dx, int dy) {
        if (!this.canEdit()) {
            return;
        }
        Tile[][] newMap = new Tile[height][width];
        HashMap<Point, Properties> newTileInstanceProperties = new HashMap<Point, Properties>();
        int maxX = Math.min(width, this.bounds.width + dx);
        int maxY = Math.min(height, this.bounds.height + dy);
        for (int x = Math.max(0, dx); x < maxX; ++x) {
            for (int y = Math.max(0, dy); y < maxY; ++y) {
                newMap[y][x] = this.getTileAt(x - dx, y - dy);
                Properties tip = this.getTileInstancePropertiesAt(x - dx, y - dy);
                if (tip == null) continue;
                newTileInstanceProperties.put(new Point(x, y), tip);
            }
        }
        this.map = newMap;
        this.tileInstanceProperties = newTileInstanceProperties;
        this.bounds.width = width;
        this.bounds.height = height;
    }
}

