/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.UndoableEditSupport;
import tiled.core.Map;
import tiled.core.MapChangeListener;
import tiled.core.MapChangedEvent;
import tiled.core.MapLayer;
import tiled.core.MapObject;
import tiled.core.ObjectGroup;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;
import tiled.io.MapHelper;
import tiled.io.MapReader;
import tiled.mapeditor.Resources;
import tiled.mapeditor.actions.AddLayerAction;
import tiled.mapeditor.actions.AddObjectGroupAction;
import tiled.mapeditor.actions.CloneLayerAction;
import tiled.mapeditor.actions.CloseMapAction;
import tiled.mapeditor.actions.DeleteLayerAction;
import tiled.mapeditor.actions.ExitAction;
import tiled.mapeditor.actions.MergeAllLayersAction;
import tiled.mapeditor.actions.MergeLayerDownAction;
import tiled.mapeditor.actions.MoveLayerDownAction;
import tiled.mapeditor.actions.MoveLayerUpAction;
import tiled.mapeditor.actions.NewMapAction;
import tiled.mapeditor.actions.OpenMapAction;
import tiled.mapeditor.actions.OpenRecentAction;
import tiled.mapeditor.actions.SaveAction;
import tiled.mapeditor.actions.SaveAsAction;
import tiled.mapeditor.actions.SaveAsImageAction;
import tiled.mapeditor.brush.AbstractBrush;
import tiled.mapeditor.brush.Brush;
import tiled.mapeditor.brush.CustomBrush;
import tiled.mapeditor.brush.ShapeBrush;
import tiled.mapeditor.dialogs.AboutDialog;
import tiled.mapeditor.dialogs.BrushDialog;
import tiled.mapeditor.dialogs.ConfigurationDialog;
import tiled.mapeditor.dialogs.NewTilesetDialog;
import tiled.mapeditor.dialogs.ObjectDialog;
import tiled.mapeditor.dialogs.PluginDialog;
import tiled.mapeditor.dialogs.PropertiesDialog;
import tiled.mapeditor.dialogs.ResizeDialog;
import tiled.mapeditor.dialogs.SearchDialog;
import tiled.mapeditor.dialogs.TilesetManager;
import tiled.mapeditor.plugin.PluginClassLoader;
import tiled.mapeditor.selection.SelectionLayer;
import tiled.mapeditor.undo.AddObjectEdit;
import tiled.mapeditor.undo.MapLayerEdit;
import tiled.mapeditor.undo.MapLayerStateEdit;
import tiled.mapeditor.undo.MoveLayerEdit;
import tiled.mapeditor.undo.MoveObjectEdit;
import tiled.mapeditor.undo.RemoveObjectEdit;
import tiled.mapeditor.undo.UndoHandler;
import tiled.mapeditor.util.LayerTableModel;
import tiled.mapeditor.util.MapEventAdapter;
import tiled.mapeditor.util.TiledFileFilter;
import tiled.mapeditor.widget.BrushPreview;
import tiled.mapeditor.widget.FloatablePanel;
import tiled.mapeditor.widget.MiniMapViewer;
import tiled.mapeditor.widget.TButton;
import tiled.mapeditor.widget.TMenuItem;
import tiled.mapeditor.widget.TabbedTilesetsPane;
import tiled.mapeditor.widget.TilePalettePanel;
import tiled.util.TiledConfiguration;
import tiled.view.MapView;

public class MapEditor
implements ActionListener,
MouseListener,
MouseMotionListener,
MapChangeListener,
ListSelectionListener,
ChangeListener,
ComponentListener {
    private static final int PS_POINT = 0;
    private static final int PS_PAINT = 1;
    private static final int PS_ERASE = 2;
    private static final int PS_POUR = 3;
    private static final int PS_EYED = 4;
    private static final int PS_MARQUEE = 5;
    private static final int PS_MOVE = 6;
    private static final int PS_ADDOBJ = 7;
    private static final int PS_REMOVEOBJ = 8;
    private static final int PS_MOVEOBJ = 9;
    private static final int APP_WIDTH = 800;
    private static final int APP_HEIGHT = 600;
    private Cursor curDefault;
    private Cursor curEyed;
    public static final String version = "0.7.2";
    private Map currentMap;
    private MapView mapView;
    private final UndoHandler undoHandler;
    private final UndoableEditSupport undoSupport;
    private final MapEventAdapter mapEventAdapter;
    private final PluginClassLoader pluginLoader;
    private static final Preferences prefs = TiledConfiguration.root();
    private int currentPointerState;
    private Tile currentTile;
    private MapObject currentObject = null;
    private int currentLayer = -1;
    private boolean bMouseIsDown;
    private boolean bMouseIsDragging;
    private SelectionLayer cursorHighlight;
    private Point mousePressLocation;
    private Point mouseInitialPressLocation;
    private Point mouseLastPixelLocation;
    private Point mouseInitialScreenLocation;
    private Point moveDist;
    private int mouseButton;
    private AbstractBrush currentBrush;
    private SelectionLayer marqueeSelection;
    private MapLayer clipboardLayer;
    private float relativeMidX;
    private float relativeMidY;
    private JPanel mainPanel;
    private JPanel dataPanel;
    private JPanel statusBar;
    public JMenuBar menuBar;
    private JCheckBoxMenuItem gridMenuItem;
    private JCheckBoxMenuItem boundaryMenuItem;
    private JCheckBoxMenuItem cursorMenuItem;
    private JCheckBoxMenuItem coordinatesMenuItem;
    private JMenu recentMenu;
    private JScrollPane mapScrollPane;
    private JTable layerTable;
    private MiniMapViewer miniMap;
    private BrushPreview brushPreview;
    public JFrame appFrame;
    private JSlider opacitySlider;
    private JLabel zoomLabel;
    private JLabel tileCoordsLabel;
    private AbstractButton paintButton;
    private AbstractButton eraseButton;
    private AbstractButton pourButton;
    private AbstractButton eyedButton;
    private AbstractButton marqueeButton;
    private AbstractButton moveButton;
    private AbstractButton objectMoveButton;
    private AbstractButton objectAddButton;
    private AbstractButton objectRemoveButton;
    private TabbedTilesetsPane tabbedTilesetsPane;
    private AboutDialog aboutDialog;
    private MapLayerEdit paintEdit;
    private FloatablePanel layersPanel;
    private FloatablePanel tilesetsPanel;
    private Vector brushes = new Vector();
    private Brush eraserBrush;
    private final SaveAction saveAction;
    private final SaveAsAction saveAsAction;
    private final SaveAsImageAction saveAsImageAction;
    private final Action exitAction;
    private final Action zoomInAction;
    private final Action zoomOutAction;
    private final Action zoomNormalAction;
    private final Action rot90Action;
    private final Action rot180Action;
    private final Action rot270Action;
    private final Action flipHorAction;
    private final Action flipVerAction;
    private final Action selectAllAction;
    private final Action inverseAction;
    private final Action cancelSelectionAction;
    private final Action addLayerAction;
    private final Action cloneLayerAction;
    private final Action deleteLayerAction;
    private final Action moveLayerDownAction;
    private final Action moveLayerUpAction;
    private final Action mergeLayerDownAction;
    private final Action mergeAllLayersAction;
    private final Action addObjectGroupAction;
    private static final String IMPORT_ERROR_MSG = Resources.getString("dialog.newtileset.import.error.message");
    private static final String PANEL_TILE_PALETTE = Resources.getString("panel.tilepalette.title");
    private static final String PANEL_LAYERS = Resources.getString("panel.layers.title");
    private static final String TOOL_PAINT = Resources.getString("tool.paint.name");
    private static final String TOOL_ERASE = Resources.getString("tool.erase.name");
    private static final String TOOL_FILL = Resources.getString("tool.fill.name");
    private static final String TOOL_EYE_DROPPER = Resources.getString("tool.eyedropper.name");
    private static final String TOOL_SELECT = Resources.getString("tool.select.name");
    private static final String TOOL_MOVE_LAYER = Resources.getString("tool.movelayer.name");
    private static final String TOOL_ADD_OBJECT = Resources.getString("tool.addobject.name");
    private static final String TOOL_REMOVE_OBJECT = Resources.getString("tool.removeobject.name");
    private static final String TOOL_MOVE_OBJECT = Resources.getString("tool.moveobject.name");

    public MapEditor() {
        this.curEyed = new Cursor(1);
        this.curDefault = new Cursor(0);
        this.undoHandler = new UndoHandler(this);
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoHandler);
        this.cursorHighlight = new SelectionLayer(1, 1);
        this.cursorHighlight.select(0, 0);
        this.cursorHighlight.setVisible(prefs.getBoolean("cursorhighlight", true));
        this.mapEventAdapter = new MapEventAdapter();
        this.saveAction = new SaveAction(this);
        this.saveAsAction = new SaveAsAction(this);
        this.saveAsImageAction = new SaveAsImageAction(this);
        this.exitAction = new ExitAction(this, this.saveAction);
        this.zoomInAction = new ZoomInAction();
        this.zoomOutAction = new ZoomOutAction();
        this.zoomNormalAction = new ZoomNormalAction();
        this.rot90Action = new LayerTransformAction(90);
        this.rot180Action = new LayerTransformAction(180);
        this.rot270Action = new LayerTransformAction(270);
        this.flipHorAction = new LayerTransformAction(1);
        this.flipVerAction = new LayerTransformAction(2);
        this.selectAllAction = new SelectAllAction();
        this.cancelSelectionAction = new CancelSelectionAction();
        this.inverseAction = new InverseSelectionAction();
        this.addLayerAction = new AddLayerAction(this);
        this.cloneLayerAction = new CloneLayerAction(this);
        this.deleteLayerAction = new DeleteLayerAction(this);
        this.moveLayerUpAction = new MoveLayerUpAction(this);
        this.moveLayerDownAction = new MoveLayerDownAction(this);
        this.mergeLayerDownAction = new MergeLayerDownAction(this);
        this.mergeAllLayersAction = new MergeAllLayersAction(this);
        this.addObjectGroupAction = new AddObjectGroupAction(this);
        this.appFrame = new JFrame(Resources.getString("dialog.main.title"));
        this.appFrame.setDefaultCloseOperation(0);
        this.appFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                MapEditor.this.exitAction.actionPerformed(null);
            }
        });
        this.appFrame.setContentPane(this.createContentPane());
        this.appFrame.setUndecorated(true);
        this.createMenuBar();
        Preferences mainDialogPrefs = prefs.node("dialog/main");
        int width = mainDialogPrefs.getInt("width", 800);
        int height = mainDialogPrefs.getInt("width", 600);
        this.appFrame.setSize(width, height);
        this.setCurrentMap(null);
        this.updateRecent(null);
        this.appFrame.setVisible(false);
        int state = mainDialogPrefs.getInt("state", 0);
        if (state != 1) {
            this.appFrame.setExtendedState(state);
        }
        this.layersPanel.restore();
        this.tilesetsPanel.restore();
        this.pluginLoader = PluginClassLoader.getInstance();
        try {
            this.pluginLoader.readPlugins(null, this.appFrame);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.appFrame, e.toString(), "Plugin loader", 2);
        }
        MapHelper.init(this.pluginLoader);
        final Preferences display = prefs.node("display");
        display.addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent event) {
                if (MapEditor.this.mapView == null) {
                    return;
                }
                String key = event.getKey();
                if ("gridOpacity".equals(key)) {
                    MapEditor.this.mapView.setGridOpacity(display.getInt("gridOpacity", 255));
                } else if ("gridAntialias".equals(key)) {
                    MapEditor.this.mapView.setAntialiasGrid(display.getBoolean("gridAntialias", true));
                } else if ("gridColor".equals(key)) {
                    MapEditor.this.mapView.setGridColor(new Color(display.getInt("gridColor", MapView.DEFAULT_GRID_COLOR.getRGB())));
                } else if ("showGrid".equals(key)) {
                    MapEditor.this.mapView.setShowGrid(display.getBoolean("showGrid", false));
                }
            }
        });
    }

    private JPanel createContentPane() {
        this.mapScrollPane = new JScrollPane(22, 32);
        this.mapScrollPane.setBorder(null);
        this.createData();
        this.createStatusBar();
        this.layersPanel = new FloatablePanel(this.getAppFrame(), this.dataPanel, PANEL_LAYERS, "layers");
        JSplitPane mainSplit = new JSplitPane(1, true, this.mapScrollPane, this.layersPanel);
        mainSplit.setOneTouchExpandable(true);
        mainSplit.setResizeWeight(1.0);
        mainSplit.setBorder(null);
        this.tabbedTilesetsPane = new TabbedTilesetsPane(this);
        this.tilesetsPanel = new FloatablePanel(this.getAppFrame(), this.tabbedTilesetsPane, PANEL_TILE_PALETTE, "tilesets");
        JSplitPane paletteSplit = new JSplitPane(0, true, mainSplit, this.tilesetsPanel);
        paletteSplit.setOneTouchExpandable(true);
        paletteSplit.setResizeWeight(1.0);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.createToolBar(), "West");
        this.mainPanel.add((Component)paletteSplit, "Center");
        this.mainPanel.add((Component)this.statusBar, "South");
        return this.mainPanel;
    }

    private void createMenuBar() {
        TMenuItem save = new TMenuItem(this.saveAction);
        TMenuItem saveAs = new TMenuItem(this.saveAsAction);
        TMenuItem saveAsImage = new TMenuItem(this.saveAsImageAction);
        TMenuItem close = new TMenuItem(new CloseMapAction(this, this.saveAction));
        this.recentMenu = new JMenu(Resources.getString("menu.file.recent"));
        this.mapEventAdapter.addListener(save);
        this.mapEventAdapter.addListener(saveAs);
        this.mapEventAdapter.addListener(saveAsImage);
        this.mapEventAdapter.addListener(close);
        JMenu fileMenu = new JMenu(Resources.getString("menu.file"));
        fileMenu.add(new TMenuItem(new NewMapAction(this, this.saveAction)));
        fileMenu.add(new TMenuItem(new OpenMapAction(this, this.saveAction)));
        fileMenu.add(this.recentMenu);
        fileMenu.add(save);
        fileMenu.add(saveAs);
        fileMenu.add(saveAsImage);
        fileMenu.addSeparator();
        fileMenu.add(close);
        fileMenu.add(new TMenuItem(this.exitAction));
        TMenuItem copyMenuItem = new TMenuItem(new CopyAction());
        TMenuItem copyAllMenuItem = new TMenuItem(new CopyAllAction());
        TMenuItem cutMenuItem = new TMenuItem(new CutAction());
        TMenuItem pasteMenuItem = new TMenuItem(new PasteAction());
        copyMenuItem.setEnabled(false);
        copyAllMenuItem.setEnabled(false);
        cutMenuItem.setEnabled(false);
        pasteMenuItem.setEnabled(false);
        JMenu transformSub = new JMenu(Resources.getString("menu.edit.transform"));
        transformSub.add(new TMenuItem(this.rot90Action, true));
        transformSub.add(new TMenuItem(this.rot180Action, true));
        transformSub.add(new TMenuItem(this.rot270Action, true));
        transformSub.addSeparator();
        transformSub.add(new TMenuItem(this.flipHorAction, true));
        transformSub.add(new TMenuItem(this.flipVerAction, true));
        this.mapEventAdapter.addListener(transformSub);
        JMenu editMenu = new JMenu(Resources.getString("menu.edit"));
        editMenu.add(new TMenuItem(this.undoHandler.getUndoAction()));
        editMenu.add(new TMenuItem(this.undoHandler.getRedoAction()));
        editMenu.addSeparator();
        editMenu.add(copyMenuItem);
        editMenu.add(copyAllMenuItem);
        editMenu.add(cutMenuItem);
        editMenu.add(pasteMenuItem);
        editMenu.addSeparator();
        editMenu.add(transformSub);
        editMenu.addSeparator();
        editMenu.add(this.createMenuItem(Resources.getString("menu.edit.preferences"), null, Resources.getString("menu.edit.preferences.tooltip"), null));
        editMenu.add(this.createMenuItem(Resources.getString("menu.edit.brush"), null, Resources.getString("menu.edit.brush.tooltip"), "control B"));
        this.mapEventAdapter.addListener(copyMenuItem);
        this.mapEventAdapter.addListener(copyAllMenuItem);
        this.mapEventAdapter.addListener(cutMenuItem);
        this.mapEventAdapter.addListener(pasteMenuItem);
        JMenu mapMenu = new JMenu(Resources.getString("menu.map"));
        mapMenu.add(this.createMenuItem(Resources.getString("menu.map.resize"), null, Resources.getString("menu.map.resize.tooltip")));
        mapMenu.add(this.createMenuItem(Resources.getString("menu.map.search"), null, Resources.getString("menu.map.search.tooltip")));
        mapMenu.addSeparator();
        mapMenu.add(this.createMenuItem(Resources.getString("menu.map.properties"), null, Resources.getString("menu.map.properties.tooltip")));
        this.mapEventAdapter.addListener(mapMenu);
        JMenu layerMenu = new JMenu(Resources.getString("menu.layer"));
        TMenuItem layerAdd = new TMenuItem(this.addLayerAction);
        this.mapEventAdapter.addListener(layerAdd);
        layerMenu.add(layerAdd);
        layerMenu.add(new TMenuItem(this.cloneLayerAction));
        layerMenu.add(new TMenuItem(this.deleteLayerAction));
        layerMenu.addSeparator();
        layerMenu.add(new TMenuItem(this.addObjectGroupAction));
        layerMenu.addSeparator();
        layerMenu.add(new TMenuItem(this.moveLayerUpAction));
        layerMenu.add(new TMenuItem(this.moveLayerDownAction));
        layerMenu.addSeparator();
        layerMenu.add(new TMenuItem(this.mergeLayerDownAction));
        layerMenu.add(new TMenuItem(this.mergeAllLayersAction));
        layerMenu.addSeparator();
        layerMenu.add(this.createMenuItem(Resources.getString("menu.layer.properties"), null, Resources.getString("menu.layer.properties.tooltip")));
        JMenu tilesetMenu = new JMenu(Resources.getString("menu.tilesets"));
        tilesetMenu.add(this.createMenuItem(Resources.getString("menu.tilesets.new"), null, Resources.getString("menu.tilesets.new.tooltip")));
        tilesetMenu.add(this.createMenuItem(Resources.getString("menu.tilesets.import"), null, Resources.getString("menu.tilesets.import.tooltip")));
        tilesetMenu.addSeparator();
        tilesetMenu.add(this.createMenuItem(Resources.getString("menu.tilesets.refresh"), null, Resources.getString("menu.tilesets.refresh.tooltip"), "F5"));
        tilesetMenu.addSeparator();
        tilesetMenu.add(this.createMenuItem(Resources.getString("menu.tilesets.manager"), null, Resources.getString("menu.tilesets.manager.tooltip")));
        JMenu selectMenu = new JMenu(Resources.getString("menu.select"));
        selectMenu.add(new TMenuItem(this.selectAllAction, true));
        selectMenu.add(new TMenuItem(this.cancelSelectionAction, true));
        selectMenu.add(new TMenuItem(this.inverseAction, true));
        this.gridMenuItem = new JCheckBoxMenuItem(Resources.getString("menu.view.grid"));
        this.gridMenuItem.addActionListener(this);
        this.gridMenuItem.setToolTipText(Resources.getString("menu.view.grid.tooltip"));
        this.gridMenuItem.setAccelerator(KeyStroke.getKeyStroke("control G"));
        this.cursorMenuItem = new JCheckBoxMenuItem(Resources.getString("menu.view.cursor"));
        this.cursorMenuItem.setSelected(prefs.getBoolean("cursorhighlight", true));
        this.cursorMenuItem.addActionListener(this);
        this.cursorMenuItem.setToolTipText(Resources.getString("menu.view.cursor.tooltip"));
        this.boundaryMenuItem = new JCheckBoxMenuItem(Resources.getString("menu.view.boundaries"));
        this.boundaryMenuItem.addActionListener(this);
        this.boundaryMenuItem.setToolTipText(Resources.getString("menu.view.boundaries.tooltip"));
        this.boundaryMenuItem.setAccelerator(KeyStroke.getKeyStroke("control E"));
        this.coordinatesMenuItem = new JCheckBoxMenuItem(Resources.getString("menu.view.coordinates"));
        this.coordinatesMenuItem.addActionListener(this);
        this.coordinatesMenuItem.setToolTipText(Resources.getString("menu.view.coordinates.tooltip"));
        JMenu viewMenu = new JMenu(Resources.getString("menu.view"));
        viewMenu.add(new TMenuItem(this.zoomInAction));
        viewMenu.add(new TMenuItem(this.zoomOutAction));
        viewMenu.add(new TMenuItem(this.zoomNormalAction));
        viewMenu.addSeparator();
        viewMenu.add(this.gridMenuItem);
        viewMenu.add(this.cursorMenuItem);
        viewMenu.add(this.coordinatesMenuItem);
        this.mapEventAdapter.addListener(layerMenu);
        this.mapEventAdapter.addListener(tilesetMenu);
        this.mapEventAdapter.addListener(selectMenu);
        this.mapEventAdapter.addListener(viewMenu);
        JMenu helpMenu = new JMenu(Resources.getString("menu.help"));
        helpMenu.add(this.createMenuItem(Resources.getString("menu.help.plugins"), null, Resources.getString("menu.help.plugins.tooltip")));
        helpMenu.add(this.createMenuItem(Resources.getString("menu.help.about"), null, Resources.getString("menu.help.about.tooltip")));
        this.menuBar = new JMenuBar();
        this.menuBar.add(fileMenu);
        this.menuBar.add(editMenu);
        this.menuBar.add(selectMenu);
        this.menuBar.add(viewMenu);
        this.menuBar.add(mapMenu);
        this.menuBar.add(layerMenu);
        this.menuBar.add(tilesetMenu);
        this.menuBar.add(helpMenu);
    }

    private JToolBar createToolBar() {
        Icon iconMove = Resources.getIcon("gimp-tool-move-22.png");
        Icon iconPaint = Resources.getIcon("gimp-tool-pencil-22.png");
        Icon iconErase = Resources.getIcon("gimp-tool-eraser-22.png");
        Icon iconPour = Resources.getIcon("gimp-tool-bucket-fill-22.png");
        Icon iconEyed = Resources.getIcon("gimp-tool-color-picker-22.png");
        Icon iconMarquee = Resources.getIcon("gimp-tool-rect-select-22.png");
        Icon iconAddObject = Resources.getIcon("gnome-list-add-22.png");
        Icon iconRemoveObject = Resources.getIcon("gnome-list-remove-22.png");
        Icon iconMoveObject = Resources.getIcon("gimp-tool-object-move-22.png");
        this.paintButton = this.createToggleButton(iconPaint, "paint", TOOL_PAINT);
        this.eraseButton = this.createToggleButton(iconErase, "erase", TOOL_ERASE);
        this.pourButton = this.createToggleButton(iconPour, "pour", TOOL_FILL);
        this.eyedButton = this.createToggleButton(iconEyed, "eyed", TOOL_EYE_DROPPER);
        this.marqueeButton = this.createToggleButton(iconMarquee, "marquee", TOOL_SELECT);
        this.moveButton = this.createToggleButton(iconMove, "move", TOOL_MOVE_LAYER);
        this.objectAddButton = this.createToggleButton(iconAddObject, "addobject", TOOL_ADD_OBJECT);
        this.objectRemoveButton = this.createToggleButton(iconRemoveObject, "removeobject", TOOL_REMOVE_OBJECT);
        this.objectMoveButton = this.createToggleButton(iconMoveObject, "moveobject", TOOL_MOVE_OBJECT);
        this.mapEventAdapter.addListener(this.moveButton);
        this.mapEventAdapter.addListener(this.paintButton);
        this.mapEventAdapter.addListener(this.eraseButton);
        this.mapEventAdapter.addListener(this.pourButton);
        this.mapEventAdapter.addListener(this.eyedButton);
        this.mapEventAdapter.addListener(this.marqueeButton);
        this.mapEventAdapter.addListener(this.objectMoveButton);
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(true);
        toolBar.add(this.moveButton);
        toolBar.add(this.paintButton);
        toolBar.add(this.eraseButton);
        toolBar.add(this.pourButton);
        toolBar.add(this.eyedButton);
        toolBar.add(this.marqueeButton);
        toolBar.add(Box.createRigidArea(new Dimension(5, 5)));
        toolBar.add(this.objectAddButton);
        toolBar.add(this.objectRemoveButton);
        toolBar.add(this.objectMoveButton);
        toolBar.add(Box.createRigidArea(new Dimension(0, 5)));
        toolBar.add(new TButton(this.zoomInAction));
        toolBar.add(new TButton(this.zoomOutAction));
        toolBar.add(Box.createRigidArea(new Dimension(5, 5)));
        toolBar.add(Box.createGlue());
        this.brushPreview = new BrushPreview();
        this.mapEventAdapter.addListener(this.brushPreview);
        toolBar.add(this.brushPreview);
        return toolBar;
    }

    private void createData() {
        this.dataPanel = new JPanel(new BorderLayout());
        this.miniMap = new MiniMapViewer();
        JScrollPane miniMapSp = new JScrollPane();
        miniMapSp.getViewport().setView(this.miniMap);
        miniMapSp.setMinimumSize(new Dimension(0, 120));
        this.layerTable = new JTable(new LayerTableModel());
        this.layerTable.getColumnModel().getColumn(0).setPreferredWidth(32);
        this.layerTable.setSelectionMode(0);
        this.layerTable.getSelectionModel().addListSelectionListener(this);
        this.opacitySlider = new JSlider(0, 100, 100);
        this.opacitySlider.addChangeListener(this);
        JLabel opacityLabel = new JLabel(Resources.getString("dialog.main.opacity.label"));
        opacityLabel.setLabelFor(this.opacitySlider);
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 0));
        sliderPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        sliderPanel.add(opacityLabel);
        sliderPanel.add(this.opacitySlider);
        sliderPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, sliderPanel.getPreferredSize().height));
        TButton layerAddButton = new TButton(this.addLayerAction);
        this.mapEventAdapter.addListener(layerAddButton);
        JPanel layerButtons = new JPanel();
        layerButtons.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        layerButtons.add((Component)layerAddButton, c);
        layerButtons.add((Component)new TButton(this.moveLayerUpAction), c);
        layerButtons.add((Component)new TButton(this.moveLayerDownAction), c);
        layerButtons.add((Component)new TButton(this.cloneLayerAction), c);
        layerButtons.add((Component)new TButton(this.deleteLayerAction), c);
        layerButtons.setMaximumSize(new Dimension(Integer.MAX_VALUE, layerButtons.getPreferredSize().height));
        JPanel layerPanel = new JPanel();
        layerPanel.setLayout(new GridBagLayout());
        layerPanel.setPreferredSize(new Dimension(120, 120));
        c = new GridBagConstraints();
        c.insets = new Insets(3, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        ++c.gridy;
        layerPanel.add((Component)sliderPanel, c);
        c.weighty = 1.0;
        ++c.gridy;
        layerPanel.add((Component)new JScrollPane(this.layerTable), c);
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        layerPanel.add((Component)layerButtons, c);
        TilePalettePanel tilePalettePanel = new TilePalettePanel();
        JPanel brushesPanel = new JPanel();
        JTabbedPane paintPanel = new JTabbedPane();
        paintPanel.add("Palette", tilePalettePanel);
        paintPanel.add("Brushes", brushesPanel);
        paintPanel.setSelectedIndex(1);
        JToolBar tabsPanel = new JToolBar();
        tabsPanel.add(paintPanel);
        this.dataPanel.add(layerPanel);
    }

    private void createStatusBar() {
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new BoxLayout(this.statusBar, 0));
        this.zoomLabel = new JLabel("100%");
        this.zoomLabel.setPreferredSize(this.zoomLabel.getPreferredSize());
        this.tileCoordsLabel = new JLabel(" ", 0);
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        JPanel largePart = new JPanel();
        this.statusBar.add(largePart);
        this.statusBar.add(this.tileCoordsLabel);
        this.statusBar.add(Box.createRigidArea(new Dimension(20, 0)));
        this.statusBar.add(this.zoomLabel);
    }

    private void updateLayerTable() {
        int cl = this.currentLayer;
        if (this.layerTable.isEditing()) {
            this.layerTable.getCellEditor(this.layerTable.getEditingRow(), this.layerTable.getEditingColumn()).cancelCellEditing();
        }
        ((LayerTableModel)this.layerTable.getModel()).setMap(this.currentMap);
        if (this.currentMap != null) {
            if (this.currentMap.getTotalLayers() > 0 && cl == -1) {
                cl = 0;
            }
            this.setCurrentLayer(cl);
        }
        this.updateLayerOperations();
    }

    private void updateLayerOperations() {
        int nrLayers = 0;
        if (this.currentMap != null) {
            nrLayers = this.currentMap.getTotalLayers();
        }
        boolean validSelection = this.currentLayer >= 0;
        boolean notBottom = this.currentLayer > 0;
        boolean notTop = this.currentLayer < nrLayers - 1 && validSelection;
        boolean tileLayer = validSelection && this.getCurrentLayer() instanceof TileLayer;
        boolean objectGroup = validSelection && this.getCurrentLayer() instanceof ObjectGroup;
        this.paintButton.setEnabled(tileLayer);
        this.eraseButton.setEnabled(tileLayer);
        this.pourButton.setEnabled(tileLayer);
        this.eyedButton.setEnabled(tileLayer);
        this.marqueeButton.setEnabled(tileLayer);
        this.moveButton.setEnabled(validSelection);
        this.objectAddButton.setEnabled(objectGroup);
        this.objectRemoveButton.setEnabled(objectGroup);
        this.objectMoveButton.setEnabled(objectGroup);
        this.cloneLayerAction.setEnabled(validSelection);
        this.deleteLayerAction.setEnabled(validSelection);
        this.moveLayerUpAction.setEnabled(notTop);
        this.moveLayerDownAction.setEnabled(notBottom);
        this.mergeLayerDownAction.setEnabled(notBottom);
        this.mergeAllLayersAction.setEnabled(nrLayers > 1);
        this.opacitySlider.setEnabled(validSelection);
    }

    private JMenuItem createMenuItem(String name, Icon icon, String tt) {
        JMenuItem menuItem = new JMenuItem(name);
        menuItem.addActionListener(this);
        if (icon != null) {
            menuItem.setIcon(icon);
        }
        if (tt != null) {
            menuItem.setToolTipText(tt);
        }
        return menuItem;
    }

    private JMenuItem createMenuItem(String name, Icon icon, String tt, String keyStroke) {
        JMenuItem menuItem = this.createMenuItem(name, icon, tt);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyStroke));
        return menuItem;
    }

    private AbstractButton createToggleButton(Icon icon, String command, String tt) {
        JToggleButton button = new JToggleButton("", icon);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setActionCommand(command);
        button.addActionListener(this);
        if (tt != null) {
            button.setToolTipText(tt);
        }
        return button;
    }

    public Tile getCurrentTile() {
        return this.currentTile;
    }

    public Map getCurrentMap() {
        return this.currentMap;
    }

    public MapLayer getCurrentLayer() {
        return this.currentMap.getLayer(this.currentLayer);
    }

    public int getCurrentLayerIndex() {
        return this.currentLayer;
    }

    public UndoableEditSupport getUndoSupport() {
        return this.undoSupport;
    }

    public UndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    public PluginClassLoader getPluginLoader() {
        return this.pluginLoader;
    }

    public Frame getAppFrame() {
        return this.appFrame;
    }

    private void doMouse(MouseEvent event) {
        if (this.currentMap == null || this.currentLayer < 0) {
            return;
        }
        Point tile = this.mapView.screenToTileCoords(event.getX(), event.getY());
        MapLayer layer = this.getCurrentLayer();
        if (layer == null) {
            return;
        }
        if (this.mouseButton == 3) {
            if (layer instanceof TileLayer) {
                if (!this.bMouseIsDragging) {
                    Tile newTile = ((TileLayer)layer).getTileAt(tile.x, tile.y);
                    this.setCurrentTile(newTile);
                } else if (this.currentPointerState == 1) {
                    if (this.marqueeSelection == null) {
                        this.marqueeSelection = new SelectionLayer(this.currentMap.getWidth(), this.currentMap.getHeight());
                        this.currentMap.addLayerSpecial(this.marqueeSelection);
                    }
                    Point limp = this.mouseInitialPressLocation;
                    Rectangle oldArea = this.marqueeSelection.getSelectedAreaBounds();
                    int minx = Math.min(limp.x, tile.x);
                    int miny = Math.min(limp.y, tile.y);
                    Rectangle selRect = new Rectangle(minx, miny, Math.max(limp.x, tile.x) - minx + 1, Math.max(limp.y, tile.y) - miny + 1);
                    this.marqueeSelection.selectRegion(selRect);
                    if (oldArea != null) {
                        oldArea.add(this.marqueeSelection.getSelectedAreaBounds());
                        this.mapView.repaintRegion(oldArea);
                    }
                }
            } else if (layer instanceof ObjectGroup && !this.bMouseIsDragging) {
                ObjectGroup group = (ObjectGroup)layer;
                Point pos = this.mapView.screenToPixelCoords(event.getX(), event.getY());
                MapObject obj = group.getObjectNear(pos.x, pos.y, this.mapView.getZoom());
                if (obj != null) {
                    ObjectDialog od = new ObjectDialog(this.appFrame, obj, this.undoSupport);
                    od.getProps();
                }
            }
        } else if (this.mouseButton == 2 || this.mouseButton == 1 && (event.getModifiersEx() & 0x200) != 0) {
            int dx = event.getX() - this.mouseInitialScreenLocation.x;
            int dy = event.getY() - this.mouseInitialScreenLocation.y;
            JViewport mapViewPort = this.mapScrollPane.getViewport();
            Point currentPosition = mapViewPort.getViewPosition();
            this.mouseInitialScreenLocation = new Point(event.getX() - dx, event.getY() - dy);
            Point newPosition = new Point(currentPosition.x - dx, currentPosition.y - dy);
            int maxX = this.mapView.getWidth() - mapViewPort.getWidth();
            int maxY = this.mapView.getHeight() - mapViewPort.getHeight();
            newPosition.x = Math.min(maxX, Math.max(0, newPosition.x));
            newPosition.y = Math.min(maxY, Math.max(0, newPosition.y));
            mapViewPort.setViewPosition(newPosition);
        } else if (this.mouseButton == 1) {
            switch (this.currentPointerState) {
                case 1: {
                    this.paintEdit.setPresentationName(TOOL_PAINT);
                    if (!(layer instanceof TileLayer)) break;
                    try {
                        this.mapView.repaintRegion(this.currentBrush.doPaint(tile.x, tile.y));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    this.paintEdit.setPresentationName(TOOL_ERASE);
                    if (!(layer instanceof TileLayer)) break;
                    ((TileLayer)layer).setTileAt(tile.x, tile.y, null);
                    this.mapView.repaintRegion(new Rectangle(tile.x, tile.y, 1, 1));
                    break;
                }
                case 3: {
                    this.paintEdit = null;
                    if (!(layer instanceof TileLayer)) break;
                    TileLayer tileLayer = (TileLayer)layer;
                    Tile oldTile = tileLayer.getTileAt(tile.x, tile.y);
                    this.pour(tileLayer, tile.x, tile.y, this.currentTile, oldTile);
                    this.mapView.repaint();
                    break;
                }
                case 4: {
                    if (!(layer instanceof TileLayer)) break;
                    TileLayer tileLayer = (TileLayer)layer;
                    Tile newTile = tileLayer.getTileAt(tile.x, tile.y);
                    this.setCurrentTile(newTile);
                    break;
                }
                case 6: {
                    Point translation = new Point(tile.x - this.mousePressLocation.x, tile.y - this.mousePressLocation.y);
                    layer.translate(translation.x, translation.y);
                    this.moveDist.translate(translation.x, translation.y);
                    this.mapView.repaint();
                    break;
                }
                case 5: {
                    if (!(layer instanceof TileLayer) || this.marqueeSelection == null) break;
                    Point limp = this.mouseInitialPressLocation;
                    Rectangle oldArea = this.marqueeSelection.getSelectedAreaBounds();
                    int minx = Math.min(limp.x, tile.x);
                    int miny = Math.min(limp.y, tile.y);
                    Rectangle selRect = new Rectangle(minx, miny, Math.max(limp.x, tile.x) - minx + 1, Math.max(limp.y, tile.y) - miny + 1);
                    if (event.isShiftDown()) {
                        this.marqueeSelection.add(new Area(selRect));
                    } else if (event.isControlDown()) {
                        this.marqueeSelection.subtract(new Area(selRect));
                    } else {
                        this.marqueeSelection.selectRegion(selRect);
                    }
                    if (oldArea == null) break;
                    oldArea.add(this.marqueeSelection.getSelectedAreaBounds());
                    this.mapView.repaintRegion(oldArea);
                    break;
                }
                case 7: {
                    if (!(layer instanceof ObjectGroup)) break;
                    if (this.marqueeSelection == null) {
                        this.marqueeSelection = new SelectionLayer(this.currentMap.getWidth(), this.currentMap.getHeight());
                        this.currentMap.addLayerSpecial(this.marqueeSelection);
                    }
                    Point limp = this.mouseInitialPressLocation;
                    Rectangle oldArea = this.marqueeSelection.getSelectedAreaBounds();
                    int minx = Math.min(limp.x, tile.x);
                    int miny = Math.min(limp.y, tile.y);
                    Rectangle selRect = new Rectangle(minx, miny, Math.max(limp.x, tile.x) - minx + 1, Math.max(limp.y, tile.y) - miny + 1);
                    this.marqueeSelection.selectRegion(selRect);
                    if (oldArea == null) break;
                    oldArea.add(this.marqueeSelection.getSelectedAreaBounds());
                    this.mapView.repaintRegion(oldArea);
                    break;
                }
                case 8: {
                    if (!(layer instanceof ObjectGroup)) break;
                    ObjectGroup group = (ObjectGroup)layer;
                    Point pos = this.mapView.screenToPixelCoords(event.getX(), event.getY());
                    MapObject obj = group.getObjectNear(pos.x, pos.y, this.mapView.getZoom());
                    if (obj == null) break;
                    this.undoSupport.postEdit(new RemoveObjectEdit(group, obj));
                    group.removeObject(obj);
                    this.mapView.repaint();
                    break;
                }
                case 9: {
                    if (!(layer instanceof ObjectGroup)) break;
                    Point pos = this.mapView.screenToPixelCoords(event.getX(), event.getY());
                    if (this.currentObject == null) {
                        ObjectGroup group = (ObjectGroup)layer;
                        this.currentObject = group.getObjectNear(pos.x, pos.y, this.mapView.getZoom());
                        if (this.currentObject == null) break;
                        this.mouseLastPixelLocation = pos;
                        this.moveDist = new Point(0, 0);
                        break;
                    }
                    Point translation = new Point(pos.x - this.mouseLastPixelLocation.x, pos.y - this.mouseLastPixelLocation.y);
                    this.currentObject.translate(translation.x, translation.y);
                    this.moveDist.translate(translation.x, translation.y);
                    this.mouseLastPixelLocation = pos;
                    this.mapView.repaint();
                }
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        this.tileCoordsLabel.setText(" ");
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Point tile = this.mapView.screenToTileCoords(e.getX(), e.getY());
        this.mouseButton = e.getButton();
        this.bMouseIsDown = true;
        this.bMouseIsDragging = false;
        this.mouseInitialPressLocation = this.mousePressLocation = this.mapView.screenToTileCoords(e.getX(), e.getY());
        MapLayer layer = this.getCurrentLayer();
        if (this.mouseButton == 2 || this.mouseButton == 1 && (e.getModifiersEx() & 0x200) != 0) {
            this.mouseInitialScreenLocation = new Point(e.getX(), e.getY());
        } else if (this.mouseButton == 1) {
            switch (this.currentPointerState) {
                case 1: {
                    if (layer instanceof TileLayer) {
                        this.currentBrush.startPaint(this.currentMap, tile.x, tile.y, this.mouseButton, this.currentLayer);
                    }
                }
                case 2: 
                case 3: {
                    this.paintEdit = new MapLayerEdit(layer, MapEditor.createLayerCopy(layer), null);
                    break;
                }
            }
        }
        if (this.currentPointerState == 5) {
            boolean contains = false;
            if (this.marqueeSelection != null && this.marqueeSelection.getSelectedArea().contains(tile.x, tile.y)) {
                contains = true;
            }
            if (this.marqueeSelection == null && !contains) {
                this.marqueeSelection = new SelectionLayer(this.currentMap.getWidth(), this.currentMap.getHeight());
                this.currentMap.addLayerSpecial(this.marqueeSelection);
            } else if (this.marqueeSelection != null && e.getModifiers() == 16) {
                this.currentMap.removeLayerSpecial(this.marqueeSelection);
                if (contains) {
                    this.marqueeSelection = null;
                } else {
                    this.marqueeSelection = new SelectionLayer(this.currentMap.getWidth(), this.currentMap.getHeight());
                    this.currentMap.addLayerSpecial(this.marqueeSelection);
                }
            }
        } else if (this.currentPointerState == 6) {
            this.moveDist = new Point(0, 0);
        }
        this.doMouse(e);
    }

    public void mouseReleased(MouseEvent event) {
        MapLayer layer = this.getCurrentLayer();
        Point limp = this.mouseInitialPressLocation;
        if (this.currentPointerState != 5) {
            if (this.currentPointerState == 6) {
                if (layer != null && (this.moveDist.x != 0 || this.moveDist.x != 0)) {
                    this.undoSupport.postEdit(new MoveLayerEdit(layer, this.moveDist));
                }
            } else if (this.currentPointerState == 1) {
                if (layer instanceof TileLayer) {
                    this.currentBrush.endPaint();
                }
            } else if (this.currentPointerState == 9 && layer instanceof ObjectGroup && this.currentObject != null && (this.moveDist.x != 0 || this.moveDist.x != 0)) {
                this.undoSupport.postEdit(new MoveObjectEdit(this.currentObject, this.moveDist));
            }
        }
        if (this.currentPointerState == 1 || this.currentPointerState == 7) {
            Point tile = this.mapView.screenToTileCoords(event.getX(), event.getY());
            int minx = Math.min(limp.x, tile.x);
            int miny = Math.min(limp.y, tile.y);
            Rectangle bounds = new Rectangle(minx, miny, Math.max(limp.x, tile.x) - minx + 1, Math.max(limp.y, tile.y) - miny + 1);
            if (this.mouseButton == 3 && layer instanceof TileLayer) {
                TileLayer brushLayer = new TileLayer(bounds);
                brushLayer.copyFrom(this.getCurrentLayer());
                brushLayer.setOffset(tile.x - (int)bounds.getWidth() / 2, tile.y - (int)bounds.getHeight() / 2);
                if (brushLayer.isEmpty()) {
                    JOptionPane.showMessageDialog(this.appFrame, Resources.getString("dialog.selection.empty"), Resources.getString("dialog.selection.empty"), 2);
                } else {
                    this.setBrush(new CustomBrush(brushLayer));
                    this.cursorHighlight.setOffset(tile.x - (int)bounds.getWidth() / 2, tile.y - (int)bounds.getHeight() / 2);
                }
            } else if (this.mouseButton == 1 && layer instanceof ObjectGroup) {
                int w = this.currentMap.getTileWidth();
                int h = this.currentMap.getTileHeight();
                MapObject object = new MapObject(bounds.x * w, bounds.y * h, bounds.width * w, bounds.height * h);
                ObjectGroup group = (ObjectGroup)layer;
                this.undoSupport.postEdit(new AddObjectEdit(group, object));
                group.addObject(object);
                this.mapView.repaint();
            }
            if (this.marqueeSelection != null) {
                this.currentMap.removeLayerSpecial(this.marqueeSelection);
                this.marqueeSelection = null;
            }
        }
        if (this.paintEdit != null) {
            if (layer != null) {
                try {
                    MapLayer endLayer = this.paintEdit.getStart().createDiff(layer);
                    this.paintEdit.end(endLayer);
                    this.undoSupport.postEdit(this.paintEdit);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.paintEdit = null;
        }
        this.currentObject = null;
        this.mouseButton = 0;
        this.bMouseIsDown = false;
        this.bMouseIsDragging = false;
    }

    public void mouseMoved(MouseEvent e) {
        boolean bl = this.bMouseIsDown = e.getButton() != 0;
        if (this.bMouseIsDown) {
            this.doMouse(e);
        }
        Point tile = this.mapView.screenToTileCoords(e.getX(), e.getY());
        this.updateTileCoordsLabel(tile);
        this.updateCursorHighlight(tile);
    }

    public void mouseDragged(MouseEvent e) {
        this.bMouseIsDragging = true;
        this.doMouse(e);
        this.mousePressLocation = this.mapView.screenToTileCoords(e.getX(), e.getY());
        Point tile = this.mapView.screenToTileCoords(e.getX(), e.getY());
        this.updateTileCoordsLabel(tile);
        this.updateCursorHighlight(tile);
    }

    private void updateTileCoordsLabel(Point tile) {
        if (this.currentMap.inBounds(tile.x, tile.y)) {
            this.tileCoordsLabel.setText(String.valueOf(tile.x) + ", " + tile.y);
        } else {
            this.tileCoordsLabel.setText(" ");
        }
    }

    private void updateCursorHighlight(Point tile) {
        if (prefs.getBoolean("cursorhighlight", true)) {
            Rectangle redraw = this.cursorHighlight.getBounds();
            Rectangle brushRedraw = this.currentBrush.getBounds();
            brushRedraw.x = tile.x - brushRedraw.width / 2;
            brushRedraw.y = tile.y - brushRedraw.height / 2;
            if (!redraw.equals(brushRedraw)) {
                if (this.currentBrush instanceof CustomBrush) {
                    CustomBrush customBrush = (CustomBrush)this.currentBrush;
                    ListIterator<MapLayer> layers = customBrush.getLayers();
                    while (layers.hasNext()) {
                        MapLayer layer = layers.next();
                        layer.setOffset(brushRedraw.x, brushRedraw.y);
                    }
                }
                this.mapView.repaintRegion(redraw);
                this.cursorHighlight.setOffset(brushRedraw.x, brushRedraw.y);
                this.mapView.repaintRegion(brushRedraw);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("paint".equals(command)) {
            this.setCurrentPointerState(1);
            this.resetBrush();
        } else if ("erase".equals(command)) {
            this.setCurrentPointerState(2);
            this.resetBrush();
        } else if ("point".equals(command)) {
            this.setCurrentPointerState(0);
            this.resetBrush();
        } else if ("pour".equals(command)) {
            this.setCurrentPointerState(3);
            this.resetBrush();
        } else if ("eyed".equals(command)) {
            this.setCurrentPointerState(4);
            this.resetBrush();
        } else if ("marquee".equals(command)) {
            this.setCurrentPointerState(5);
            this.resetBrush();
        } else if ("move".equals(command)) {
            this.setCurrentPointerState(6);
            this.resetBrush();
        } else if ("addobject".equals(command)) {
            this.setCurrentPointerState(7);
            this.resetBrush();
        } else if ("removeobject".equals(command)) {
            this.setCurrentPointerState(8);
            this.resetBrush();
        } else if ("moveobject".equals(command)) {
            this.setCurrentPointerState(9);
            this.resetBrush();
        } else {
            this.handleEvent(event);
        }
    }

    private void handleEvent(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(Resources.getString("menu.edit.brush"))) {
            BrushDialog bd = new BrushDialog(this, this.appFrame, this.currentBrush);
            bd.setVisible(true);
        } else if (command.equals(Resources.getString("menu.tilesets.new"))) {
            NewTilesetDialog dialog;
            TileSet newSet;
            if (this.currentMap != null && (newSet = (dialog = new NewTilesetDialog(this.appFrame, this.currentMap)).create()) != null) {
                this.currentMap.addTileset(newSet);
            }
        } else if (command.equals(Resources.getString("menu.tilesets.import"))) {
            if (this.currentMap != null) {
                MapReader[] readers;
                JFileChooser chooser = new JFileChooser(this.currentMap.getFilename());
                for (MapReader reader : readers = this.pluginLoader.getReaders()) {
                    try {
                        chooser.addChoosableFileFilter(new TiledFileFilter(reader.getFilter(), reader.getName()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                chooser.addChoosableFileFilter(new TiledFileFilter(2));
                int ret = chooser.showOpenDialog(this.appFrame);
                if (ret == 0) {
                    String filename = chooser.getSelectedFile().getAbsolutePath();
                    try {
                        TileSet set = MapHelper.loadTileset(filename);
                        this.currentMap.addTileset(set);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (command.equals(Resources.getString("menu.tilesets.refresh"))) {
            if (this.currentMap != null) {
                Vector<TileSet> tilesets = this.currentMap.getTilesets();
                for (TileSet tileset : tilesets) {
                    try {
                        tileset.checkUpdate();
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(this.appFrame, e.getLocalizedMessage(), IMPORT_ERROR_MSG, 2);
                    }
                }
                this.mapView.repaint();
                this.brushPreview.setBrush(this.currentBrush);
            }
        } else if (command.equals(Resources.getString("menu.tilesets.manager"))) {
            if (this.currentMap != null) {
                TilesetManager manager = new TilesetManager(this.appFrame, this.currentMap);
                manager.setVisible(true);
            }
        } else if (command.equals(Resources.getString("menu.map.properties"))) {
            PropertiesDialog pd = new PropertiesDialog(this.appFrame, this.currentMap.getProperties());
            pd.setTitle(Resources.getString("dialog.properties.map.title"));
            pd.getProps();
        } else if (command.equals(Resources.getString("menu.layer.properties"))) {
            MapLayer layer = this.getCurrentLayer();
            PropertiesDialog lpd = new PropertiesDialog(this.appFrame, layer.getProperties());
            lpd.setTitle(layer.getName() + " " + Resources.getString("dialog.properties.title"));
            lpd.getProps();
        } else if (command.equals(Resources.getString("menu.view.boundaries")) || command.equals("Hide Boundaries")) {
            this.mapView.toggleMode(2);
        } else if (command.equals(Resources.getString("menu.view.grid"))) {
            Preferences displayPrefs;
            boolean showGrid = (displayPrefs = prefs.node("display")).getBoolean("showGrid", false);
            displayPrefs.putBoolean("showGrid", !showGrid);
        } else if (command.equals(Resources.getString("menu.view.coordinates"))) {
            this.mapView.toggleMode(4);
        } else if (command.equals(Resources.getString("menu.view.cursor"))) {
            prefs.putBoolean("cursorhighlight", this.cursorMenuItem.isSelected());
            this.cursorHighlight.setVisible(this.cursorMenuItem.isSelected());
        } else if (command.equals(Resources.getString("menu.map.resize"))) {
            ResizeDialog rd = new ResizeDialog(this.appFrame, this);
            rd.setVisible(true);
        } else if (command.equals(Resources.getString("menu.map.search"))) {
            SearchDialog sd = new SearchDialog(this.appFrame, this.currentMap);
            sd.setVisible(true);
        } else if (command.equals(Resources.getString("menu.help.about"))) {
            this.showAboutDialog();
        } else if (command.equals(Resources.getString("menu.help.plugins"))) {
            PluginDialog pluginDialog = new PluginDialog(this.appFrame, this.pluginLoader);
            pluginDialog.setVisible(true);
        } else if (command.equals(Resources.getString("menu.edit.preferences"))) {
            ConfigurationDialog dialog = new ConfigurationDialog(this.appFrame);
            dialog.configure();
        } else {
            System.out.println(event);
        }
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
        String s = String.valueOf((int)(this.mapView.getZoom() * 100.0)) + "%";
        this.zoomLabel.setText(s);
        JViewport mapViewPort = this.mapScrollPane.getViewport();
        Rectangle viewRect = mapViewPort.getViewRect();
        int absMidX = Math.max(0, Math.round(this.relativeMidX * (float)this.mapView.getWidth()) - viewRect.width / 2);
        int absMidY = Math.max(0, Math.round(this.relativeMidY * (float)this.mapView.getHeight()) - viewRect.height / 2);
        mapViewPort.setViewPosition(new Point(absMidX, absMidY));
    }

    public void componentShown(ComponentEvent event) {
    }

    public void mapChanged(MapChangedEvent e) {
        if (e.getMap() == this.currentMap) {
            this.mapScrollPane.setViewportView(this.mapView);
            this.updateLayerTable();
            this.mapView.repaint();
        }
    }

    public void tilesetAdded(MapChangedEvent e, TileSet tileset) {
    }

    public void tilesetRemoved(MapChangedEvent e, int index) {
        this.mapView.repaint();
    }

    public void tilesetsSwapped(MapChangedEvent e, int index0, int index1) {
    }

    public void valueChanged(ListSelectionEvent e) {
        int selectedRow = this.layerTable.getSelectedRow();
        if (this.currentMap != null && selectedRow >= 0) {
            this.currentLayer = this.currentMap.getTotalLayers() - selectedRow - 1;
            float opacity = this.getCurrentLayer().getOpacity();
            this.opacitySlider.setValue((int)(opacity * 100.0f));
        } else {
            this.currentLayer = -1;
        }
        this.updateLayerOperations();
    }

    public void stateChanged(ChangeEvent e) {
        JViewport mapViewport = this.mapScrollPane.getViewport();
        if (e.getSource() == this.opacitySlider) {
            if (this.currentMap != null && this.currentLayer >= 0) {
                MapLayer layer = this.getCurrentLayer();
                layer.setOpacity((float)this.opacitySlider.getValue() / 100.0f);
            }
        } else if (e.getSource() == mapViewport && this.mapView != null) {
            Rectangle viewRect = mapViewport.getViewRect();
            this.relativeMidX = Math.min(1.0f, (float)(viewRect.x + viewRect.width / 2) / (float)this.mapView.getWidth());
            this.relativeMidY = Math.min(1.0f, (float)(viewRect.y + viewRect.height / 2) / (float)this.mapView.getHeight());
        }
    }

    public MapView getMapView() {
        return this.mapView;
    }

    public void shutdown() {
        int extendedState = this.appFrame.getExtendedState();
        Preferences mainDialogPrefs = prefs.node("dialog/main");
        mainDialogPrefs.putInt("state", extendedState);
        if (extendedState == 0) {
            mainDialogPrefs.putInt("width", this.appFrame.getWidth());
            mainDialogPrefs.putInt("height", this.appFrame.getHeight());
        }
        this.layersPanel.save();
        this.tilesetsPanel.save();
    }

    private void showAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this.appFrame);
        }
        this.aboutDialog.setVisible(true);
    }

    private void pour(TileLayer layer, int x, int y, Tile newTile, Tile oldTile) {
        Rectangle area;
        if (newTile == oldTile || !layer.canEdit()) {
            return;
        }
        TileLayer before = (TileLayer)MapEditor.createLayerCopy(layer);
        if (before == null) {
            return;
        }
        if (this.marqueeSelection == null) {
            area = new Rectangle(new Point(x, y));
            Stack<Point> stack = new Stack<Point>();
            stack.push(new Point(x, y));
            while (!stack.empty()) {
                Point p = (Point)stack.pop();
                if (!layer.contains(p.x, p.y) || layer.getTileAt(p.x, p.y) != oldTile) continue;
                layer.setTileAt(p.x, p.y, newTile);
                area.add(p);
                stack.push(new Point(p.x, p.y - 1));
                stack.push(new Point(p.x, p.y + 1));
                stack.push(new Point(p.x + 1, p.y));
                stack.push(new Point(p.x - 1, p.y));
            }
        } else if (this.marqueeSelection.getSelectedArea().contains(x, y)) {
            area = this.marqueeSelection.getSelectedAreaBounds();
            for (int i = area.y; i < area.height + area.y; ++i) {
                for (int j = area.x; j < area.width + area.x; ++j) {
                    if (!this.marqueeSelection.getSelectedArea().contains(j, i)) continue;
                    layer.setTileAt(j, i, newTile);
                }
            }
        } else {
            return;
        }
        Rectangle bounds = new Rectangle(area.x, area.y, area.width + 1, area.height + 1);
        TileLayer after = new TileLayer(bounds);
        after.copyFrom(layer);
        MapLayerEdit mle = new MapLayerEdit(layer, before, after);
        mle.setPresentationName(TOOL_FILL);
        this.undoSupport.postEdit(mle);
    }

    public AbstractBrush getBrush() {
        return this.currentBrush;
    }

    public void resetBrush() {
        if (this.currentBrush instanceof CustomBrush) {
            ShapeBrush sb = new ShapeBrush();
            sb.makeQuadBrush(new Rectangle(0, 0, 1, 1));
            sb.setTile(this.currentTile);
            this.setBrush(sb);
        }
    }

    public void setBrush(AbstractBrush brush) {
        if (this.mapView != null && prefs.getBoolean("cursorhighlight", true)) {
            Rectangle redraw = this.cursorHighlight.getBounds();
            this.mapView.repaintRegion(redraw);
        }
        this.currentBrush = brush;
        Rectangle brushRedraw = this.currentBrush.getBounds();
        this.cursorHighlight.resize(brushRedraw.width, brushRedraw.height, 0, 0);
        this.cursorHighlight.selectRegion(this.currentBrush.getShape());
        if (this.mapView != null) {
            this.mapView.setBrush(this.currentBrush);
        }
    }

    public void updateTitle() {
        String title = Resources.getString("dialog.main.title");
        if (this.currentMap != null) {
            String filename = this.currentMap.getFilename();
            title = title + " - ";
            title = filename != null ? title + this.currentMap.getFilename() : title + Resources.getString("general.file.untitled");
            if (this.unsavedChanges()) {
                title = title + "*";
            }
        }
        this.appFrame.setTitle(title);
    }

    public boolean unsavedChanges() {
        return this.currentMap != null && this.undoHandler.canUndo() && !this.undoHandler.isAllSaved();
    }

    public boolean loadMap(String file) {
        File exist = new File(file);
        if (!exist.exists()) {
            JOptionPane.showMessageDialog(this.appFrame, Resources.getString("general.file.notexists.message"), Resources.getString("dialog.openmap.error.title"), 0);
            return false;
        }
        try {
            Map map = MapHelper.loadMap(file);
            if (map != null) {
                this.setCurrentMap(map);
                this.updateRecent(file);
                return true;
            }
            JOptionPane.showMessageDialog(this.appFrame, Resources.getString("general.file.failed"), Resources.getString("dialog.openmap.error.title"), 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.appFrame, "Error while loading " + file + ": " + e.getLocalizedMessage() + (e.getCause() != null ? "\nCause: " + e.getCause().getLocalizedMessage() : ""), Resources.getString("dialog.openmap.error.title"), 0);
            e.printStackTrace();
        }
        return false;
    }

    private static MapLayer createLayerCopy(MapLayer layer) {
        try {
            return (MapLayer)layer.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateRecent(String filename) {
        if (filename != null) {
            TiledConfiguration.addToRecentFiles(filename);
        }
        List<String> files = TiledConfiguration.getRecentFiles();
        this.recentMenu.removeAll();
        for (String file : files) {
            this.recentMenu.add(new TMenuItem(new OpenRecentAction(this, this.saveAction, file)));
        }
    }

    public void setCurrentMap(Map newMap) {
        if (this.marqueeSelection != null && this.currentMap != null) {
            this.currentMap.removeLayerSpecial(this.marqueeSelection);
        }
        this.marqueeSelection = null;
        this.currentMap = newMap;
        boolean mapLoaded = this.currentMap != null;
        ShapeBrush sb = new ShapeBrush();
        sb.makeQuadBrush(new Rectangle(0, 0, 1, 1));
        this.setBrush(sb);
        this.tabbedTilesetsPane.setMap(this.currentMap);
        if (!mapLoaded) {
            this.mapEventAdapter.fireEvent(2);
            this.mapView = null;
            this.mapScrollPane.setViewportView(Box.createRigidArea(new Dimension(0, 0)));
            this.setCurrentPointerState(0);
            this.tileCoordsLabel.setPreferredSize(null);
            this.tileCoordsLabel.setText(" ");
            this.zoomLabel.setText(" ");
            this.setCurrentTile(null);
        } else {
            Preferences display = prefs.node("display");
            this.mapEventAdapter.fireEvent(1);
            this.mapView = MapView.createViewforMap(this.currentMap);
            this.mapView.addMouseListener(this);
            this.mapView.addMouseMotionListener(this);
            this.mapView.addComponentListener(this);
            this.mapView.setGridOpacity(display.getInt("gridOpacity", 255));
            this.mapView.setAntialiasGrid(display.getBoolean("gridAntialias", true));
            this.mapView.setGridColor(new Color(display.getInt("gridColor", MapView.DEFAULT_GRID_COLOR.getRGB())));
            this.mapView.setShowGrid(display.getBoolean("showGrid", false));
            JViewport mapViewport = new JViewport();
            mapViewport.setView(this.mapView);
            mapViewport.addChangeListener(this);
            this.mapScrollPane.setViewport(mapViewport);
            this.setCurrentPointerState(1);
            this.currentMap.addMapChangeListener(this);
            this.gridMenuItem.setState(this.mapView.getShowGrid());
            this.coordinatesMenuItem.setState(this.mapView.getMode(4));
            this.tileCoordsLabel.setText(String.valueOf(this.currentMap.getWidth() - 1) + ", " + (this.currentMap.getHeight() - 1));
            this.tileCoordsLabel.setPreferredSize(null);
            Dimension size = this.tileCoordsLabel.getPreferredSize();
            this.tileCoordsLabel.setText(" ");
            this.tileCoordsLabel.setMinimumSize(new Dimension(20, 50));
            this.tileCoordsLabel.setPreferredSize(size);
            this.zoomLabel.setText(String.valueOf((int)(this.mapView.getZoom() * 100.0)) + "%");
            Vector<TileSet> tilesets = this.currentMap.getTilesets();
            Tile firstTile = null;
            if (!tilesets.isEmpty()) {
                Iterator<TileSet> it = tilesets.iterator();
                while (it.hasNext() && firstTile == null) {
                    firstTile = it.next().getFirstTile();
                }
            }
            this.setCurrentTile(firstTile);
            this.currentMap.addLayerSpecial(this.cursorHighlight);
        }
        this.zoomInAction.setEnabled(mapLoaded);
        this.zoomOutAction.setEnabled(mapLoaded);
        this.zoomNormalAction.setEnabled(mapLoaded && this.mapView.getZoomLevel() != MapView.ZOOM_NORMALSIZE);
        this.undoHandler.discardAllEdits();
        this.updateLayerTable();
        this.updateTitle();
    }

    public void setCurrentLayer(int index) {
        int totalLayers;
        if (this.currentMap != null && (totalLayers = this.currentMap.getTotalLayers()) > index && index >= 0) {
            this.currentLayer = index;
            this.layerTable.changeSelection(totalLayers - this.currentLayer - 1, 0, false, false);
        }
    }

    public void setCurrentTile(Tile tile) {
        this.resetBrush();
        if (this.currentTile != tile) {
            this.currentTile = tile;
            if (this.currentBrush instanceof ShapeBrush) {
                ((ShapeBrush)this.currentBrush).setTile(tile);
            }
            this.brushPreview.setBrush(this.currentBrush);
        }
    }

    private void setCurrentPointerState(int state) {
        this.currentPointerState = state;
        this.paintButton.setSelected(state == 1);
        this.eraseButton.setSelected(state == 2);
        this.pourButton.setSelected(state == 3);
        this.eyedButton.setSelected(state == 4);
        this.marqueeButton.setSelected(state == 5);
        this.moveButton.setSelected(state == 6);
        this.objectAddButton.setSelected(state == 7);
        this.objectRemoveButton.setSelected(state == 8);
        this.objectMoveButton.setSelected(state == 9);
        if (this.mapView != null) {
            switch (this.currentPointerState) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    this.mapView.setCursor(this.curDefault);
                    break;
                }
                case 4: {
                    this.mapView.setCursor(this.curEyed);
                }
            }
        }
    }

    public static void main(String[] args) {
        String filename;
        List<String> recent;
        MapEditor editor = new MapEditor();
        if (args.length > 0) {
            File file = new File(args[0]);
            try {
                editor.loadMap(file.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (prefs.node("io").getBoolean("autoOpenLast", false) && !(recent = TiledConfiguration.getRecentFiles()).isEmpty() && new File(filename = recent.get(0)).exists()) {
            editor.loadMap(filename);
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super(Resources.getString("action.paste.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
            this.putValue("ShortDescription", Resources.getString("action.paste.tooltip"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (MapEditor.this.currentMap != null && MapEditor.this.clipboardLayer != null) {
                Vector<MapLayer> layersBefore = MapEditor.this.currentMap.getLayerVector();
                MapLayer ml = MapEditor.createLayerCopy(MapEditor.this.clipboardLayer);
                ml.setName(Resources.getString("general.layer.layer") + " " + MapEditor.this.currentMap.getTotalLayers());
                MapEditor.this.currentMap.addLayer(ml);
                MapEditor.this.undoSupport.postEdit(new MapLayerStateEdit(MapEditor.this.currentMap, layersBefore, new Vector<MapLayer>(MapEditor.this.currentMap.getLayerVector()), "Paste Selection"));
            }
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super(Resources.getString("action.cut.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control X"));
            this.putValue("ShortDescription", Resources.getString("action.cut.tooltip"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (MapEditor.this.currentMap != null && MapEditor.this.marqueeSelection != null) {
                MapLayer ml = MapEditor.this.getCurrentLayer();
                if (MapEditor.this.getCurrentLayer() instanceof TileLayer) {
                    MapEditor.this.clipboardLayer = new TileLayer(MapEditor.this.marqueeSelection.getSelectedAreaBounds());
                } else if (MapEditor.this.getCurrentLayer() instanceof ObjectGroup) {
                    MapEditor.this.clipboardLayer = new ObjectGroup(MapEditor.this.marqueeSelection.getSelectedAreaBounds());
                }
                MapEditor.this.clipboardLayer.maskedCopyFrom(ml, MapEditor.this.marqueeSelection.getSelectedArea());
                Rectangle area = MapEditor.this.marqueeSelection.getSelectedAreaBounds();
                Area mask = MapEditor.this.marqueeSelection.getSelectedArea();
                if (ml instanceof TileLayer) {
                    TileLayer tl = (TileLayer)ml;
                    for (int i = area.y; i < area.height + area.y; ++i) {
                        for (int j = area.x; j < area.width + area.x; ++j) {
                            if (!mask.contains(j, i)) continue;
                            tl.setTileAt(j, i, null);
                        }
                    }
                }
                MapEditor.this.mapView.repaintRegion(area);
            }
        }
    }

    private class CopyAllAction
    extends AbstractAction {
        public CopyAllAction() {
            super(Resources.getString("action.copyall.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift control C"));
            this.putValue("ShortDescription", Resources.getString("action.copyall.tooltip"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (MapEditor.this.currentMap != null && MapEditor.this.marqueeSelection != null) {
                MapEditor.this.clipboardLayer = new TileLayer(MapEditor.this.marqueeSelection.getSelectedAreaBounds());
                ListIterator<MapLayer> itr = MapEditor.this.currentMap.getLayers();
                while (itr.hasNext()) {
                    MapLayer layer = itr.next();
                    if (!(layer instanceof TileLayer)) continue;
                    MapEditor.this.clipboardLayer.maskedMergeOnto(layer, MapEditor.this.marqueeSelection.getSelectedArea());
                }
            }
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(Resources.getString("action.copy.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
            this.putValue("ShortDescription", Resources.getString("action.copy.tooltip"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (MapEditor.this.currentMap != null && MapEditor.this.marqueeSelection != null) {
                if (MapEditor.this.getCurrentLayer() instanceof TileLayer) {
                    MapEditor.this.clipboardLayer = new TileLayer(MapEditor.this.marqueeSelection.getSelectedAreaBounds());
                } else if (MapEditor.this.getCurrentLayer() instanceof ObjectGroup) {
                    MapEditor.this.clipboardLayer = new ObjectGroup(MapEditor.this.marqueeSelection.getSelectedAreaBounds());
                }
                MapEditor.this.clipboardLayer.maskedCopyFrom(MapEditor.this.getCurrentLayer(), MapEditor.this.marqueeSelection.getSelectedArea());
            }
        }
    }

    private class ZoomNormalAction
    extends AbstractAction {
        public ZoomNormalAction() {
            super(Resources.getString("action.zoom.normal.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control 0"));
            this.putValue("ShortDescription", Resources.getString("action.zoom.normal.tooltip"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (MapEditor.this.currentMap != null) {
                MapEditor.this.zoomInAction.setEnabled(true);
                MapEditor.this.zoomOutAction.setEnabled(true);
                this.setEnabled(false);
                MapEditor.this.mapView.setZoomLevel(MapView.ZOOM_NORMALSIZE);
            }
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction() {
            super(Resources.getString("action.zoom.out.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control MINUS"));
            this.putValue("ShortDescription", Resources.getString("action.zoom.out.tooltip"));
            this.putValue("SmallIcon", Resources.getIcon("gnome-zoom-out.png"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (MapEditor.this.currentMap != null) {
                MapEditor.this.zoomInAction.setEnabled(true);
                if (!MapEditor.this.mapView.zoomOut()) {
                    this.setEnabled(false);
                }
                MapEditor.this.zoomNormalAction.setEnabled(MapEditor.this.mapView.getZoomLevel() != MapView.ZOOM_NORMALSIZE);
            }
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        public ZoomInAction() {
            super(Resources.getString("action.zoom.in.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control EQUALS"));
            this.putValue("ShortDescription", Resources.getString("action.zoom.in.tooltip"));
            this.putValue("SmallIcon", Resources.getIcon("gnome-zoom-in.png"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (MapEditor.this.currentMap != null) {
                MapEditor.this.zoomOutAction.setEnabled(true);
                if (!MapEditor.this.mapView.zoomIn()) {
                    this.setEnabled(false);
                }
                MapEditor.this.zoomNormalAction.setEnabled(MapEditor.this.mapView.getZoomLevel() != MapView.ZOOM_NORMALSIZE);
            }
        }
    }

    private class InverseSelectionAction
    extends AbstractAction {
        public InverseSelectionAction() {
            super(Resources.getString("action.select.invert.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control I"));
            this.putValue("ShortDescription", Resources.getString("action.select.invert.tooltip"));
        }

        public void actionPerformed(ActionEvent e) {
            if (MapEditor.this.marqueeSelection != null) {
                MapEditor.this.marqueeSelection.invert();
                MapEditor.this.mapView.repaint();
            }
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super(Resources.getString("action.select.all.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control A"));
            this.putValue("ShortDescription", Resources.getString("action.select.all.tooltip"));
        }

        public void actionPerformed(ActionEvent e) {
            if (MapEditor.this.currentMap != null) {
                if (MapEditor.this.marqueeSelection != null) {
                    MapEditor.this.currentMap.removeLayerSpecial(MapEditor.this.marqueeSelection);
                }
                MapEditor.this.marqueeSelection = new SelectionLayer(MapEditor.this.currentMap.getWidth(), MapEditor.this.currentMap.getHeight());
                MapEditor.this.marqueeSelection.selectRegion(MapEditor.this.marqueeSelection.getBounds());
                MapEditor.this.currentMap.addLayerSpecial(MapEditor.this.marqueeSelection);
            }
        }
    }

    private class CancelSelectionAction
    extends AbstractAction {
        public CancelSelectionAction() {
            super(Resources.getString("action.select.none.name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift A"));
            this.putValue("ShortDescription", Resources.getString("action.select.none.tooltip"));
        }

        public void actionPerformed(ActionEvent e) {
            if (MapEditor.this.currentMap != null) {
                if (MapEditor.this.marqueeSelection != null) {
                    MapEditor.this.currentMap.removeLayerSpecial(MapEditor.this.marqueeSelection);
                }
                MapEditor.this.marqueeSelection = null;
            }
        }
    }

    private class LayerTransformAction
    extends AbstractAction {
        private final int transform;

        public LayerTransformAction(int transform) {
            this.transform = transform;
            switch (transform) {
                case 90: {
                    this.putValue("Name", Resources.getString("action.layer.transform.rotate90.name"));
                    this.putValue("ShortDescription", Resources.getString("action.layer.transform.rotate90.tooltip"));
                    this.putValue("SmallIcon", Resources.getIcon("gimp-rotate-90-16.png"));
                    break;
                }
                case 180: {
                    this.putValue("Name", Resources.getString("action.layer.transform.rotate180.name"));
                    this.putValue("ShortDescription", Resources.getString("action.layer.transform.rotate180.tooltip"));
                    this.putValue("SmallIcon", Resources.getIcon("gimp-rotate-180-16.png"));
                    break;
                }
                case 270: {
                    this.putValue("Name", Resources.getString("action.layer.transform.rotate270.name"));
                    this.putValue("ShortDescription", Resources.getString("action.layer.transform.rotate270.tooltip"));
                    this.putValue("SmallIcon", Resources.getIcon("gimp-rotate-270-16.png"));
                    break;
                }
                case 2: {
                    this.putValue("Name", Resources.getString("action.layer.transform.vertical.name"));
                    this.putValue("ShortDescription", Resources.getString("action.layer.transform.vertical.tooltip"));
                    this.putValue("SmallIcon", Resources.getIcon("gimp-flip-vertical-16.png"));
                    break;
                }
                case 1: {
                    this.putValue("Name", Resources.getString("action.layer.transform.horizontal.name"));
                    this.putValue("ShortDescription", Resources.getString("action.layer.transform.horizontal.tooltip"));
                    this.putValue("SmallIcon", Resources.getIcon("gimp-flip-horizontal-16.png"));
                }
            }
        }

        public void actionPerformed(ActionEvent evt) {
            MapLayer currentLayer;
            MapLayer layer = currentLayer = MapEditor.this.getCurrentLayer();
            MapLayerEdit transEdit = new MapLayerEdit(currentLayer, MapEditor.createLayerCopy(currentLayer));
            if (MapEditor.this.marqueeSelection != null) {
                if (currentLayer instanceof TileLayer) {
                    layer = new TileLayer(MapEditor.this.marqueeSelection.getSelectedAreaBounds());
                } else if (currentLayer instanceof ObjectGroup) {
                    layer = new ObjectGroup(MapEditor.this.marqueeSelection.getSelectedAreaBounds());
                }
                layer.setMap(MapEditor.this.currentMap);
                layer.maskedCopyFrom(currentLayer, MapEditor.this.marqueeSelection.getSelectedArea());
            }
            switch (this.transform) {
                case 90: 
                case 180: 
                case 270: {
                    transEdit.setPresentationName("Rotate");
                    layer.rotate(this.transform);
                    break;
                }
                case 2: {
                    transEdit.setPresentationName("Vertical Flip");
                    layer.mirror(2);
                    break;
                }
                case 1: {
                    transEdit.setPresentationName("Horizontal Flip");
                    layer.mirror(1);
                }
            }
            if (MapEditor.this.marqueeSelection != null) {
                layer.mergeOnto(currentLayer);
            }
            transEdit.end(MapEditor.createLayerCopy(currentLayer));
            MapEditor.this.undoSupport.postEdit(transEdit);
            MapEditor.this.mapView.repaint();
        }
    }
}

