/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tiled.mapeditor.Resources;
import tiled.mapeditor.util.ConfirmableFileFilter;
import tiled.mapeditor.util.ConfirmingFileChooser;
import tiled.mapeditor.widget.IntegerSpinner;
import tiled.mapeditor.widget.VerticalStaticJPanel;
import tiled.util.TiledConfiguration;

public class ConfigurationDialog
extends JDialog {
    private IntegerSpinner undoDepth;
    private JSlider gridOpacitySlider;
    private JCheckBox cbBinaryEncode;
    private JCheckBox cbCompressLayerData;
    private JCheckBox cbUsefulComments;
    private JCheckBox cbEmbedImages;
    private JCheckBox cbReportIOWarnings;
    private JCheckBox cbAutoOpenLastFile;
    private JRadioButton rbEmbedInTiles;
    private JRadioButton rbEmbedInSet;
    private JCheckBox cbGridAA;
    private static final Preferences prefs = TiledConfiguration.root();
    private static final Preferences savingPrefs = prefs.node("saving");
    private static final Preferences ioPrefs = prefs.node("io");
    private static final Preferences displayPrefs = prefs.node("display");
    private static final String DIALOG_TITLE = Resources.getString("dialog.preferences.title");
    private static final String CLOSE_BUTTON = Resources.getString("general.button.close");
    private static final String OPACITY_LABEL = Resources.getString("dialog.preferences.opacity.label");
    private static final String BINARY_ENCODE_CHECKBOX = Resources.getString("dialog.preferences.binary.encode.checkbox");
    private static final String COMPRESS_LAYER_DATA_CHECKBOX = Resources.getString("dialog.preferences.compress.layer.data.checkbox");
    private static final String USEFUL_COMMENTS_CHECKBOX = Resources.getString("dialog.preferences.useful.comments.checkbox");
    private static final String EMBED_IMAGES_CHECKBOX = Resources.getString("dialog.preferences.embed.images.checkbox");
    private static final String REPORT_IO_WARNINGS_CHECKBOX = Resources.getString("dialog.preferences.report.io.warnings.checkbox");
    private static final String AUTO_OPEN_LAST_FILE_CHECKBOX = Resources.getString("dialog.preferences.report.io.autoopenlast.checkbox");
    private static final String EMBED_IN_TILES_CHECKBOX = Resources.getString("dialog.preferences.embed.in.tiles.checkbox");
    private static final String EMBED_IN_SET_CHECKBOX = Resources.getString("dialog.preferences.embed.in.set.checkbox");
    private static final String ANTIALIASING_CHECKBOX = Resources.getString("dialog.preferences.antialiasing.checkbox");
    private static final String GENERAL_SAVING_OPTIONS_TITLE = Resources.getString("dialog.preferences.general.tab");
    private static final String LAYER_OPTIONS_TITLE = Resources.getString("dialog.preferences.layer.options.title");
    private static final String UNDO_DEPTH_LABEL = Resources.getString("dialog.preferences.undo.depth.label");
    private static final String TILESET_OPTIONS_TITLE = Resources.getString("dialog.preferences.tileset.options.title");
    private static final String GENERAL_TAB = Resources.getString("dialog.preferences.general.tab");
    private static final String SAVING_TAB = Resources.getString("dialog.preferences.saving.tab");
    private static final String GRID_TAB = Resources.getString("dialog.preferences.grid.tab");
    private static final String EXPORT_BUTTON = Resources.getString("dialog.preferences.export.button");
    private static final String IMPORT_BUTTON = Resources.getString("dialog.preferences.import.button");
    private static final ConfirmableFileFilter xmlFileFilter = new ConfirmableFileFilter(){

        public String getDefaultExtension() {
            return "xml";
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getPath().endsWith(".xml");
        }

        public String getDescription() {
            return "XML files (*.xml)";
        }
    };

    public ConfigurationDialog(JFrame parent) {
        super(parent, DIALOG_TITLE, true);
        this.init();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void init() {
        this.cbBinaryEncode = new JCheckBox(BINARY_ENCODE_CHECKBOX);
        this.cbCompressLayerData = new JCheckBox(COMPRESS_LAYER_DATA_CHECKBOX);
        this.cbUsefulComments = new JCheckBox(USEFUL_COMMENTS_CHECKBOX);
        this.cbEmbedImages = new JCheckBox(EMBED_IMAGES_CHECKBOX);
        this.cbReportIOWarnings = new JCheckBox(REPORT_IO_WARNINGS_CHECKBOX);
        this.cbAutoOpenLastFile = new JCheckBox(AUTO_OPEN_LAST_FILE_CHECKBOX);
        this.rbEmbedInTiles = new JRadioButton(EMBED_IN_TILES_CHECKBOX);
        this.rbEmbedInSet = new JRadioButton(EMBED_IN_SET_CHECKBOX);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbEmbedInTiles);
        bg.add(this.rbEmbedInSet);
        this.undoDepth = new IntegerSpinner();
        this.cbGridAA = new JCheckBox(ANTIALIASING_CHECKBOX);
        this.gridOpacitySlider = new JSlider(0, 255, 255);
        VerticalStaticJPanel layerOps = new VerticalStaticJPanel();
        layerOps.setLayout(new GridBagLayout());
        layerOps.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(LAYER_OPTIONS_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.fill = 0;
        c.gridy = 1;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        layerOps.add((Component)this.cbBinaryEncode, c);
        c.gridy = 2;
        c.insets = new Insets(0, 10, 0, 0);
        layerOps.add((Component)this.cbCompressLayerData, c);
        VerticalStaticJPanel generalOps = new VerticalStaticJPanel();
        generalOps.setLayout(new GridBagLayout());
        generalOps.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        c = new GridBagConstraints();
        c.anchor = 11;
        c.fill = 0;
        generalOps.add((Component)new JLabel(UNDO_DEPTH_LABEL), c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        generalOps.add((Component)this.undoDepth, c);
        c.gridy = 1;
        c.gridx = 0;
        generalOps.add((Component)this.cbReportIOWarnings, c);
        c.gridy = 2;
        c.gridx = 0;
        generalOps.add((Component)this.cbAutoOpenLastFile, c);
        VerticalStaticJPanel generalSavingOps = new VerticalStaticJPanel();
        generalSavingOps.setLayout(new GridBagLayout());
        generalSavingOps.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(GENERAL_SAVING_OPTIONS_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        generalSavingOps.add((Component)this.cbUsefulComments, c);
        VerticalStaticJPanel tilesetOps = new VerticalStaticJPanel();
        tilesetOps.setLayout(new GridBagLayout());
        tilesetOps.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(TILESET_OPTIONS_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        tilesetOps.add((Component)this.cbEmbedImages, c);
        c.gridy = 1;
        c.insets = new Insets(0, 10, 0, 0);
        tilesetOps.add((Component)this.rbEmbedInTiles, c);
        c.gridy = 2;
        c.insets = new Insets(0, 10, 0, 0);
        tilesetOps.add((Component)this.rbEmbedInSet, c);
        VerticalStaticJPanel gridOps = new VerticalStaticJPanel();
        gridOps.setLayout(new GridBagLayout());
        gridOps.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 5);
        gridOps.add((Component)new JLabel(OPACITY_LABEL), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.gridx = 1;
        c.fill = 2;
        gridOps.add((Component)this.gridOpacitySlider, c);
        c.gridwidth = 2;
        c.gridy = 1;
        c.gridx = 0;
        gridOps.add((Component)this.cbGridAA, c);
        JButton exportButton = new JButton(EXPORT_BUTTON);
        exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.doExport();
            }
        });
        JButton importButton = new JButton(IMPORT_BUTTON);
        importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.doImport();
            }
        });
        JButton closeButton = new JButton(CLOSE_BUTTON);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.dispose();
            }
        });
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(exportButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 5)));
        buttons.add(importButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 5)));
        buttons.add(Box.createGlue());
        buttons.add(closeButton);
        JPanel saving = new JPanel();
        saving.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        saving.setLayout(new BoxLayout(saving, 1));
        saving.add(generalSavingOps);
        saving.add(layerOps);
        saving.add(tilesetOps);
        JPanel general = new JPanel();
        general.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        general.setLayout(new BoxLayout(general, 1));
        general.add(generalOps);
        JPanel grid = new JPanel();
        grid.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        grid.setLayout(new BoxLayout(grid, 1));
        grid.add(gridOps);
        JTabbedPane perfs = new JTabbedPane();
        perfs.addTab(GENERAL_TAB, general);
        perfs.addTab(SAVING_TAB, saving);
        perfs.addTab(GRID_TAB, grid);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(perfs);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(buttons);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(closeButton);
        this.cbBinaryEncode.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean selected = ConfigurationDialog.this.cbBinaryEncode.isSelected();
                savingPrefs.putBoolean("encodeLayerData", selected);
                ConfigurationDialog.this.cbCompressLayerData.setEnabled(selected);
            }
        });
        this.cbCompressLayerData.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                savingPrefs.putBoolean("layerCompression", ConfigurationDialog.this.cbCompressLayerData.isSelected());
            }
        });
        this.cbUsefulComments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                savingPrefs.putBoolean("usefulComments", ConfigurationDialog.this.cbUsefulComments.isSelected());
            }
        });
        this.cbEmbedImages.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean embed = ConfigurationDialog.this.cbEmbedImages.isSelected();
                savingPrefs.putBoolean("embedImages", embed);
                ConfigurationDialog.this.rbEmbedInTiles.setEnabled(embed);
                ConfigurationDialog.this.rbEmbedInSet.setEnabled(embed);
            }
        });
        this.cbReportIOWarnings.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ioPrefs.putBoolean("reportWarnings", ConfigurationDialog.this.cbReportIOWarnings.isSelected());
            }
        });
        this.cbAutoOpenLastFile.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ioPrefs.putBoolean("autoOpenLast", ConfigurationDialog.this.cbAutoOpenLastFile.isSelected());
            }
        });
        this.cbGridAA.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                displayPrefs.putBoolean("gridAntialias", ConfigurationDialog.this.cbGridAA.isSelected());
            }
        });
        this.undoDepth.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                prefs.putInt("undoDepth", ConfigurationDialog.this.undoDepth.intValue());
            }
        });
        this.gridOpacitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                displayPrefs.putInt("gridOpacity", ConfigurationDialog.this.gridOpacitySlider.getValue());
            }
        });
        this.rbEmbedInTiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                savingPrefs.putBoolean("tileSetImages", !ConfigurationDialog.this.rbEmbedInTiles.isSelected());
            }
        });
        this.rbEmbedInSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                savingPrefs.putBoolean("tileSetImages", ConfigurationDialog.this.rbEmbedInSet.isSelected());
            }
        });
        this.rbEmbedInTiles.setEnabled(false);
        this.rbEmbedInSet.setEnabled(false);
    }

    public void configure() {
        this.updateFromConfiguration();
        this.setVisible(true);
    }

    private void updateFromConfiguration() {
        this.undoDepth.setValue(prefs.getInt("undoDepth", 30));
        this.gridOpacitySlider.setValue(displayPrefs.getInt("gridOpacity", 255));
        boolean embedImages = savingPrefs.getBoolean("embedImages", true);
        if (embedImages) {
            this.cbEmbedImages.setSelected(true);
            if (savingPrefs.getBoolean("tileSetImages", false)) {
                this.rbEmbedInSet.setSelected(true);
            } else {
                this.rbEmbedInTiles.setSelected(true);
            }
        }
        this.cbUsefulComments.setSelected(savingPrefs.getBoolean("usefulComments", false));
        this.cbBinaryEncode.setSelected(savingPrefs.getBoolean("encodeLayerData", true));
        this.cbCompressLayerData.setSelected(savingPrefs.getBoolean("layerCompression", true));
        this.cbGridAA.setSelected(displayPrefs.getBoolean("gridAntialias", true));
        this.cbReportIOWarnings.setSelected(ioPrefs.getBoolean("reportWarnings", false));
        this.cbAutoOpenLastFile.setSelected(ioPrefs.getBoolean("autoOpenLast", false));
        this.cbCompressLayerData.setEnabled(this.cbBinaryEncode.isSelected());
        this.rbEmbedInTiles.setEnabled(embedImages);
        this.rbEmbedInSet.setEnabled(embedImages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doExport() {
        ConfirmingFileChooser chooser = new ConfirmingFileChooser(null);
        chooser.addChoosableFileFilter(xmlFileFilter);
        int result = ((JFileChooser)chooser).showSaveDialog(this);
        if (result != 0) return;
        File configFile = chooser.getSelectedFile();
        try {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(configFile);
                prefs.exportSubtree(outputStream);
                Object var6_6 = null;
                if (outputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return;
        }
        catch (Exception e) {
            System.out.println("Error while exporting configuration:\n" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doImport() {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(xmlFileFilter);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            block6: {
                File configFile = chooser.getSelectedFile();
                try {
                    FileInputStream inputStream = null;
                    try {
                        inputStream = new FileInputStream(configFile);
                        Preferences.importPreferences(inputStream);
                        Object var6_6 = null;
                        if (inputStream == null) break block6;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Exception e) {
                    System.out.println("Error while importing configuration:\n" + e.toString());
                }
            }
            this.updateFromConfiguration();
        }
    }
}

