/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEditSupport;
import tiled.core.MapObject;
import tiled.mapeditor.Resources;
import tiled.mapeditor.dialogs.PropertiesDialog;
import tiled.mapeditor.undo.ChangeObjectEdit;
import tiled.mapeditor.widget.IntegerSpinner;
import tiled.mapeditor.widget.VerticalStaticJPanel;
import tiled.util.TiledConfiguration;

public class ObjectDialog
extends PropertiesDialog {
    private JTextField objectName;
    private JTextField objectType;
    private JTextField objectImageSource;
    private IntegerSpinner objectWidth;
    private IntegerSpinner objectHeight;
    private final MapObject object;
    private final UndoableEditSupport undoSupport;
    private static String path;
    private static final String DIALOG_TITLE;
    private static final String NAME_LABEL;
    private static final String TYPE_LABEL;
    private static final String IMAGE_LABEL;
    private static final String WIDTH_LABEL;
    private static final String HEIGHT_LABEL;
    private static final String UNTITLED_OBJECT;
    private static final String BROWSE_BUTTON;

    public ObjectDialog(JFrame parent, MapObject object, UndoableEditSupport undoSupport) {
        super(parent, object.getProperties());
        this.object = object;
        this.undoSupport = undoSupport;
        this.setTitle(DIALOG_TITLE);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void init() {
        super.init();
        JLabel nameLabel = new JLabel(NAME_LABEL);
        JLabel typeLabel = new JLabel(TYPE_LABEL);
        JLabel imageLabel = new JLabel(IMAGE_LABEL);
        JLabel widthLabel = new JLabel(WIDTH_LABEL);
        JLabel heightLabel = new JLabel(HEIGHT_LABEL);
        this.objectName = new JTextField(UNTITLED_OBJECT);
        this.objectType = new JTextField();
        this.objectImageSource = new JTextField();
        this.objectWidth = new IntegerSpinner(0, 0, 1024);
        this.objectHeight = new IntegerSpinner(0, 0, 1024);
        JButton browseButton = new JButton(BROWSE_BUTTON);
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser ch;
                int ret;
                String startLocation = path;
                if (startLocation == null) {
                    startLocation = TiledConfiguration.fileDialogStartLocation();
                }
                if ((ret = (ch = new JFileChooser(startLocation)).showOpenDialog(ObjectDialog.this)) == 0) {
                    path = ch.getSelectedFile().getAbsolutePath();
                    ObjectDialog.this.objectImageSource.setText(path);
                }
            }
        });
        JPanel imageSourcePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        imageSourcePanel.add((Component)this.objectImageSource, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 5, 0, 0);
        imageSourcePanel.add((Component)browseButton, c);
        VerticalStaticJPanel miscPropPanel = new VerticalStaticJPanel();
        miscPropPanel.setLayout(new GridBagLayout());
        miscPropPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        c = new GridBagConstraints();
        c.anchor = 13;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 0, 5);
        miscPropPanel.add((Component)nameLabel, c);
        c.gridy = 1;
        miscPropPanel.add((Component)typeLabel, c);
        c.gridy = 2;
        miscPropPanel.add((Component)imageLabel, c);
        c.gridy = 3;
        miscPropPanel.add((Component)widthLabel, c);
        c.gridy = 4;
        miscPropPanel.add((Component)heightLabel, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        miscPropPanel.add((Component)this.objectName, c);
        c.gridy = 1;
        miscPropPanel.add((Component)this.objectType, c);
        c.gridy = 2;
        miscPropPanel.add((Component)imageSourcePanel, c);
        c.gridy = 3;
        miscPropPanel.add((Component)this.objectWidth, c);
        c.gridy = 4;
        miscPropPanel.add((Component)this.objectHeight, c);
        this.mainPanel.add((Component)miscPropPanel, 0);
    }

    public void updateInfo() {
        super.updateInfo();
        this.objectName.setText(this.object.getName());
        this.objectType.setText(this.object.getType());
        this.objectImageSource.setText(this.object.getImageSource());
        this.objectWidth.setValue(this.object.getWidth());
        this.objectHeight.setValue(this.object.getHeight());
    }

    protected void buildPropertiesAndDispose() {
        this.undoSupport.postEdit(new ChangeObjectEdit(this.object));
        this.object.setName(this.objectName.getText());
        this.object.setType(this.objectType.getText());
        this.object.setImageSource(this.objectImageSource.getText());
        this.object.setWidth(this.objectWidth.intValue());
        this.object.setHeight(this.objectHeight.intValue());
        super.buildPropertiesAndDispose();
    }

    static {
        DIALOG_TITLE = Resources.getString("dialog.object.title");
        NAME_LABEL = Resources.getString("dialog.object.name.label");
        TYPE_LABEL = Resources.getString("dialog.object.type.label");
        IMAGE_LABEL = Resources.getString("dialog.object.image.label");
        WIDTH_LABEL = Resources.getString("dialog.object.width.label");
        HEIGHT_LABEL = Resources.getString("dialog.object.height.label");
        UNTITLED_OBJECT = Resources.getString("general.object.object");
        BROWSE_BUTTON = Resources.getString("general.button.browse");
    }
}

