/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import tiled.core.Map;
import tiled.core.Tile;
import tiled.core.TileSet;
import tiled.mapeditor.Resources;
import tiled.mapeditor.dialogs.TileImageDialog;
import tiled.mapeditor.util.ImageCellRenderer;
import tiled.mapeditor.util.PropertiesTableModel;
import tiled.mapeditor.util.TileDialogListRenderer;
import tiled.mapeditor.widget.VerticalStaticJPanel;

public class TileDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private Tile currentTile;
    private TileSet tileset;
    private Map map;
    private JList tileList;
    private JList imageList;
    private JTable tileProperties;
    private JButton okButton;
    private JButton addImagesButton;
    private JButton deleteTileButton;
    private JButton changeImageButton;
    private JButton duplicateTileButton;
    private JButton createTileButton;
    private String location = "";
    private JTextField tilesetNameEntry;
    private JTabbedPane tabs;
    private int currentImageIndex = -1;
    private static final String DIALOG_TITLE = Resources.getString("dialog.tile.title");
    private static final String OK_BUTTON = Resources.getString("general.button.ok");
    private static final String DELETE_BUTTON = Resources.getString("dialog.tile.button.deletetile");
    private static final String CI_BUTTON = Resources.getString("dialog.tile.button.changeimage");
    private static final String ADD_IMAGES_BUTTON = Resources.getString("dialog.tile.button.addimages");
    private static final String CREATE_BUTTON = Resources.getString("dialog.tile.button.createtile");
    private static final String DUPLICATE_BUTTON = Resources.getString("dialog.tile.button.duptile");
    private static final String ANIMATION_BUTTON = Resources.getString("dialog.tile.button.animation");
    private static final String PREVIEW_TAB = Resources.getString("dialog.tile.tab.view");
    private static final String TILES_TAB = Resources.getString("general.tile.tiles");
    private static final String IMAGES_TAB = "Images";
    private static final String NAME_LABEL = Resources.getString("dialog.newtileset.name.label");
    private static final String ERROR_LOADING_IMAGE = Resources.getString("dialog.tile.image.load.error");
    private static final String TILES_CREATED_MESSAGE = Resources.getString("action.tile.create.done.message");
    private static final String TILES_CREATED_TITLE = Resources.getString("action.tile.create.done.title");

    public TileDialog(Dialog parent, TileSet tileset, Map map) {
        super(parent, DIALOG_TITLE + " '" + tileset.getName() + "'", true);
        this.tileset = tileset;
        this.map = map;
        this.init();
        this.setTileset(tileset);
        this.setCurrentTile(null);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private JPanel createTilePanel() {
        this.deleteTileButton = new JButton(DELETE_BUTTON);
        this.changeImageButton = new JButton(CI_BUTTON);
        this.duplicateTileButton = new JButton(DUPLICATE_BUTTON);
        this.deleteTileButton.addActionListener(this);
        this.changeImageButton.addActionListener(this);
        this.duplicateTileButton.addActionListener(this);
        this.tileProperties = new JTable(new PropertiesTableModel());
        this.tileProperties.getSelectionModel().addListSelectionListener(this);
        JScrollPane propScrollPane = new JScrollPane(this.tileProperties);
        propScrollPane.setPreferredSize(new Dimension(150, 150));
        this.tileList = new JList();
        this.tileList.setCellRenderer(new TileDialogListRenderer());
        this.tileList.addListSelectionListener(this);
        JScrollPane sp = new JScrollPane();
        sp.getViewport().setView(this.tileList);
        sp.setPreferredSize(new Dimension(150, 150));
        JSplitPane splitPane = new JSplitPane(1, true);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        splitPane.setResizeWeight(0.25);
        splitPane.setLeftComponent(sp);
        splitPane.setRightComponent(propScrollPane);
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(this.deleteTileButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.changeImageButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.duplicateTileButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(Box.createGlue());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        mainPanel.add((Component)splitPane, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridy = 1;
        mainPanel.add((Component)buttons, c);
        return mainPanel;
    }

    private JPanel createImagePanel() {
        this.imageList = new JList();
        this.imageList.setCellRenderer(new ImageCellRenderer());
        this.imageList.setLayoutOrientation(2);
        this.imageList.addListSelectionListener(this);
        JScrollPane sp = new JScrollPane(this.imageList);
        sp.setPreferredSize(new Dimension(250, 150));
        this.createTileButton = new JButton(CREATE_BUTTON);
        this.addImagesButton = new JButton(ADD_IMAGES_BUTTON);
        this.createTileButton.addActionListener(this);
        this.addImagesButton.addActionListener(this);
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(this.addImagesButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.createTileButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        mainPanel.add((Component)sp, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridy = 1;
        mainPanel.add((Component)buttons, c);
        return mainPanel;
    }

    private void init() {
        JLabel nameLabel = new JLabel(NAME_LABEL);
        this.tilesetNameEntry = new JTextField(32);
        VerticalStaticJPanel namePanel = new VerticalStaticJPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        namePanel.add(nameLabel);
        namePanel.add(Box.createRigidArea(new Dimension(5, 5)));
        namePanel.add(this.tilesetNameEntry);
        this.tabs = new JTabbedPane(1);
        this.tabs.addTab(TILES_TAB, this.createTilePanel());
        this.tabs.addTab(IMAGES_TAB, this.createImagePanel());
        this.okButton = new JButton(OK_BUTTON);
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createGlue());
        buttons.add(this.okButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(namePanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(this.tabs);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(buttons);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileDialog.this.tileset.setName(TileDialog.this.tilesetNameEntry.getText());
                TileDialog.this.applyTileProperties();
                TileDialog.this.dispose();
            }
        });
    }

    private void changeImage() {
        if (this.currentTile == null) {
            return;
        }
        TileImageDialog dialog = new TileImageDialog((Dialog)this, this.tileset, this.currentTile.getImageId());
        dialog.setVisible(true);
        if (dialog.getImageId() >= 0) {
            this.currentTile.setImage(dialog.getImageId());
        }
    }

    private void addImages() {
        JFileChooser fc = new JFileChooser(this.location);
        fc.setMultiSelectionEnabled(true);
        int ret = fc.showOpenDialog(this);
        if (ret == 0) {
            File[] files;
            for (File file : files = fc.getSelectedFiles()) {
                BufferedImage image;
                try {
                    image = ImageIO.read(file);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error!", 0);
                    return;
                }
                this.tileset.addImage(image);
            }
            if (files.length > 0) {
                this.location = files[0].getAbsolutePath();
            }
        }
        this.queryImages();
    }

    public void setTileset(TileSet set) {
        this.tileset = set;
        if (this.tileset != null) {
            if (this.tileset.getSource() != null) {
                this.location = this.tileset.getSource();
            } else if (this.map != null) {
                this.location = this.map.getFilename();
            }
            this.tilesetNameEntry.setText(this.tileset.getName());
        }
        this.queryTiles();
        this.queryImages();
        this.updateEnabledState();
    }

    public void queryTiles() {
        if (this.tileset != null && this.tileset.size() > 0) {
            Vector<Tile> listData = new Vector<Tile>();
            Iterator tileIterator = this.tileset.iterator();
            while (tileIterator.hasNext()) {
                Tile tile = (Tile)tileIterator.next();
                listData.add(tile);
            }
            this.tileList.setListData(listData);
        }
        if (this.currentTile != null) {
            this.tileList.setSelectedIndex(this.currentTile.getId() - 1);
            this.tileList.ensureIndexIsVisible(this.currentTile.getId() - 1);
        }
    }

    public void queryImages() {
        Vector<Image> listData = new Vector<Image>();
        Enumeration<String> ids = this.tileset.getImageIds();
        while (ids.hasMoreElements()) {
            Image img = this.tileset.getImageById(Integer.parseInt(ids.nextElement()));
            if (img == null) continue;
            listData.add(img);
        }
        this.imageList.setListData(listData);
        if (this.currentImageIndex != -1) {
            this.imageList.setSelectedIndex(this.currentImageIndex);
            this.imageList.ensureIndexIsVisible(this.currentImageIndex);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.tileList) {
            this.setCurrentTile((Tile)this.tileList.getSelectedValue());
        } else if (e.getSource() == this.imageList) {
            this.setImageIndex(this.imageList.getSelectedIndex());
        }
    }

    private void setCurrentTile(Tile tile) {
        this.applyTileProperties();
        this.currentTile = tile;
        this.updateTileInfo();
        this.updateEnabledState();
    }

    private void applyTileProperties() {
        TableCellEditor editor = this.tileProperties.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        if (this.currentTile != null) {
            PropertiesTableModel model = (PropertiesTableModel)this.tileProperties.getModel();
            this.currentTile.setProperties(model.getProperties());
        }
    }

    private void setImageIndex(int i) {
        this.currentImageIndex = i;
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        boolean tilebmp = this.tileset.getTilebmpFile() != null;
        boolean tileSelected = this.currentTile != null;
        boolean atLeastOneSharedImage = this.tileset.getTotalImages() >= 1;
        boolean imageSelected = this.imageList.getSelectedValue() != null;
        this.deleteTileButton.setEnabled(!tilebmp && tileSelected);
        this.changeImageButton.setEnabled(atLeastOneSharedImage && !tilebmp && tileSelected);
        this.duplicateTileButton.setEnabled(!tilebmp && tileSelected);
        this.tileProperties.setEnabled(tileSelected);
        this.addImagesButton.setEnabled(!tilebmp);
        this.createTileButton.setEnabled(!tilebmp && imageSelected);
    }

    private void updateTileInfo() {
        PropertiesTableModel model = (PropertiesTableModel)this.tileProperties.getModel();
        if (this.currentTile == null) {
            model.setProperties(new Properties());
        } else {
            model.setProperties(this.currentTile.getProperties());
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.deleteTileButton) {
            int answer = JOptionPane.showConfirmDialog(this, Resources.getString("action.tile.delete.confirm.message"), Resources.getString("action.tile.delete.confirm.title"), 0, 3);
            if (answer == 0) {
                Tile tile = (Tile)this.tileList.getSelectedValue();
                if (tile != null) {
                    this.tileset.removeTile(tile.getId());
                }
                this.queryTiles();
            }
        } else if (source == this.changeImageButton) {
            this.changeImage();
        } else if (source == this.addImagesButton) {
            this.addImages();
        } else if (source == this.duplicateTileButton) {
            Tile newTile = new Tile(this.currentTile);
            this.tileset.addNewTile(newTile);
            this.queryTiles();
            this.tileList.setSelectedIndex(this.tileset.size() - 1);
            this.tileList.ensureIndexIsVisible(this.tileset.size() - 1);
        } else if (source == this.createTileButton) {
            Object[] imgs = this.imageList.getSelectedValues();
            if (imgs.length == 0) {
                return;
            }
            for (Object img : imgs) {
                Tile newTile = new Tile(this.tileset);
                newTile.setImage(this.tileset.getIdByImage((Image)img));
                this.tileset.addNewTile(newTile);
            }
            this.queryTiles();
            this.tileList.setSelectedIndex(this.tileset.size() - 1);
            this.tileList.ensureIndexIsVisible(this.tileset.size() - 1);
            JOptionPane.showMessageDialog(this, MessageFormat.format(TILES_CREATED_MESSAGE, imgs.length), TILES_CREATED_TITLE, 1);
        }
        this.repaint();
    }
}

