/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tiled.core.TileSet;
import tiled.mapeditor.Resources;
import tiled.mapeditor.util.ImageCellRenderer;
import tiled.mapeditor.widget.VerticalStaticJPanel;

public class TileImageDialog
extends JDialog
implements ListSelectionListener {
    private JList imageList;
    private JButton okButton;
    private JButton cancelButton;
    private int imageId;
    private final TileSet tileset;
    private JLabel imageLabel;
    private int[] imageIds;
    private static final String DIALOG_TITLE = Resources.getString("dialog.tileimage.title");
    private static final String OK_BUTTON = Resources.getString("general.button.ok");
    private static final String CANCEL_BUTTON = Resources.getString("general.button.cancel");

    public TileImageDialog(Dialog parent, TileSet set) {
        this(parent, set, 0);
    }

    public TileImageDialog(Dialog parent, TileSet set, int id) {
        super(parent, DIALOG_TITLE, true);
        this.tileset = set;
        this.imageId = id;
        this.init();
        this.queryImages();
        this.updateImageLabel();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void init() {
        this.imageList = new JList();
        this.imageList.setCellRenderer(new ImageCellRenderer());
        this.imageList.setLayoutOrientation(2);
        this.imageList.addListSelectionListener(this);
        JScrollPane sp = new JScrollPane();
        sp.getViewport().setView(this.imageList);
        sp.setPreferredSize(new Dimension(150, 150));
        JPanel image_panel = new JPanel();
        image_panel.setLayout(new BoxLayout(image_panel, 1));
        this.imageLabel = new JLabel(new ImageIcon());
        image_panel.add(this.imageLabel);
        this.okButton = new JButton(OK_BUTTON);
        this.cancelButton = new JButton(CANCEL_BUTTON);
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        mainPanel.add((Component)sp, c);
        c.weightx = 0.0;
        c.gridx = 1;
        mainPanel.add((Component)image_panel, c);
        c.gridx = 0;
        c.weighty = 0.0;
        c.gridy = 1;
        c.gridwidth = 2;
        mainPanel.add((Component)buttons, c);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileImageDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileImageDialog.this.imageId = -1;
                TileImageDialog.this.dispose();
            }
        });
    }

    public void queryImages() {
        int i;
        Vector<Image> listData = new Vector<Image>();
        int initialIndex = 0;
        Enumeration<String> ids = this.tileset.getImageIds();
        this.imageIds = new int[this.tileset.getTotalImages()];
        for (i = 0; i < this.imageIds.length; ++i) {
            this.imageIds[i] = Integer.parseInt(ids.nextElement());
        }
        Arrays.sort(this.imageIds);
        for (i = 0; i < this.imageIds.length; ++i) {
            if (this.imageIds[i] == this.imageId) {
                initialIndex = i;
            }
            Image img = this.tileset.getImageById(this.imageIds[i]);
            listData.add(img);
        }
        this.imageList.setListData(listData);
        this.imageList.setSelectedIndex(initialIndex);
        this.imageList.ensureIndexIsVisible(initialIndex);
    }

    private void updateEnabledState() {
        this.okButton.setEnabled(this.imageId >= 0);
    }

    private void updateImageLabel() {
        if (this.imageId >= 0) {
            Image img = this.tileset.getImageById(this.imageId);
            this.imageLabel.setIcon(new ImageIcon(img));
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.imageId = this.imageIds[this.imageList.getSelectedIndex()];
        this.updateImageLabel();
        this.updateEnabledState();
    }

    public int getImageId() {
        return this.imageId;
    }
}

