/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import tiled.core.MapObject;
import tiled.core.ObjectGroup;
import tiled.mapeditor.Resources;

public class AddObjectEdit
extends AbstractUndoableEdit {
    private final ObjectGroup objectGroup;
    private final MapObject mapObject;

    public AddObjectEdit(ObjectGroup objectGroup, MapObject mapObject) {
        this.objectGroup = objectGroup;
        this.mapObject = mapObject;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.objectGroup.removeObject(this.mapObject);
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.objectGroup.addObject(this.mapObject);
    }

    public String getPresentationName() {
        return Resources.getString("action.object.add.name");
    }
}

