/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.widget;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import tiled.core.Map;
import tiled.core.MapChangeListener;
import tiled.core.MapChangedEvent;
import tiled.core.TileSet;
import tiled.core.TilesetChangeListener;
import tiled.core.TilesetChangedEvent;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.brush.CustomBrush;
import tiled.mapeditor.util.TileRegionSelectionEvent;
import tiled.mapeditor.util.TileSelectionEvent;
import tiled.mapeditor.util.TileSelectionListener;
import tiled.mapeditor.widget.TilePalettePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedTilesetsPane
extends JTabbedPane
implements TileSelectionListener {
    private final HashMap<TileSet, TilePalettePanel> tilePanels = new HashMap();
    private final MyChangeListener listener = new MyChangeListener();
    private final MapEditor mapEditor;
    private Map map;

    public TabbedTilesetsPane(MapEditor mapEditor) {
        this.mapEditor = mapEditor;
    }

    public void setMap(Map map) {
        if (this.map != null) {
            this.map.removeMapChangeListener(this.listener);
        }
        if (map == null) {
            this.removeAll();
        } else {
            this.recreateTabs(map.getTilesets());
            map.addMapChangeListener(this.listener);
        }
        this.map = map;
    }

    private void recreateTabs(List<TileSet> tilesets) {
        for (TilePalettePanel panel : this.tilePanels.values()) {
            panel.removeTileSelectionListener(this);
            panel.getTileset().removeTilesetChangeListener(this.listener);
        }
        this.tilePanels.clear();
        this.removeAll();
        if (tilesets != null) {
            for (TileSet tileset : tilesets) {
                if (tileset == null) continue;
                this.addTabForTileset(tileset);
            }
        }
    }

    private void addTabForTileset(TileSet tileset) {
        tileset.addTilesetChangeListener(this.listener);
        TilePalettePanel tilePanel = new TilePalettePanel();
        tilePanel.setTileset(tileset);
        tilePanel.addTileSelectionListener(this);
        JScrollPane paletteScrollPane = new JScrollPane(tilePanel, 22, 30);
        this.addTab(tileset.getName(), paletteScrollPane);
        this.tilePanels.put(tileset, tilePanel);
    }

    @Override
    public void tileSelected(TileSelectionEvent e) {
        this.mapEditor.setCurrentTile(e.getTile());
    }

    @Override
    public void tileRegionSelected(TileRegionSelectionEvent e) {
        this.mapEditor.setBrush(new CustomBrush(e.getTileRegion()));
    }

    private class MyChangeListener
    implements MapChangeListener,
    TilesetChangeListener {
        private MyChangeListener() {
        }

        public void mapChanged(MapChangedEvent e) {
        }

        public void tilesetAdded(MapChangedEvent e, TileSet tileset) {
            TabbedTilesetsPane.this.addTabForTileset(tileset);
        }

        public void tilesetRemoved(MapChangedEvent e, int index) {
            JScrollPane scroll = (JScrollPane)TabbedTilesetsPane.this.getComponentAt(index);
            TilePalettePanel panel = (TilePalettePanel)scroll.getViewport().getView();
            TileSet set = panel.getTileset();
            panel.removeTileSelectionListener(TabbedTilesetsPane.this);
            set.removeTilesetChangeListener(TabbedTilesetsPane.this.listener);
            TabbedTilesetsPane.this.tilePanels.remove(set);
            TabbedTilesetsPane.this.removeTabAt(index);
        }

        public void tilesetsSwapped(MapChangedEvent e, int index0, int index1) {
            int sIndex = TabbedTilesetsPane.this.getSelectedIndex();
            String title0 = TabbedTilesetsPane.this.getTitleAt(index0);
            String title1 = TabbedTilesetsPane.this.getTitleAt(index1);
            Component comp0 = TabbedTilesetsPane.this.getComponentAt(index0);
            Component comp1 = TabbedTilesetsPane.this.getComponentAt(index1);
            TabbedTilesetsPane.this.removeTabAt(index1);
            TabbedTilesetsPane.this.removeTabAt(index0);
            TabbedTilesetsPane.this.insertTab(title1, null, comp1, null, index0);
            TabbedTilesetsPane.this.insertTab(title0, null, comp0, null, index1);
            if (sIndex == index0) {
                sIndex = index1;
            } else if (sIndex == index1) {
                sIndex = index0;
            }
            TabbedTilesetsPane.this.setSelectedIndex(sIndex);
        }

        public void tilesetChanged(TilesetChangedEvent event) {
        }

        public void nameChanged(TilesetChangedEvent event, String oldName, String newName) {
            TileSet set = event.getTileset();
            int index = TabbedTilesetsPane.this.map.getTilesets().indexOf(set);
            TabbedTilesetsPane.this.setTitleAt(index, newName);
        }

        public void sourceChanged(TilesetChangedEvent event, String oldSource, String newSource) {
        }
    }
}

