/*
 * Decompiled with CFR 0.152.
 */
package tiled.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Iterator;
import tiled.core.Map;
import tiled.core.MapObject;
import tiled.core.ObjectGroup;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.mapeditor.selection.SelectionLayer;
import tiled.view.MapView;

public class HexMapView
extends MapView {
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_BOTTOM = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int ALIGN_LEFT = 4;
    private static final double HEX_SLOPE = Math.tan(Math.toRadians(60.0));
    private int mapAlignment = 1;
    private boolean hexEdgesToTheLeft = false;
    private boolean alignedToBottomOrRight;

    public HexMapView(Map map) {
        super(map);
        if (this.mapAlignment == 1 || this.mapAlignment == 2) {
            this.hexEdgesToTheLeft = true;
        }
        this.alignedToBottomOrRight = false;
        if (this.mapAlignment == 2 || this.mapAlignment == 3) {
            this.alignedToBottomOrRight = true;
        }
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension tsize = this.getEffectiveTileSize();
        int border = this.showGrid ? 1 : 0;
        int tq = this.getThreeQuarterHex();
        int hWidth = (int)((double)(tsize.width / 2) + 0.49) + border;
        int hHeight = (int)((double)(tsize.height / 2) + 0.49) + border;
        if (orientation == 1) {
            if (this.hexEdgesToTheLeft) {
                return (visibleRect.height - hHeight) / (tsize.height + border) * (tsize.height + border);
            }
            return (visibleRect.height - hHeight) / (tq + border) * (tq + border);
        }
        if (this.hexEdgesToTheLeft) {
            return (visibleRect.width - hWidth) / (tq + border) * (tq + border);
        }
        return (visibleRect.width - hWidth) / (tsize.width + border) * (tsize.width + border);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension tsize = this.getEffectiveTileSize();
        int border = this.showGrid ? 1 : 0;
        int tq = this.getThreeQuarterHex();
        if (orientation == 1) {
            if (this.hexEdgesToTheLeft) {
                return tsize.height + border;
            }
            return tq + border;
        }
        if (this.hexEdgesToTheLeft) {
            return tq + border;
        }
        return tsize.width + border;
    }

    public Dimension getPreferredSize() {
        int h;
        int w;
        Dimension tsize = this.getEffectiveTileSize();
        int border = this.showGrid ? 1 : 0;
        int tq = this.getThreeQuarterHex();
        int oq = this.getOneQuarterHex();
        if (this.hexEdgesToTheLeft) {
            w = this.map.getWidth() * (tq + border) + oq + border;
            h = this.map.getHeight() * (tsize.height + border) + (int)((double)(tsize.height / 2) + 0.49) + border;
        } else {
            w = this.map.getWidth() * (tsize.width + border) + (int)((double)(tsize.width / 2) + 0.49) + border;
            h = this.map.getHeight() * (tq + border) + oq + border;
        }
        return new Dimension(w, h);
    }

    protected void paintLayer(Graphics2D g2d, TileLayer layer) {
        Dimension tsize = this.getEffectiveTileSize();
        Rectangle clipRect = g2d.getClipBounds();
        Point topLeft = this.screenToTileCoords((int)clipRect.getMinX(), (int)clipRect.getMinY());
        Point bottomRight = this.screenToTileCoords((int)clipRect.getMaxX(), (int)clipRect.getMaxY());
        int startX = (int)topLeft.getX();
        int startY = (int)topLeft.getY();
        int endX = (int)bottomRight.getX();
        int endY = (int)bottomRight.getY();
        if (startX < 0) {
            startX = 0;
        }
        if (startY < 0) {
            startY = 0;
        }
        if (endX >= this.map.getWidth()) {
            endX = this.map.getWidth() - 1;
        }
        if (endY >= this.map.getHeight()) {
            endY = this.map.getHeight() - 1;
        }
        for (int y = startY; y <= endY; ++y) {
            for (int x = startX; x <= endX; ++x) {
                Tile t = layer.getTileAt(x, y);
                if (t == null) continue;
                if (layer.getClass() == SelectionLayer.class) {
                    Polygon gridPoly = this.createGridPolygon(x, y, 0);
                    g2d.fillPolygon(gridPoly);
                    continue;
                }
                Point screenCoords = this.getTopLeftCornerOfTile(x, y);
                double gx = screenCoords.getX();
                double gy = screenCoords.getY();
                t.draw(g2d, (int)gx, (int)(gy + (double)tsize.height), this.zoom);
            }
        }
    }

    protected void paintLayer(Graphics2D g2d, ObjectGroup og) {
    }

    private Dimension getEffectiveTileSize() {
        return new Dimension((int)((double)this.map.getTileWidth() * this.zoom + 0.999), (int)((double)this.map.getTileHeight() * this.zoom + 0.999));
    }

    private int getThreeQuarterHex() {
        int tq = this.hexEdgesToTheLeft ? (int)((double)this.getEffectiveTileSize().width * 3.0 / 4.0 + 0.49) : (int)((double)this.getEffectiveTileSize().height * 3.0 / 4.0 + 0.49);
        return tq;
    }

    private int getOneQuarterHex() {
        int oq = this.hexEdgesToTheLeft ? this.getEffectiveTileSize().width : this.getEffectiveTileSize().height;
        return oq - this.getThreeQuarterHex();
    }

    protected void paintGrid(Graphics2D g2d) {
        g2d.setColor(Color.black);
        Dimension tileSize = this.getEffectiveTileSize();
        Rectangle clipRect = g2d.getClipBounds();
        Point topLeft = this.screenToTileCoords((int)clipRect.getMinX(), (int)clipRect.getMinY());
        Point bottomRight = this.screenToTileCoords((int)clipRect.getMaxX(), (int)clipRect.getMaxY());
        int startX = (int)topLeft.getX();
        int startY = (int)topLeft.getY();
        int endX = (int)bottomRight.getX();
        int endY = (int)bottomRight.getY();
        if (startX < 0) {
            startX = 0;
        }
        if (startY < 0) {
            startY = 0;
        }
        if (endX >= this.map.getWidth()) {
            endX = this.map.getWidth() - 1;
        }
        if (endY >= this.map.getHeight()) {
            endY = this.map.getHeight() - 1;
        }
        boolean dy = false;
        boolean dx = false;
        if (this.hexEdgesToTheLeft) {
            for (int x = startX; x <= endX; ++x) {
                Polygon grid = this.createGridPolygon(x, startY, 1);
                for (int y = startY; y <= endY; ++y) {
                    g2d.drawPolygon(grid);
                    grid.translate(0, tileSize.height + 1);
                }
            }
        } else {
            for (int y = startY; y <= endY; ++y) {
                Polygon grid = this.createGridPolygon(startX, y, 1);
                for (int x = startX; x <= endX; ++x) {
                    g2d.drawPolygon(grid);
                    grid.translate(tileSize.width + 1, 0);
                }
            }
        }
    }

    protected void paintCoordinates(Graphics2D g2d) {
    }

    public Point screenToTileCoords(int screenX, int screenY) {
        int tx = 0;
        int ty = 0;
        int border = this.showGrid ? 1 : 0;
        Dimension tileSize = this.getEffectiveTileSize();
        int tileWidth = tileSize.width + border;
        int tileHeight = tileSize.height + border;
        int hWidth = (int)((double)(tileWidth / 2) + 0.49) + border;
        int hHeight = (int)((double)(tileHeight / 2) + 0.49) + border;
        Point[] fourPoints = new Point[4];
        Point[] fourTiles = new Point[4];
        int x = screenX;
        int y = screenY;
        int col = 0;
        col = x < hWidth ? -1 : (this.hexEdgesToTheLeft ? (int)((double)(x - hWidth) / (double)(this.getThreeQuarterHex() + border) + 0.001) : (int)((double)(x - hWidth) / (double)tileWidth + 0.001));
        int row = 0;
        row = y < hHeight ? -1 : (this.hexEdgesToTheLeft ? (int)((double)(y - hHeight) / (double)tileHeight + 0.001) : (int)((double)(y - hHeight) / (double)(this.getThreeQuarterHex() + border) + 0.001));
        fourTiles[0] = new Point(col, row);
        fourTiles[1] = new Point(col, row + 1);
        fourTiles[2] = new Point(col + 1, row);
        fourTiles[3] = new Point(col + 1, row + 1);
        fourPoints[0] = this.tileToScreenCoords(col, row);
        fourPoints[1] = this.tileToScreenCoords(col, row + 1);
        fourPoints[2] = this.tileToScreenCoords(col + 1, row);
        fourPoints[3] = this.tileToScreenCoords(col + 1, row + 1);
        double minDist = 2 * (this.map.getTileWidth() + this.map.getTileHeight());
        int minI = 5;
        for (int i = 0; i < fourPoints.length; ++i) {
            if (!(fourPoints[i].distance(x, y) < minDist)) continue;
            minDist = fourPoints[i].distance(x, y);
            minI = i;
        }
        tx = (int)fourTiles[minI].getX();
        ty = (int)fourTiles[minI].getY();
        return new Point(tx, ty);
    }

    public void repaintRegion(Rectangle region) {
        super.repaintRegion(region);
    }

    protected Polygon createGridPolygon(int tx, int ty, int border) {
        Dimension tileSize = this.getEffectiveTileSize();
        Polygon poly = new Polygon();
        Point p = this.getTopLeftCornerOfTile(tx, ty);
        int topLeftX = (int)p.getX();
        int topLeftY = (int)p.getY();
        int tq = this.getThreeQuarterHex();
        int oq = this.getOneQuarterHex();
        if (this.hexEdgesToTheLeft) {
            int hh = (int)((double)(tileSize.height / 2) + 0.49);
            poly.addPoint(topLeftX - 1, topLeftY + hh - 1);
            poly.addPoint(topLeftX + oq - 1, topLeftY - 1);
            poly.addPoint(topLeftX + tq, topLeftY - 1);
            poly.addPoint(topLeftX + tileSize.width, topLeftY + hh - 1);
            poly.addPoint(topLeftX + tq, topLeftY + tileSize.height);
            poly.addPoint(topLeftX + oq - 1, topLeftY + tileSize.height);
        } else {
            int hh = (int)((double)(tileSize.width / 2) + 0.49);
            poly.addPoint(topLeftX + hh - 1, topLeftY - 1);
            poly.addPoint(topLeftX + tileSize.width, topLeftY + oq - 1);
            poly.addPoint(topLeftX + tileSize.width, topLeftY + tq);
            poly.addPoint(topLeftX + hh - 1, topLeftY + tileSize.height);
            poly.addPoint(topLeftX - 1, topLeftY + tq);
            poly.addPoint(topLeftX - 1, topLeftY + oq - 1);
        }
        return poly;
    }

    private Point getTopLeftCornerOfTile(int x, int y) {
        int yy;
        int xx;
        Dimension tileSize = this.getEffectiveTileSize();
        int w = tileSize.width;
        int h = tileSize.height;
        if (this.hexEdgesToTheLeft) {
            xx = x * this.getThreeQuarterHex();
            yy = y * h;
        } else {
            xx = x * w;
            yy = y * this.getThreeQuarterHex();
        }
        if (this.showGrid) {
            xx += x + 1;
            yy += y + 1;
        }
        if (Math.abs(x % 2) == 1 && this.mapAlignment == 1 || x % 2 == 0 && this.mapAlignment == 2) {
            yy += (int)((double)h / 2.0 + 0.49);
        }
        if (Math.abs(y % 2) == 1 && this.mapAlignment == 4 || y % 2 == 0 && this.mapAlignment == 3) {
            xx += (int)((double)w / 2.0 + 0.49);
        }
        return new Point(xx, yy);
    }

    public Point tileToScreenCoords(int x, int y) {
        Point p = this.getTopLeftCornerOfTile(x, y);
        Dimension tileSize = this.getEffectiveTileSize();
        return new Point((int)p.getX() + (int)((double)(tileSize.width / 2) + 0.49), (int)p.getY() + (int)((double)(tileSize.height / 2) + 0.49));
    }

    public Point screenToPixelCoords(int x, int y) {
        return new Point((int)((double)x / this.zoom), (int)((double)y / this.zoom));
    }

    protected void paintPropertyFlags(Graphics2D g2d, TileLayer layer) {
    }

    protected void paintObjectGroup(Graphics2D g, ObjectGroup og) {
        Iterator<MapObject> itr = og.getObjects();
        while (itr.hasNext()) {
            MapObject mo = itr.next();
            double ox = (double)mo.getX() * this.zoom;
            double oy = (double)mo.getY() * this.zoom;
            if (mo.getWidth() == 0 || mo.getHeight() == 0) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.black);
                g.fillOval((int)ox + 1, (int)oy + 1, (int)(10.0 * this.zoom), (int)(10.0 * this.zoom));
                g.setColor(Color.orange);
                g.fillOval((int)ox, (int)oy, (int)(10.0 * this.zoom), (int)(10.0 * this.zoom));
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                g.setColor(Color.black);
                g.drawRect((int)ox + 1, (int)oy + 1, (int)((double)mo.getWidth() * this.zoom), (int)((double)mo.getHeight() * this.zoom));
                g.setColor(Color.orange);
                g.drawRect((int)ox, (int)oy, (int)((double)mo.getWidth() * this.zoom), (int)((double)mo.getHeight() * this.zoom));
            }
            if (!(this.zoom > 0.0625)) continue;
            String s = mo.getName() != null ? mo.getName() : "(null)";
            g.setColor(Color.black);
            g.drawString(s, (int)(ox - 5.0) + 1, (int)(oy - 5.0) + 1);
            g.setColor(Color.white);
            g.drawString(s, (int)(ox - 5.0), (int)(oy - 5.0));
        }
    }
}

