/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;

public class CompassPanel
extends JPanel {
    private static final int PANEL_SIZE = 80;
    private static final int CIRCLE_RADIUS = 5;
    private static final int OFFSET = 8;
    private int[] xPos;
    private int[] yPos;
    private int compassDir;
    private Font labelFont;
    private String axesLabel;
    private int xLabel;
    private int yLabel;

    public CompassPanel(String label) {
        this.axesLabel = label;
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(80, 80));
        this.initCompass();
        this.labelFont = new Font("SansSerif", 1, 12);
        FontMetrics metrics = this.getFontMetrics(this.labelFont);
        this.xLabel = (80 - metrics.stringWidth(this.axesLabel)) / 2;
        this.yLabel = 16;
    }

    private void initCompass() {
        this.xPos = new int[9];
        this.yPos = new int[9];
        this.xPos[0] = 8;
        this.yPos[0] = 8;
        this.xPos[1] = 40;
        this.yPos[1] = 8;
        this.xPos[2] = 72;
        this.yPos[2] = 8;
        this.xPos[3] = 8;
        this.yPos[3] = 40;
        this.xPos[4] = 40;
        this.yPos[4] = 40;
        this.xPos[5] = 72;
        this.yPos[5] = 40;
        this.xPos[6] = 8;
        this.yPos[6] = 72;
        this.xPos[7] = 40;
        this.yPos[7] = 72;
        this.xPos[8] = 72;
        this.yPos[8] = 72;
        this.compassDir = 4;
    }

    public void setCompass(int pos) {
        if (pos < 0 || pos >= 9) {
            System.out.println("Compass value out of range");
            this.compassDir = 4;
        } else {
            this.compassDir = pos;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawRect(1, 1, 78, 78);
        g.setFont(this.labelFont);
        g.drawString(this.axesLabel, this.xLabel, this.yLabel);
        g.fillOval(this.xPos[this.compassDir] - 5, this.yPos[this.compassDir] - 5, 10, 10);
    }
}

