/*
 * Decompiled with CFR 0.152.
 */
package com.easycapture.recorder;

import com.easycapture.recorder.Recorder;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jemu.ui.Display;

public class Control
extends JFrame {
    private ButtonGroup buttonGroup1;
    private JRadioButton fps;
    private JRadioButton fps25;
    public static JLabel frames;
    public static JCheckBox hires;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JToggleButton jToggleButton1;
    public JToggleButton pause;
    public static JLabel prev;
    private JSlider qual;
    private JLabel quali;

    public Control() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        prev = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.qual = new JSlider();
        this.quali = new JLabel();
        hires = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.fps25 = new JRadioButton();
        this.fps = new JRadioButton();
        this.pause = new JToggleButton();
        this.jLabel2 = new JLabel();
        frames = new JLabel();
        this.setTitle("JavaCPC Quicktime Recorder");
        this.setResizable(false);
        prev.setBorder(BorderFactory.createEtchedBorder());
        this.jToggleButton1.setText("Start");
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Control.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.qual.setMajorTickSpacing(10);
        this.qual.setPaintTicks(true);
        this.qual.setValue(80);
        this.qual.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Control.this.qualStateChanged(evt);
            }
        });
        this.quali.setText("80%");
        hires.setText("HiRes");
        this.jLabel1.setText("Image quality:");
        this.buttonGroup1.add(this.fps25);
        this.fps25.setSelected(true);
        this.fps25.setText("25 fps");
        this.fps25.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Control.this.fps25ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.fps);
        this.fps.setText("50 fps");
        this.pause.setText("Pause");
        this.pause.setEnabled(false);
        this.jLabel2.setText("Frames:");
        frames.setText("0");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(prev, GroupLayout.Alignment.LEADING, -2, 388, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fps25).addComponent(this.jToggleButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pause).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.qual, -1, 156, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.quali)).addGroup(layout.createSequentialGroup().addComponent(this.fps).addGap(18, 18, 18).addComponent(hires).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(frames))))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(prev, -2, 276, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.quali, -2, 23, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jToggleButton1, -1, -1, Short.MAX_VALUE).addComponent(this.pause, -1, -1, Short.MAX_VALUE)).addComponent(this.qual, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fps25).addComponent(this.fps).addComponent(hires).addComponent(this.jLabel2).addComponent(frames)))).addContainerGap()));
        this.pack();
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        if (this.jToggleButton1.isSelected()) {
            Recorder.frames = 0L;
            this.fps.setEnabled(false);
            this.fps25.setEnabled(false);
            this.qual.setEnabled(false);
            hires.setEnabled(false);
            this.quali.setEnabled(false);
            this.jToggleButton1.setText("Stop");
            Display.cancap = true;
            this.pause.setEnabled(true);
        } else {
            this.jToggleButton1.setText("Start");
            this.fps.setEnabled(true);
            this.fps25.setEnabled(true);
            this.qual.setEnabled(true);
            hires.setEnabled(true);
            this.quali.setEnabled(true);
            this.pause.setEnabled(false);
            Display.stopcap = true;
        }
    }

    private void qualStateChanged(ChangeEvent evt) {
        this.quali.setText(this.qual.getValue() + "%");
        String h = "" + (double)this.qual.getValue() / 100.0;
        Display.quality = Float.parseFloat(h);
    }

    private void fps25ActionPerformed(ActionEvent evt) {
        if (this.fps25.isSelected()) {
            Recorder.captureInterval = 25;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Control().setVisible(true);
            }
        });
    }
}

