/*
 * Decompiled with CFR 0.152.
 */
package com.easycapture.recorder;

import com.easycapture.recorder.Control;
import com.easycapture.recorder.JpegImagesToMovie;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.media.MediaLocator;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import jemu.ui.Display;

public class Recorder {
    public static long frames = 0L;
    public static int screenWidth = 384;
    public static int hiresWidth = 768;
    public static int screenHeight = 272;
    public static int hiresHeight = 544;
    public static int captureInterval = 25;
    public static String store;
    static boolean ret;
    static BufferedImage buffer;

    public static void clearTemp() {
        final File fz = new File(store);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean deleted = false;
                    while (!deleted) {
                        deleted = Recorder.deleteDirectory(fz);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void step(float quality) {
        if (ret) {
            return;
        }
        Graphics g = buffer.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g = g2;
        g.drawImage(Display.image, 0, 0, screenWidth, screenHeight, null);
        try {
            Control.prev.setIcon(new ImageIcon(buffer));
        }
        catch (Exception f) {
            // empty catch block
        }
        if (Control.hires.isSelected()) {
            this.writeImage(Display.image, quality);
        } else {
            this.writeImage(buffer, quality);
        }
        Control.frames.setText("" + ++frames);
    }

    public void writeImage(BufferedImage in, float quality) {
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(quality);
            File file = new File("./" + store + "/" + System.currentTimeMillis() + ".jpg");
            FileImageOutputStream output = new FileImageOutputStream(file);
            writer.setOutput(output);
            IIOImage image = new IIOImage(in, null, null);
            writer.write(null, image, iwp);
            output.close();
            writer.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeVideo(String movFile) throws MalformedURLException {
        ret = true;
        Display.record = false;
        if (frames < 1L) {
            return;
        }
        System.out.println("#### Easy Capture making video, please wait!!! ####");
        JpegImagesToMovie imageToMovie = new JpegImagesToMovie();
        Vector<String> imgLst = new Vector<String>();
        File f = new File(store);
        File[] fileLst = f.listFiles();
        for (int i = 0; i < fileLst.length; ++i) {
            imgLst.add(fileLst[i].getAbsolutePath());
        }
        MediaLocator oml = JpegImagesToMovie.createMediaLocator(movFile);
        if (oml == null) {
            System.err.println("Cannot build media locator from: " + movFile);
            System.exit(0);
        }
        if (Control.hires.isSelected()) {
            imageToMovie.doIt(hiresWidth, hiresHeight, captureInterval, imgLst, oml);
        } else {
            imageToMovie.doIt(screenWidth, screenHeight, captureInterval, imgLst, oml);
        }
    }

    static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Recorder.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
            path.delete();
            return false;
        }
        return true;
    }

    public static void doMov() {
        ret = false;
        store = "tmp_" + System.currentTimeMillis();
        File f = new File(store);
        if (!f.exists()) {
            f.mkdir();
        }
        buffer = null;
        int width = Display.image.getWidth();
        int height = Display.image.getHeight();
        width = 384;
        height = 272;
        buffer = new BufferedImage(384, 272, 1);
        screenWidth = width;
        screenHeight = height;
    }

    public static void stopMov() {
        ret = true;
        System.out.println("Easy Capture has stopped.");
        try {
            Recorder.makeVideo(System.currentTimeMillis() + ".mov");
            Recorder.clearTemp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        ret = false;
    }
}

